/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CmpGiveAccountResultInfo;
import com.kingdee.shr.compensation.app.AbstractCmpGiveAccountResultControllerBean;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import shaded.com.google.common.collect.Lists;
import shaded.com.google.common.collect.Maps;

public class CmpGiveAccountResultControllerBean
extends AbstractCmpGiveAccountResultControllerBean {
    private static final long serialVersionUID = 2472081194147779278L;

    @Override
    protected void _calculatePaymentAcount(Context ctx, Map param) throws BOSException, EASBizException {
        String insertSql = this.generateInsertSql();
        List<Object[]> insertParams = this.calculateAndGetGiveAccountParamsList(ctx, param);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, insertParams);
    }

    protected String generateInsertSql() {
        return "INSERT INTO T_HR_SCmpGiveAccountResult (Fid, FCmpCalTableID, FPersonID, FCmpItemId, FPersonBankId, FCurrencyId, FAmount, FGiveAccount, FExchangeRate, FSourceType) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    protected List<Object[]> calculateAndGetGiveAccountParamsList(Context ctx, Map<String, Object> inputParam) throws BOSException, EASBizException {
        ArrayList insertParams = Lists.newArrayList();
        CalSchemeInfo calScheme = (CalSchemeInfo)inputParam.get("calSchemeInfo");
        Map<String, BigDecimal> targetExchangeRateMap = this.getExchangeRateMap(ctx, calScheme);
        List listData = (List)inputParam.get("listData");
        Map<String, CalSchemeItemInfo> calSchemeItemMap = this.getCalSchemeItemMap(ctx, calScheme);
        for (Map calTableRecord : listData) {
            String calTableId = (String)calTableRecord.get("cmp_ctb.id");
            String personId = (String)calTableRecord.get("cmp_person.id");
            String cmpItemId = (String)calTableRecord.get("gv_cmpaccres.cmpitem");
            String personBankId = (String)calTableRecord.get("gv_cmpaccres.personbank");
            ArrayList insertParam = Lists.newArrayList();
            insertParam.add(BOSUuid.create((BOSObjectType)new CmpGiveAccountResultInfo().getBOSType()).toString());
            insertParam.add(calTableId);
            insertParam.add(personId);
            insertParam.add(cmpItemId);
            insertParam.add(personBankId);
            String giveCurrency = (String)calTableRecord.get("gv_cmpaccres.currency");
            giveCurrency = StringUtils.isEmpty((CharSequence)giveCurrency) ? calScheme.getCurrency().getId().toString() : giveCurrency;
            insertParam.add(giveCurrency);
            int grantCmpItemFieldSn = calSchemeItemMap.get(cmpItemId).getCmpItem().getFieldSn();
            int cmpItemDataDot = calSchemeItemMap.get(cmpItemId).getCmpItem().getDataDot().getValue();
            String cmp_ctbField = "cmp_ctb.s" + grantCmpItemFieldSn;
            Object originItemValue = calTableRecord.get(cmp_ctbField);
            if (originItemValue != null) {
                insertParam.add(originItemValue);
                BigDecimal exchangeRate = targetExchangeRateMap.get(giveCurrency);
                exchangeRate = exchangeRate == null ? new BigDecimal(1) : exchangeRate;
                BigDecimal giveItemValue = new BigDecimal(String.valueOf(originItemValue)).multiply(exchangeRate).setScale(cmpItemDataDot, 4);
                insertParam.add(FunctionTools.getRound(cmpItemDataDot, giveItemValue.doubleValue()));
                insertParam.add(exchangeRate);
            } else {
                insertParam.add(null);
                insertParam.add(null);
                insertParam.add(null);
            }
            insertParam.add(2);
            insertParams.add(insertParam.toArray());
        }
        return insertParams;
    }

    protected Map<String, BigDecimal> getExchangeRateMap(Context ctx, CalSchemeInfo calScheme) throws BOSException {
        Date ruleEffdt = CurrencyUtil.getEffdtByExchangeRule(calScheme.getExchangeRule(), calScheme.getBeginDate(), calScheme.getEndDate());
        ExchangeRateCollection coll = CurrencyUtil.getExchangeRate(ctx, calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), ruleEffdt);
        HashMap targetExchangeRateMap = Maps.newHashMap();
        for (int i = 0; i < coll.size(); ++i) {
            ExchangeRateInfo exchangeRateInfo = coll.get(i);
            targetExchangeRateMap.put(exchangeRateInfo.getTargetCurrency().getId().toString(), exchangeRateInfo.getConvertRate());
        }
        return targetExchangeRateMap;
    }

    protected Map<String, CalSchemeItemInfo> getCalSchemeItemMap(Context ctx, CalSchemeInfo calScheme) throws BOSException {
        String oql = "select id, isGrant, cmpItem.id, cmpItem.fieldSn, cmpItem.dataDot where calScheme = '" + calScheme.getId().toString() + "' and isGrant = 1";
        CalSchemeItemCollection col = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection(oql);
        HashMap res = Maps.newHashMap();
        for (int i = 0; i < col.size(); ++i) {
            res.put(col.get(i).getCmpItem().getId().toString(), col.get(i));
        }
        return res;
    }

    @Override
    protected String _clearPaymentAccount(Context ctx, String verifyQuerySql, String schemeFilterSql) throws BOSException, EASBizException {
        String whereSQL = "WHERE FCmpCalTableId in (" + schemeFilterSql + ") AND FPersonID NOT IN (SELECT personId FROM (" + verifyQuerySql + ") verifyTable )";
        String countSQL = "SELECT count(1) as countResult FROM T_HR_SCMPGIVEACCOUNTRESULT " + whereSQL;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSQL);
        long countDelete = 0L;
        try {
            while (rs.next()) {
                countDelete = rs.getInt("countResult");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String clearSql = "DELETE FROM T_HR_SCMPGIVEACCOUNTRESULT " + whereSQL;
        DbUtil.execute((Context)ctx, (String)clearSql);
        if (countDelete > 0L) {
            return MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpGiveBankResource", (String)"label66", (Locale)ctx.getLocale()), countDelete);
        }
        return null;
    }
}

