/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CostBearException;
import com.kingdee.shr.compensation.CostBearOrgCollection;
import com.kingdee.shr.compensation.CostBearOrgFactory;
import com.kingdee.shr.compensation.CostBearOrgInfo;
import com.kingdee.shr.compensation.app.AbstractCostBearFacadeControllerBean;
import com.kingdee.shr.compensation.app.segment.CmpSegmColumnCollection;
import com.kingdee.shr.compensation.app.segment.CmpSegmColumnFactory;
import com.kingdee.shr.compensation.app.segment.CmpSegmColumnInfo;
import com.kingdee.shr.compensation.cost.CmpAxle;
import com.kingdee.shr.compensation.cost.CmpCostBearForExport;
import com.kingdee.shr.compensation.exception.CostBearFacadeException;
import com.kingdee.shr.compensation.permission.CalSchemePermAPI;
import com.kingdee.shr.compensation.permission.CmpItemPermAPI;
import com.kingdee.shr.compensation.permission.RecordPermAPI;
import com.kingdee.shr.compensation.sql.wizard.CostBearSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CostBearFacadeControllerBean
extends AbstractCostBearFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private Map<String, CmpCostBearForExport> costMap = new HashMap<String, CmpCostBearForExport>();

    @Override
    protected String _transDataForHorizontal(Context ctx, String filterSql, IObjectCollection itemColl) throws BOSException {
        StringBuilder str = new StringBuilder();
        StringBuilder itemStr = new StringBuilder();
        CmpItemCollection coll = (CmpItemCollection)itemColl;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CmpItemInfo cmpItemInfo = coll.get(i);
            int fieldSn = cmpItemInfo.getFieldSn();
            String colFieldSn = "S" + fieldSn;
            itemStr.append(" SUM(CASE WHEN ITEM.FIELDSN = ").append(fieldSn).append(" THEN BEAR.FBEARMONEY END) AS ").append(colFieldSn).append(",");
            itemStr.append(" SUM(CASE WHEN ITEM.FIELDSN = ").append(fieldSn).append(" THEN TO_NUMBER(BEAR.FCOSTBEARPERC) END) AS ").append(colFieldSn).append("P,");
        }
        str.append(" SELECT BEAR.FCMPCALTABLEID, BEAR.FHRORGUNITID, BEAR.FCOSTBEARORGUNITID, BEAR.FPERSONID");
        if (CmpStrUtil.isNotEmpty(itemStr.toString()) && itemStr.toString().contains(",")) {
            str.append(", ");
            str.append(itemStr.substring(0, itemStr.lastIndexOf(",")));
        }
        str.append(" FROM T_HR_SCOSTBEAR BEAR ");
        str.append(" INNER JOIN T_HR_SCMPITEM ITEM ON BEAR.FCMPITEMID = ITEM.FID ");
        str.append(" WHERE 1 = 1");
        if (CmpStrUtil.isNotEmpty(filterSql)) {
            str.append(" AND EXISTS (SELECT 1 FROM T_HR_SCMPCALTABLE CALTABLE ");
            str.append(" WHERE CALTABLE.FID ").append(filterSql);
            str.append(" AND BEAR.FCMPCALTABLEID = CALTABLE.FID) ");
        }
        str.append(" GROUP BY BEAR.FCMPCALTABLEID, BEAR.FHRORGUNITID, BEAR.FCOSTBEARORGUNITID, BEAR.FPERSONID ");
        return str.toString();
    }

    protected void _verifyCostBearPerc(Context ctx, IObjectValue coreBaseInfo) throws BOSException {
        CostBearOrgInfo costBearInfo = (CostBearOrgInfo)coreBaseInfo;
        String hrOrgUnitName = "";
        double zprec = costBearInfo.getCostBearPerc().doubleValue();
        if (zprec > 100.0) {
            throw new BOSException(new CostBearFacadeException(CostBearFacadeException.PROPORTIONTOOLONG).getMessage());
        }
        int state = costBearInfo.getState().getValue();
        if (1 != state) {
            return;
        }
        String hrOrgUnitId = costBearInfo.getHrOrgUnit() == null ? null : costBearInfo.getHrOrgUnit().getId().toString();
        String cmpEmpORelationId = costBearInfo.getCmpEmpORelation() == null ? null : costBearInfo.getCmpEmpORelation().getId().toString();
        String cmpItemId = costBearInfo.getCmpItem() == null ? null : costBearInfo.getCmpItem().getId().toString();
        StringBuilder str = new StringBuilder();
        str.append("select cmpItem.name, costBearPerc, hrOrgUnit.name where person = '");
        str.append(costBearInfo.getPerson().getId());
        str.append("' and state = '1' and cmpEmpORelation = '").append(cmpEmpORelationId).append("' ");
        if (CmpStrUtil.isNullOrEmpty(hrOrgUnitId)) {
            str.append(" and hrOrgUnit is null");
        } else {
            str.append(" and hrOrgUnit = '").append(hrOrgUnitId).append("' ");
        }
        if (CmpStrUtil.isNullOrEmpty(cmpItemId)) {
            str.append(" and cmpItem is null");
        } else {
            str.append(" and cmpItem = '").append(cmpItemId).append("'");
        }
        if (costBearInfo.getId() != null) {
            str.append(" and id not in ('").append(costBearInfo.getId().toString()).append("') ");
        }
        CostBearOrgCollection costBearOrgCollection = CostBearOrgFactory.getLocalInstance(ctx).getCostBearOrgCollection(str.toString());
        CostBearOrgInfo costBearOrgInfo = null;
        for (int i = 0; i < costBearOrgCollection.size(); ++i) {
            costBearOrgInfo = costBearOrgCollection.get(i);
            hrOrgUnitName = costBearOrgInfo.getHrOrgUnit().getName();
            double costBearPerc = costBearOrgInfo.getCostBearPerc().doubleValue();
            if (!((zprec += costBearPerc) > 100.0)) continue;
            Object[] hrArray = new String[]{hrOrgUnitName};
            throw new BOSException((Throwable)((Object)new CostBearException(CostBearException.PERC_ERROR, hrArray)));
        }
    }

    @Override
    protected Map _createCostBearData(Context ctx, String cmpCalIds, String calSchemeId) throws BOSException {
        CalSchemeInfo calSchemeInfo = new CalSchemeInfo();
        HashMap map = new HashMap();
        calSchemeInfo = CalSchemePermAPI.getCalSchemeInfo(ctx, calSchemeId);
        this.insertCostBearData(ctx, cmpCalIds, calSchemeInfo);
        this.updateCalTableForCostBear(ctx, cmpCalIds);
        return map;
    }

    private void updateCalTableForCostBear(Context ctx, String cmpCalIds) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" update T_HR_SCmpCalTable set FIsCostBear = 1 ");
        str.append(" where fid in (").append(cmpCalIds).append(")");
    }

    @Deprecated
    private void insertCostBearReport(Context ctx, String cmpCalIds, CalSchemeInfo calSchemeInfo) throws BOSException {
        StringBuilder insertStr = new StringBuilder();
        StringBuilder str = new StringBuilder();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        insertStr.append("insert into T_HR_SCostBearReport(");
        insertStr.append("FID,FHrOrgUnitId,FCostBearOrgUnitID,FCalSchemeID,FPersonID,FCalID");
        insertStr.append(",FCalTime,FPeriodYear,FPeriodMonth");
        insertStr.append(",FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime)");
        str.append(insertStr.toString());
        str.append(" select newbosid('0B0FB9C3') as fid, t0.* from ");
        str.append(" (select distinct cost.FHrOrgUnitId, cost.FCostBearOrgId, cal.FCalSchemeId, cal.FPersonId, cal.Fid, ");
        str.append(" cal.FCalTime, cal.FPeriodYear, cal.FPeriodMonth,");
        str.append(" '").append(currentUserId).append("', ");
        str.append(CmpDateUtil.toKSqlDate(new java.util.Date())).append(", ");
        str.append(" '").append(currentUserId).append("', ");
        str.append(CmpDateUtil.toKSqlDate(new java.util.Date()));
        str.append(" from T_HR_SCmpCalTable cal ");
        str.append(" inner join T_HR_SCosrBearOrg cost on cal.FPersonId = cost.FPersonId  and cost.effactDate <= cal.FRealEndDate ");
        str.append(" and cost.FState = 1 ");
        str.append(" where cal.fid in (").append(cmpCalIds).append(")) as t0 ");
        CmpSQLUtil.execute(ctx, str.toString());
        str = new StringBuilder();
        str.append(insertStr.toString());
        str.append(" select newbosid('0B0FB9C3') as fid, cal.FHrOrgUnitId, cal.FAdminOrgUnitId, cal.FCalSchemeId, cal.FPersonId, cal.Fid, ");
        str.append(" cal.FCalTime, cal.FPeriodYear, cal.FPeriodMonth,");
        str.append(" '").append(currentUserId).append("', ");
        str.append(CmpDateUtil.toKSqlDate(new java.util.Date())).append(", ");
        str.append(" '").append(currentUserId).append("', ");
        str.append(CmpDateUtil.toKSqlDate(new java.util.Date()));
        str.append(" from T_HR_SCmpCalTable cal ");
        str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
        str.append(" and not exists (select 1 from T_HR_SCostBearReport where cal.fid = FCalId) ");
        CmpSQLUtil.execute(ctx, str.toString());
    }

    private void insertCostBearData1(Context ctx, String cmpCalIds, CmpItemCollection itemColl, CalSchemeInfo calSchemeInfo) throws BOSException {
        String table;
        HashMap numberMap = new HashMap();
        HashMap varcharMap = new HashMap();
        HashSet<String> varcharSet = new HashSet<String>();
        String filterSql = "";
        String currentUserId = "'" + HRFilterUtils.getCurrentUserId((Context)ctx) + "'";
        String sqlDate = CmpDateUtil.toKSqlDate(new java.util.Date());
        filterSql = cmpCalIds.substring(cmpCalIds.indexOf("in"));
        StringBuffer itemBu = new StringBuffer();
        int size = itemColl.size();
        for (int i = size - 1; i >= 0; --i) {
            CmpItemInfo itemInfo = itemColl.get(i);
            itemBu.append("'").append(itemInfo.getId().toString()).append("',");
            if (!CmpItemDataType.STRING.equals((Object)itemInfo.getDataType())) continue;
            varcharSet.add(itemInfo.getId().toString());
            itemColl.remove(itemInfo);
        }
        String costBearSql = this._transDataForHorizontal(ctx, filterSql, (IObjectCollection)itemColl);
        String tempTable = SQLHandleUtil.getTempTable(ctx, costBearSql);
        String itemIds = itemBu.substring(0, itemBu.length() - 1);
        String oql = "select column, sourData, dataType, cmpSegmTable.* where sourData in (" + itemIds + ")";
        CmpSegmColumnCollection cmpSegmColumnCollection = CmpSegmColumnFactory.getLocalInstance(ctx).getCmpSegmColumnCollection(oql);
        int size2 = cmpSegmColumnCollection.size();
        for (int i = 0; i < size2; ++i) {
            HashSet<String> set;
            CmpSegmColumnInfo cmpSegmColumnInfo = cmpSegmColumnCollection.get(i);
            table = cmpSegmColumnInfo.getCmpSegmTable().getTable();
            String column = cmpSegmColumnInfo.getColumn();
            String itemId = cmpSegmColumnInfo.getSourData();
            if (varcharSet.contains(itemId)) {
                if (varcharMap.containsKey(table)) {
                    ((Set)varcharMap.get(table)).add(column);
                    continue;
                }
                set = new HashSet<String>();
                set.add(column);
                varcharMap.put(table, set);
                continue;
            }
            if (numberMap.containsKey(table)) {
                ((Set)numberMap.get(table)).add(column);
                continue;
            }
            set = new HashSet();
            set.add(column);
            numberMap.put(table, set);
        }
        StringBuffer insertBu = new StringBuffer();
        insertBu.append(" INSERT INTO T_HR_SCMPSEGMCOST (FID,FCMPCALTABLEID,FCOSTBEARORGID,FISDISTRIBUTE,");
        insertBu.append(" FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME) ");
        insertBu.append(" SELECT NEWBOSID('EFCF8DEE'),FCMPCALTABLEID,FCOSTBEARORGUNITID,0,");
        insertBu.append(currentUserId + "," + sqlDate + "," + currentUserId + "," + sqlDate);
        insertBu.append(" from (" + tempTable + ") as tempTab ");
        CmpSQLUtil.execute(ctx, insertBu.toString());
        StringBuilder updateBu = new StringBuilder();
        updateBu.append(" UPDATE T_HR_SCMPSEGMCOST T1 SET FINANCIALORGID = ").append("\r\n");
        updateBu.append(" (").append("\r\n");
        updateBu.append(" SELECT FTOUNITID FROM T_ORG_UNITRELATION UNITRE  ").append("\r\n");
        updateBu.append(" INNER JOIN T_ORG_TYPERELATION TYPERE ON UNITRE.FTYPERELATIONID = TYPERE.FID ").append("\r\n");
        updateBu.append(" WHERE TYPERE.FFROMTYPE=0 AND TYPERE.FTOTYPE=1 ").append("\r\n");
        updateBu.append(" AND UNITRE.FFROMUNITID=T1.FCOSTBEARORGID ").append("\r\n");
        updateBu.append(" )").append("\r\n");
        updateBu.append(" WHERE EXISTS (SELECT 1 FROM T_HR_SCMPCALTABLE CALTABLE ");
        updateBu.append(" WHERE CALTABLE.FID ").append(filterSql);
        updateBu.append(" AND CALTABLE.FID = T1.FCMPCALTABLEID)");
        CmpSQLUtil.execute(ctx, updateBu.toString());
        for (Map.Entry entry : numberMap.entrySet()) {
            int length;
            itemBu = new StringBuffer();
            StringBuffer costBu = new StringBuffer();
            table = (String)entry.getKey();
            boolean consainVar = varcharMap.containsKey(table);
            Set colSet = (Set)entry.getValue();
            for (String column : colSet) {
                length = column.length();
                costBu.append(", ").append(column);
                if ("C".equalsIgnoreCase(column.substring(length - 1))) {
                    itemBu.append(", TEMP.").append(column.substring(0, length - 1));
                    continue;
                }
                itemBu.append(", TEMP.").append(column);
            }
            if (consainVar) {
                Set set = (Set)varcharMap.get(table);
                for (String column : set) {
                    length = column.length();
                    costBu.append(",").append(column);
                    if ("C".equalsIgnoreCase(column.substring(length - 1))) {
                        itemBu.append(",cal.").append(column.substring(0, length - 1));
                        continue;
                    }
                    itemBu.append(", 100");
                }
            }
            insertBu = new StringBuffer();
            insertBu.append(" INSERT INTO " + table);
            insertBu.append(" (FCMPCALTABLEID,FCOSTBEARORGID,FSEGMCOSTID " + costBu + ")");
            insertBu.append(" SELECT TEMP.FCMPCALTABLEID,TEMP.FCOSTBEARORGUNITID,COST.FID " + itemBu);
            insertBu.append(" FROM (" + tempTable + ") AS TEMP ");
            if (consainVar) {
                insertBu.append(" inner join T_HR_SCmpCalTable as cal on TEMP.FCMPCALTABLEID = cal.fid ");
            }
            insertBu.append(" INNER JOIN T_HR_SCMPSEGMCOST AS COST ON TEMP.FCMPCALTABLEID = COST.FCMPCALTABLEID ");
            insertBu.append(" AND TEMP.FCOSTBEARORGUNITID = COST.FCOSTBEARORGID ");
            CmpSQLUtil.execute(ctx, insertBu.toString());
        }
    }

    private void insertCostBearData(Context ctx, String cmpCalIds, CalSchemeInfo calSchemeInfo) throws BOSException {
        int dataDot;
        int dataType;
        int fieldSn;
        CmpItemInfo itemInfo;
        int i;
        StringBuilder insertNumStr = new StringBuilder();
        StringBuilder insertStrStr = new StringBuilder();
        StringBuilder selectStr = new StringBuilder();
        StringBuilder str = new StringBuilder();
        ArrayList<StringBuilder> numberArr = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> stringArr = new ArrayList<StringBuilder>();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String sqlDate = CmpDateUtil.toKSqlDate(new java.util.Date());
        String DEFAULT_CURRENCY = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        insertNumStr.append("insert into T_HR_SCostBear(");
        insertNumStr.append("FID, FCmpCalTableId, FCostBearOrgUnitID, FHrOrgUnitID, FAdminOrgID ");
        insertNumStr.append(",FCalSchemeID, FCmpPeriodID ,FCmpItemID, FPersonID, FCostBearPerc ");
        insertNumStr.append(",FCalTime, FPeriodYear, FPeriodMonth, FCreatorID, FCreateTime");
        insertNumStr.append(",FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FBearMoney, FCostMoney");
        insertNumStr.append(",FCostValue, FBearValue, FCommitmentCurrencyID) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, null, null, ?)");
        insertStrStr.append("insert into T_HR_SCostBear(");
        insertStrStr.append("FID, FCmpCalTableId, FCostBearOrgUnitID, FHrOrgUnitID, FAdminOrgID ");
        insertStrStr.append(",FCalSchemeID, FCmpPeriodID ,FCmpItemID, FPersonID, FCostBearPerc ");
        insertStrStr.append(",FCalTime, FPeriodYear, FPeriodMonth, FCreatorID, FCreateTime");
        insertStrStr.append(",FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FBearMoney, FCostMoney");
        insertStrStr.append(",FCostValue, FBearValue, FCommitmentCurrencyID) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, null, null, ?, ?, ?)");
        selectStr.append(" select newbosid('0B0FB9C3') as FID, cal.fid as FCmpCalTableId, cost.FCostBearOrgId as FCostBearOrgUnitID, cost.FHrOrgUnitId as FHrOrgUnitID, cal.FAdminOrgUnitId as FAdminOrgID, ");
        selectStr.append(" cal.FCalSchemeId as FCalSchemeID, cal.FCmpPeriodId as FCmpPeriodID, item.fid as FCmpItemID, cal.FPersonId as FPersonID, cost.FCostBearPerc as FCostBearPerc, ");
        selectStr.append(" cal.FCalTime as FCalTime, cal.FPeriodYear as FPeriodYear, cal.FPeriodMonth as FPeriodMonth, '" + currentUserId + "' as FCreatorID," + sqlDate + " as FCreateTime, ");
        selectStr.append(" '" + currentUserId + "' as FLastUpdateUserID," + sqlDate + " as FLastUpdateTime, cal.FControlUnitID as FControlUnitID, ");
        selectStr.append(" cost.FCommitmentCurrencyID as FCommitmentCurrencyID, ");
        CmpItemCollection itemColl = CmpItemPermAPI.getCostItemByCalScheme(ctx, calSchemeInfo.getId().toString());
        if (null == itemColl || itemColl.size() < 1) {
            return;
        }
        int size = itemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            fieldSn = itemInfo.getFieldSn();
            dataType = itemInfo.getDataType().getValue();
            dataDot = itemInfo.getDataDot().getValue();
            str = new StringBuilder();
            str.append(selectStr.toString());
            if (0 == dataType) {
                str.append(" cal.S").append(fieldSn).append(" as FBearMoney, ");
                str.append(" cal.S").append(fieldSn).append(" as FCostMoney ");
            } else {
                str.append(" cal.S").append(fieldSn).append(" as FCostValue, ");
                str.append(" cal.S").append(fieldSn).append(" as FBearValue");
            }
            str.append(" ,'S").append(fieldSn).append("' as SN");
            str.append(" ,'").append(dataDot).append("' as SNDOT");
            str.append(" from T_HR_SCmpCalTable as cal ");
            str.append(" inner join T_HR_SCalSchemeItem as schemeItem on cal.FCalSchemeId = schemeItem.FCalSchemeId and schemeItem.FIsCostBear = 1 ");
            str.append(" inner join T_HR_SCmpItem as item on schemeItem.FCmpItemId = item.fid ");
            str.append(" inner join T_HR_SCostBearOrg as cost on cal.FPersonId = cost.FPersonId and item.fid = cost.FCmpItemId ");
            str.append(" and cal.FCmpEmpORelationID = cost.FCmpEmpORelationID ");
            str.append(" and cost.FState = 1 and cost.FEffactDate <= cal.FRealEndDate and (cost.FLeffectDate >= cal.FRealEndDate or cost.FLeffectDate is null) ");
            str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
            str.append(" and item.FieldSn = ").append(fieldSn);
            if (0 == dataType) {
                numberArr.add(str);
                continue;
            }
            stringArr.add(str);
        }
        this.batchInsertCostBearData(ctx, numberArr, insertNumStr, 0);
        this.batchInsertCostBearData(ctx, stringArr, insertStrStr, 1);
        size = itemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            fieldSn = itemInfo.getFieldSn();
            dataType = itemInfo.getDataType().getValue();
            dataDot = itemInfo.getDataDot().getValue();
            str = new StringBuilder();
            str.append(selectStr.toString());
            if (0 == dataType) {
                str.append(" cal.S").append(fieldSn).append(" as FBearMoney, ");
                str.append(" cal.S").append(fieldSn).append(" as FCostMoney ");
            } else {
                str.append(" cal.S").append(fieldSn).append(" as FCostValue, ");
                str.append(" cal.S").append(fieldSn).append(" as FBearValue");
            }
            str.append(" ,'S").append(fieldSn).append("' as SN");
            str.append(" ,'").append(dataDot).append("' as SNDOT");
            str.append(" from T_HR_SCmpCalTable as cal ");
            str.append(" inner join T_HR_SCalSchemeItem as schemeItem on cal.FCalSchemeId = schemeItem.FCalSchemeId and schemeItem.FIsCostBear = 1 ");
            str.append(" inner join T_HR_SCmpItem as item on schemeItem.FCmpItemId = item.fid ");
            str.append(" inner join T_HR_SCostBearOrg as cost on cal.FPersonId = cost.FPersonId and cost.FCmpItemId is null ");
            str.append(" and cal.FCmpEmpORelationID = cost.FCmpEmpORelationID ");
            str.append(" and cost.FState = 1 and cost.FEffactDate <= cal.FRealEndDate and (cost.FLeffectDate >= cal.FRealEndDate or cost.FLeffectDate is null) ");
            str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
            str.append(" and item.FieldSn = ").append(fieldSn);
            str.append(" and not exists (select 1 from T_HR_SCostBear where cal.fid = FCmpCalTableId and FCmpItemId = item.fid) ");
            if (0 == dataType) {
                numberArr.add(str);
                continue;
            }
            stringArr.add(str);
        }
        this.batchInsertCostBearData(ctx, numberArr, insertNumStr, 0);
        this.batchInsertCostBearData(ctx, stringArr, insertStrStr, 1);
        size = itemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            fieldSn = itemInfo.getFieldSn();
            dataType = itemInfo.getDataType().getValue();
            dataDot = itemInfo.getDataDot().getValue();
            str = new StringBuilder();
            str.append(" select newbosid('0B0FB9C3') as FID,");
            str.append(" cal.fid as FCmpCalTableId, cal.FCostBearOrgID as FCostBearOrgUnitID, cal.FHrOrgUnitID as FHrOrgUnitID, cal.FAdminOrgUnitId as FAdminOrgID, ");
            str.append(" cal.FCalSchemeId as FCalSchemeID, cal.FCmpPeriodId as FCmpPeriodID, item.fid as FCmpItemID, cal.FPersonId as FPersonID,  ");
            str.append(" 100 as FCostBearPerc, cal.FCalTime as FCalTime, cal.FPeriodYear as FPeriodYear, cal.FPeriodMonth as FPeriodMonth, ");
            str.append(" '" + currentUserId + "' as FCreatorID," + sqlDate + " as FCreateTime, ");
            str.append(" '" + currentUserId + "' as FLastUpdateUserID," + sqlDate + " as FLastUpdateTime, cal.FControlUnitID as FControlUnitID, ");
            str.append(" null as FCommitmentCurrencyID, ");
            if (0 == dataType) {
                str.append(" cal.S").append(fieldSn).append(" as FBearMoney, ");
                str.append(" cal.S").append(fieldSn).append(" as FCostMoney ");
            } else {
                str.append(" cal.S").append(fieldSn).append(" as FBearValue, ");
                str.append(" cal.S").append(fieldSn).append(" as FCostValue ");
            }
            str.append(" ,'S").append(fieldSn).append("' as SN");
            str.append(" ,'").append(dataDot).append("' as SNDOT");
            str.append(" from T_HR_SCmpCalTable as cal ");
            str.append(" inner join T_HR_SCalSchemeItem as schemeItem on cal.FCalSchemeId = schemeItem.FCalSchemeId and schemeItem.FIsCostBear = 1 ");
            str.append(" inner join T_HR_SCmpItem as item on schemeItem.FCmpItemId = item.fid ");
            str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
            str.append(" and item.FieldSn = ").append(fieldSn);
            str.append(" and not exists (select 1 from T_HR_SCostBear where cal.fid = FCmpCalTableId and FCmpItemId = item.fid) ");
            if (0 == dataType) {
                numberArr.add(str);
                continue;
            }
            stringArr.add(str);
        }
        this.batchInsertCostBearData(ctx, numberArr, insertNumStr, 0);
        this.batchInsertCostBearData(ctx, stringArr, insertStrStr, 1);
        this.insertCostBearData1(ctx, cmpCalIds, itemColl, calSchemeInfo);
    }

    /*
     * WARNING - void declaration
     */
    private void batchInsertCostBearData(Context ctx, List<StringBuilder> sqlArr, StringBuilder insertStr, int dataType) throws BOSException {
        if (sqlArr.size() > 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            try {
                double perSize = 1.0;
                double totalSize = sqlArr.size();
                int pages = (int)Math.ceil(totalSize / perSize);
                List<Object> tempSqlArr = new ArrayList();
                StringBuffer sqlUnion = new StringBuffer();
                for (int i = 0; i < pages; ++i) {
                    BigDecimal lastValue;
                    void var17_16;
                    int fromIndex = i * (int)perSize;
                    int toIndex = (i + 1) * (int)perSize;
                    toIndex = toIndex > (int)totalSize ? (int)totalSize : toIndex;
                    tempSqlArr = sqlArr.subList(fromIndex, toIndex);
                    sqlUnion.append(" select t.* from (");
                    for (StringBuilder stringBuilder : tempSqlArr) {
                        sqlUnion.append(" union all ").append(stringBuilder.toString());
                    }
                    sqlUnion.append(" )t  order by t.FCmpCalTableId ");
                    ArrayList<Object[]> perPersonParam = new ArrayList<Object[]>();
                    String string = "";
                    String tempPerPersonKey = "";
                    BigDecimal totalValue = null;
                    IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sqlUnion.toString().replaceFirst(" union all ", ""));
                    HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
                    while (rowSet.next()) {
                        Object[] param;
                        if (1 == dataType) {
                            param = this.getExecuteBatchParam(rowSet, dataType);
                            paramsList.add(param);
                            continue;
                        }
                        tempPerPersonKey = rowSet.getString("FCmpCalTableId") + "_" + rowSet.getString("SN");
                        map.put(tempPerPersonKey, rowSet.getBigDecimal("FBearMoney"));
                        param = this.getExecuteBatchParam(rowSet, dataType);
                        if (!var17_16.equals(tempPerPersonKey)) {
                            if (!StringUtils.isEmpty((String)var17_16)) {
                                totalValue = (BigDecimal)map.get(var17_16);
                            }
                            lastValue = totalValue;
                            boolean isDealLastValue = false;
                            int size = perPersonParam.size();
                            for (int j = 0; null != totalValue && j < size - 1; ++j) {
                                Object[] tempParam = (Object[])perPersonParam.get(j);
                                lastValue = lastValue.subtract((BigDecimal)tempParam[18]);
                                isDealLastValue = true;
                            }
                            if (perPersonParam.size() > 0) {
                                Object[] lasteParam = (Object[])perPersonParam.get(perPersonParam.size() - 1);
                                lasteParam[18] = isDealLastValue ? lastValue : totalValue;
                            }
                            paramsList.addAll(perPersonParam);
                            perPersonParam.clear();
                            String string2 = tempPerPersonKey;
                        }
                        perPersonParam.add(param);
                    }
                    if (perPersonParam.size() > 0) {
                        boolean isDealLastValue = false;
                        lastValue = totalValue = (BigDecimal)map.get(var17_16);
                        int size = perPersonParam.size();
                        for (int j = 0; null != totalValue && j < size - 1; ++j) {
                            Object[] tempParam = (Object[])perPersonParam.get(j);
                            lastValue = lastValue.subtract((BigDecimal)tempParam[18]);
                            isDealLastValue = true;
                        }
                        Object[] lasteParam = (Object[])perPersonParam.get(perPersonParam.size() - 1);
                        lasteParam[18] = isDealLastValue ? lastValue : totalValue;
                        paramsList.addAll(perPersonParam);
                        perPersonParam.clear();
                    }
                    sqlUnion.setLength(0);
                }
            }
            catch (SQLException e) {
                throw new BOSException("Sql222 execute exception : " + sqlArr, (Throwable)e);
            }
            if (paramsList.size() > 0) {
                CmpSQLUtil.executeBatch(ctx, insertStr.toString(), paramsList);
            }
            sqlArr.clear();
        }
    }

    private Object[] getExecuteBatchParam(IRowSet rowSet, int dataType) throws SQLException {
        Object[] executeBatchParam = new Object[21];
        executeBatchParam[0] = rowSet.getObject("FID");
        executeBatchParam[1] = rowSet.getObject("FCmpCalTableId");
        executeBatchParam[2] = rowSet.getObject("FCostBearOrgUnitID");
        executeBatchParam[3] = rowSet.getObject("FHrOrgUnitID");
        executeBatchParam[4] = rowSet.getObject("FAdminOrgID");
        executeBatchParam[5] = rowSet.getObject("FCalSchemeID");
        executeBatchParam[6] = rowSet.getObject("FCmpPeriodID");
        executeBatchParam[7] = rowSet.getObject("FCmpItemID");
        executeBatchParam[8] = rowSet.getObject("FPersonID");
        executeBatchParam[9] = rowSet.getObject("FCostBearPerc");
        executeBatchParam[10] = rowSet.getObject("FCalTime");
        executeBatchParam[11] = rowSet.getObject("FPeriodYear");
        executeBatchParam[12] = rowSet.getObject("FPeriodMonth");
        executeBatchParam[13] = rowSet.getObject("FCreatorID");
        executeBatchParam[14] = rowSet.getObject("FCreateTime");
        executeBatchParam[15] = rowSet.getObject("FLastUpdateUserID");
        executeBatchParam[16] = rowSet.getObject("FLastUpdateTime");
        executeBatchParam[17] = rowSet.getObject("FControlUnitID");
        if (0 == dataType) {
            if (null != rowSet.getObject("FBearMoney")) {
                String bearMoneyStr = rowSet.getString("FBearMoney");
                BigDecimal bearMoneyBig = new BigDecimal(bearMoneyStr);
                String percStr = rowSet.getString("FCostBearPerc");
                BigDecimal percBig = new BigDecimal(percStr);
                BigDecimal value = bearMoneyBig.multiply(percBig).divide(new BigDecimal("100"), rowSet.getInt("SNDOT"), 4);
                executeBatchParam[18] = value;
            } else {
                executeBatchParam[18] = rowSet.getObject("FBearMoney");
            }
            executeBatchParam[19] = rowSet.getObject("FCostMoney");
        } else {
            executeBatchParam[18] = rowSet.getObject("FCostValue");
            executeBatchParam[19] = rowSet.getObject("FBearValue");
        }
        executeBatchParam[20] = rowSet.getObject("FCommitmentCurrencyID");
        return executeBatchParam;
    }

    @Deprecated
    private void insertCostBearDataOld(Context ctx, String cmpCalIds, CalSchemeInfo calSchemeInfo) throws BOSException {
        int dataType;
        int fieldSn;
        CmpItemInfo itemInfo;
        int i;
        StringBuilder insertStr = new StringBuilder();
        StringBuilder selectStr = new StringBuilder();
        StringBuilder str = new StringBuilder();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String sqlDate = CmpDateUtil.toKSqlDate(new java.util.Date());
        insertStr.append("insert into T_HR_SCostBear(");
        insertStr.append("FID, FCmpCalTableId, FCostBearOrgUnitID, FHrOrgUnitID, FAdminOrgID ");
        insertStr.append(",FCalSchemeID, FCmpPeriodID ,FCmpItemID, FPersonID, FCostBearPerc ");
        insertStr.append(",FCalTime, FPeriodYear, FPeriodMonth, FCreatorID, FCreateTime");
        insertStr.append(",FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FBearMoney, FCostMoney");
        insertStr.append(",FCostValue, FBearValue)");
        selectStr.append(" union ");
        selectStr.append(" select newbosid('0B0FB9C3') fid, cal.fid, cost.FCostBearOrgId, cost.FHrOrgUnitId, cal.FAdminOrgUnitId, ");
        selectStr.append(" cal.FCalSchemeId, cal.FCmpPeriodId, item.fid, cal.FPersonId, cost.FCostBearPerc, ");
        selectStr.append(" cal.FCalTime, cal.FPeriodYear, cal.FPeriodMonth, '" + currentUserId + "'," + sqlDate + ", ");
        selectStr.append(" '" + currentUserId + "'," + sqlDate + ", cal.FControlUnitID, ");
        CmpItemCollection itemColl = CmpItemPermAPI.getCostItemByCalScheme(ctx, calSchemeInfo.getId().toString());
        if (null == itemColl || itemColl.size() < 1) {
            return;
        }
        str.append(insertStr.toString());
        int size = itemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            fieldSn = itemInfo.getFieldSn();
            dataType = itemInfo.getDataType().getValue();
            str.append(selectStr.toString());
            if (0 == dataType) {
                str.append(" case when cal.S").append(fieldSn).append(" is null then null else ");
                str.append(" cal.S").append(fieldSn).append("*cost.FCostBearPerc/100 end as FBearMoney, ");
                str.append(" cal.S").append(fieldSn).append(", ");
                str.append(" null, null ");
            } else {
                str.append(" null, null, ");
                str.append(" cal.S").append(fieldSn).append(", ");
                str.append(" cal.S").append(fieldSn);
            }
            str.append(" from T_HR_SCmpCalTable as cal ");
            str.append(" inner join T_HR_SCalSchemeItem as schemeItem on cal.FCalSchemeId = schemeItem.FCalSchemeId and schemeItem.FIsCostBear = 1 ");
            str.append(" inner join T_HR_SCmpItem as item on schemeItem.FCmpItemId = item.fid ");
            str.append(" inner join T_HR_SCostBearOrg as cost on cal.FPersonId = cost.FPersonId and item.fid = cost.FCmpItemId ");
            str.append(" and cal.FCmpEmpORelationID = cost.FCmpEmpORelationID ");
            str.append(" and cost.FState = 1 and cost.FEffactDate <= cal.FRealEndDate and (cost.FLeffectDate >= cal.FRealEndDate or cost.FLeffectDate is null) ");
            str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
            str.append(" and item.FieldSn = ").append(fieldSn);
        }
        CmpSQLUtil.execute(ctx, str.toString().replaceFirst("union", ""));
        str = new StringBuilder();
        str.append(insertStr.toString());
        size = itemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            fieldSn = itemInfo.getFieldSn();
            dataType = itemInfo.getDataType().getValue();
            str.append(selectStr.toString());
            if (0 == dataType) {
                str.append(" case when cal.S").append(fieldSn).append(" is null then null else ");
                str.append(" cal.S").append(fieldSn).append("*cost.FCostBearPerc/100 end as FBearMoney, ");
                str.append(" cal.S").append(fieldSn).append(", ");
                str.append(" null, null ");
            } else {
                str.append(" null, null, ");
                str.append(" cal.S").append(fieldSn).append(", ");
                str.append(" cal.S").append(fieldSn);
            }
            str.append(" from T_HR_SCmpCalTable as cal ");
            str.append(" inner join T_HR_SCalSchemeItem as schemeItem on cal.FCalSchemeId = schemeItem.FCalSchemeId and schemeItem.FIsCostBear = 1 ");
            str.append(" inner join T_HR_SCmpItem as item on schemeItem.FCmpItemId = item.fid ");
            str.append(" inner join T_HR_SCostBearOrg as cost on cal.FPersonId = cost.FPersonId and cost.FCmpItemId is null ");
            str.append(" and cal.FCmpEmpORelationID = cost.FCmpEmpORelationID ");
            str.append(" and cost.FState = 1 and cost.FEffactDate <= cal.FRealEndDate and (cost.FLeffectDate >= cal.FRealEndDate or cost.FLeffectDate is null) ");
            str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
            str.append(" and item.FieldSn = ").append(fieldSn);
            str.append(" and not exists (select 1 from T_HR_SCostBear where cal.fid = FCmpCalTableId and FCmpItemId = item.fid) ");
        }
        CmpSQLUtil.execute(ctx, str.toString().replaceFirst("union", ""));
        str = new StringBuilder();
        str.append(insertStr.toString());
        size = itemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            fieldSn = itemInfo.getFieldSn();
            dataType = itemInfo.getDataType().getValue();
            str.append(" union ");
            str.append(" select newbosid('0B0FB9C3') as fid,");
            str.append(" cal.fid, cal.FCostBearOrgID, cal.FHrOrgUnitID, cal.FAdminOrgUnitId, ");
            str.append(" cal.FCalSchemeId, cal.FCmpPeriodId, item.fid, cal.FPersonId, ");
            str.append(" 100 as FCostBearPerc, cal.FCalTime, cal.FPeriodYear, cal.FPeriodMonth, ");
            str.append(" '" + currentUserId + "'," + sqlDate + ", ");
            str.append(" '" + currentUserId + "'," + sqlDate + ", cal.FControlUnitID, ");
            if (0 == dataType) {
                str.append(" cal.S").append(fieldSn).append(" as FBearMoney, ");
                str.append(" cal.S").append(fieldSn).append(" as FCostMoney, ");
                str.append(" null, null ");
            } else {
                str.append(" null, null, ");
                str.append(" cal.S").append(fieldSn).append(" as FBearValue, ");
                str.append(" cal.S").append(fieldSn).append(" as FCostValue ");
            }
            str.append(" from T_HR_SCmpCalTable as cal ");
            str.append(" inner join T_HR_SCalSchemeItem as schemeItem on cal.FCalSchemeId = schemeItem.FCalSchemeId and schemeItem.FIsCostBear = 1 ");
            str.append(" inner join T_HR_SCmpItem as item on schemeItem.FCmpItemId = item.fid ");
            str.append(" where cal.fid in (").append(cmpCalIds).append(") ");
            str.append(" and item.FieldSn = ").append(fieldSn);
            str.append(" and not exists (select 1 from T_HR_SCostBear where cal.fid = FCmpCalTableId and FCmpItemId = item.fid) ");
        }
        CmpSQLUtil.execute(ctx, str.toString().replaceFirst("union", ""));
        this.insertCostBearData1(ctx, cmpCalIds, itemColl, calSchemeInfo);
    }

    private String beforeDeleteCostBearData(Context ctx, String cmpCalIds, IObjectValue calSchemeInfo) throws BOSException {
        StringBuffer str = new StringBuffer();
        str.append("select distinct FCmpCalTableId from T_HR_SCostBear where FCmpCalTableId in (");
        str.append(cmpCalIds).append(")");
        str.append(" and FAccountBillID is not null");
        return str.toString();
    }

    @Override
    protected int _deleteCostBearData(Context ctx, String cmpCalIds, IObjectValue calSchemeInfo) throws BOSException {
        CalSchemeInfo schemeInfo = (CalSchemeInfo)calSchemeInfo;
        StringBuilder calSchemeSql = new StringBuilder();
        calSchemeSql.append("FCalSchemeID = '");
        calSchemeSql.append(schemeInfo.getId().toString());
        calSchemeSql.append("' and FPeriodYear = ");
        calSchemeSql.append(schemeInfo.getPeriodYear());
        calSchemeSql.append(" and FPeriodMonth = ");
        calSchemeSql.append(schemeInfo.getPeriodMonth());
        calSchemeSql.append(" and FCalTime = ");
        calSchemeSql.append(schemeInfo.getCalTime());
        String calSchemeFilter = calSchemeSql.toString();
        String accoutBillSql = this.beforeDeleteCostBearData(ctx, cmpCalIds, calSchemeInfo);
        IRowSet executeQuery = CmpSQLUtil.executeQuery(ctx, accoutBillSql);
        int size = executeQuery.size();
        StringBuilder str = new StringBuilder();
        str.append("delete from T_HR_SCostBear where ");
        if (!CmpStrUtil.isNullOrEmpty(cmpCalIds)) {
            str.append("FCmpCalTableId in (");
            str.append(cmpCalIds);
            str.append(")");
        } else {
            str.append(calSchemeFilter);
        }
        if (size > 0) {
            str.append(" and FCmpCalTableId not in (");
            str.append(accoutBillSql.replace("distinct", "")).append(")");
        }
        CmpSQLUtil.execute(ctx, str.toString());
        String calIds = cmpCalIds;
        if (CmpStrUtil.isNullOrEmpty(cmpCalIds)) {
            calIds = "select fid from T_HR_SCmpCalTable where " + calSchemeFilter;
        }
        str = new StringBuilder();
        str.append("delete from T_HR_SCmpSegmCost where FCmpCalTableID in (").append(calIds).append(")");
        CmpSQLUtil.execute(ctx, str.toString());
        IRowSet q2 = CmpSQLUtil.executeQuery(ctx, "select FTable from T_HR_SCmpSegmTable");
        try {
            while (q2.next()) {
                CmpSQLUtil.execute(ctx, "delete from " + q2.getString(1) + " where FCmpCalTableID in (" + calIds + ")");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return size;
    }

    private Map<String, CmpAxle> assameCostBearData(Context ctx, CoreBaseCollection coreBaseCollection, String costSql) throws BOSException {
        String key;
        double perc;
        Date endDate;
        Date beginDate;
        String itemId;
        String cmpEmpId;
        String hrId;
        String personId;
        HashMap<String, CmpAxle> map = new HashMap<String, CmpAxle>();
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, costSql);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("id");
                personId = rowSet.getString("personId");
                hrId = rowSet.getString("hrId");
                cmpEmpId = rowSet.getString("cmpEmpId");
                itemId = rowSet.getString("itemId");
                beginDate = rowSet.getDate("effactDate");
                endDate = rowSet.getDate("leffectDate");
                perc = rowSet.getDouble("perc");
                key = personId + "_" + hrId + "_" + cmpEmpId + "_" + (null == itemId ? "Empty" : itemId);
                this.assembleCmpAxleMap(id, key, beginDate, endDate, perc, 0, map);
                this.costMap.put(id, new CmpCostBearForExport(rowSet));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (null != coreBaseCollection && coreBaseCollection.size() > 0) {
            int size = coreBaseCollection.size();
            for (int i = 0; i < size; ++i) {
                CoreBaseInfo coreBaseInfo = coreBaseCollection.get(i);
                personId = ((CoreBaseInfo)coreBaseInfo.get("person")).getId().toString();
                hrId = ((CoreBaseInfo)coreBaseInfo.get("hrOrgUnit")).getId().toString();
                cmpEmpId = ((CoreBaseInfo)coreBaseInfo.get("cmpEmpORelation")).getId().toString();
                itemId = null == coreBaseInfo.get("cmpItem") ? null : ((CoreBaseInfo)coreBaseInfo.get("cmpItem")).getId().toString();
                beginDate = coreBaseInfo.getDate("effactDate");
                endDate = coreBaseInfo.getDate("leffectDate");
                perc = coreBaseInfo.getDouble("costBearPerc");
                int index = coreBaseInfo.getInt("index");
                key = personId + "_" + hrId + "_" + cmpEmpId + "_" + (null == itemId ? "Empty" : itemId);
                this.assembleCmpAxleMap(null, key, beginDate, endDate, perc, index, map);
            }
        }
        return map;
    }

    private void assembleCmpAxleMap(String id, String key, java.util.Date beginDate, java.util.Date endDate, double perc, int index, Map<String, CmpAxle> map) throws BOSException {
        if (map.containsKey(key)) {
            CmpAxle axle = map.get(key);
            axle.put(id, beginDate, endDate, perc, index);
            map.put(key, axle);
        } else {
            CmpAxle axle = new CmpAxle();
            axle.put(id, beginDate, endDate, perc, index);
            map.put(key, axle);
        }
    }

    @Override
    protected Set _getInvalidImportData(Context ctx, CoreBaseCollection coreBaseCollection, String personFilter, String permId) throws BOSException, EASBizException {
        HashSet<Integer> set = new HashSet<Integer>();
        String sql = CostBearSQL.getNeedVerifyDataSqlForPerm(ctx, personFilter, null, permId);
        Map<String, CmpAxle> map = this.assameCostBearData(ctx, coreBaseCollection, sql);
        for (Map.Entry<String, CmpAxle> e : map.entrySet()) {
            CmpAxle axle = e.getValue();
            Set<Integer> safePoint = axle.getSafePoint();
            for (Integer sp : safePoint) {
                double sumPerc = axle.getSumPerc(sp);
                if (!(sumPerc > 100.0)) continue;
                set.addAll(axle.getIndexSet(sp));
            }
        }
        return set;
    }

    @Override
    protected List _checkPercent(Context ctx, String personFilter, String hrOrgIds, String permId) throws BOSException, EASBizException {
        ArrayList<CmpCostBearForExport> list = new ArrayList<CmpCostBearForExport>();
        String sql = CostBearSQL.getNeedVerifyDataSqlForPerm(ctx, personFilter, hrOrgIds, permId);
        Map<String, CmpAxle> map = this.assameCostBearData(ctx, null, sql);
        for (Map.Entry<String, CmpAxle> e : map.entrySet()) {
            boolean isExport = false;
            CmpAxle axle = e.getValue();
            Set<Integer> safePoint = axle.getSafePoint();
            for (Integer key : safePoint) {
                double sumPerc = axle.getSumPerc(key);
                if (sumPerc == 100.0 || sumPerc == 0.0) continue;
                isExport = true;
                break;
            }
            if (!isExport) continue;
            Set<String> idSet = axle.getAllId();
            for (String id : idSet) {
                if (list.contains(this.costMap.get(id))) continue;
                list.add(this.costMap.get(id));
            }
        }
        return list;
    }

    @Override
    protected boolean _checkPercent(Context ctx, CoreBaseCollection coreBaseCollection, String personFilter, String unableIds) throws BOSException, EASBizException {
        String sql = CostBearSQL.getNeedVerifyDataSql(personFilter, unableIds, ctx);
        Map<String, CmpAxle> map = this.assameCostBearData(ctx, coreBaseCollection, sql);
        for (Map.Entry<String, CmpAxle> e : map.entrySet()) {
            CmpAxle axle = e.getValue();
            String key = e.getKey();
            Set<Integer> safePoint = axle.getSafePoint();
            for (Integer point : safePoint) {
                double sumPerc = axle.getSumPerc(point);
                if (!(sumPerc > 100.0)) continue;
                PersonInfo personInfo = RecordPermAPI.getPersonInfo(ctx, key.substring(0, key.indexOf("_")));
                throw new BOSException(new CostBearFacadeException(CostBearFacadeException.NAMEPROPORTIONTOOLONG, new Object[]{personInfo.getName()}).getMessage());
            }
        }
        return false;
    }

    @Override
    protected void _insertCostSegment(Context ctx, String calIds, IObjectCollection itemColl, IObjectValue schemInfo) throws BOSException, EASBizException {
        this.insertCostBearData1(ctx, calIds, (CmpItemCollection)itemColl, (CalSchemeInfo)schemInfo);
    }
}

