/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.AbstractHRCmpBriefGetSubOrgFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HRCmpBriefGetSubOrgFacadeControllerBean
extends AbstractHRCmpBriefGetSubOrgFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpBriefGetSubOrgFacadeControllerBean");

    @Override
    protected Map _getCmpBriefSubOrg(Context ctx, String orgId) throws BOSException, EASBizException {
        HashMap<String, ArrayList<Map>> subOrgMap = new HashMap<String, ArrayList<Map>>();
        ArrayList<Map> list = new ArrayList<Map>();
        String userId = HRCmpReportUtil.getUserId(ctx);
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getResponseAdminOrg(ctx, userId, list);
            this.mergeResponseAdminAndLeaderRange(ctx, userId, list, "fffffff0-ffff-efff-f2bd-0000002990a0PERMITEM");
        } else {
            this.getSubAdminOrg(ctx, userId, orgId, list, "fffffff0-ffff-efff-f2bd-0000002990a0PERMITEM");
        }
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            if (map.containsKey("subLongNumber")) {
                map.remove("subLongNumber");
            }
            subOrgMap.put("subOrg", list);
        }
        return subOrgMap;
    }

    private void getResponseAdminOrg(Context ctx, String userId, List<Map> list) throws BOSException, EASBizException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer("select adminOrg.fid,adminOrg.flongnumber,adminOrg.fname_" + l + " fname,adminOrg.fisleaf").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adminOrg on position.fadminorgunitid = adminOrg.fid").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition=1").append(" and adminOrg.FIsSealUp=0").append(" order by adminOrg.flongnumber asc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                String fid = rowSet.getString("fid");
                String fname = rowSet.getString("fname");
                String flongnumber = rowSet.getString("flongnumber");
                boolean isLeaf = rowSet.getBoolean("fisleaf");
                boolean includeSub = !isLeaf;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("subOrgId", fid);
                map.put("subOrgName", fname);
                map.put("subLongNumber", flongnumber);
                map.put("includeSub", includeSub);
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void mergeResponseAdminAndLeaderRange(Context ctx, String userId, List<Map> list, String permItemId) throws BOSException, EASBizException {
        String responseLongNumber = "";
        boolean isLeader = HRCmpReportUtil.getUserIsLeader(ctx, userId);
        if (!isLeader) {
            return;
        }
        if (list.size() > 0) {
            responseLongNumber = (String)list.get(0).get("subLongNumber");
        }
        String needEASPermSql = "select * from t_hr_shruseradminorgperm where FUserId = ? and FPermItemId = ? and FIsForbidden = 0";
        IRowSet needEASRowSet = DbUtil.executeQuery((Context)ctx, (String)needEASPermSql, (Object[])new Object[]{userId, permItemId});
        boolean needEASPerm = true;
        if (needEASRowSet.size() > 0) {
            needEASPerm = false;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        if (needEASPerm) {
            sql.append("select adminOrg.fid,adminOrg.flongnumber,adminOrg.fname_" + l + " fname,").append(" adminOrg.fisleaf,subOrg.fisincludesuborg").append(" from T_PM_OrgRangeIncludeSubOrg subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.forgid = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" where subOrg.fuserid = '").append(userId).append("'").append(" and subOrg.ftype = 20").append(" and adminOrg.fisstartshr = 1").append(" and adminOrg.FIsSealUp=0").append(" order by adminOrg.flongnumber asc");
        } else {
            sql.append("select adminOrg.fid,adminOrg.flongnumber,adminOrg.fname_" + l + " fname,").append(" adminOrg.fisleaf,subOrg.FIsIncludeSubOrg fisincludesuborg").append(" from t_hr_shruseradminorgperm subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.FAdminOrgID = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" where subOrg.fuserid = '").append(userId).append("'").append(" and subOrg.FPermType = 20").append(" and subOrg.FIsForbidden = 0").append(" and subOrg.FPermItemId = '").append(permItemId).append("'").append(" and adminOrg.FIsSealUp=0").append(" order by adminOrg.flongnumber asc");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                boolean includeSub;
                String fid = rowSet.getString("fid");
                String fname = rowSet.getString("fname");
                String longNumber = rowSet.getString("flongnumber");
                boolean isLeaf = rowSet.getBoolean("fisleaf");
                boolean isincludesuborg = rowSet.getBoolean("fisincludesuborg");
                boolean bl = includeSub = !isLeaf && isincludesuborg;
                if (!StringUtils.isEmpty((CharSequence)responseLongNumber)) {
                    boolean isSub = this.getIsSub(responseLongNumber, longNumber);
                    if (isSub) continue;
                    isSub = this.getIsSub(longNumber, responseLongNumber);
                    if (isSub && isincludesuborg) {
                        responseLongNumber = "";
                        list.remove(0);
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("subOrgId", fid);
                map.put("subOrgName", fname);
                map.put("includeSub", includeSub);
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void getSubAdminOrg(Context ctx, String userId, String orgId, List<Map> list, String permItemId) throws BOSException, EASBizException {
        try {
            boolean isLeader = HRCmpReportUtil.getUserIsLeader(ctx, userId);
            StringBuffer userAdminRangeSql = new StringBuffer();
            userAdminRangeSql.append("select adminOrg.fid").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin adminOrg on (charindex(concat(adcount.flongnumber,'!'),adminOrg.flongnumber) = 1 or adcount.flongnumber = adminOrg.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and adminOrg.FIsSealUp=0").append(" and position.fisrespposition=1");
            if (isLeader) {
                userAdminRangeSql.append(" union ");
                String needEASPermSql = "select * from t_hr_shruseradminorgperm where FUserId = ? and FPermItemId = ? and FIsForbidden = 0";
                IRowSet needEASRowSet = DbUtil.executeQuery((Context)ctx, (String)needEASPermSql, (Object[])new Object[]{userId, permItemId});
                boolean needEASPerm = true;
                if (needEASRowSet.size() > 0) {
                    needEASPerm = false;
                }
                if (needEASPerm) {
                    userAdminRangeSql.append("select adminOrg.fid").append(" from T_PM_OrgRange subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.forgid = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" where subOrg.fuserid = '").append(userId).append("'").append(" and subOrg.ftype = 20").append(" and adminOrg.fisstartshr = 1").append(" and adminOrg.FIsSealUp=0");
                } else {
                    userAdminRangeSql.append(" SELECT FAdminOrgID as fid FROM T_HR_SHRUserAdminOrgPerm  ").append(" where FUserId = '").append(userId).append("'").append(" and FPermItemId = '").append(permItemId).append("'").append(" and FIsForbidden = 0 ").append(" and FIsIncludeSubOrg = 0 ").append(" union all ").append(" SELECT org.FID FAdminOrgID FROM  (").append(" SELECT perm.FAdminOrgID,adminOrg.FLONGNUMBER  FROM T_HR_SHRUserAdminOrgPerm perm ").append(" inner join T_ORG_Admin adminOrg ").append(" on perm.FAdminOrgID = adminOrg.FID ").append(" where perm.fuserid = '").append(userId).append("'").append(" and perm.fpermItemId = '").append(permItemId).append("'").append(" and perm.FIsIncludeSubOrg = 1 and perm.FIsForbidden = 0 ").append(" and adminOrg.FIsSealUp=0").append(" ) detail ").append(" inner join T_ORG_Admin org ").append(" on ( CHARINDEX( concat(detail.flongnumber,'!'),org.flongnumber )=1 ").append(" or detail.flongnumber = org.flongnumber)");
                }
            }
            StringBuffer downAdminHasSubSql = new StringBuffer();
            downAdminHasSubSql.append("select count(children.fid) childrenCount, parent.fid");
            downAdminHasSubSql.append(" from t_org_admin parent");
            downAdminHasSubSql.append(" left join t_org_admin children  on (charindex(concat(parent.flongnumber,'!'),children.flongnumber) = 1)");
            downAdminHasSubSql.append(" and children.fid in (");
            downAdminHasSubSql.append(userAdminRangeSql).append(")");
            downAdminHasSubSql.append(" and children.FIsSealUp=0");
            downAdminHasSubSql.append(" where parent.fparentid = '");
            downAdminHasSubSql.append(orgId).append("'");
            downAdminHasSubSql.append(" and parent.FIsSealUp=0");
            downAdminHasSubSql.append(" group by parent.fid");
            String l = LocaleUtils.getShortCode((Context)ctx);
            StringBuffer downAdminSql = new StringBuffer();
            downAdminSql.append("select adminOrg.fid, adminOrg.fisstartshr,adminOrg.fisleaf,downAdmin.childrenCount,adminOrg.fname_" + l + " name from t_org_admin adminOrg");
            downAdminSql.append(" inner join (");
            downAdminSql.append(downAdminHasSubSql.toString()).append(") downAdmin");
            downAdminSql.append(" on downAdmin.fid = adminOrg.fid");
            IRowSet downAdminRowSet = DbUtil.executeQuery((Context)ctx, (String)downAdminSql.toString());
            while (downAdminRowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (downAdminRowSet.getString("fisstartshr") == null) {
                    if (downAdminRowSet.getInt("childrenCount") == 0 || downAdminRowSet.getInt("childrenCount") <= 0) continue;
                    map.put("subOrgId", downAdminRowSet.getString("fid"));
                    map.put("subOrgName", downAdminRowSet.getString("name") + "\uff08uninitialized\uff09");
                    map.put("includeSub", true);
                    list.add(map);
                    continue;
                }
                if (downAdminRowSet.getInt("fisstartshr") == 0 && downAdminRowSet.getInt("childrenCount") == 0) continue;
                if (downAdminRowSet.getInt("fisstartshr") == 0 && downAdminRowSet.getInt("childrenCount") > 0) {
                    map.put("subOrgId", downAdminRowSet.getString("fid"));
                    map.put("subOrgName", downAdminRowSet.getString("name") + "\uff08uninitialized\uff09");
                    map.put("includeSub", true);
                    list.add(map);
                    continue;
                }
                if (downAdminRowSet.getInt("fisstartshr") == 1 && downAdminRowSet.getInt("childrenCount") == 0) {
                    map.put("subOrgId", downAdminRowSet.getString("fid"));
                    map.put("subOrgName", downAdminRowSet.getString("name"));
                    map.put("includeSub", false);
                    list.add(map);
                    continue;
                }
                if (downAdminRowSet.getInt("fisstartshr") != 1 || downAdminRowSet.getInt("childrenCount") <= 0) continue;
                map.put("subOrgId", downAdminRowSet.getString("fid"));
                map.put("subOrgName", downAdminRowSet.getString("name"));
                map.put("includeSub", true);
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private boolean getIsSub(String longNumber1, String longNumber2) {
        boolean isSub = false;
        int index = longNumber2.indexOf(longNumber1 + "!");
        if (index == 0 || longNumber1.equals(longNumber2)) {
            isSub = true;
        }
        return isSub;
    }
}

