/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpBudgetReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpBudgetReportFacadeControllerBean
extends AbstractHRCmpBudgetReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpBudgetReportFacadeControllerBean");

    @Override
    protected Map _getCmpBudgetReport(Context ctx, String orgId) throws BOSException, EASBizException {
        Map<String, Object> cmpBudgetReport = this.getCmpBudget(ctx, orgId);
        return cmpBudgetReport;
    }

    private Map<String, Object> getCmpBudget(Context ctx, String orgId) throws BOSException {
        int year = HRCmpReportUtil.getCurrYear();
        int month = HRCmpReportUtil.getCurrMonth();
        logger.info("~~~~~~ Compensation period : " + year + "-" + month);
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null);
        logger.info("~~~~~~ Compensation cmpItem : " + cmpItems + " ~~~~~~~");
        Map<String, Object> cmpBudgetReportMap = this.getCmpBudgetReport(ctx, orgId, year, month, cmpItems);
        return cmpBudgetReportMap;
    }

    private Map<String, Object> getCmpBudgetReport(Context ctx, String orgId, int year, int month, String cmpItems) throws BOSException {
        HashMap<String, Object> cmpTrendMap = new HashMap<String, Object>();
        this.getSalaryTrend(ctx, orgId, year, month, cmpItems, cmpTrendMap);
        this.getBudgetTrend(ctx, orgId, year, month, cmpTrendMap);
        return cmpTrendMap;
    }

    private void getSalaryTrend(Context ctx, String orgId, int year, int month, String cmpItems, Map<String, Object> cmpTrendMap) throws BOSException {
        HashMap<String, Object> salaryTrend = new HashMap<String, Object>();
        ArrayList<String> salaryTrendLable = new ArrayList<String>(6);
        ArrayList<Double> salaryTrendData = new ArrayList<Double>(6);
        if (month < 6) {
            int lastMonth = 12 - (6 - month) + 1;
            int lastYear = year - 1;
            String lastYearSalaryTrendSql = HRCmpReportUtil.getYearSalaryTrend(ctx, cmpItems, orgId, lastYear, lastMonth, false);
            this.handleResultFromRowSet(ctx, lastYearSalaryTrendSql, salaryTrendLable, salaryTrendData);
        }
        String currYearSalaryTrendSql = HRCmpReportUtil.getYearSalaryTrend(ctx, cmpItems, orgId, year, month, true);
        this.handleResultFromRowSet(ctx, currYearSalaryTrendSql, salaryTrendLable, salaryTrendData);
        salaryTrend.put("labelList", salaryTrendLable);
        salaryTrend.put("dataList", salaryTrendData);
        this.handleTrendMap(salaryTrend, year, month);
        cmpTrendMap.put("salaryTrend", salaryTrend);
    }

    private void getBudgetTrend(Context ctx, String orgId, int year, int month, Map<String, Object> cmpTrendMap) {
        HashMap<String, ArrayList<Object>> costBudgetTrend = new HashMap<String, ArrayList<Object>>();
        HashMap<String, Object> costBudgetData = new HashMap<String, Object>();
        ArrayList<String> costBudgetTrendLable = new ArrayList<String>(6);
        ArrayList<Double> costBudgetTrendData = new ArrayList<Double>(6);
        String budgetTrendSql = HRCmpReportUtil.getBudgetTrend(ctx, orgId, year);
        this.handleBudgetFromRowSet(ctx, budgetTrendSql, costBudgetData);
        HRCmpReportUtil.handleTrendList(year, month, costBudgetTrendLable, costBudgetTrendData, costBudgetData);
        costBudgetTrend.put("labelList", costBudgetTrendLable);
        costBudgetTrend.put("dataList", costBudgetTrendData);
        cmpTrendMap.put("budgetTrend", costBudgetTrend);
    }

    private void handleResultFromRowSet(Context ctx, String sql, List<String> salaryTrendLable, List<Double> salaryTrendData) {
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            while (rowSet.next()) {
                int yearLabel = rowSet.getInt("periodYear");
                int monthLabel = rowSet.getInt("periodMonth");
                double salaryTotal = rowSet.getDouble("total");
                String periodLabel = yearLabel + "-" + monthLabel;
                salaryTrendLable.add(periodLabel);
                salaryTrendData.add(salaryTotal);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void handleTrendMap(Map<String, Object> trend, int year, int month) {
        List<String> defPeriodLabelList = HRCmpReportUtil.getDefPeriodLabel(year, month, 6);
        List labelList = (List)trend.get("labelList");
        List dataList = (List)trend.get("dataList");
        for (int i = 0; i < defPeriodLabelList.size(); ++i) {
            String label = defPeriodLabelList.get(i);
            if (labelList.contains(label)) continue;
            labelList.add(i, label);
            dataList.add(i, 0.0);
        }
        trend.put("labelList", labelList);
        trend.put("dataList", dataList);
    }

    private void handleBudgetFromRowSet(Context ctx, String sql, Map<String, Object> costBudgetData) {
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("year");
                int rsMonth = rowSet.getInt("month");
                double total = rowSet.getDouble("total");
                costBudgetData.put(rsYear + "-" + rsMonth, total);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

