/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpOrgReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpOrgReportFacadeControllerBean
extends AbstractHRCmpOrgReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpOrgReportFacadeControllerBean");

    @Override
    protected Map _getCmpOrgReport(Context ctx, String orgId, String period) throws BOSException, EASBizException {
        HashMap<String, Map<String, Object>> orgReportData = new HashMap<String, Map<String, Object>>();
        Map<String, Object> cmpOrgData = this.getCmpOrgData(ctx, orgId, period);
        orgReportData.put("cmpOrgData", cmpOrgData);
        return orgReportData;
    }

    private Map<String, Object> getCmpOrgData(Context ctx, String orgId, String period) throws BOSException {
        HashMap<String, Object> cmpDimensionIndexData = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int year = HRCmpReportUtil.getYearViaPeriod(period);
        int month = HRCmpReportUtil.getMonthViaPeriod(period);
        double sumTotal = 0.0;
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null);
        sumTotal += this.handleCurrOrgData(ctx, cmpItems, list, orgId, year, month);
        HRCmpReportUtil.getPercent(list, sumTotal += this.handleSubOrgData(ctx, cmpItems, list, orgId, year, month));
        cmpDimensionIndexData.put("cmpOrgList", list);
        return cmpDimensionIndexData;
    }

    private double handleCurrOrgData(Context ctx, String cmpItems, List<Map<String, Object>> list, String orgId, int year, int month) {
        double sumTotal = 0.0;
        try {
            String sumCurrOrgDataSql = HRCmpReportUtil.getSumCurrOrgDataByPeriodYearAndMonth(ctx, cmpItems, orgId, year, month);
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sumCurrOrgDataSql);
            if (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String name = rowSet.getString("name");
                boolean isLeaf = rowSet.getBoolean("isleaf");
                boolean includeSub = !isLeaf;
                double total = rowSet.getInt("total");
                String id = rowSet.getString("id");
                sumTotal += total;
                map.put("name", name + "(" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"labe5", (Locale)ctx.getLocale()) + ")");
                map.put("total", total);
                map.put("includeSub", includeSub);
                map.put("id", id);
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sumTotal;
    }

    private double handleSubOrgData(Context ctx, String cmpItems, List<Map<String, Object>> list, String orgId, int year, int month) throws BOSException {
        double sumTotal = 0.0;
        String sumSubOrgDataSql = HRCmpReportUtil.getSumSubOrgDataByPeriodYearAndMonth(ctx, orgId, cmpItems, year, month);
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sumSubOrgDataSql);
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String name = rowSet.getString("name");
                boolean isLeaf = rowSet.getBoolean("isleaf");
                boolean includeSub = !isLeaf;
                double total = rowSet.getInt("total");
                String id = rowSet.getString("id");
                sumTotal += total;
                map.put("name", name);
                map.put("total", total);
                map.put("includeSub", includeSub);
                map.put("id", id);
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sumTotal;
    }
}

