/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpTotalReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpTotalReportFacadeControllerBean
extends AbstractHRCmpTotalReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpTotalReportFacadeControllerBean");

    @Override
    protected Map _getCmpTotalReport(Context ctx, String orgId) throws BOSException, EASBizException {
        Map<String, Object> cmpTotalReport = this.getCmpTotal(ctx, orgId);
        return cmpTotalReport;
    }

    private Map<String, Object> getCmpTotal(Context ctx, String orgId) {
        HashMap<String, Object> cmpMap = new HashMap<String, Object>();
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null, true);
        logger.info("~~~~~~ Compensation cmpItems : " + cmpItems);
        double total = this.getCmpLaborTotal(ctx, cmpItems, orgId);
        logger.info("~~~~~~ Compensation labor total : " + total);
        DecimalFormat fmt = new DecimalFormat("#,##0.00");
        cmpMap.put("salary", fmt.format((Object)total));
        return cmpMap;
    }

    private double getCmpLaborTotal(Context ctx, String cmpItems, String orgId) {
        double salary = 0.0;
        int periodYear = 0;
        int periodMonth = 0;
        try {
            String sumLaborTotalSql = HRCmpReportUtil.getSumLaborTotalBySingleMonth(ctx, cmpItems, orgId);
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sumLaborTotalSql);
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                double rsSalary = rowSet.getDouble("total");
                if (rsYear <= periodYear && (rsYear != periodYear || rsMonth <= periodMonth)) continue;
                periodYear = rsYear;
                periodMonth = rsMonth;
                salary = rsSalary;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return salary;
    }
}

