/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpTrendReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpTrendReportFacadeControllerBean
extends AbstractHRCmpTrendReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpTrendReportFacadeControllerBean");

    @Override
    protected Map _getCmpTrendReport(Context ctx, String orgId) throws BOSException, EASBizException {
        int year = HRCmpReportUtil.getCurrYear();
        int month = HRCmpReportUtil.getCurrMonth();
        logger.info("~~~~~~ Compensation period : " + year + "-" + month);
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null, true);
        logger.info("~~~~~~ Compensation cmpItem : " + cmpItems);
        return this.getCmpTrendReport(ctx, orgId, year, month, cmpItems);
    }

    private Map<String, Object> getCmpTrendReport(Context ctx, String orgId, int year, int month, String cmpItems) throws BOSException {
        HashMap<String, Object> cmpTrendMap = new HashMap<String, Object>();
        this.getSalaryTrend(ctx, orgId, year, month, cmpItems, cmpTrendMap);
        this.handDiscrepancyRateTrend(cmpTrendMap);
        this.getBudgetData(ctx, orgId, year, month, cmpTrendMap);
        return cmpTrendMap;
    }

    private void getSalaryTrend(Context ctx, String orgId, int year, int month, String cmpItems, Map<String, Object> cmpTrendMap) throws BOSException {
        HashMap<String, Object[]> salaryTrend = new HashMap<String, Object[]>();
        HashMap<String, Object> salaryData = new HashMap<String, Object>();
        List<String> salaryTrendLable = new ArrayList<String>();
        ArrayList<Double> salaryTrendData = new ArrayList<Double>();
        HashMap<String, Object[]> yoySalaryTrend = new HashMap<String, Object[]>();
        List<String> yoySalaryTrendLable = new ArrayList<String>();
        ArrayList<Double> yoySalaryTrendData = new ArrayList<Double>();
        double actual = 0.0;
        String compSalaryTrendSql = HRCmpReportUtil.getCompSalaryTrend(ctx, cmpItems, orgId, year, month);
        this.handleCompSalaryTrend(ctx, compSalaryTrendSql, salaryData);
        HRCmpReportUtil.handleTrendList(year, month, salaryTrendLable, salaryTrendData, salaryData);
        HRCmpReportUtil.handleTrendList(year - 1, month, yoySalaryTrendLable, yoySalaryTrendData, salaryData);
        String currMonthLabel = year + "-" + month;
        if (salaryData.containsKey(currMonthLabel)) {
            actual = Double.valueOf(salaryData.get(currMonthLabel).toString());
        }
        cmpTrendMap.put("actual", actual);
        if ("l1".equalsIgnoreCase(ctx.getLocale().getLanguage())) {
            yoySalaryTrendLable = CmpDateUtil.changeDateToEnForMat(yoySalaryTrendLable);
            salaryTrendLable = CmpDateUtil.changeDateToEnForMat(salaryTrendLable);
        }
        salaryTrend.put("labelList", salaryTrendLable.toArray());
        salaryTrend.put("dataList", salaryTrendData.toArray());
        cmpTrendMap.put("salaryTrend", salaryTrend);
        yoySalaryTrend.put("labelList", yoySalaryTrendLable.toArray());
        yoySalaryTrend.put("dataList", yoySalaryTrendData.toArray());
        cmpTrendMap.put("YOYSalaryTrend", yoySalaryTrend);
    }

    private void handleCompSalaryTrend(Context ctx, String sql, Map<String, Object> salaryData) {
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sql);
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                double total = rowSet.getDouble("total");
                salaryData.put(rsYear + "-" + rsMonth, HRCmpReportUtil.formatDouble(total / 10000.0));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void getBudgetData(Context ctx, String orgId, int year, int month, Map<String, Object> cmpTrendMap) {
        double total = 0.0;
        String currMonthBudgetSql = HRCmpReportUtil.getCurrMonthBudget(orgId, year, month);
        try {
            IRowSet rowSet = SqlUtil.executeQuery(ctx, currMonthBudgetSql);
            while (rowSet.next()) {
                total = rowSet.getDouble("total");
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        cmpTrendMap.put("budget", HRCmpReportUtil.formatDouble(total / 10000.0));
    }

    private void handDiscrepancyRateTrend(Map<String, Object> cmpTrendMap) {
        HashMap discrepancyRateTrend = new HashMap();
        ArrayList<String> discrepancyRateTrendLable = new ArrayList<String>();
        ArrayList<Double> discrepancyRateTrendValue = new ArrayList<Double>();
        ArrayList<String> discrepancyRateTrendData = new ArrayList<String>();
        Map salaryTrend = (Map)cmpTrendMap.get("salaryTrend");
        Map yoySalaryTrend = (Map)cmpTrendMap.get("YOYSalaryTrend");
        if (salaryTrend != null && yoySalaryTrend != null) {
            Object[] labelList = (Object[])salaryTrend.get("labelList");
            Object[] salaryDataList = (Object[])salaryTrend.get("dataList");
            Object[] yoySalaryDataList = (Object[])yoySalaryTrend.get("dataList");
            for (int i = 0; i < labelList.length; ++i) {
                discrepancyRateTrendLable.add(labelList[i].toString());
                double percent = HRCmpReportUtil.calPercent(Double.valueOf(salaryDataList[i].toString()), Double.valueOf(yoySalaryDataList[i].toString()));
                discrepancyRateTrendData.add(percent + "%");
                discrepancyRateTrendValue.add(percent);
            }
        }
        discrepancyRateTrend.put("labelList", discrepancyRateTrendLable);
        discrepancyRateTrend.put("dataList", discrepancyRateTrendData);
        discrepancyRateTrend.put("valueList", discrepancyRateTrendValue);
        cmpTrendMap.put("discrepancyRateTrend", discrepancyRateTrend);
    }
}

