/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CmpEmpORelationCollection;
import com.kingdee.shr.compensation.CmpEmpORelationFactory;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.ICmpEmpORelation;
import com.kingdee.shr.compensation.PersonCmpException;
import com.kingdee.shr.compensation.PersonCmpInfo;
import com.kingdee.shr.compensation.app.AbstractPersonCmpFacadeControllerBean;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.ml.util.NumberTransfer;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonCmpFacadeControllerBean
extends AbstractPersonCmpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.PersonCmpFacadeControllerBean");

    @Override
    protected boolean _checkDataValid(Context ctx, Map param) throws BOSException, EASBizException {
        PersonCmpInfo info = (PersonCmpInfo)param.get("info");
        String id = info.getId().toString();
        java.util.Date effectDate = info.getEffectDate();
        java.util.Date leffectDate = info.getLeffectDate();
        ICmpEmpORelation cmpEmpORelation = CmpEmpORelationFactory.getLocalInstance(ctx);
        String maxKsqlDate = CmpDateUtil.getMaxKsqlDate();
        String oql = "where personCmp='" + id + "' and leffectDate<" + maxKsqlDate + " order by effectDate";
        CmpEmpORelationCollection coll = cmpEmpORelation.getCmpEmpORelationCollection(oql);
        if (coll.size() == 0) {
            return true;
        }
        CmpEmpORelationInfo firstRelation = coll.get(0);
        CmpEmpORelationInfo lastRelation = coll.get(coll.size() - 1);
        java.util.Date minDate = firstRelation.getEffectDate();
        java.util.Date maxDate = lastRelation.getLeffectDate();
        return !(!effectDate.before(minDate) && !effectDate.equals(minDate) || !leffectDate.after(maxDate) && !leffectDate.equals(maxDate));
    }

    @Override
    protected void _loseData(Context ctx, Map param) throws BOSException, EASBizException {
        String billIds = (String)param.get("billIds");
        String cmpEmpIds = (String)param.get("cmpEmpIds");
        String recordIds = CmpSQLUtil.createInSql(ctx, billIds, "T_HR_SPersonCmp", "fid");
        java.util.Date loseDate = (java.util.Date)param.get("loseDate");
        this.checkLoseDateValid(ctx, billIds, loseDate, recordIds);
        this.checkCalTableQuote(ctx, cmpEmpIds, loseDate);
        Date sqlDate = new Date(loseDate.getTime());
        Object[] updateParam = new Object[]{sqlDate};
        String sql = CmpRecordSQL.getChangePersonCmpLoseDateSql(recordIds);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])updateParam);
        Object[] cmpEmpParam = new Object[]{sqlDate, sqlDate};
        String cmpEmpSql = CmpRecordSQL.getChangeCmpEmpOLoseDateSql(recordIds);
        DbUtil.execute((Context)ctx, (String)cmpEmpSql, (Object[])cmpEmpParam);
        Object[] cmpSystemParam = new Object[]{sqlDate, sqlDate};
        String cmpSystemSql = CmpRecordSQL.getChangeCmpSystemLoseDateSql(recordIds);
        DbUtil.execute((Context)ctx, (String)cmpSystemSql, (Object[])cmpSystemParam);
        Object[] costBearParam = new Object[]{sqlDate, sqlDate};
        String costBearSql = CmpRecordSQL.getChangeCostBearOrgLoseDateSql(recordIds);
        DbUtil.execute((Context)ctx, (String)costBearSql, (Object[])costBearParam);
        String pbuIdSql = " select FPersonBURelationID from T_HR_SCmpEmpORelation where FPersonCmpID in (" + recordIds + ")";
        RecordUtil.updatePBUState(ctx, pbuIdSql, 2, false);
    }

    @Override
    protected Map _sendSalary(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String updateSql = (String)param.get("updateSql");
        int num = CmpSQLUtil.executeUpdate(ctx, updateSql);
        String message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label0", (Locale)ctx.getLocale()) + "\uff1a" + NumberTransfer.format((Context)ctx, (int)0, (String)"round", (Object)num) + "";
        map.put("message", message);
        return map;
    }

    @Override
    protected Map _stopSalary(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String updateSql = (String)param.get("updateSql");
        int num = CmpSQLUtil.executeUpdate(ctx, updateSql);
        StringBuilder message = new StringBuilder();
        message.append(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label1", (Locale)ctx.getLocale()) + "\uff1a" + NumberTransfer.format((Context)ctx, (int)0, (String)"round", (Object)num));
        String failSql = (String)param.get("failSql");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)failSql);
        try {
            while (rs.next()) {
                int count = rs.getInt("count");
                if (count <= 0) continue;
                message.append("," + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label2", (Locale)ctx.getLocale()) + "\uff1a" + NumberTransfer.format((Context)ctx, (int)0, (String)"round", (Object)count) + "!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        map.put("message", message.toString());
        return map;
    }

    private void checkLoseDateValid(Context ctx, String billIds, java.util.Date loseDate, String inSql) throws BOSException, EASBizException {
        Map<String, List<Object>> allDataMap = this.getPersonCmpMap(ctx, inSql);
        Map<String, List<java.util.Date>> maxCmpEmpOreDateMap = this.getMaxCmpEmpOreDateMap(ctx, inSql);
        Map<String, List<java.util.Date>> maxCmpSystemDateMap = this.getMaxCmpSystemDateMap(ctx, inSql);
        Map<String, List<java.util.Date>> maxCostbearDateMap = this.getMaxCostbearDateMap(ctx, inSql);
        String[] billArr = billIds.split(",");
        String dateStr = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date effectDate = null;
        java.util.Date maxEmpDate = null;
        java.util.Date minEmpDate = null;
        java.util.Date minSystemDate = null;
        java.util.Date maxSystemDate = null;
        java.util.Date minCostDate = null;
        java.util.Date maxCostDate = null;
        for (String billId : billArr) {
            List<Object> list = allDataMap.get(billId);
            if (maxCmpEmpOreDateMap.get(billId) != null) {
                minEmpDate = maxCmpEmpOreDateMap.get(billId).get(0);
                maxEmpDate = maxCmpEmpOreDateMap.get(billId).get(1);
            }
            effectDate = (java.util.Date)list.get(0);
            String personName = (String)list.get(1);
            if (loseDate.before(effectDate)) {
                Object[] param = new Object[]{personName};
                throw new PersonCmpException(PersonCmpException.EFFECT_AFTER_LEFFECT, param);
            }
            if (maxEmpDate != null && loseDate.before(maxEmpDate)) {
                dateStr = format.format(maxEmpDate);
                Object[] param = new Object[]{personName, dateStr};
                throw new PersonCmpFacadeException(PersonCmpFacadeException.BEFOREDATEPART);
            }
            if (minEmpDate != null && loseDate.before(minEmpDate)) {
                dateStr = format.format(minEmpDate);
                Object[] param = new Object[]{personName, dateStr};
                throw new PersonCmpFacadeException(PersonCmpFacadeException.BEFOREDATEPART);
            }
            if (maxCmpSystemDateMap.get(billId) != null) {
                minSystemDate = maxCmpSystemDateMap.get(billId).get(0);
                maxSystemDate = maxCmpSystemDateMap.get(billId).get(1);
            }
            if (maxSystemDate != null && loseDate.before(maxSystemDate)) {
                dateStr = format.format(maxSystemDate);
                Object[] param = new Object[]{personName, dateStr};
                throw new PersonCmpFacadeException(PersonCmpFacadeException.BEFOREDATEPART);
            }
            if (minSystemDate != null && loseDate.before(minSystemDate)) {
                dateStr = format.format(minSystemDate);
                Object[] param = new Object[]{personName, dateStr};
                throw new PersonCmpFacadeException(PersonCmpFacadeException.BEFOREDATEPART);
            }
            if (maxCostbearDateMap.get(billId) != null) {
                minCostDate = maxCostbearDateMap.get(billId).get(0);
                maxCostDate = maxCostbearDateMap.get(billId).get(1);
            }
            if (maxCostDate != null && loseDate.before(maxCostDate)) {
                dateStr = format.format(maxCostDate);
                Object[] param = new Object[]{personName, dateStr};
                throw new PersonCmpFacadeException(PersonCmpFacadeException.BEFORESHAREDATE);
            }
            if (minCostDate == null || !loseDate.before(minCostDate)) continue;
            dateStr = format.format(minCostDate);
            Object[] param = new Object[]{personName, dateStr};
            throw new PersonCmpFacadeException(PersonCmpFacadeException.BEFORESHAREDATE);
        }
    }

    private void checkCalTableQuote(Context ctx, String cmpEmpIds, java.util.Date loseDate) throws BOSException, EASBizException {
        String[] cmpEmpIdArr = cmpEmpIds.split(",");
        String filterSql = CmpSQLUtil.createInSql(ctx, cmpEmpIds, "t_hr_scmpcaltable", "FCmpEmpORelationID");
        Map<String, java.util.Date> empEffectDateMap = this.getEmpEffectDateMap(ctx, filterSql);
        Map<String, List<String>> schemeEmpMap = this.getSchemeByCmpEmpAndBeginDate(ctx, filterSql);
        String cmpEmpId2 = "";
        java.util.Date maxDate = null;
        String msg = "";
        String key = "";
        String dateStr = "";
        String schemeName = "";
        String periodYear = "";
        String periodMonth = "";
        String calTime = "";
        String personName = "";
        List<String> shemeList = null;
        for (String cmpEmpId2 : cmpEmpIdArr) {
            if (!empEffectDateMap.containsKey(cmpEmpId2) || !loseDate.before(maxDate = empEffectDateMap.get(cmpEmpId2))) continue;
            dateStr = CmpDateUtil.toKSqlDate(maxDate);
            key = cmpEmpId2 + "_" + dateStr;
            shemeList = schemeEmpMap.get(key);
            schemeName = shemeList.get(0);
            periodYear = shemeList.get(1);
            periodMonth = shemeList.get(2);
            calTime = shemeList.get(3);
            personName = shemeList.get(4);
            msg = personName + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label3", (Locale)ctx.getLocale()) + "[" + schemeName + "-" + periodYear + "-" + periodMonth + "-" + calTime + "]";
            throw new EASBizException(new NumericExceptionSubItem("001", msg));
        }
    }

    private Map<String, java.util.Date> getEmpEffectDateMap(Context ctx, String filterSql) throws BOSException {
        HashMap<String, java.util.Date> map = new HashMap<String, java.util.Date>();
        String sql = "select FCmpEmpORelationID, max(FRealEndDate) maxDate from t_hr_scmpcaltable where FCmpEmpORelationID in(" + filterSql + ") group by FCmpEmpORelationID";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String cmpEmpId = "";
        Date maxDate = null;
        try {
            while (rs.next()) {
                cmpEmpId = rs.getString("FCmpEmpORelationID");
                maxDate = rs.getDate("maxDate");
                map.put(cmpEmpId, maxDate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, List<String>> getSchemeByCmpEmpAndBeginDate(Context ctx, String filterSql) throws BOSException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select person.fname_" + l + " personName, caltable.FCmpEmpORelationID, caltable.FRealEndDate, scheme.fname_" + l + ", scheme.FPeriodYear, scheme.FPeriodMonth, scheme.FCalTime from t_hr_scmpcaltable caltable left join t_hr_scalscheme scheme on caltable.FCalSchemeID=scheme.fid left join t_bd_person person on caltable.fpersonid=person.fid where caltable.FCmpEmpORelationID in(" + filterSql + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String cmpEmpId = "";
        String dateStr = "";
        String personName = "";
        Date realEndDate = null;
        String key = "";
        String schemeName = "";
        String periodYear = "";
        String periodMonth = "";
        String calTime = "";
        ArrayList<String> value = null;
        try {
            while (rs.next()) {
                cmpEmpId = rs.getString("FCmpEmpORelationID");
                realEndDate = rs.getDate("FRealEndDate");
                dateStr = CmpDateUtil.toKSqlDate(realEndDate);
                schemeName = rs.getString("fname_" + l + "");
                periodYear = rs.getString("FPeriodYear");
                periodMonth = rs.getString("FPeriodMonth");
                calTime = rs.getString("FCalTime");
                personName = rs.getString("personName");
                value = new ArrayList<String>();
                value.add(schemeName);
                value.add(periodYear);
                value.add(periodMonth);
                value.add(calTime);
                value.add(personName);
                key = cmpEmpId + "_" + dateStr;
                map.put(key, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, List<Object>> getPersonCmpMap(Context ctx, String inSql) throws BOSException {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        ArrayList<Object> list = null;
        String sql = CmpRecordSQL.getPersonCmpInfoSql(inSql, ctx);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                list = new ArrayList<Object>();
                String personCmpId = rs.getString("fid");
                Date effectDate = rs.getDate("FEffectDate");
                String personName = rs.getString("personName");
                list.add(effectDate);
                list.add(personName);
                map.put(personCmpId, list);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, List<java.util.Date>> getMaxCmpEmpOreDateMap(Context ctx, String inSql) throws BOSException {
        HashMap<String, List<java.util.Date>> map = new HashMap<String, List<java.util.Date>>();
        String sql = CmpRecordSQL.getMaxCmpEmpOreLoseDateSql(inSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<Date> list = null;
        try {
            while (rs.next()) {
                list = new ArrayList<Date>();
                String personCmpId = rs.getString("fpersoncmpid");
                Date minDate = rs.getDate("minDate");
                Date maxDate = rs.getDate("maxDate");
                list.add(minDate);
                list.add(maxDate);
                map.put(personCmpId, list);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, List<java.util.Date>> getMaxCmpSystemDateMap(Context ctx, String inSql) throws BOSException {
        HashMap<String, List<java.util.Date>> map = new HashMap<String, List<java.util.Date>>();
        String sql = CmpRecordSQL.getMaxCmpSystemLoseDateSql(inSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<Date> list = null;
        try {
            while (rs.next()) {
                list = new ArrayList<Date>();
                String personCmpId = rs.getString("fpersoncmpid");
                Date minDate = rs.getDate("minDate");
                Date maxDate = rs.getDate("maxDate");
                list.add(minDate);
                list.add(maxDate);
                map.put(personCmpId, list);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, List<java.util.Date>> getMaxCostbearDateMap(Context ctx, String inSql) throws BOSException {
        HashMap<String, List<java.util.Date>> map = new HashMap<String, List<java.util.Date>>();
        String sql = CmpRecordSQL.getMaxCostbearLoseDateSql(inSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<Date> list = null;
        try {
            while (rs.next()) {
                list = new ArrayList<Date>();
                String personCmpId = rs.getString("fpersoncmpid");
                Date minDate = rs.getDate("minDate");
                Date maxDate = rs.getDate("maxDate");
                list.add(minDate);
                list.add(maxDate);
                map.put(personCmpId, list);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

