/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.TaxDataPermCommonException;
import com.kingdee.shr.compensation.TaxUnitDataPermFactory;
import com.kingdee.shr.compensation.TaxUnitDataPermInfo;
import com.kingdee.shr.compensation.TaxUnitDataPermType;
import com.kingdee.shr.compensation.app.AbstractTaxUnitDataPermFacadeControllerBean;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.permission.RecordPermAPI;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class TaxUnitDataPermFacadeControllerBean
extends AbstractTaxUnitDataPermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.TaxUnitDataPermFacadeControllerBean");

    @Override
    protected void _saveTaxUnitDataPermRange(Context ctx, Map param) throws BOSException, EASBizException {
        String personIds = (String)param.get("personIds");
        String itemInfo = (String)param.get("itemInfo");
        CoreBaseCollection coll = new CoreBaseCollection();
        String[] personIdArr = personIds.split(",");
        try {
            for (int k = 0; k < personIdArr.length; ++k) {
                String personId = personIdArr[k].trim();
                if (StringUtils.isEmpty((String)personId)) continue;
                PersonInfo personInfo = RecordPermAPI.getPersonInfo(ctx, personId);
                TaxUnitDataPermFactory.getLocalInstance(ctx).delete(" where person.id='" + personId + "'");
                TaxUnitDataPermInfo item = null;
                JSONArray items = new JSONArray(itemInfo);
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject t = items.getJSONObject(i);
                    String itemId = t.getString("itemId");
                    item = new TaxUnitDataPermInfo();
                    TaxUnitInfo taxUnitInfo = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitInfo((IObjectPK)new ObjectUuidPK(itemId));
                    item.setPerson(personInfo);
                    item.setTaxUnit(taxUnitInfo);
                    item.setIsPersonPerm(true);
                    item.setPermType(TaxUnitDataPermType.personType);
                    coll.add((CoreBaseInfo)item);
                }
                TaxUnitDataPermFactory.getLocalInstance(ctx).saveBatchData(coll);
                coll.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaxDataPermCommonException(TaxDataPermCommonException.SAVE_DATAPERM_ERROR);
        }
    }

    @Override
    protected List _getAssignedTaxUnit(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        String personId = (String)param.get("personId");
        String personIds = "('" + personId.replace(",", "','") + "')";
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT perm.fid id,tax.fnumber number, tax.fname_" + l + " taxUnitName, perm.FTaxUnitID ");
        sb.append(" FROM T_HR_STaxUnitDataPerm perm ");
        sb.append(" left join T_HR_TaxUnit tax on perm.FTaxUnitID=tax.fid ");
        sb.append(" where perm.FPermType='1' and perm.FIsPersonPerm=1 and perm.fpersonid in " + personIds);
        sb.append(" order by tax.fnumber asc, tax.fname_" + l + " asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int count = 0;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList<String> list = null;
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                String taxUnitId = rs.getString("FTaxUnitID");
                String taxUnitNumber = rs.getString("number");
                String taxUnitName = rs.getString("taxUnitName");
                list = new ArrayList<String>();
                list.add(taxUnitId);
                list.add(taxUnitNumber);
                list.add(taxUnitName);
                map.put(id, list);
                if (countMap.get(taxUnitId) == null) {
                    count = 1;
                } else {
                    count = (Integer)countMap.get(taxUnitId);
                    ++count;
                }
                countMap.put(taxUnitId, count);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaxDataPermCommonException(TaxDataPermCommonException.ASSIGNED_TAXUNIT_ERROR);
        }
        result.add(map);
        result.add(countMap);
        return result;
    }

    @Override
    protected void _saveTaxUnitRolePerm(Context ctx, Map param) throws BOSException {
        String roleIds = (String)param.get("roleIds");
        String itemInfo = (String)param.get("itemInfo");
        CoreBaseCollection coll = new CoreBaseCollection();
        String[] roleIdArr = roleIds.split(",");
        try {
            for (int k = 0; k < roleIdArr.length; ++k) {
                String roleId = roleIdArr[k].trim();
                if (StringUtils.isEmpty((String)roleId)) continue;
                RoleInfo roleInfo = RoleFactory.getLocalInstance((Context)ctx).getRoleInfo((IObjectPK)new ObjectUuidPK(roleId));
                TaxUnitDataPermFactory.getLocalInstance(ctx).delete(" where role.id='" + roleId + "'");
                TaxUnitDataPermInfo item = null;
                JSONArray items = new JSONArray(itemInfo);
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject t = items.getJSONObject(i);
                    String itemId = t.getString("itemId");
                    item = new TaxUnitDataPermInfo();
                    TaxUnitInfo taxUnitInfo = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitInfo((IObjectPK)new ObjectUuidPK(itemId));
                    item.setRole(roleInfo);
                    item.setTaxUnit(taxUnitInfo);
                    item.setIsRolePerm(true);
                    item.setPermType(TaxUnitDataPermType.roleType);
                    coll.add((CoreBaseInfo)item);
                }
                TaxUnitDataPermFactory.getLocalInstance(ctx).saveBatchData(coll);
                coll.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(new TaxDataPermCommonException(TaxDataPermCommonException.SAVE_DATAPERM_ERROR).getMessage());
        }
    }

    @Override
    protected List _getAssignedRoleTaxUnit(Context ctx, Map param) throws BOSException {
        ArrayList result = new ArrayList();
        String roleId = (String)param.get("roleId");
        String roleIds = "('" + roleId.replace(",", "','") + "')";
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT perm.fid id,tax.fnumber number, tax.fname_" + l + " taxUnitName, perm.FTaxUnitID ");
        sb.append(" FROM T_HR_STaxUnitDataPerm perm ");
        sb.append(" left join T_HR_TaxUnit tax on perm.FTaxUnitID=tax.fid ");
        sb.append(" where perm.FPermType='2' and perm.froleid in " + roleIds);
        sb.append(" order by tax.fnumber, tax.fname_" + l);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int count = 0;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList<String> list = null;
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                String taxUnitId = rs.getString("FTaxUnitID");
                String taxUnitNumber = rs.getString("number");
                String taxUnitName = rs.getString("taxUnitName");
                list = new ArrayList<String>();
                list.add(taxUnitId);
                list.add(taxUnitNumber);
                list.add(taxUnitName);
                map.put(id, list);
                if (countMap.get(taxUnitId) == null) {
                    count = 1;
                } else {
                    count = (Integer)countMap.get(taxUnitId);
                    ++count;
                }
                countMap.put(taxUnitId, count);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(new TaxDataPermCommonException(TaxDataPermCommonException.ASSIGNED_TAXUNIT_ERROR).getMessage());
        }
        result.add(map);
        result.add(countMap);
        return result;
    }
}

