/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillSchemeFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillSchemeInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CmpOptionalFieldCollection;
import com.kingdee.shr.compensation.CmpOptionalFieldFactory;
import com.kingdee.shr.compensation.ICmpAgentPayBillScheme;
import com.kingdee.shr.compensation.ICmpOptionalField;
import com.kingdee.shr.compensation.PaymentCompany;
import com.kingdee.shr.compensation.app.agentIntegrate.helper.CmpGiveBankHelper;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import shaded.com.google.common.collect.Sets;

public abstract class AbstractCmpAgentPayBillCreating {
    private static final Logger logger = Logger.getLogger(AbstractCmpAgentPayBillCreating.class);
    private Map<String, List<Object>> calTableMap = Maps.newHashMap();
    private Set<String> existPers = Sets.newHashSet();
    private Map<String, CalSchemeItemInfo> calSchemeItemMap = Maps.newHashMap();
    protected Map<Integer, Object> finOrgMap = Maps.newHashMap();
    protected List<String> adminOrgList;
    protected Map<String, String> adminOrgId2Name = Maps.newHashMap();
    protected Map<String, String> adminOrgId2Number = Maps.newHashMap();
    private List<String> splitItemsInQuery = new ArrayList<String>();
    private CmpAgentPayBillSchemeInfo cmpAgentPayBillSchemeInfo = null;
    private static final String IS_NOT_SPLIT_BY_ORG = "isNotSplitByOrg";
    private static final String AGENT_AND_SPLITOR = "&";
    private static final String AGENT_SPLITOR = "##";
    private static final String AGENT_INNER_SPLITOR = "@@";
    private static final String CAL_SCHEME_INFO_KEY = "calSchemeInfo";

    protected void initPayBillInfo(Context ctx, Map param) throws BOSException, EASBizException {
        try {
            this.assembleCalTableMap(ctx, param);
            this.assembleHadCreatedPers(ctx, param);
            this.assembleCalSchemeItemMap(ctx, (CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY));
            this.initSplitSchemeInfo(ctx, param);
            this.initPayOrg(ctx, param);
            this.checkPayOrgExists(ctx, param);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void initSplitSchemeInfo(Context ctx, Map param) throws BOSException, EASBizException {
        String agentPayBillSchemeId = this.getAgentPayBillSchemeId(ctx, param);
        this.assebleSplitOptionFields(ctx, agentPayBillSchemeId);
        this.cmpAgentPayBillSchemeInfo = this.getSplitSchemeById(ctx, agentPayBillSchemeId);
    }

    public void initPayOrg(Context ctx, Map param) throws BOSException, EASBizException {
        boolean isNotSplitByOrg;
        boolean bl = isNotSplitByOrg = param.get(IS_NOT_SPLIT_BY_ORG) != null && (Boolean)param.get(IS_NOT_SPLIT_BY_ORG) != false;
        if (!isNotSplitByOrg) {
            this.assembleAndGetFinOrg(ctx, param);
        }
        this.initCheckPayOrgList(ctx, param);
    }

    protected void initCheckPayOrgList(Context ctx, Map param) throws EASBizException {
        boolean isUseSchemePayOrg;
        this.adminOrgList = Lists.newArrayList();
        boolean isDealOrg = ((CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY)).isIsDealPayOrg();
        boolean bl = isUseSchemePayOrg = this.hasCmpAgentPayBillSchemeInfo() && PaymentCompany.CalSchemeOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany());
        if (isDealOrg || !this.hasCmpAgentPayBillSchemeInfo() || isUseSchemePayOrg) {
            return;
        }
        boolean isUsePerOrg = PaymentCompany.CalPersonOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany());
        if (isUsePerOrg) {
            List listData = (List)param.get("listData");
            listData.forEach(a -> this.adminOrgList.add((String)a.get("cmp_ctb.adminorgunit")));
        }
    }

    protected void checkPayOrgExists(Context ctx, Map param) throws EASBizException {
        if (this.adminOrgList == null || this.adminOrgList.isEmpty()) {
            return;
        }
        Map adminOrgAndFinOrgMap = (Map)this.finOrgMap.get(2);
        List<String> notExistPayOrgList = this.adminOrgList.stream().filter(admin -> !adminOrgAndFinOrgMap.containsKey(admin)).collect(Collectors.toList());
        if (notExistPayOrgList.isEmpty()) {
            return;
        }
        try {
            this.genHrOrgMappingMap(ctx, notExistPayOrgList);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        StringBuilder adminStr = new StringBuilder();
        notExistPayOrgList.forEach(orgId -> {
            String adminOrgName = this.adminOrgId2Name.get(orgId);
            String adminOrgNumber = this.adminOrgId2Number.get(orgId);
            adminStr.append(adminOrgName + "\uff08" + adminOrgNumber + "\uff09\uff0c");
        });
        adminStr.deleteCharAt(adminStr.length() - 1);
        throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION26, new Object[]{adminStr});
    }

    public void assembleCalTableMap(Context ctx, Map param) throws SQLException, BOSException {
        CalSchemeInfo calSchemeInfo = (CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY);
        String schemeId = calSchemeInfo.getId().toString();
        StringBuilder sb = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sb.append(" select cal.fid calId, cal.FHrOrgUnitID, person.fid personId, person.fnumber personNum, ");
        sb.append(" person.fname_" + l + " personName, cal.FAdminOrgUnitID orgId, cal.FCmpCalOrgID calOrgId from t_hr_scmpcaltable cal ");
        sb.append(" left join t_bd_person person on cal.fpersonid = person.fid ");
        sb.append(" where cal.FCalSchemeID = ? and cal.fperiodYear = ? and cal.fperiodMonth = ? and cal.fcaltime = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{schemeId, calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime()});
        while (rowSet.next()) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)rowSet.getString("personId")));
            personInfo.setNumber(rowSet.getString("personNum"));
            personInfo.setName(rowSet.getString("personName"));
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)rowSet.getString("orgId")));
            AdminOrgUnitInfo calOrgInfo = null;
            String calOrgId = rowSet.getString("calOrgId");
            if (!StringUtils.isEmpty((String)calOrgId)) {
                calOrgInfo = new AdminOrgUnitInfo();
                calOrgInfo.setId(BOSUuid.read((String)calOrgId));
            }
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FHrOrgUnitID")));
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(personInfo);
            list.add(orgInfo);
            list.add(calOrgInfo);
            list.add(hrOrgUnitInfo);
            this.calTableMap.put(rowSet.getString("calId"), list);
        }
    }

    protected void assembleHadCreatedPers(Context ctx, Map param) throws BOSException, SQLException {
        CalSchemeInfo schemeInfo = (CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY);
        String cmpSchemeId = schemeInfo.getId().toString();
        int periodYear = schemeInfo.getPeriodYear();
        int periodMonth = schemeInfo.getPeriodMonth();
        int calTime = schemeInfo.getCalTime();
        String sql = CmpGiveBankHelper.buildCreatedSql(cmpSchemeId, periodYear, periodMonth, calTime);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            String personId = rowSet.getString("person");
            String cmpItemId = rowSet.getString("cmpitem");
            this.existPers.add(personId + "~" + cmpItemId);
        }
    }

    protected void assembleCalSchemeItemMap(Context ctx, CalSchemeInfo calScheme) throws BOSException {
        String oql = "select id, isGrant, cmpItem.id, cmpItem.fieldSn, cmpItem.name, cmpItem.dataDot where calScheme = '" + calScheme.getId().toString() + "' and isGrant = 1";
        CalSchemeItemCollection col = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection(oql);
        for (int i = 0; i < col.size(); ++i) {
            this.calSchemeItemMap.put(col.get(i).getCmpItem().getId().toString(), col.get(i));
        }
    }

    protected void assembleAndGetFinOrg(Context ctx, Map param) throws BOSException, EASBizException {
        String orgId = (String)param.get("orgId");
        this.finOrgMap.put(1, this.getFinOrgnameByAdminOrgId(ctx, orgId));
        this.finOrgMap.put(2, this.getAdminOrgIdAndFinOrgNameMap(ctx));
    }

    protected void assebleSplitOptionFields(Context ctx, String agentPayBillSchemeId) throws BOSException {
        if (StringUtils.isEmpty((String)agentPayBillSchemeId)) {
            return;
        }
        String oql = "select cmpItem.fieldSn where cmpAgentPayBillScheme = '%s'";
        ICmpOptionalField instance = CmpOptionalFieldFactory.getLocalInstance(ctx);
        CmpOptionalFieldCollection optionsCol = instance.getCmpOptionalFieldCollection(String.format(oql, agentPayBillSchemeId));
        for (int i = 0; i < optionsCol.size(); ++i) {
            this.splitItemsInQuery.add("cmp_ctb.s" + optionsCol.get(i).getCmpItem().getFieldSn());
        }
    }

    protected CmpAgentPayBillSchemeInfo getSplitSchemeById(Context ctx, String agentPayBillSchemeId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)agentPayBillSchemeId)) {
            return null;
        }
        String oql = "select id,name, paymentCompany, optionalCompanyField.fieldsn where id = '%s'";
        ICmpAgentPayBillScheme schemeInstance = CmpAgentPayBillSchemeFactory.getLocalInstance(ctx);
        return schemeInstance.getCmpAgentPayBillSchemeInfo(String.format(oql, agentPayBillSchemeId));
    }

    protected CmpAgentPayBillInfo buildCmpPayBill(Context ctx, Map param, CmpItemInfo cmpItemInfo, String currencyId) throws EASBizException, BOSException {
        CmpAgentPayBillInfo info = new CmpAgentPayBillInfo();
        CalSchemeInfo calSchemeInfo = (CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY);
        String hrOrgId = (String)param.get("hrOrgId");
        String desc = (String)param.get("desc");
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCalScheme(calSchemeInfo);
        info.setSchemeNum(calSchemeInfo.getNumber());
        info.setSchemeName(calSchemeInfo.getName());
        info.setPeriodYear(calSchemeInfo.getPeriodYear());
        info.setPeriodMonth(calSchemeInfo.getPeriodMonth());
        info.setCalTime(calSchemeInfo.getCalTime());
        info.setCmpItem(cmpItemInfo);
        info.setCmpItemName(cmpItemInfo.getName());
        info.setHrOrgUnit(calSchemeInfo.getHrOrgUnit());
        info.setBusinessDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        info.setComment(desc);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        info.setCurrency(currency);
        this.buildBillMark(info);
        info.setNumber(NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)hrOrgId));
        return info;
    }

    protected void fillCmpBillPayOrg(CmpAgentPayBillInfo info, String splitKey) throws EASBizException {
        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)this.getOrgIdFromSplitKey(splitKey)));
        info.setPayOrg(orgUnitInfo);
    }

    protected void fillSplitInfo(CmpAgentPayBillInfo cmpPayBillInfo, String splitFiledKey) {
        if (this.hasCmpAgentPayBillSchemeInfo()) {
            cmpPayBillInfo.setSplitScheme(this.cmpAgentPayBillSchemeInfo);
            if (null != splitFiledKey && splitFiledKey.lastIndexOf(AGENT_SPLITOR) != -1 && splitFiledKey.lastIndexOf(AGENT_SPLITOR) + AGENT_SPLITOR.length() <= splitFiledKey.length()) {
                String splitFileds = splitFiledKey.substring(splitFiledKey.lastIndexOf(AGENT_SPLITOR) + AGENT_SPLITOR.length(), splitFiledKey.length());
                cmpPayBillInfo.setSplitFields(splitFileds);
            }
        }
    }

    public String getSplitFieldKey(Map<String, Object> data, Map param, EntryGroups entryGroups) throws BOSException, EASBizException {
        StringBuilder splitFiledkeyBuilder = new StringBuilder();
        splitFiledkeyBuilder.append(this.getCmpItemSplitInfo(data, entryGroups)).append(AGENT_AND_SPLITOR);
        splitFiledkeyBuilder.append(this.getCurrencySplitInfo(data, entryGroups));
        splitFiledkeyBuilder.append(AGENT_SPLITOR);
        splitFiledkeyBuilder.append(this.getPayOrgSplitKey(data, param, entryGroups));
        splitFiledkeyBuilder.append(AGENT_SPLITOR);
        for (String key : this.splitItemsInQuery) {
            if ((String)data.get(key) == null) continue;
            splitFiledkeyBuilder.append((String)data.get(key)).append(AGENT_AND_SPLITOR);
        }
        if (splitFiledkeyBuilder.lastIndexOf(AGENT_SPLITOR) + AGENT_SPLITOR.length() < splitFiledkeyBuilder.length()) {
            splitFiledkeyBuilder.deleteCharAt(splitFiledkeyBuilder.lastIndexOf(AGENT_AND_SPLITOR));
        }
        return splitFiledkeyBuilder.toString();
    }

    protected String getPayOrgSplitKey(Map<String, Object> data, Map param, EntryGroups entryGroups) throws EASBizException {
        boolean isUseSchemePayOrg;
        boolean isNotSplitByOrg;
        boolean bl = isNotSplitByOrg = param.get(IS_NOT_SPLIT_BY_ORG) != null && (Boolean)param.get(IS_NOT_SPLIT_BY_ORG) != false;
        if (isNotSplitByOrg) {
            return AGENT_INNER_SPLITOR;
        }
        boolean isDealOrg = ((CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY)).isIsDealPayOrg();
        boolean bl2 = isUseSchemePayOrg = this.hasCmpAgentPayBillSchemeInfo() && PaymentCompany.CalSchemeOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany());
        if (isDealOrg || !this.hasCmpAgentPayBillSchemeInfo() || isUseSchemePayOrg) {
            return this.getSchemePayOrgName();
        }
        boolean isUsePerOrg = PaymentCompany.CalPersonOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany());
        if (isUsePerOrg) {
            return this.getPersonOrgSplitKey(data, entryGroups);
        }
        boolean isUseOptionalPayOrg = PaymentCompany.OptionalPayOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany());
        if (isUseOptionalPayOrg && this.getCmpAgentPayBillSchemeInfoNotNull().getOptionalCompanyField() != null) {
            return this.getOptionalPayOrgSplitKey(data, entryGroups);
        }
        throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION11);
    }

    protected String getSchemePayOrgName() throws CmpAgentPayBillException {
        String finOrgName;
        String string = finOrgName = this.finOrgMap.get(1) == null ? "" : String.valueOf(this.finOrgMap.get(1));
        if (StringUtils.isEmpty((String)finOrgName)) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION24);
        }
        return finOrgName;
    }

    protected String getCmpItemSplitInfo(Map<String, Object> data, EntryGroups entryGroups) throws EASBizException {
        return (String)data.get("gv_cmpitem.name");
    }

    protected String getCurrencySplitInfo(Map<String, Object> data, EntryGroups entryGroups) throws EASBizException {
        return (String)data.get("gv_currency.name");
    }

    protected String getPersonOrgSplitKey(Map<String, Object> data, EntryGroups entryGroups) throws EASBizException {
        String calOrgId;
        Map adminOrgAndFinOrgMap = (Map)this.finOrgMap.get(2);
        String finOrgName = (String)adminOrgAndFinOrgMap.get(calOrgId = (String)data.get("cmp_ctb.adminorgunit"));
        if (finOrgName == null) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION25);
        }
        return finOrgName;
    }

    protected String getOptionalPayOrgSplitKey(Map<String, Object> data, EntryGroups entryGroups) throws EASBizException {
        return this.cmpAgentPayBillSchemeInfo.getOptionalCompanyField().getId().toString() + AGENT_INNER_SPLITOR + this.cmpAgentPayBillSchemeInfo.getOptionalCompanyField().getName();
    }

    protected String getOrgIdFromSplitKey(String splitKey) throws EASBizException {
        if (splitKey.indexOf(AGENT_SPLITOR) == -1 || splitKey.indexOf(AGENT_INNER_SPLITOR) == -1) {
            logger.error((Object)splitKey);
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION9);
        }
        return splitKey.substring(splitKey.indexOf(AGENT_SPLITOR) + AGENT_SPLITOR.length(), splitKey.indexOf(AGENT_INNER_SPLITOR));
    }

    protected String getAgentPayBillSchemeId(Context ctx, Map param) throws BOSException {
        CalSchemeInfo calScheme = (CalSchemeInfo)param.get(CAL_SCHEME_INFO_KEY);
        String calSchemeId = calScheme.getId().toString();
        return CmpGiveBankHelper.getAgentPayBillBySchemeId(ctx, calSchemeId);
    }

    protected Map<String, String> getAdminOrgIdAndFinOrgNameMap(Context ctx) throws BOSException {
        HashMap result = Maps.newHashMap();
        String lang = LocaleUtils.getShortCode((Context)ctx);
        String sql = " SELECT unit.FID orgId, unit.fname_" + lang + " orgName, unitRe.FFROMUNITID adminOrgId FROM T_ORG_UnitRelation unitRe  left join T_ORG_TypeRelation typeRe  on unitRe.FTYPERELATIONID = typeRe.fid  LEFT JOIN T_ORG_BaseUnit unit ON unitRe.FTOUNITID = unit.FID  where typeRe.FTOTYPE = 1  and typeRe.FFROMTYPE = 0";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                result.put(rowSet.getString("adminOrgId"), rowSet.getString("orgId") + AGENT_INNER_SPLITOR + rowSet.getString("orgName"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String getFinOrgnameByAdminOrgId(Context ctx, String orgId) throws BOSException {
        String lang = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select fid, fname_" + lang + " orgName from t_org_baseUnit where fid = '" + orgId + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                return rowSet.getString("fid") + AGENT_INNER_SPLITOR + rowSet.getString("orgName");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public abstract void create(Context var1, Map var2) throws BOSException, EASBizException;

    protected abstract EntryGroups buildPayBillEntry(Context var1, Map var2) throws BOSException, EASBizException;

    protected abstract void buildBillMark(CmpAgentPayBillInfo var1);

    public boolean hasCmpAgentPayBillSchemeInfo() {
        return this.cmpAgentPayBillSchemeInfo != null;
    }

    public Map<String, List<Object>> getCalTableMap() {
        return this.calTableMap;
    }

    public void setCalTableMap(Map<String, List<Object>> calTableMap) {
        this.calTableMap = calTableMap;
    }

    public Set<String> getExistPers() {
        return this.existPers;
    }

    public void setExistPers(Set<String> existPers) {
        this.existPers = existPers;
    }

    public Map<String, CalSchemeItemInfo> getCalSchemeItemMap() {
        return this.calSchemeItemMap;
    }

    public void setCalSchemeItemMap(Map<String, CalSchemeItemInfo> calSchemeItemMap) {
        this.calSchemeItemMap = calSchemeItemMap;
    }

    public List<String> getSplitItemsInQuery() {
        return this.splitItemsInQuery;
    }

    public void setSplitItemsInQuery(List<String> splitItemsInQuery) {
        this.splitItemsInQuery = splitItemsInQuery;
    }

    public CmpAgentPayBillSchemeInfo getCmpAgentPayBillSchemeInfo() {
        return this.cmpAgentPayBillSchemeInfo;
    }

    public CmpAgentPayBillSchemeInfo getCmpAgentPayBillSchemeInfoNotNull() throws EASBizException {
        if (this.cmpAgentPayBillSchemeInfo == null) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION15);
        }
        return this.cmpAgentPayBillSchemeInfo;
    }

    public void setCmpAgentPayBillSchemeInfo(CmpAgentPayBillSchemeInfo cmpAgentPayBillSchemeInfo) {
        this.cmpAgentPayBillSchemeInfo = cmpAgentPayBillSchemeInfo;
    }

    protected void putPayBillSumAmount(CmpAgentPayBillInfo cmpPayBillInfo, EntryGroups entryGroups, String key) {
        AmountCombie sumAmount = entryGroups.getSumAmount(key);
        if (sumAmount == null) {
            cmpPayBillInfo.setSumAmount(BigDecimal.ZERO);
            cmpPayBillInfo.setSumCalAmount(BigDecimal.ZERO);
        } else {
            cmpPayBillInfo.setSumAmount(sumAmount.getAmount());
            cmpPayBillInfo.setSumCalAmount(sumAmount.getCalAmount());
        }
    }

    protected void genHrOrgMappingMap(Context ctx, List<String> adminList) throws BOSException {
        CmpInSql<String> inSql = CmpInSqlFactory.getInstance();
        String lan = ctx.getLocale().getLanguage();
        String sql = "select distinct fid, fnumber, fname_" + lan + " name from T_ORG_BaseUnit where fid in " + inSql.createInSqlBaseOnFId(ctx, adminList);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                this.adminOrgId2Number.put(rs.getString("fid"), rs.getString("fnumber"));
                this.adminOrgId2Name.put(rs.getString("fid"), rs.getString("name"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            inSql.release(ctx);
        }
    }

    public static class EntryGroups {
        private Map<String, CmpAgentPayBillEntryCollection> cmpEntrysGroup = Maps.newHashMap();
        private Map<String, AgentPayBillEntryCollection> cashEntrysGroup = Maps.newHashMap();
        private Map<String, CmpItemInfo> cmpItemGroup = Maps.newHashMap();
        private Map<String, String> currencyGroup = Maps.newHashMap();
        private Map<String, String> calCurrencyGroup = Maps.newHashMap();
        private Map<String, String> optionalCompanyMap = Maps.newHashMap();
        private Map<String, AmountCombie> sumAmountMap = Maps.newHashMap();
        private String errorMsg;

        public void putSumAmountValue(String key, AmountCombie ac) {
            if (ac == null) {
                return;
            }
            AmountCombie amountCombie = this.sumAmountMap.get(key);
            if (amountCombie == null) {
                amountCombie = ac;
                this.sumAmountMap.put(key, amountCombie);
                return;
            }
            amountCombie.addAmount(ac);
        }

        public AmountCombie getSumAmount(String key) {
            return this.sumAmountMap.get(key);
        }

        public Map<String, CmpAgentPayBillEntryCollection> getCmpEntrysGroup() {
            return this.cmpEntrysGroup;
        }

        public void putCmpEntrysGroup(String key, CmpAgentPayBillEntryInfo value) {
            CmpAgentPayBillEntryCollection cmpAgentPayBillEntryCollection = this.cmpEntrysGroup.get(key);
            if (cmpAgentPayBillEntryCollection == null) {
                cmpAgentPayBillEntryCollection = new CmpAgentPayBillEntryCollection();
                this.cmpEntrysGroup.put(key, cmpAgentPayBillEntryCollection);
            }
            cmpAgentPayBillEntryCollection.add(value);
        }

        public Map<String, AgentPayBillEntryCollection> getCashEntrysGroup() {
            return this.cashEntrysGroup;
        }

        public void putCashEntrysGroup(String key, AgentPayBillEntryInfo value) {
            AgentPayBillEntryCollection agentPayBillEntryCollection = this.cashEntrysGroup.get(key);
            if (agentPayBillEntryCollection == null) {
                agentPayBillEntryCollection = new AgentPayBillEntryCollection();
                this.cashEntrysGroup.put(key, agentPayBillEntryCollection);
            }
            agentPayBillEntryCollection.add(value);
        }

        public Map<String, CmpItemInfo> getCmpItemGroup() {
            return this.cmpItemGroup;
        }

        public void putCmpItemGroup(String key, CmpItemInfo value) {
            this.cmpItemGroup.put(key, value);
        }

        public Map<String, String> getCurrencyGroup() {
            return this.currencyGroup;
        }

        public void putCurrencyGroup(String key, String value) {
            this.currencyGroup.put(key, value);
        }

        public Map<String, String> getCalCurrencyGroup() {
            return this.calCurrencyGroup;
        }

        public void putCalCurrencyGroup(String key, String value) {
            this.calCurrencyGroup.put(key, value);
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public Map<String, String> getOptionalCompanyMap() {
            return this.optionalCompanyMap;
        }

        public void putOptionalCompanyMap(String key, String value) {
            this.optionalCompanyMap.put(key, value);
        }
    }

    public static class AmountCombie {
        private BigDecimal amount = BigDecimal.ZERO;
        private BigDecimal calAmount = BigDecimal.ZERO;

        public AmountCombie() {
        }

        public AmountCombie(BigDecimal amount, BigDecimal calAmount) {
            this.amount = amount;
            this.calAmount = calAmount;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getCalAmount() {
            return this.calAmount;
        }

        public void setCalAmount(BigDecimal calAmount) {
            this.calAmount = calAmount;
        }

        public void addAmount(AmountCombie ac) {
            if (ac.getAmount() != null) {
                this.amount = this.amount.add(ac.getAmount());
            }
            if (ac.getCalAmount() != null) {
                this.calAmount = this.calAmount.add(ac.getCalAmount());
            }
        }
    }
}

