/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.hr.emp.BankInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillEASCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpAgentSource;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITType;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CmpAgentPayBillMultiCurEASCreating
extends AbstractCmpAgentPayBillEASCreating {
    @Override
    public void create(Context ctx, Map param) throws BOSException, EASBizException {
        this.initPayBillInfo(ctx, param);
        AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups = (AbstractCmpAgentPayBillEASCreating.EASEntryGroups)this.buildPayBillEntry(ctx, param);
        if (StringUtils.isNotEmpty((CharSequence)entryGroups.getErrorMsg())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION12, new Object[]{entryGroups.getErrorMsg()});
        }
        if (entryGroups.getCmpEntrysGroup().isEmpty()) {
            throw new PersonCmpFacadeException(PersonCmpFacadeException.CREATEFAIL);
        }
        entryGroups.setOrgIdAndPayOrgMap(this.getOrgIdAndPayOrgMap(ctx, entryGroups.getCmpEntrysGroup()));
        for (String key : entryGroups.getCmpEntrysGroup().keySet()) {
            this.buildAndSavePayBill(ctx, param, key, entryGroups);
        }
    }

    @Override
    protected AbstractCmpAgentPayBillCreating.EntryGroups buildPayBillEntry(Context ctx, Map param) throws BOSException, EASBizException {
        AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups = new AbstractCmpAgentPayBillEASCreating.EASEntryGroups();
        String calTableName = (String)param.get("calTableName");
        List listData = (List)param.get("listData");
        for (Map data : listData) {
            CmpAgentPayBillEntryInfo cmpEntryInfo = new CmpAgentPayBillEntryInfo();
            AgentPayBillEntryInfo cashEntryInfo = new AgentPayBillEntryInfo();
            List<Object> calTableList = this.getCalTableMap().get(data.get(calTableName + ".id"));
            BigDecimal giveAmount = new BigDecimal(data.get("gv_cmpaccres.giveamount") == null ? "0" : data.get("gv_cmpaccres.giveamount").toString());
            if (giveAmount == null || giveAmount.compareTo(BigDecimal.ZERO) <= 0) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label12", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            PersonInfo personInfo = (PersonInfo)calTableList.get(0);
            String currentPersonId = personInfo.getId().toString();
            CmpItemInfo cmpItem = this.getCalSchemeItemMap().get(data.get("gv_cmpitem.id")).getCmpItem();
            if (this.getExistPers().contains(currentPersonId + "~" + cmpItem.getId().toString())) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label13", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            String bankName = (String)data.get("gv_bank.name");
            String accountNum = (String)data.get("gv_perbkrec.accountnum");
            String beProvince = (String)data.get("gv_perbkrec.province");
            String beCity = (String)data.get("gv_perbkrec.city");
            BankInfo bankInfo = new BankInfo();
            bankInfo.setId(BOSUuid.read((String)((String)data.get("gv_bank.id"))));
            boolean validBankName = (Boolean)param.get("validBankName");
            if (validBankName) {
                BEBankInfo beBankInfo = (BEBankInfo)this.recBankMap.get(bankName);
                beProvince = beBankInfo == null ? "" : beBankInfo.getBeProvince();
                beCity = beBankInfo == null ? "" : beBankInfo.getBeCity();
            }
            BOSUuid cmpAgentPayBillEntryId = BOSUuid.create((BOSObjectType)cmpEntryInfo.getBOSType());
            cmpEntryInfo.setPerson(personInfo);
            cmpEntryInfo.setPersonNum(personInfo.getNumber());
            cmpEntryInfo.setPersonName(personInfo.getName());
            cmpEntryInfo.setAmount(giveAmount);
            cmpEntryInfo.setAdminOrg((AdminOrgUnitInfo)calTableList.get(1));
            cmpEntryInfo.setCmpCalOrg((AdminOrgUnitInfo)calTableList.get(2));
            cmpEntryInfo.setHrOrgUnit((HROrgUnitInfo)calTableList.get(3));
            cmpEntryInfo.setIsSuccess(false);
            cmpEntryInfo.setUseDefault((Boolean)data.get(calTableName + ".usedefault"));
            cmpEntryInfo.setId(cmpAgentPayBillEntryId);
            cmpEntryInfo.setCmpItemName(cmpItem.getName());
            cmpEntryInfo.setCmpItem(cmpItem);
            cmpEntryInfo.setBankName(bankName);
            cmpEntryInfo.setAccountNum(accountNum);
            cmpEntryInfo.setRecProvince(beProvince);
            cmpEntryInfo.setRecCity(beCity);
            cmpEntryInfo.setHrBank(bankInfo);
            BigDecimal amount = new BigDecimal(data.get("gv_cmpaccres.amount") == null ? "0" : data.get("gv_cmpaccres.amount").toString());
            cmpEntryInfo.setCalAmount(amount);
            String accountName = (String)data.get("gv_perbkrec.accountname");
            accountName = CmpStrUtil.isEmpty(accountName) ? (String)data.get("cmp_person.name") : accountName;
            cmpEntryInfo.setAccountName(accountName);
            cashEntryInfo.setRecName(accountName);
            cashEntryInfo.setAmount(giveAmount);
            cashEntryInfo.setSourceBillId(cmpAgentPayBillEntryId.toString());
            cashEntryInfo.setRecBankAccount(accountNum);
            cashEntryInfo.setRecProvince(beProvince);
            cashEntryInfo.setRecCity(beCity);
            cashEntryInfo.setRecBankName(bankName);
            cashEntryInfo.setRecBank((BEBankInfo)this.recBankMap.get(bankName));
            AbstractCmpAgentPayBillCreating.AmountCombie ac = new AbstractCmpAgentPayBillCreating.AmountCombie(giveAmount, amount);
            String splitField = this.getSplitFieldKey(data, param, entryGroups);
            entryGroups.putCmpEntrysGroup(splitField, cmpEntryInfo);
            entryGroups.putCashEntrysGroup(splitField, cashEntryInfo);
            entryGroups.putCmpItemGroup(splitField, cmpItem);
            entryGroups.putCurrencyGroup(splitField, (String)data.get("gv_currency.id"));
            entryGroups.putSumAmountValue(splitField, ac);
        }
        return entryGroups;
    }

    @Override
    protected CmpAgentPayBillInfo buildEASCmpPayBill(Context ctx, String key, Map param, AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups) throws EASBizException, BOSException {
        return this.buildCmpPayBill(ctx, param, entryGroups.getCmpItemGroup().get(key), this.getCurrencyId(key, entryGroups));
    }

    @Override
    protected String getCurrencyId(String key, AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups) {
        return entryGroups.getCurrencyGroup().get(key);
    }

    @Override
    protected void buildBillMark(CmpAgentPayBillInfo info) {
        info.setITType(CmpITType.EAS);
        info.setAgentSource(CmpAgentSource.MultiCur);
    }

    @Override
    protected String getCurrencySplitInfo(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        return (String)data.get("gv_currency.name");
    }
}

