/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.budget.AbstractCmpUsedAmountFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountInfo;
import com.kingdee.shr.compensation.service.budget.DeductionParamUsedAmount;
import com.kingdee.shr.compensation.service.budget.impl.AbstractUsedAmountDeductionService;
import com.kingdee.shr.compensation.service.budget.impl.CmpCalRefreshBalanceService;
import com.kingdee.shr.compensation.service.budget.impl.SubmitBillRefreshBalanceService;
import org.apache.log4j.Logger;

public class CmpUsedAmountFacadeControllerBean
extends AbstractCmpUsedAmountFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(CmpUsedAmountFacadeControllerBean.class);

    @Override
    protected void _refreshBalance(Context ctx, DeductionParamUsedAmount refreshParam) throws BOSException, EASBizException {
        AbstractUsedAmountDeductionService usedAmountDeductionService;
        BudgetTemplateTypeEnum templateType = refreshParam.getBudgetTemplate().getTemplateType();
        if (templateType == BudgetTemplateTypeEnum.SALARY_TYPE) {
            usedAmountDeductionService = new CmpCalRefreshBalanceService();
        } else if (templateType == BudgetTemplateTypeEnum.SUBMIT_TYPE || templateType == BudgetTemplateTypeEnum.SPIRE_TYPE) {
            usedAmountDeductionService = new SubmitBillRefreshBalanceService();
        } else {
            throw new RuntimeException("Not Supported Template Type");
        }
        usedAmountDeductionService.refreshBalanceByUsedAmount(ctx, refreshParam);
    }

    @Override
    protected void _genPeriodUsedAmount(Context ctx, CmpUsedAmountInfo usedAmountInfo) throws BOSException {
        AbstractUsedAmountDeductionService usedAmountDeductionService;
        BudgetTemplateTypeEnum templateType = usedAmountInfo.getTemplate().getTemplateType();
        if (templateType == BudgetTemplateTypeEnum.SALARY_TYPE) {
            usedAmountDeductionService = new CmpCalRefreshBalanceService();
        } else if (templateType == BudgetTemplateTypeEnum.SUBMIT_TYPE || templateType == BudgetTemplateTypeEnum.SPIRE_TYPE) {
            usedAmountDeductionService = new SubmitBillRefreshBalanceService();
        } else {
            throw new RuntimeException("Not Supported Template Type");
        }
        DeductionParamUsedAmount paramUsedAmount = new DeductionParamUsedAmount();
        paramUsedAmount.setBudgetTemplate(usedAmountInfo.getTemplate());
        paramUsedAmount.getBudgetManageList().add(usedAmountInfo.getBudgetManage());
        usedAmountDeductionService.setCmpBudgetItemInfo(usedAmountInfo.getCmpBudgetItem());
        usedAmountDeductionService.setUsedAmountInfo(usedAmountInfo);
        usedAmountDeductionService.genPeriodUsedAmount(ctx, paramUsedAmount);
    }
}

