/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.compensation.app.budget.AbstractStandingBookItemControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.budget.StandingBookItemFactory;
import com.kingdee.shr.compensation.app.budget.StandingBookItemInfo;
import com.kingdee.shr.compensation.app.budget.StandingBookItemTypeEnum;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class StandingBookItemControllerBean
extends AbstractStandingBookItemControllerBean {
    protected void checkReferenced(Context ctx, String id) throws EASBizException, BOSException {
        String oql = "select id,template.id,template.name where standingBookItem.id = '" + id + "' or balanceLedgerItem.id = '" + id + "'";
        BudgetTemplateSTBItemCollection templateStbColl = BudgetTemplateSTBItemFactory.getLocalInstance(ctx).getBudgetTemplateSTBItemCollection(oql);
        if (!templateStbColl.isEmpty()) {
            int maxNum = 10;
            int size = templateStbColl.size();
            StringBuilder nameBuilder = new StringBuilder();
            for (int i = 0; i < size && i < maxNum; ++i) {
                BudgetTemplateSTBItemInfo templateSTBItemInfo = templateStbColl.get(i);
                if (templateSTBItemInfo == null || templateSTBItemInfo.getTemplate() == null) continue;
                nameBuilder.append(",").append(templateSTBItemInfo.getTemplate().getName(ctx.getLocale()));
            }
            String names = nameBuilder.toString();
            if (!StringUtils.isEmpty((String)names)) {
                names = names.substring(1);
                String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label14", (Locale)ctx.getLocale()), names);
                throw new EASBizException(new NumericExceptionSubItem("022", message));
            }
        }
    }

    protected String checkReferencedByEdit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StandingBookItemInfo info = (StandingBookItemInfo)model;
        if (info.getId() == null) {
            return "";
        }
        StandingBookItemTypeEnum itemType = info.getItemType();
        String id = info.getId().toString();
        String oql = "select id,template.id,template.name where standingBookItem.id = '" + id + "' or balanceLedgerItem.id = '" + id + "'";
        BudgetTemplateSTBItemCollection templateStbColl = BudgetTemplateSTBItemFactory.getLocalInstance(ctx).getBudgetTemplateSTBItemCollection(oql);
        if (!templateStbColl.isEmpty()) {
            int maxNum = 10;
            int size = templateStbColl.size();
            StringBuilder nameBuilder = new StringBuilder();
            for (int i = 0; i < size && i < maxNum; ++i) {
                BudgetTemplateSTBItemInfo templateSTBItemInfo = templateStbColl.get(i);
                if (templateSTBItemInfo == null || templateSTBItemInfo.getTemplate() == null) continue;
                nameBuilder.append(",").append(templateSTBItemInfo.getTemplate().getName(ctx.getLocale()));
            }
            String names = nameBuilder.toString();
            if (!StringUtils.isEmpty((String)names)) {
                StandingBookItemTypeEnum oldItemType;
                names = names.substring(1);
                String itemOql = "select itemType where id = '" + id + "'";
                StandingBookItemInfo standingBookItemInfo = StandingBookItemFactory.getLocalInstance(ctx).getStandingBookItemInfo(itemOql);
                if (standingBookItemInfo != null && (oldItemType = standingBookItemInfo.getItemType()) != null && oldItemType.getValue() != itemType.getValue()) {
                    String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label15", (Locale)ctx.getLocale()), names);
                    throw new EASBizException(new NumericExceptionSubItem("022", message));
                }
            }
        }
        return "";
    }

    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.checkReferenced(ctx, id);
        super._disable(ctx, id);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FunUtils.clearSessionMap();
        this.checkInfo(ctx, model);
        this.checkReferencedByEdit(ctx, model);
        StandingBookItemInfo info = (StandingBookItemInfo)model;
        boolean isNewOp = false;
        int orgFieldSn = info.getFieldSn();
        if (orgFieldSn == -1 || orgFieldSn == 0) {
            isNewOp = true;
        }
        if (info.getId() != null && !StringUtils.isEmpty((String)info.getId().toString())) {
            isNewOp = false;
        }
        if (isNewOp) {
            int fieldSn = this.getFieldSn(ctx);
            return this.doAddNewItem(ctx, info, fieldSn);
        }
        return this.updateItem(ctx, info);
    }

    protected int getFieldSn(Context ctx) throws BOSException {
        int fieldSn = 60;
        String sql = "select max(FieldSn) from T_HR_SStandingBookItem";
        IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (list.next()) {
                if (list.getInt(1) <= fieldSn) continue;
                fieldSn = list.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return fieldSn;
    }

    protected Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        return new Timestamp(d.getTime().getTime());
    }

    protected SHRBasicItemInfo getShrBasicItemInfo(Context ctx) throws BOSException, EASBizException {
        String entityName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType()).getFullName();
        ISHRBasicItem shrBasicItem = SHRBasicItemFactory.getLocalInstance((Context)ctx);
        String oql = "where entityName='" + entityName + "'";
        return shrBasicItem.getSHRBasicItemInfo(oql);
    }

    protected IObjectPK doAddNewItem(Context ctx, StandingBookItemInfo item, int fieldSn) throws BOSException, EASBizException {
        IObjectPK idPk;
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String number = item.getNumber();
        int dataLength = item.getDataLength();
        SHRBasicItemInfo shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        this.checkNameDup(ctx, (DataBaseInfo)item);
        String oql = "select id where number = '" + number + "'";
        boolean exists = StandingBookItemFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label30"), number)));
        }
        item.setFieldSn(fieldSn + 1);
        item.setIsSysPreset(false);
        item.setShrBasicItem(shrBasicItemInfo);
        if (item.getCU() == null) {
            item.setCU(this.getCU(ctx, (ObjectBaseInfo)item));
        }
        if (item.getCreator() == null) {
            item.setCreator(userInfo);
        }
        Timestamp createTimestamp = this.getTime();
        if (item.getCreateTime() == null) {
            item.setCreateTime(createTimestamp);
        }
        item.setLastUpdateUser(userInfo);
        item.setLastUpdateTime(createTimestamp);
        item.setState(BaseItemStateEnum.NEW);
        if (!BaseItemStateEnum.NEW.equals((Object)item.getState())) {
            IObjectPK baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            } else {
                baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
                if (null != baseInfoChangePK) {
                    this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                }
            }
        } else {
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
        }
        if (1 == item.getDataType().getValue() && dataLength > 1000) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label6", (Locale)ctx.getLocale()));
        }
        item.setId(BOSUuid.read((String)idPk.toString()));
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, idPk));
        return idPk;
    }

    protected void beforeUpdate(Context ctx, StandingBookItemInfo item) throws BOSException {
    }

    protected IObjectPK updateItem(Context ctx, StandingBookItemInfo item) throws BOSException, EASBizException {
        String number = item.getNumber();
        String itemId = item.getId().toString();
        this.beforeUpdate(ctx, item);
        this.checkNameDup(ctx, (DataBaseInfo)item);
        String oql = "select id where  number = '" + number + "' and id <> '" + itemId + "'";
        boolean exists = StandingBookItemFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label30"), number)));
        }
        StandingBookItemInfo itemInfo = this.getNewItemInfo(ctx, item);
        ObjectUuidPK idPk = new ObjectUuidPK(item.getId().toString());
        IObjectPK baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
        super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)itemInfo);
        if (null != baseInfoChangePK) {
            this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
        } else {
            baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            }
        }
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, (IObjectPK)idPk));
        return idPk;
    }

    protected StandingBookItemInfo getNewItemInfo(Context ctx, StandingBookItemInfo item) throws BOSException, EASBizException {
        SHRBasicItemInfo shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        StandingBookItemInfo itemInfo = new StandingBookItemInfo();
        itemInfo.setId(item.getId());
        itemInfo.setName(item.getName(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
        itemInfo.setName(item.getName(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
        itemInfo.setName(item.getName(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
        itemInfo.setNumber(item.getNumber());
        itemInfo.setDescription(item.getDescription(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
        itemInfo.setDescription(item.getDescription(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
        itemInfo.setDescription(item.getDescription(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
        itemInfo.setDataDot(item.getDataDot());
        itemInfo.setDataLength(item.getDataLength());
        itemInfo.setHrOrgUnit(item.getHrOrgUnit());
        itemInfo.setUsePolicy(item.getUsePolicy());
        itemInfo.setState(item.getState());
        itemInfo.setIndex(item.getIndex());
        itemInfo.setIsSysPreset(item.isIsSysPreset());
        itemInfo.setCreateOU(item.getCreateOU());
        itemInfo.setApplyScope(item.getApplyScope());
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        itemInfo.setLastUpdateUser(userInfo);
        itemInfo.setLastUpdateTime(this.getTime());
        itemInfo.setShrBasicItem(shrBasicItemInfo);
        itemInfo.setDataType(item.getDataType());
        itemInfo.setBudgetItemType(item.getBudgetItemType());
        itemInfo.setItemType(item.getItemType());
        if (item.getFieldSn() <= 0) {
            this.setFieldSn(ctx, item, itemInfo);
        } else {
            itemInfo.setFieldSn(item.getFieldSn());
        }
        this.setOtherInfo(ctx, itemInfo);
        return itemInfo;
    }

    protected void setOtherInfo(Context ctx, StandingBookItemInfo itemInfo) {
    }

    protected void setFieldSn(Context ctx, StandingBookItemInfo item, StandingBookItemInfo itemInfo) throws BOSException {
        String sql = "select FieldSn from T_HR_SStandingBookItem where fid='" + item.getId().toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                int fieldSn = rowSet.getInt(1);
                itemInfo.setFieldSn(fieldSn);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandingBookItemInfo info = (StandingBookItemInfo)model;
        String name = info.getName();
        String number = info.getNumber();
        String name_l1 = info.getName(LocaleUtils.locale_L1);
        String name_l2 = info.getName(LocaleUtils.locale_L2);
        String name_l3 = info.getName(LocaleUtils.locale_L3);
        if (!StringUtils.isEmpty((String)name) && (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3))) {
            name_l1 = StringUtils.isEmpty((String)name_l1) ? name : name_l1;
            name_l2 = StringUtils.isEmpty((String)name_l2) ? name : name_l2;
            String string = name_l3 = StringUtils.isEmpty((String)name_l3) ? name : name_l3;
        }
        if (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3) || StringUtils.isEmpty((String)number)) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label7", (Locale)ctx.getLocale())));
        }
        String reg = "^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9\uff08\uff09]*$";
        if (!(name_l1.matches(reg) && name_l2.matches(reg) && name_l3.matches(reg))) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label8", (Locale)ctx.getLocale())));
        }
        if (!number.matches(reg)) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label16", (Locale)ctx.getLocale())));
        }
        String[] arr = new String[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label66", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label67"), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label68", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label69", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label70", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label71", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label72", (Locale)ctx.getLocale())};
        for (int i = 0; i < arr.length; ++i) {
            if (name_l1.contains(arr[i]) || name_l2.contains(arr[i]) || name_l3.contains(arr[i])) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label8", (Locale)ctx.getLocale())));
            }
            if (!number.contains(arr[i])) continue;
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label16", (Locale)ctx.getLocale())));
        }
        this.afterCheckInfo(ctx, model);
    }

    protected void afterCheckInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }
}

