/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.AbstractSubBudgetAssignFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetAssignTypeEnum;
import com.kingdee.shr.compensation.app.budget.SubBudgetDifferenceFactory;
import com.kingdee.shr.compensation.app.budget.SubBudgetDifferenceInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageFacadeFactory;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.updateType;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubBudgetAssignFacadeControllerBean
extends AbstractSubBudgetAssignFacadeControllerBean {
    private static final Logger logger = Logger.getLogger(SubBudgetAssignFacadeControllerBean.class);
    public static final String SPLIT_FLAG = "###";

    protected BudgetPeriodEnum getBudgetPeriod(Context ctx, String budgetSchemeId) throws BOSException {
        CmpBudgetSchemeInfo budgetSchemeInfo;
        String oql = " select id,template.id,template.budgetPeriod where id = '" + budgetSchemeId + "'";
        CmpBudgetSchemeCollection collection = CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection(oql);
        if (collection != null && !collection.isEmpty() && (budgetSchemeInfo = collection.get(0)) != null && budgetSchemeInfo.getTemplate() != null) {
            return budgetSchemeInfo.getTemplate().getBudgetPeriod();
        }
        return null;
    }

    protected Map<String, BudgetManageInfo> getBasicInfoManageMap(Context ctx, String budgetSchemeId, List<SubBudgetManageInfo> subBudgetManageInfoList) throws BOSException, SQLException {
        HashSet<String> budgetManageIdSet = new HashSet<String>();
        for (int i = 0; i < subBudgetManageInfoList.size(); ++i) {
            SubBudgetManageInfo subBudgetManageInfo = subBudgetManageInfoList.get(i);
            if (subBudgetManageInfo == null || subBudgetManageInfo.getBudgetMange() == null || subBudgetManageInfo.getBudgetMange().getId() == null) continue;
            budgetManageIdSet.add(subBudgetManageInfo.getBudgetMange().getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String inSqlBaseOnFId = cmpInSql.createInSqlBaseOnFId(ctx, budgetManageIdSet);
        String sqlBuilder = " SELECT FID,FAdminOrgUnitID,FCostTypeID  FROM T_HR_SBudgetManage where FID in " + inSqlBaseOnFId;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder);
        HashMap<String, BudgetManageInfo> budgetBasicDataMap = new HashMap<String, BudgetManageInfo>();
        while (iRowSet.next()) {
            String id = iRowSet.getString("FID");
            if (StringUtils.isEmpty((String)id)) continue;
            String adminOrgUnitID = iRowSet.getString("FAdminOrgUnitID");
            String costTypeID = iRowSet.getString("FCostTypeID");
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            if (!StringUtils.isEmpty((String)adminOrgUnitID)) {
                adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitID));
            }
            CostTypeInfo costTypeInfo = null;
            if (!StringUtils.isEmpty((String)costTypeID)) {
                costTypeInfo = new CostTypeInfo();
                costTypeInfo.setId(BOSUuid.read((String)costTypeID));
            }
            BudgetManageInfo budgetManageInfo = new BudgetManageInfo();
            budgetManageInfo.setId(BOSUuid.read((String)id));
            budgetManageInfo.setAdminOrgUnit(adminOrgUnitInfo);
            budgetManageInfo.setCostType(costTypeInfo);
            budgetBasicDataMap.put(id, budgetManageInfo);
        }
        return budgetBasicDataMap;
    }

    protected CoreBaseCollection checkBudgetLimitAndReturnDifference(Context ctx, String budgetSchemeId, Map<String, BigDecimal> budgetDataMap, List<SubBudgetManageInfo> subBudgetManageInfoList, BudgetPeriodEnum budgetPeriod) throws BOSException, SQLException, EASBizException {
        String getBudgetSchemeSql = "SELECT FID,FCurrencyID,FSubBudgetAssignType FROM T_HR_SCmpBudgetScheme where FID = ?";
        IRowSet budgetSchemeRowSet = DbUtil.executeQuery((Context)ctx, (String)getBudgetSchemeSql, (Object[])new Object[]{budgetSchemeId});
        CurrencyInfo currencyInfo = null;
        SubBudgetAssignTypeEnum subBudgetAssignTypeEnum = null;
        while (budgetSchemeRowSet.next()) {
            String currencyID = budgetSchemeRowSet.getString("FCurrencyID");
            int subBudgetAssignType = budgetSchemeRowSet.getInt("FSubBudgetAssignType");
            if (!StringUtils.isEmpty((String)currencyID)) {
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)currencyID));
            }
            subBudgetAssignTypeEnum = SubBudgetAssignTypeEnum.getEnum(subBudgetAssignType);
        }
        Map<String, BudgetManageInfo> basicInfoManageMap = this.getBasicInfoManageMap(ctx, budgetSchemeId, subBudgetManageInfoList);
        CoreBaseCollection differenceColl = new CoreBaseCollection();
        for (int i = 0; i < subBudgetManageInfoList.size() && budgetPeriod != null; ++i) {
            BigDecimal budgetData;
            SubBudgetManageInfo subBudgetManageInfo = subBudgetManageInfoList.get(i);
            if (subBudgetManageInfo == null || subBudgetManageInfo.getBudgetMange() == null || subBudgetManageInfo.getBudgetMange().getId() == null || subBudgetManageInfo.getCmpBudgetItem() == null || subBudgetManageInfo.getCmpBudgetItem().getId() == null) {
                // empty if block
            }
            BigDecimal sumData = BigDecimal.ZERO;
            int periodValue = budgetPeriod.getValue();
            if (1 == periodValue) {
                BigDecimal firstHalfYear = subBudgetManageInfo.getFirstHalfYear() == null ? BigDecimal.ZERO : subBudgetManageInfo.getFirstHalfYear();
                BigDecimal lastHalfYear = subBudgetManageInfo.getLastHalfYear() == null ? BigDecimal.ZERO : subBudgetManageInfo.getLastHalfYear();
                sumData = sumData.add(firstHalfYear).add(lastHalfYear);
            } else if (2 == periodValue) {
                BigDecimal quarter1 = subBudgetManageInfo.getQuarter1() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter1();
                BigDecimal quarter2 = subBudgetManageInfo.getQuarter2() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter2();
                BigDecimal quarter3 = subBudgetManageInfo.getQuarter3() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter3();
                BigDecimal quarter4 = subBudgetManageInfo.getQuarter4() == null ? BigDecimal.ZERO : subBudgetManageInfo.getQuarter4();
                sumData = sumData.add(quarter1).add(quarter2).add(quarter3).add(quarter4);
            } else if (3 == periodValue) {
                for (int j = 1; j <= 12; ++j) {
                    String monthKey = "month" + j;
                    BigDecimal monthData = subBudgetManageInfo.get(monthKey) == null ? BigDecimal.ZERO : (BigDecimal)subBudgetManageInfo.get(monthKey);
                    sumData = sumData.add(monthData);
                }
            }
            String budgetManageId = subBudgetManageInfo.getBudgetMange().getId().toString();
            String budgetItemId = subBudgetManageInfo.getCmpBudgetItem().getId().toString();
            String key = budgetManageId + SPLIT_FLAG + budgetItemId;
            BigDecimal bigDecimal = budgetData = budgetDataMap.get(key) == null ? BigDecimal.ZERO : budgetDataMap.get(key);
            if (budgetData.compareTo(sumData) < 0) {
                String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label17", (Locale)ctx.getLocale()), sumData, budgetData);
                throw new EASBizException(new NumericExceptionSubItem("CMP_COMOM_INFO", message));
            }
            SubBudgetDifferenceInfo subBudgetDifferenceInfo = new SubBudgetDifferenceInfo();
            subBudgetDifferenceInfo.setBudgetManage(subBudgetManageInfo.getBudgetMange());
            BudgetManageInfo budgetManageInfo = basicInfoManageMap.get(budgetManageId);
            if (budgetManageInfo != null) {
                subBudgetDifferenceInfo.setAdminOrgUnit(budgetManageInfo.getAdminOrgUnit());
                subBudgetDifferenceInfo.setCostType(budgetManageInfo.getCostType());
            }
            subBudgetDifferenceInfo.setCurrency(currencyInfo);
            subBudgetDifferenceInfo.setCmpBudgetItem(subBudgetManageInfo.getCmpBudgetItem());
            subBudgetDifferenceInfo.setYearAmount(budgetData);
            subBudgetDifferenceInfo.setSubBudgetAssignType(subBudgetAssignTypeEnum);
            if (budgetData.compareTo(sumData) == 0) {
                subBudgetDifferenceInfo.setIsConsistent(true);
            } else {
                subBudgetDifferenceInfo.setIsConsistent(false);
            }
            subBudgetDifferenceInfo.setDifferenceValue(sumData.subtract(budgetData));
            subBudgetDifferenceInfo.setUpdateType(updateType.Manual);
            int periodVal = budgetPeriod.getValue();
            if (1 == periodVal) {
                subBudgetDifferenceInfo.setYear1(subBudgetManageInfo.getFirstHalfYear());
                subBudgetDifferenceInfo.setYear2(subBudgetManageInfo.getLastHalfYear());
            } else if (2 == periodVal) {
                subBudgetDifferenceInfo.setQuarter1(subBudgetManageInfo.getQuarter1());
                subBudgetDifferenceInfo.setQuarter2(subBudgetManageInfo.getQuarter2());
                subBudgetDifferenceInfo.setQuarter3(subBudgetManageInfo.getQuarter3());
                subBudgetDifferenceInfo.setQuarter4(subBudgetManageInfo.getQuarter4());
            } else if (3 == periodVal) {
                for (int j = 1; j <= 12; ++j) {
                    String monthKey = "month" + j;
                    subBudgetDifferenceInfo.put(monthKey, subBudgetManageInfo.get(monthKey));
                }
            }
            differenceColl.add((CoreBaseInfo)subBudgetDifferenceInfo);
        }
        return differenceColl;
    }

    protected CmpBudgetSchemeInfo getBudgetTemplateId(Context ctx, String budgetSchemeId) throws BOSException {
        String oql = "select id, template.id, template.name, budgetYear where id = '" + budgetSchemeId + "'";
        return CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection(oql).get(0);
    }

    protected Set<String> getCmpBudgetItemIds(List<SubBudgetManageInfo> subBudgetManageInfoList) {
        HashSet<String> cmpBudgetItemIdSet = new HashSet<String>();
        for (int i = 0; i < subBudgetManageInfoList.size(); ++i) {
            SubBudgetManageInfo budgetManageInfo = subBudgetManageInfoList.get(i);
            if (budgetManageInfo == null || budgetManageInfo.getCmpBudgetItem() == null || budgetManageInfo.getCmpBudgetItem().getId() == null) continue;
            CmpBudgetItemInfo cmpBudgetItem = budgetManageInfo.getCmpBudgetItem();
            cmpBudgetItemIdSet.add(cmpBudgetItem.getId().toString());
        }
        return cmpBudgetItemIdSet;
    }

    protected IRowSet querySchemeDeductConfig(Context ctx, String budgetTemplateId, Set<String> cmpBudgetItemIds) throws BOSException {
        CmpInSql<String> inSqlInstance = CmpInSqlFactory.getInstance();
        String cmpBudgetItemIn = inSqlInstance.createInSqlBaseOnFId(ctx, cmpBudgetItemIds);
        String fieldSqlBuild = " SELECT distinct  bi.FID as budgetItemId, bi.FieldSn as budgetItemSn, sbi.FID as standingBookItemId, sbi.FieldSn as standingBookItemSn FROM T_HR_SSchemeDeduConfig de  left join T_HR_SCmpBudgetItem bi on bi.FID= de.FCmpBudgetItemID  left join T_HR_SBudgetTemplateSTBItem tti on tti.FID = de.FTemplateStbItemID  left join T_HR_SStandingBookItem sbi on sbi.FID = tti.FStandingBookItemID  where de.FCalSubmitSchemeID in ( SELECT ss.FID FROM T_HR_ScalSubmitScheme ss where ss.FBudgetTemplateID = ? )  and de.FCmpBudgetItemID in " + cmpBudgetItemIn + " and tti.FTemplateID = ? ";
        return DbUtil.executeQuery((Context)ctx, (String)fieldSqlBuild, (Object[])new Object[]{budgetTemplateId, budgetTemplateId});
    }

    protected Set<String> getBudgetManageIds(List<SubBudgetManageInfo> subBudgetManageInfoList) {
        HashSet<String> budgetManageIds = new HashSet<String>();
        for (int i = 0; i < subBudgetManageInfoList.size(); ++i) {
            SubBudgetManageInfo budgetManageInfo = subBudgetManageInfoList.get(i);
            if (budgetManageInfo == null || budgetManageInfo.getBudgetMange() == null || budgetManageInfo.getBudgetMange().getId() == null) continue;
            budgetManageIds.add(budgetManageInfo.getBudgetMange().getId().toString());
        }
        return budgetManageIds;
    }

    protected void checkBudgetAndUsed(Context ctx, String budgetSchemeId, List<SubBudgetManageInfo> subBudgetManageInfoList, String budgetTemplateId, BudgetPeriodEnum budgetPeriod) throws BOSException, EASBizException {
        Map<String, BigDecimal> useDataObj;
        if (budgetPeriod == null) {
            return;
        }
        Set<String> cmpBudgetItemIds = this.getCmpBudgetItemIds(subBudgetManageInfoList);
        CmpInSql<String> inSqlInstance = CmpInSqlFactory.getInstance();
        String cmpBudgetItemIn = inSqlInstance.createInSqlBaseOnFId(ctx, cmpBudgetItemIds);
        IRowSet rowSet = this.querySchemeDeductConfig(ctx, budgetTemplateId, cmpBudgetItemIds);
        HashSet<String> allColNameSet = new HashSet<String>();
        HashMap<Object, HashMap<String, Integer>> itemSnMap = new HashMap<Object, HashMap<String, Integer>>();
        try {
            String standingSnPreFix = "S";
            while (rowSet.next()) {
                String budgetItemId = rowSet.getString("budgetItemId");
                String standingBookItemId = rowSet.getString("standingBookItemId");
                if (StringUtils.isEmpty((String)budgetItemId) || StringUtils.isEmpty((String)standingBookItemId)) continue;
                HashMap<String, Integer> map = (HashMap<String, Integer>)itemSnMap.get(budgetItemId);
                if (map == null) {
                    map = new HashMap<String, Integer>();
                }
                map.put("budgetItemSn", rowSet.getInt("budgetItemSn"));
                HashSet<String> standingBookItemSnSet = (HashSet<String>)map.get("standingBookItemSnSet");
                if (standingBookItemSnSet == null) {
                    standingBookItemSnSet = new HashSet<String>();
                }
                int standingBookItemSn = rowSet.getInt("standingBookItemSn");
                standingBookItemSnSet.add(standingSnPreFix + standingBookItemSn);
                allColNameSet.add(standingSnPreFix + standingBookItemSn);
                map.put("standingBookItemSnSet", (Integer)((Object)standingBookItemSnSet));
                itemSnMap.put(budgetItemId, map);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        StringBuilder colNameBuilder = new StringBuilder();
        for (String colName : allColNameSet) {
            colNameBuilder.append(",sc.").append(colName);
        }
        Set<String> budgetManageIds = this.getBudgetManageIds(subBudgetManageInfoList);
        CmpInSql<String> instance = CmpInSqlFactory.getInstance();
        String budgetMangeIdIn = instance.createInSqlBaseOnFId(ctx, budgetManageIds);
        String sqlBuild = " SELECT  sbq.FBudgetManageID as FBudgetManageID,sbq.FID as subQueryId,sc.FID as subBookId " + colNameBuilder + " FROM T_HR_SubCmpStandingBook sc  left join T_HR_SSubBudgetQuery sbq on sbq.FID=sc.FSubBudgetQueryID  where sbq.FBudgetManageID in " + budgetMangeIdIn + " order by sbq.FBudgetManageID,sbq.FEffectDate asc,sbq.FExpiryDate asc ";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sqlBuild);
        HashMap<String, Map<String, BigDecimal>> useDataMap = new HashMap<String, Map<String, BigDecimal>>();
        try {
            while (rowSet1.next()) {
                String budgetManageID = rowSet1.getString("FBudgetManageID");
                for (Map.Entry next : itemSnMap.entrySet()) {
                    Integer index;
                    String budgetItemId = (String)next.getKey();
                    Map snObj = (Map)next.getValue();
                    Set standingBookItemSnSet = (Set)snObj.get("standingBookItemSnSet");
                    String dataKey = budgetManageID + SPLIT_FLAG + budgetItemId;
                    useDataObj = useDataMap.get(dataKey) == null ? new HashMap() : (Map)useDataMap.get(dataKey);
                    Integer n = index = Integer.valueOf(useDataObj.get("index") == null ? 0 : (Integer)useDataObj.get("index"));
                    Integer n2 = index = Integer.valueOf(index + 1);
                    BigDecimal totalUse = useDataObj.get("totalUse") == null ? BigDecimal.ZERO : (BigDecimal)useDataObj.get("totalUse");
                    String useKey = "use" + index;
                    BigDecimal useData = BigDecimal.ZERO;
                    if (!standingBookItemSnSet.isEmpty()) {
                        for (String standingColName : standingBookItemSnSet) {
                            BigDecimal bigDecimal = rowSet1.getBigDecimal(standingColName) == null ? BigDecimal.ZERO : rowSet1.getBigDecimal(standingColName);
                            useData = useData.add(bigDecimal);
                        }
                    }
                    totalUse = totalUse.add(useData);
                    useDataObj.put(useKey, useData);
                    useDataObj.put("index", (BigDecimal)((Object)index));
                    useDataObj.put("totalUse", totalUse);
                    useDataMap.put(dataKey, useDataObj);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Map<String, BigDecimal> outUseDataMap = this.getOutUsedDataMap(ctx, cmpBudgetItemIn, budgetMangeIdIn);
        Map<String, Object> budgetMap = this.getBudgetCmpBudgetItemBudget(subBudgetManageInfoList, budgetPeriod);
        for (Map.Entry<String, Object> next : budgetMap.entrySet()) {
            BigDecimal use1;
            BigDecimal data2;
            BigDecimal outUseData;
            BigDecimal totalData;
            String key = next.getKey();
            Map budgetObj = (Map)next.getValue();
            BigDecimal bigDecimal = totalData = budgetObj.get("totalData") == null ? BigDecimal.ZERO : (BigDecimal)budgetObj.get("totalData");
            useDataObj = (Map<String, BigDecimal>)useDataMap.get(key);
            if (useDataObj == null) continue;
            BigDecimal totalUse = useDataObj.get("totalUse") == null ? BigDecimal.ZERO : (BigDecimal)useDataObj.get("totalUse");
            BigDecimal allUsed = totalUse.add(outUseData = outUseDataMap.get(key) == null ? BigDecimal.ZERO : outUseDataMap.get(key));
            if (totalData.compareTo(allUsed) < 0) {
                String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label18", (Locale)ctx.getLocale()), totalData, allUsed);
                throw new EASBizException(new NumericExceptionSubItem("CMP_COMOM_INFO", message));
            }
            if (1 == budgetPeriod.getValue()) {
                BigDecimal data1 = this.getData((BigDecimal)budgetObj.get("data1"));
                data2 = this.getData((BigDecimal)budgetObj.get("data2"));
                use1 = this.getData((BigDecimal)useDataObj.get("use1"));
                BigDecimal use2 = this.getData((BigDecimal)useDataObj.get("use2"));
                this.checkIllegal(data1, use1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label19", (Locale)ctx.getLocale()));
                this.checkIllegal(data2, use2, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label20", (Locale)ctx.getLocale()));
                continue;
            }
            if (2 == budgetPeriod.getValue()) {
                BigDecimal data1 = this.getData((BigDecimal)budgetObj.get("data1"));
                data2 = this.getData((BigDecimal)budgetObj.get("data2"));
                BigDecimal data3 = this.getData((BigDecimal)budgetObj.get("data3"));
                BigDecimal data4 = this.getData((BigDecimal)budgetObj.get("data4"));
                BigDecimal use12 = this.getData((BigDecimal)useDataObj.get("use1"));
                BigDecimal use2 = this.getData((BigDecimal)useDataObj.get("use2"));
                BigDecimal use3 = this.getData((BigDecimal)useDataObj.get("use3"));
                BigDecimal use4 = this.getData((BigDecimal)useDataObj.get("use4"));
                this.checkIllegal(data1, use12, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label21", (Locale)ctx.getLocale()));
                this.checkIllegal(data2, use2, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label22", (Locale)ctx.getLocale()));
                this.checkIllegal(data3, use3, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label23", (Locale)ctx.getLocale()));
                this.checkIllegal(data4, use4, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label24", (Locale)ctx.getLocale()));
                continue;
            }
            if (3 != budgetPeriod.getValue()) continue;
            for (int j = 1; j <= 12; ++j) {
                BigDecimal data1 = this.getData((BigDecimal)budgetObj.get("data" + j));
                use1 = this.getData((BigDecimal)useDataObj.get("use" + j));
                String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label25", (Locale)ctx.getLocale()), j);
                this.checkIllegal(data1, use1, message);
            }
        }
    }

    protected void checkIllegal(BigDecimal budget, BigDecimal use, String info) throws EASBizException {
        if (budget == null) {
            budget = BigDecimal.ZERO;
        }
        if (use == null) {
            use = BigDecimal.ZERO;
        }
        if (budget.compareTo(use) < 0) {
            String messageTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label26", (Locale)new Context().getLocale());
            String formatMsg = MessageFormat.format(messageTemplate, info, budget, use);
            throw new EASBizException(new NumericExceptionSubItem("CMP_COMOM_INFO", formatMsg));
        }
    }

    protected BigDecimal getData(BigDecimal data) {
        if (data == null) {
            return BigDecimal.ZERO;
        }
        return data;
    }

    protected Map<String, Object> getBudgetCmpBudgetItemBudget(List<SubBudgetManageInfo> subBudgetManageInfoList, BudgetPeriodEnum budgetPeriod) {
        HashMap<String, Object> budgetMap = new HashMap<String, Object>();
        for (int i = 0; i < subBudgetManageInfoList.size(); ++i) {
            SubBudgetManageInfo subBudgetManageInfo = subBudgetManageInfoList.get(i);
            if (subBudgetManageInfo == null || subBudgetManageInfo.getBudgetMange() == null || subBudgetManageInfo.getBudgetMange().getId() == null || subBudgetManageInfo.getCmpBudgetItem() == null || subBudgetManageInfo.getCmpBudgetItem().getId() == null) continue;
            String budgetMangeId = subBudgetManageInfo.getBudgetMange().getId().toString();
            String cmpBudgetItemId = subBudgetManageInfo.getCmpBudgetItem().getId().toString();
            String key = budgetMangeId + SPLIT_FLAG + cmpBudgetItemId;
            HashMap<String, BigDecimal> dataObj = new HashMap<String, BigDecimal>();
            BigDecimal totalData = BigDecimal.ZERO;
            if (1 == budgetPeriod.getValue()) {
                BigDecimal firstData = this.getData(subBudgetManageInfo.getFirstHalfYear());
                BigDecimal lastData = this.getData(subBudgetManageInfo.getLastHalfYear());
                totalData = totalData.add(firstData).add(lastData);
                dataObj.put("totalData", totalData);
                dataObj.put("data1", firstData);
                dataObj.put("data2", lastData);
            } else if (2 == budgetPeriod.getValue()) {
                BigDecimal data1 = this.getData(subBudgetManageInfo.getQuarter1());
                BigDecimal data2 = this.getData(subBudgetManageInfo.getQuarter2());
                BigDecimal data3 = this.getData(subBudgetManageInfo.getQuarter3());
                BigDecimal data4 = this.getData(subBudgetManageInfo.getQuarter4());
                totalData = totalData.add(data1).add(data2).add(data3).add(data4);
                dataObj.put("totalData", totalData);
                dataObj.put("data1", data1);
                dataObj.put("data2", data2);
                dataObj.put("data3", data3);
                dataObj.put("data4", data4);
            } else if (3 == budgetPeriod.getValue()) {
                for (int j = 1; j <= 12; ++j) {
                    BigDecimal monthData = (BigDecimal)subBudgetManageInfo.get("month" + j);
                    monthData = this.getData(monthData);
                    totalData = totalData.add(monthData);
                    dataObj.put("data" + j, monthData);
                }
                dataObj.put("totalData", totalData);
            }
            budgetMap.put(key, dataObj);
        }
        return budgetMap;
    }

    private Map<String, BigDecimal> getOutUsedDataMap(Context ctx, String cmpBudgetItemIn, String budgetMangeIdIn) throws BOSException {
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)(" SELECT FBudgetManageID,FCmpBudgetItemID,FUsedAmount FROM T_HR_SCmpUsedAmount where FBudgetManageID in " + budgetMangeIdIn + " and FCmpBudgetItemID in " + cmpBudgetItemIn));
        HashMap<String, BigDecimal> outUseDataMap = new HashMap<String, BigDecimal>();
        try {
            while (rowSet2.next()) {
                String budgetManageID = rowSet2.getString("FBudgetManageID");
                String cmpBudgetItemID = rowSet2.getString("FCmpBudgetItemID");
                BigDecimal usedAmount = rowSet2.getBigDecimal("FUsedAmount");
                String key = budgetManageID + SPLIT_FLAG + cmpBudgetItemID;
                outUseDataMap.put(key, usedAmount);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return outUseDataMap;
    }

    protected IRowSet getSchemeDeductConfigSn(Context ctx, String budgetTemplateId, String cmpBudgetItemIn) throws BOSException {
        String fieldSqlBuild = " SELECT distinct  bi.FID as budgetItemId, bi.FieldSn as budgetItemSn, sbi.FID as standingBookItemId, sbi.FieldSn as standingBookItemSn, sbl.FID as balanceLedgerItemID, sbl.FieldSn as balanceLedgerItemSn  FROM T_HR_SSchemeDeduConfig de  left join T_HR_SCmpBudgetItem bi on bi.FID= de.FCmpBudgetItemID  left join T_HR_SBudgetTemplateSTBItem tti on tti.FID = de.FTemplateStbItemID  left join T_HR_SStandingBookItem sbi on sbi.FID = tti.FStandingBookItemID  left join T_HR_SStandingBookItem sbl on sbl.FID = tti.FBalanceLedgerItemID  where de.FCalSubmitSchemeID in ( SELECT ss.FID FROM T_HR_ScalSubmitScheme ss where ss.FBudgetTemplateID = ? )  and de.FCmpBudgetItemID in " + cmpBudgetItemIn + " and tti.FTemplateID = ? ";
        return DbUtil.executeQuery((Context)ctx, (String)fieldSqlBuild, (Object[])new Object[]{budgetTemplateId, budgetTemplateId});
    }

    protected Map<String, Object> getUsedDataMap(Context ctx, String budgetSchemeId, List<SubBudgetManageInfo> subBudgetManageInfoList, Set<Integer> useSnSet, StringBuilder colNameBuilder) throws BOSException {
        Set<String> budgetManageIds = this.getBudgetManageIds(subBudgetManageInfoList);
        CmpInSql<String> instance = CmpInSqlFactory.getInstance();
        String budgetMangeIdIn = instance.createInSqlBaseOnFId(ctx, budgetManageIds);
        String sqlBuild = " SELECT  sbq.FBudgetManageID as FBudgetManageID,sbq.FID as subQueryId,sc.FID as subBookId " + colNameBuilder + " FROM T_HR_SubCmpStandingBook sc  left join T_HR_SSubBudgetQuery sbq on sbq.FID=sc.FSubBudgetQueryID  where sbq.FBudgetManageID in " + budgetMangeIdIn + " order by sbq.FBudgetManageID,sbq.FEffectDate asc,sbq.FExpiryDate asc ";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sqlBuild);
        HashMap<String, Object> useDataMap = new HashMap<String, Object>();
        try {
            while (rowSet1.next()) {
                String budgetManageID = rowSet1.getString("FBudgetManageID");
                ArrayList subDataList = (ArrayList)useDataMap.get(budgetManageID);
                if (subDataList == null) {
                    subDataList = new ArrayList();
                }
                HashMap<String, Object> subDataMap = new HashMap<String, Object>();
                subDataMap.put("subQueryId", rowSet1.getString("subQueryId"));
                subDataMap.put("subBookId", rowSet1.getString("subBookId"));
                for (Integer useSn : useSnSet) {
                    String snKey;
                    subDataMap.put(snKey, rowSet1.getBigDecimal(snKey = "S" + useSn) == null ? BigDecimal.ZERO : rowSet1.getBigDecimal(snKey));
                }
                subDataList.add(subDataMap);
                useDataMap.put(budgetManageID, subDataList);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return useDataMap;
    }

    protected void calLeftData(IRowSet rowSet, Map<String, Object> budgetCmpBudgetItemBudget, Map<String, Object> useDataMap, Map<String, BigDecimal> outUsedDataMap, Map<String, Object> leftDataMap) throws BOSException {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String budgetItemId = rowSet.getString("budgetItemId");
                if (StringUtils.isEmpty((String)budgetItemId)) continue;
                int standingBookItemSn = rowSet.getInt("standingBookItemSn");
                int balanceLedgerItemSn = rowSet.getInt("balanceLedgerItemSn");
                for (Map.Entry<String, Object> next : budgetCmpBudgetItemBudget.entrySet()) {
                    String[] keySplit;
                    String key = next.getKey();
                    if (StringUtils.isEmpty((String)key) || (keySplit = key.split(SPLIT_FLAG)) == null || keySplit.length < 2) continue;
                    String budgetManageId = keySplit[0];
                    String cmpBudgetItemId = keySplit[1];
                    if (!budgetItemId.equals(cmpBudgetItemId)) continue;
                    Map dataObj = (Map)next.getValue();
                    List subDataList = (List)useDataMap.get(budgetManageId);
                    HashMap<String, HashMap<String, BigDecimal>> realLeftDataMap = (HashMap<String, HashMap<String, BigDecimal>>)leftDataMap.get(budgetManageId);
                    if (realLeftDataMap == null) {
                        realLeftDataMap = new HashMap<String, HashMap<String, BigDecimal>>();
                    }
                    if (subDataList == null || subDataList.isEmpty()) continue;
                    for (int i = 0; i < subDataList.size(); ++i) {
                        Map useMap = (Map)subDataList.get(i);
                        if (useMap == null) continue;
                        BigDecimal budget = dataObj.get("data" + (i + 1)) == null ? BigDecimal.ZERO : (BigDecimal)dataObj.get("data" + (i + 1));
                        BigDecimal used = (BigDecimal)useMap.get("S" + standingBookItemSn);
                        BigDecimal leftData = budget.subtract(used);
                        String subQueryId = (String)useMap.get("subQueryId");
                        String subBookId = (String)useMap.get("subBookId");
                        HashMap<String, BigDecimal> leftDataObj = (HashMap<String, BigDecimal>)realLeftDataMap.get(subBookId);
                        if (leftDataObj == null) {
                            leftDataObj = new HashMap<String, BigDecimal>();
                        }
                        leftDataObj.put("S" + balanceLedgerItemSn, leftData);
                        realLeftDataMap.put(subBookId, leftDataObj);
                    }
                    String outUseKey = budgetManageId + SPLIT_FLAG + cmpBudgetItemId;
                    if (outUsedDataMap.get(outUseKey) != null && BigDecimal.ZERO.compareTo(outUsedDataMap.get(outUseKey)) != 0) {
                        BigDecimal outUseData = outUsedDataMap.get(outUseKey);
                        BigDecimal outUseDataCal = new BigDecimal(outUseData.toString());
                        for (int i = subDataList.size() - 1; i >= 0; --i) {
                            String subBookId;
                            Map leftDataObj;
                            Map subDataMap = (Map)subDataList.get(i);
                            if (subDataMap == null || (leftDataObj = (Map)realLeftDataMap.get(subBookId = (String)subDataMap.get("subBookId"))) == null || BigDecimal.ZERO.compareTo(outUseDataCal) == 0) continue;
                            BigDecimal leftData = (BigDecimal)leftDataObj.get("S" + balanceLedgerItemSn);
                            if (outUseDataCal.compareTo(leftData) > 0) {
                                outUseDataCal = outUseDataCal.subtract(leftData);
                                leftData = leftData.subtract(leftData);
                            } else {
                                leftData = leftData.subtract(outUseDataCal);
                                outUseDataCal = outUseDataCal.subtract(outUseDataCal);
                            }
                            leftDataObj.put("S" + balanceLedgerItemSn, leftData);
                        }
                    }
                    leftDataMap.put(budgetManageId, realLeftDataMap);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Map _assignSubBudgetData(Context ctx, String budgetSchemeId, Map budgetDataMap, List subBudgetManageInfoList, Map otherParamMap) throws BOSException, EASBizException {
        BudgetPeriodEnum budgetPeriod = this.getBudgetPeriod(ctx, budgetSchemeId);
        CoreBaseCollection differencesCoreBaseColl = null;
        try {
            differencesCoreBaseColl = this.checkBudgetLimitAndReturnDifference(ctx, budgetSchemeId, budgetDataMap, subBudgetManageInfoList, budgetPeriod);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        CmpBudgetSchemeInfo budgetSchemeInfo = this.getBudgetTemplateId(ctx, budgetSchemeId);
        this.checkBudgetAndUsed(ctx, budgetSchemeId, subBudgetManageInfoList, budgetSchemeInfo.getTemplate().getId().toString(), budgetPeriod);
        if (!subBudgetManageInfoList.isEmpty()) {
            SubBudgetManageFacadeFactory.getLocalInstance(ctx).updateSubBudgetManage(budgetSchemeId, subBudgetManageInfoList);
        }
        if (differencesCoreBaseColl != null && !differencesCoreBaseColl.isEmpty()) {
            SubBudgetDifferenceFactory.getLocalInstance(ctx).save(differencesCoreBaseColl);
        }
        return new HashMap();
    }

    protected String getUpdateField(Set<String> snSet, BigDecimal data) {
        String snStr;
        String addOperate = "+";
        StringBuilder snBuild = new StringBuilder();
        if (BigDecimal.ZERO.compareTo(data) < 0) {
            for (String sn : snSet) {
                snBuild.append(",").append(sn).append(" = ").append(sn).append(" ").append(addOperate).append(" ").append(data);
            }
        } else if (BigDecimal.ZERO.compareTo(data) > 0) {
            for (String sn : snSet) {
                snBuild.append(",").append(sn).append(" = ").append(sn).append(data);
            }
        }
        if (!StringUtils.isEmpty((String)(snStr = snBuild.toString()))) {
            snStr = snStr.substring(1);
        }
        return snStr;
    }

    protected BigDecimal getSubtract(SubBudgetManageInfo subBudgetManageInfo, SubBudgetManageInfo changedSubBudgetInfo, String key) {
        BigDecimal quarter1 = this.getData(subBudgetManageInfo.getBigDecimal(key));
        BigDecimal cQuarter1 = this.getData(changedSubBudgetInfo.getBigDecimal(key));
        BigDecimal subtracted = cQuarter1.subtract(quarter1);
        return subtracted;
    }
}

