/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.calculate;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.calculate.AbstractCmpCalculateFacadeControllerBean;
import com.kingdee.shr.compensation.calculate.cache.SalaryCalProcessCache;
import com.kingdee.shr.compensation.calculate.combine.StdCombineData;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import com.kingdee.shr.compensation.calculate.pt.StdSalaryCalFunMgr;
import com.kingdee.shr.compensation.calculate.result.CmpCalculateCallBack;
import com.kingdee.shr.compensation.calculate.result.handle.BudgetExecuteService;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import com.kingdee.shr.compensation.calculate.thread.SalaryCalThreadPoolManger;
import com.kingdee.shr.compensation.calculate.thread.SalaryCalculator;
import com.kingdee.shr.compensation.exception.NewCalException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.validaterule.formula.callback.IValidateRuleCallBack;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpCalculateFacadeControllerBean
extends AbstractCmpCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.calculate.CmpCalculateFacadeControllerBean");

    @Override
    protected Map _execute(Context ctx, CalInitData calInitData) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        int noCalCount = 0;
        HashSet<Integer> calStateSet = new HashSet<Integer>();
        calStateSet.add(1);
        calStateSet.add(4);
        String filterSql = calInitData.getFilterSql();
        String sql = "SELECT FID, FCALSTATE FROM T_HR_SCMPCALTABLE WHERE FID IN (" + filterSql + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() <= 0) {
            throw new NewCalException(NewCalException.NOCALPERSON);
        }
        try {
            while (rowSet.next()) {
                if (calStateSet.contains(rowSet.getInt(2))) {
                    idList.add(rowSet.getString(1));
                    continue;
                }
                ++noCalCount;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (idList.size() <= 0) {
            throw new NewCalException(NewCalException.NOCALPERSON);
        }
        if (idList.size() <= 10) {
            calInitData.setFilterSql(CmpStrUtil.convertListToString(idList));
        } else {
            calInitData.setFilterSql("SELECT FID FROM T_HR_SCMPCALTABLE WHERE FID IN (" + filterSql + ") AND FCALSTATE IN (1,2,3,4,5,6,7)");
        }
        String cacheKey = CalculateTool.getCacheKey(HRFilterUtils.getCurrentUserId((Context)calInitData.getCtx()), calInitData.getSchemeInfo().getId().toString());
        calInitData.setCacheKey(cacheKey);
        SalaryCalProcessCache.initProcess(rowSet.size(), noCalCount, calInitData);
        calInitData.setCalSuccessCallBack(this.getCallBackLists(ctx, calInitData));
        SalaryCalculator calculator = new SalaryCalculator(new StdSalaryCalFunMgr(), new StdCombineData(calInitData), calInitData);
        SalaryCalThreadPoolManger.addTask(ctx, calculator);
        return null;
    }

    protected List<IValidateRuleCallBack> getCallBackLists(Context ctx, CalInitData calInitData) {
        ArrayList callBacks = Lists.newArrayList();
        callBacks.add(new CmpCalculateCallBack());
        callBacks.add(new BudgetExecuteService());
        return callBacks;
    }

    @Override
    protected boolean _calIsRunning(Context ctx, String calSchemeId) throws BOSException, EASBizException {
        boolean isCal = false;
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String sql = " SELECT FID, FBEGINTIME, FPROCESS, FSERVER, FIP FROM T_HR_SCMPCALTASK WHERE FTASKBASEID IN (SELECT FID FROM T_HR_SCMPCALTASKBASE WHERE FCALSCHEMEID = '" + calSchemeId + "' AND FCREATORID = '" + userId + "') AND FPROCESS <= 60";
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            while (rowSet.next()) {
                String fid = rowSet.getString("FID");
                long calBeginTime = rowSet.getDate("FBEGINTIME").getTime();
                long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
                String lastCalServer = rowSet.getString("FSERVER");
                String newServer = System.getProperty("EAS_INSTANCE_NAME");
                String oldIp = null == rowSet.getString("FIP") ? "" : rowSet.getString("FIP");
                String newIp = "";
                try {
                    newIp = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (startTime > calBeginTime || !lastCalServer.equals(newServer) || !oldIp.equals(newIp) && lastCalServer.equals(newServer)) {
                    String updateSql = "UPDATE T_HR_SCMPCALTASK SET FPROCESS = 80, FDESCRIPTION_" + ctx.getLocale().getLanguage() + " = '" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.NewCalResource", (String)"label0", (Locale)ctx.getLocale()) + "' WHERE FID = '" + fid + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    continue;
                }
                isCal = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isCal;
    }
}

