/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.calculate.validate;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.calculate.validate.AbstractCmpCalResultValidateFacadeControllerBean;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateParam;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.formula.CalculatorManager2;
import com.kingdee.shr.validaterule.formula.ConcurrentCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.SalayCalculatorMgr2;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.process.CalculatorProcessCache;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpCalResultValidateFacadeControllerBean
extends AbstractCmpCalResultValidateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateFacadeControllerBean");

    @Override
    protected Map _validate(Context ctx, CmpCalResultValidateParam param) throws BOSException {
        BaseFormulaCollection formulaCollection = this.initValidateRule(ctx, param);
        if (null == formulaCollection || formulaCollection.isEmpty()) {
            if ("CMP_CAL_RESULT_002".equals(param.calCategoryNum)) {
                this.setCmpCalTablePass(ctx, param);
            }
            return null;
        }
        Sheet sheet = this.post(ctx, param, formulaCollection);
        HashMap<String, Sheet> result = new HashMap<String, Sheet>();
        result.put("result", sheet);
        return result;
    }

    @Override
    protected boolean _isNeedVerify(Context ctx, String calSchemeId, String vrNodeId) throws BOSException {
        boolean isNeedVerify = false;
        String existsVrSql = " select top 1 1 from  T_HR_SCalSchemeVeriRule A \r\n INNER JOIN T_HR_SCalSchemeVeriRuleNodeRel R on A.FID = R.FCALSCHEMEVERIFICATIONRULEID \r\n INNER JOIN T_HR_SVerificationRuleNode N on  R.FVERIFICATIONRULENODEID = N.FID \r\n WHERE A.FCalSchemeID = ? \r\n AND  N.FID = ? \r\n AND  A.FState = ? \r\n";
        try {
            isNeedVerify = DbUtil.executeQuery((Context)ctx, (String)existsVrSql, (Object[])new Object[]{calSchemeId, vrNodeId, 1}).next();
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"CmpCalResultValidateFacadeControllerBean -- query calschemeverificationrule failed , ", e);
        }
        return isNeedVerify;
    }

    protected void setCmpCalTablePass(Context ctx, CmpCalResultValidateParam param) {
        String filterSql = param.getFilterSql();
        this.deleteBeforeData(ctx, filterSql, this.getNodeIdByNum(ctx, param.getValidateNodeNum()));
        try {
            DbUtil.execute((Context)ctx, (String)("update T_HR_SCmpCalTable set FValidateState = ? where fid in (" + filterSql + ")"), (Object[])new Object[]{60});
        }
        catch (BOSException e) {
            logger.error((Object)"update T_HR_SCmpCalTable validate State error", (Throwable)e);
        }
    }

    protected BaseFormulaCollection initValidateRule(Context ctx, CmpCalResultValidateParam param) {
        BaseFormulaCollection validateRuleCollection = new BaseFormulaCollection();
        StringBuilder sqlBuilder = new StringBuilder();
        String language = ctx.getLocale().getLanguage();
        sqlBuilder.append(" SELECT B.FID,B.FNAME_").append(language).append(" NAME,D.FEXPRESS,D.FBIGEXPRESS,D.FLISTITEM,D.FLISTFUNC,D.FLISTVAR,A.FWarnType \r\n");
        sqlBuilder.append(" FROM T_HR_SCalSchemeVeriRule A \r\n");
        sqlBuilder.append(" INNER JOIN T_HR_SVERIFICATIONRULE B ON A.FVERIFICATIONRULEID = B.FID \r\n");
        sqlBuilder.append(" INNER JOIN T_HR_SBUSINESSRELATIONCONFIG C ON B.FID = C.FBUSINESSID \r\n");
        sqlBuilder.append(" INNER JOIN T_HR_SBASEFORMULA D ON D.FBUSINESSRELATIONCONFIGID = C.FID \r\n");
        sqlBuilder.append(" INNER JOIN T_HR_SCalSchemeVeriRuleNodeRel R on A.FID = R.FCALSCHEMEVERIFICATIONRULEID \r\n");
        sqlBuilder.append(" INNER JOIN T_HR_SVerificationRuleNode N on  R.FVERIFICATIONRULENODEID = N.FID \r\n");
        sqlBuilder.append(" WHERE A.FCalSchemeID = ? \r\n");
        sqlBuilder.append(" AND  N.FNUMBER = ? ");
        sqlBuilder.append(" AND  A.FState = ? ");
        sqlBuilder.append(" ORDER BY A.FSORTCODE \r\n");
        if (logger.isDebugEnabled()) {
            logger.error((Object)("query Formula sql :  " + sqlBuilder));
        }
        String nodeNum = param.getValidateNodeNum();
        String calSchemeId = param.getCalSchemeId();
        boolean isSubCmpBudget = !StringUtils.isEmpty((CharSequence)param.getPeriod());
        String csbTable = "T_HR_SCmpStandingBook";
        String scsbTable = "T_HR_SubCmpStandingBook";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{calSchemeId, nodeNum, 1});
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                String name = rowSet.getString("NAME");
                String express = rowSet.getString("FEXPRESS");
                String bigExpress = rowSet.getString("FBIGEXPRESS");
                String listItem = rowSet.getString("FLISTITEM");
                String listFunc = rowSet.getString("FLISTFUNC");
                String listVar = rowSet.getString("FLISTVAR");
                String warningType2 = rowSet.getString("FWarnType");
                BaseFormulaInfo verificationRule = new BaseFormulaInfo();
                verificationRule.setId(BOSUuid.read((String)id));
                verificationRule.setName(name);
                express = isSubCmpBudget ? express.replace(csbTable, scsbTable) : express;
                verificationRule.setExpress(express);
                bigExpress = isSubCmpBudget ? bigExpress.replace(csbTable, scsbTable) : bigExpress;
                verificationRule.setBigExpress(bigExpress);
                listItem = listItem != null && isSubCmpBudget ? listItem.replace(csbTable, scsbTable) : listItem;
                verificationRule.setListItem(listItem);
                verificationRule.setListFunc(listFunc);
                verificationRule.setListVar(listVar);
                verificationRule.put("isValidateRule", (Object)true);
                verificationRule.put("validaterule_warnig_type", (Object)warningType2);
                validateRuleCollection.add(verificationRule);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"Cmp Cal validation init validaterule error", e);
        }
        return validateRuleCollection;
    }

    protected Sheet post(Context ctx, CmpCalResultValidateParam param, BaseFormulaCollection formulaCollection) {
        String calSchemeId = param.getCalSchemeId();
        String uid = CalculateTool.getCacheKey(HRFilterUtils.getCurrentUserId((Context)ctx), calSchemeId + "_" + param.getValidateNodeNum());
        CalculatorProcessCache.addValidateTask((String)uid);
        SalaryCalculator2 cal = new SalaryCalculator2(uid);
        SalayCalculatorMgr2.addTask((SalaryCalculator2)cal);
        Sheet result = null;
        try {
            ConcurrentCalculatorProxy2.Parameters parameters = ConcurrentCalculatorProxy2.createParamInstance();
            parameters.setMainTableName(param.getCalTable());
            parameters.setMainTableAlias(param.getClientNumber());
            parameters.setCalCategoryNum(param.getCalCategoryNum());
            parameters.setSchemeID(calSchemeId);
            parameters.setCtx(ctx);
            parameters.setEndDate(param.getCalSchemeInfo().getEndDate());
            parameters.setFormulaCollection(formulaCollection);
            parameters.setMainTableRowFilter(param.getFilterSql());
            parameters.setContainsVerification(true);
            HashMap outerData = Maps.newHashMap();
            outerData.put("param", param);
            parameters.setOuterData((Object)outerData);
            ConcurrentCalculatorProxy2 calculatorProxy2 = ConcurrentCalculatorProxy2.getInstance((ConcurrentCalculatorProxy2.Parameters)parameters, (SalaryCalculator2)cal);
            calculatorProxy2.run();
            if (param.isReturnResult()) {
                Future taskFuture = CalculatorManager2.findTaskFuture((String)uid);
                result = (Sheet)taskFuture.get();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String getNodeIdByNum(Context ctx, String nodeNum) {
        String nodeId = "";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select FID from T_HR_SVerificationRuleNode where fnumber = ?", (Object[])new Object[]{nodeNum});
            while (rowSet.next()) {
                nodeId = rowSet.getString("FID");
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"get VerificationRuleNode error", e);
        }
        return nodeId;
    }

    protected void deleteBeforeData(Context ctx, String filterSql, String nodeId) {
        try {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SCmpCalValidateResult where FCmpCalTableID in (" + filterSql + ") and FNodeID = ?"), (Object[])new Object[]{nodeId});
        }
        catch (BOSException e) {
            logger.error((Object)"delete validate result error", (Throwable)e);
        }
    }
}

