/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.formula.SalaryCalculator;
import com.kingdee.shr.compensation.app.formula.SalayCalculatorMgr;
import com.kingdee.shr.compensation.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;

public class SalaryCalculatorProxy
implements ISalaryCalculator {
    private boolean isSynchronous = true;
    SalaryCalculator calculator;

    public SalaryCalculatorProxy() {
        this.calculator = new SalaryCalculator();
    }

    public SalaryCalculatorProxy(String uid) throws EASBizException {
        this.calculator = SalayCalculatorMgr.findTask(uid);
        if (this.calculator == null) {
            throw new SalaryException(SalaryException.CALCOM);
        }
    }

    public SalaryCalculatorProxy(String uid, boolean isInitFirst) throws EASBizException {
        if (isInitFirst) {
            this.calculator = SalayCalculatorMgr.findTask(uid);
        }
        if (null == this.calculator) {
            throw new SalaryException(SalaryException.CALCOM);
        }
    }

    public String getCalMessage() {
        return this.calculator.getCalMessage();
    }

    public double getFinishedPer() {
        return this.calculator.getFinishedPer();
    }

    public int getStatus() {
        return this.calculator.getStatus();
    }

    public String getUID() {
        return this.calculator.getUID();
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    public boolean post() throws Exception {
        this.calculator.run();
        return true;
    }

    public void setCalFormulas(String calFormulas) {
        this.calculator.setCalFormulas(calFormulas);
    }

    public void setCalFromDate(String calFromDate) {
        this.calculator.setCalFromDate(calFromDate);
    }

    public void setCalMessage(String calMessage) {
        this.calculator.setCalMessage(calMessage);
    }

    public void setCalToDate(String calToDate) {
        this.calculator.setCalToDate(calToDate);
    }

    public void setCtx(Context ctx) {
        this.calculator.setCtx(ctx);
    }

    public void setMainTableName(String mainTableName) {
        this.calculator.setMainTableName(mainTableName);
    }

    public void setMainTableRowFilter(String condition) {
        this.calculator.setMainTableRowFilter(condition);
    }

    public void setMonth(String month) {
        this.calculator.setMonth(month);
    }

    public void setPrecision(int v) {
        this.calculator.setPrecision(v);
    }

    public void setSchemeID(String schemeID) {
        this.calculator.setSchemeID(schemeID);
    }

    public void setSynchronous(boolean isSynchronous) {
        this.isSynchronous = isSynchronous;
    }

    public void setTempTable(String tempTable) {
        this.calculator.setTempTable(tempTable);
    }

    public void setFilterSql(String filterSql) {
        this.calculator.setFilterSql(filterSql);
    }
}

