/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula;

import com.kingdee.shr.compensation.app.formula.SalaryCalculator;
import com.kingdee.shr.compensation.app.formula.TaskInfo;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class SalayCalculatorMgr
extends Thread {
    private static int taskCount = 0;
    public static int maxTasks = 1;
    public static int waitTime = 10;
    private static SalayCalculatorMgr instance = null;
    private static ArrayList<SalaryCalculator> taskList = new ArrayList();
    private static ArrayList<TaskInfo> taskInfo = new ArrayList();

    public static synchronized void addTask(SalaryCalculator calculator) {
        taskList.add(calculator);
    }

    public static synchronized SalaryCalculator findTask(String uid) {
        int index;
        if (uid == null || "".equals(uid)) {
            return null;
        }
        for (index = 0; index < taskList.size(); ++index) {
            SalaryCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            return calculator;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (task.getUid().equals(uid)) {
                String info = task.getInfo();
                if (StringUtils.isEmpty((String)info)) {
                    info = "Calculation completed";
                }
                taskInfo.remove(index);
                throw new RuntimeException(info);
            }
            if (System.currentTimeMillis() - task.getEndTime() <= 6000000L) continue;
            taskInfo.remove(index);
            --index;
        }
        return null;
    }

    public static synchronized SalaryCalculator getTask() {
        SalaryCalculator calculator = null;
        for (int index = 0; index < taskList.size(); ++index) {
            calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            calculator.setStatus(1);
            return calculator;
        }
        return null;
    }

    public static synchronized void removeTask(String uid, String cause) {
        int index;
        if (uid == null || "".equals(uid)) {
            return;
        }
        for (index = 0; index < taskList.size(); ++index) {
            ISalaryCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            taskList.remove(index);
            --taskCount;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (!task.getUid().equals(uid)) continue;
            task.setEndTime(System.currentTimeMillis());
            task.setInfo(cause);
            return;
        }
    }

    private boolean haveNewTask() {
        ISalaryCalculator calculator = null;
        for (int index = 0; index < taskList.size(); ++index) {
            calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (true) {
            System.out.println("==========taskCount is " + taskCount + "===========");
            while (taskCount >= maxTasks || !this.haveNewTask()) {
                try {
                    SalayCalculatorMgr.sleep(waitTime * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                SalaryCalculator calculator = SalayCalculatorMgr.getTask();
                if (calculator == null) continue;
                ++taskCount;
                taskInfo.add(new TaskInfo(calculator.getUID()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void wakeup() {
        this.notifyAll();
    }
}

