/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.data;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.formula.data.ColumnAttributes;
import com.kingdee.shr.compensation.app.formula.data.DataColumn;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataSetGenerator;
import com.kingdee.shr.compensation.exception.DataSetException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTable
extends DataColumn {
    public List<DataRow> datas = null;
    public Map<String, Integer> datasIndexMap = null;
    public ArrayList<Object> emptyrow = null;
    public String tablename = "DefaultTN";

    public void addRow(DataRow row, String key) {
        if (this.datas == null) {
            this.datas = new ArrayList<DataRow>();
            this.datasIndexMap = new HashMap<String, Integer>();
        }
        this.datas.add(row);
        if (!StringUtils.isEmpty((String)key)) {
            this.datasIndexMap.put(key, this.datas.size() - 1);
        }
    }

    public DataTable Clone() {
        DataTable dt = new DataTable();
        try {
            for (int i = 0; i < this.columnCount(); ++i) {
                dt.addColumn(dt.newColumn(this.getColumns(i).getName(), this.getColumns(i).getType(), this.getColumns(i).getDefaultValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dt;
    }

    @Override
    public void deleteColumn(int index) throws EASBizException {
        if (!this.testArray(this.columns, index)) {
            throw new DataSetException(DataSetException.INDEXOUTOF);
        }
        if (this.emptyrow != null) {
            this.emptyrow.remove(index);
        }
        if (this.rowCount() > 0) {
            for (int i = 0; i < this.datas.size(); ++i) {
                this.datas.get(i).remove(index);
            }
        }
        super.deleteColumn(index);
    }

    @Override
    protected void deleteColumn(String name) throws EASBizException {
        int index = this.getColumnsIndex(name);
        this.deleteColumn(index);
    }

    public void deleteRows(int index) {
        this.datas.remove(index);
    }

    public DataRow[] getAllRows() {
        if (this.datas == null) {
            return null;
        }
        int rowCounter = this.datas.size();
        DataRow[] rows = new DataRow[rowCounter];
        for (int i = 0; i < rowCounter; ++i) {
            rows[i] = new DataRow();
            rows[i].columns = this.columns;
            rows[i] = this.datas.get(i);
        }
        return rows;
    }

    public DataRow getDataRow(String id) throws EASBizException {
        int index;
        if (this.datas == null || this.datas.size() == 0) {
            return null;
        }
        int rowCounter = this.datas.size();
        if (null != this.datasIndexMap && this.datasIndexMap.containsKey(id) && (index = this.datasIndexMap.get(id).intValue()) >= 0 && index < rowCounter) {
            return this.datas.get(index);
        }
        index = this.getColumnsIndex("fid");
        for (int i = 0; i < rowCounter; ++i) {
            DataRow dataRow = this.datas.get(i);
            List<Object> rows = dataRow.getDatarow();
            if (!id.equals(rows.get(index))) continue;
            dataRow.columns = this.columns;
            return dataRow;
        }
        return null;
    }

    public DataRow getRows(int index) {
        DataRow row = new DataRow();
        row.columns = this.columns;
        row = this.datas.get(index);
        return row;
    }

    @Override
    public ColumnAttributes newColumn(String name, int type, Object defaultvalue) {
        return super.newColumn(name, type, defaultvalue);
    }

    public DataRow newRow() throws EASBizException {
        if (this.columns == null || this.columns.size() == 0) {
            throw new DataSetException(DataSetException.NULLLISTMSG);
        }
        DataRow row = new DataRow();
        row.columns = this.columns;
        if (this.emptyrow == null) {
            try {
                this.emptyrow = DataSetGenerator.generateEmptyRow(this.columns);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        row.datarow = (ArrayList)this.emptyrow.clone();
        return row;
    }

    public int rowCount() {
        if (this.datas == null) {
            return 0;
        }
        return this.datas.size();
    }

    public void setTableName(String tablename) {
        this.tablename = tablename;
    }

    public String TableName() {
        return this.tablename;
    }

    class OrderInfo {
        public String name = "";
        public boolean isASC = true;

        OrderInfo() {
        }
    }
}

