/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.app.formula.data.DAFactory;
import com.kingdee.shr.compensation.app.formula.data.DataAccess;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.app.formula.data.ISQLGenStrategy;
import com.kingdee.shr.compensation.app.formula.data.SQLFieldInfo;
import com.kingdee.shr.compensation.app.formula.data.SQLJoinTable;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.formula.data.perfectSQLGenStrategy;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SQLGenerate {
    public String otherJoinTables = "HR_LABORRELATION";
    public String defaultJoinType = "left";
    public String pointTimeTypeTables = "";
    public String periodTimeTypeTables = "";
    public String noTimeTypeTables = "";
    public String refRelationId = "";
    public String userId = "";
    public boolean isDistinct = false;
    public String fromTime = "";
    public String toTime = "";
    public String defaultTimeType = "point";
    public boolean isListGridField = false;
    public boolean isShowCodeText = true;
    public String appendJoinTableFilter = "";
    public ArrayList joinTableList = null;
    public ISQLGenStrategy sqlGenStrategy = new perfectSQLGenStrategy();
    private ArrayList fieldInfoArr = null;
    private int codeTableCount = 0;
    static Logger logger = Logger.getLogger(SQLGenerate.class);

    public static String deleteChildSQL(String sqlstr) {
        Pattern pattern = null;
        Matcher m = null;
        String tmpstr = sqlstr;
        String childSql = "\\((\\s)*SELECT(\\s)+";
        pattern = Pattern.compile(childSql, 2);
        m = pattern.matcher(tmpstr);
        String pstr = " ";
        boolean isSingleField = false;
        int start = 0;
        int findstart = 0;
        boolean findend = false;
        int leftG = 0;
        int rightG = 0;
        while (m.find(start)) {
            findstart = m.start();
            pstr = tmpstr.substring(findstart + 1, tmpstr.length());
            leftG = 0;
            rightG = 0;
            while (pstr.indexOf("(") > -1 || pstr.indexOf(")") > -1) {
                if (pstr.indexOf(")") > -1 && pstr.indexOf("(") > -1 && pstr.indexOf(")") < pstr.indexOf("(")) {
                    ++rightG;
                    pstr = pstr.substring(pstr.indexOf(")") + 1, pstr.length());
                } else if (pstr.indexOf(")") > -1 && pstr.indexOf("(") > -1 && pstr.indexOf(")") > pstr.indexOf("(")) {
                    ++leftG;
                    pstr = pstr.substring(pstr.indexOf("(") + 1, pstr.length());
                } else if (pstr.indexOf(")") > -1 && pstr.indexOf("(") == -1) {
                    ++rightG;
                    pstr = pstr.substring(pstr.indexOf(")") + 1, pstr.length());
                } else if (pstr.indexOf("(") > -1 && pstr.indexOf(")") == -1) {
                    ++leftG;
                    pstr = pstr.substring(pstr.indexOf("(") + 1, pstr.length());
                }
                if (rightG <= leftG) continue;
            }
            tmpstr = tmpstr.substring(0, findstart + 1) + tmpstr.substring(tmpstr.length() - pstr.length(), tmpstr.length());
            pattern = Pattern.compile(childSql, 2);
            m = pattern.matcher(tmpstr);
        }
        return tmpstr;
    }

    public static void delRepeatRelation(DataTable dt, int step, String relationIdStr) throws EASBizException {
        DataRow dr = null;
        String preRelationId = "";
        String aftRelationId = "";
        int prePlace = 0;
        int aftPlace = 0;
        if (dt.rowCount() > 1) {
            dr = dt.getRows(0);
            for (int m = 0; m < dt.rowCount(); ++m) {
                if (dr == dt.getRows(m)) continue;
                for (int i = 1; i <= step; ++i) {
                    preRelationId = dr.getString("a" + i + "relationid");
                    aftRelationId = dt.getRows(m).getString("a" + i + "relationid");
                    prePlace = relationIdStr.indexOf("," + preRelationId + ",");
                    if (prePlace < (aftPlace = relationIdStr.indexOf("," + aftRelationId + ",")) && prePlace >= 0 && aftPlace >= 0) {
                        dt.deleteRows(m);
                        --m;
                        continue;
                    }
                    if (prePlace > aftPlace && prePlace >= 0 && aftPlace >= 0) {
                        dt.deleteRows(0);
                        dr = dt.getRows(--m);
                        continue;
                    }
                    if (prePlace > aftPlace && prePlace >= 0 && aftPlace < 0) {
                        dt.deleteRows(m);
                        --m;
                        continue;
                    }
                    if (prePlace >= aftPlace || prePlace >= 0 || aftPlace < 0) continue;
                    dt.deleteRows(0);
                    dr = dt.getRows(--m);
                }
            }
        }
        if (dt.rowCount() > 1) {
            dr = dt.getRows(0);
            String preFKTable = "";
            String aftFKTable = "";
            for (int m = 0; m < dt.rowCount(); ++m) {
                if (dr == dt.getRows(m)) continue;
                for (int i = 1; i <= step; ++i) {
                    preFKTable = dr.getString("a" + i + "fktable");
                    if (preFKTable.equals(aftFKTable = dt.getRows(m).getString("a" + i + "fktable"))) continue;
                    dt.deleteRows(m);
                    --m;
                }
            }
        }
    }

    public static String getFieldListCommaPlace(String str) {
        String tempField = SQLGenerate.replaceTextContent(str, "'");
        String tempstr = "0";
        String commaPlace = "";
        int left = 0;
        int right = 0;
        while (tempField.indexOf(",") > -1) {
            if (tempField.indexOf("(") > -1 && tempField.indexOf(")") > -1 && tempField.indexOf("(") > tempField.indexOf(")")) {
                tempstr = tempstr + tempField.substring(0, tempField.indexOf(")") + 1);
                tempField = tempField.substring(tempField.indexOf(")") + 1, tempField.length());
                ++right;
                continue;
            }
            if (tempField.indexOf("(") < tempField.indexOf(",") && tempField.indexOf("(") > -1) {
                tempstr = tempstr + tempField.substring(0, tempField.indexOf("(") + 1);
                tempField = tempField.substring(tempField.indexOf("(") + 1, tempField.length());
                ++left;
                continue;
            }
            if (tempField.indexOf(")") < tempField.indexOf(",") && tempField.indexOf(")") > -1) {
                tempstr = tempstr + tempField.substring(0, tempField.indexOf(")") + 1);
                tempField = tempField.substring(tempField.indexOf(")") + 1, tempField.length());
                ++right;
                continue;
            }
            if (tempField.indexOf("(") > tempField.indexOf(",") && tempField.indexOf(")") > tempField.indexOf(",")) {
                if (left == right) {
                    tempstr = tempstr + tempField.substring(0, tempField.indexOf(",") + 1);
                    commaPlace = commaPlace.equals("") ? "" + (tempstr.length() - 1) : commaPlace + "," + (tempstr.length() - 1);
                    tempField = tempField.substring(tempField.indexOf(",") + 1, tempField.length());
                    continue;
                }
                if (tempField.indexOf("(") < tempField.indexOf(")")) {
                    tempstr = tempstr + tempField.substring(0, tempField.indexOf("(") + 1);
                    tempField = tempField.substring(tempField.indexOf("(") + 1, tempField.length());
                    ++left;
                    continue;
                }
                tempstr = tempstr + tempField.substring(0, tempField.indexOf(")") + 1);
                tempField = tempField.substring(tempField.indexOf(")") + 1, tempField.length());
                ++right;
                continue;
            }
            if (left == right) {
                tempstr = tempstr + tempField.substring(0, tempField.indexOf(",") + 1);
                commaPlace = commaPlace.equals("") ? "" + (tempstr.length() - 1) : commaPlace + "," + (tempstr.length() - 1);
                tempField = tempField.substring(tempField.indexOf(",") + 1, tempField.length());
                continue;
            }
            tempstr = tempstr + tempField.substring(0, tempField.indexOf(",") + 1);
            tempField = tempField.substring(tempField.indexOf(",") + 1, tempField.length());
        }
        tempstr = tempstr + tempField;
        return commaPlace;
    }

    public static SQLJoinTable getJoinTableFromList(ArrayList joinTableList, String tableName) {
        int joinTableCount = joinTableList.size();
        SQLJoinTable joinTable = null;
        for (int i = 0; i < joinTableCount; ++i) {
            joinTable = (SQLJoinTable)joinTableList.get(i);
            if (!joinTable.tableName.equals(tableName)) continue;
            return joinTable;
        }
        return null;
    }

    public static String getRelationIdSQL(String preTables, String joinedTables, int step, String filter, String relationIds) {
        String fieldStr = "";
        String joinStr = "";
        String orderbyStr = "";
        String whereStr = "(1=1)";
        for (int i = 1; i <= step; ++i) {
            fieldStr = fieldStr.equals("") ? "a" + i + ".pktable as a" + i + "pktable,a" + i + ".fktable as a" + i + "fktable,a" + i + ".relationid as a" + i + "relationid,a" + i + ".pkfield as a" + i + "pkfield,a" + i + ".fkfield as a" + i + "fkfield" : fieldStr + ",a" + i + ".pktable as a" + i + "pktable,a" + i + ".fktable as a" + i + "fktable,a" + i + ".relationid as a" + i + "relationid,a" + i + ".pkfield as a" + i + "pkfield,a" + i + ".fkfield as a" + i + "fkfield";
            if (joinStr.equals("")) {
                joinStr = " from V_MIS_TABLERELATION a1 ";
            } else {
                joinStr = joinStr + " inner join V_MIS_TABLERELATION a" + i + " on a" + (i - 1) + ".fktable=a" + i + ".pktable and a1.pktable!=a" + i + ".fktable ";
                for (int m = 1; m < i; ++m) {
                    joinStr = joinStr + " and a" + m + ".fktable!=a" + i + ".fktable ";
                }
            }
            orderbyStr = orderbyStr.equals("") ? " order by a" + i + ".relationid ,a" + i + ".fktable" : orderbyStr + ",a" + i + ".relationid ,a" + i + ".fktable";
        }
        relationIds = "'" + relationIds.replaceAll(",", "','") + "'";
        String sql = "select distinct " + fieldStr + joinStr + " where ((a1.relationid in (" + relationIds + ") and a1.pktable in (" + preTables + ")) or (a1.pktable in (" + preTables + ") and not exists (select 1 from mis_tablerelation t where t.relationid in (" + relationIds + ") and t.pktable=a1.pktable))) and " + whereStr + " and ((a" + step + ".relationid in (" + relationIds + ") and a" + step + ".fktable in (" + joinedTables + ")) or (a" + step + ".fktable in (" + joinedTables + ") and not exists (select 1 from mis_tablerelation t where t.relationid in (" + relationIds + ") and t.fktable=a" + step + ".fktable))) " + (filter.equals("") ? "" : " and (" + filter + ") ") + orderbyStr + " asc ";
        return sql;
    }

    public static String getTableFromJoinTableList(ArrayList joinTableList, boolean isJoined) {
        int joinTableCount = joinTableList.size();
        SQLJoinTable joinTable = null;
        String tmpstr = "";
        for (int i = 0; i < joinTableCount; ++i) {
            joinTable = (SQLJoinTable)joinTableList.get(i);
            if (joinTable.isJoined != isJoined) continue;
            tmpstr = tmpstr.equals("") ? "'" + joinTable.tableName + "'" : tmpstr + ",'" + joinTable.tableName + "'";
        }
        return tmpstr;
    }

    public static boolean isExistNotJoinTable(ArrayList joinTableList) {
        int joinTableCount = joinTableList.size();
        SQLJoinTable joinTable = null;
        for (int i = 0; i < joinTableCount; ++i) {
            joinTable = (SQLJoinTable)joinTableList.get(i);
            if (joinTable.isJoined) continue;
            return true;
        }
        return false;
    }

    public static String replaceTextContent(String str, String comma) {
        String p = comma + "[^" + comma + "]*" + comma;
        Pattern pattern = Pattern.compile(p, 2);
        Matcher m = pattern.matcher(str);
        String reStr = "";
        int start = 0;
        int preend = 0;
        int findstart = 0;
        int findend = 0;
        while (m.find(start)) {
            findstart = m.start();
            if (findstart + 1 < (findend = m.end())) {
                reStr = reStr + str.substring(preend, findstart + 1);
                for (int i = findstart + 1; i < findend - 1; ++i) {
                    reStr = reStr + "#";
                }
            } else {
                reStr = reStr + str.substring(preend, findend);
            }
            preend = findend - 1;
            start = findend;
        }
        if (findstart == 0 && findend == 0) {
            return str;
        }
        reStr = reStr + str.substring(preend, str.length());
        return reStr;
    }

    public static void setJoinTableList(ArrayList al, String tableName) {
        SQLJoinTable joinTable = null;
        tableName = tableName.trim().toUpperCase(Locale.ENGLISH);
        boolean flag = false;
        for (int i = 0; i < al.size(); ++i) {
            joinTable = (SQLJoinTable)al.get(i);
            if (!joinTable.tableName.equals(tableName.toUpperCase(Locale.ENGLISH))) continue;
            flag = true;
            break;
        }
        if (!flag) {
            joinTable = new SQLJoinTable();
            joinTable.fromTime = "";
            joinTable.toTime = "";
            joinTable.tableName = tableName.toUpperCase(Locale.ENGLISH);
            joinTable.mainField = "";
            al.add(joinTable);
        }
    }

    private String assembleCodeTable(String concernDate) {
        String joinsql = "";
        if (!this.isListGridField && !this.isShowCodeText) {
            return joinsql;
        }
        SQLFieldInfo fieldInfo = null;
        for (int i = 0; i < this.fieldInfoArr.size(); ++i) {
            fieldInfo = (SQLFieldInfo)this.fieldInfoArr.get(i);
            if (!fieldInfo.fieldType.equals("0") || joinsql.indexOf(fieldInfo.joinTable + " " + fieldInfo.joinTableAlias + " ON ") >= 0) continue;
            joinsql = joinsql + " LEFT JOIN " + fieldInfo.joinTable + " " + fieldInfo.joinTableAlias + " ON " + fieldInfo.joinTableAlias + "." + fieldInfo.joinField + "=" + fieldInfo.tableName + "." + fieldInfo.fieldItem;
            if (fieldInfo.joinFromTime.equals("") || fieldInfo.joinToTime.equals("")) continue;
            joinsql = !fieldInfo.fromTime.equals("") && !fieldInfo.toTime.equals("") ? joinsql + " AND " + fieldInfo.joinTableAlias + "." + fieldInfo.joinFromTime + "<=" + fieldInfo.tableName + "." + fieldInfo.toTime + " AND " + fieldInfo.joinTableAlias + "." + fieldInfo.joinToTime + ">=" + fieldInfo.tableName + "." + fieldInfo.toTime : joinsql + " AND " + fieldInfo.joinTableAlias + "." + fieldInfo.joinFromTime + "<=TO_DATE('" + concernDate + "','YYYY-MM-DD')  AND " + fieldInfo.joinTableAlias + "." + fieldInfo.joinToTime + ">=TO_DATE('" + concernDate + "','YYYY-MM-DD')";
        }
        return joinsql;
    }

    private String assembleFields() {
        SQLFieldInfo fieldInfo = null;
        String fields = "";
        for (int i = 0; i < this.fieldInfoArr.size(); ++i) {
            if (i > 0) {
                fields = fields + ",";
            }
            fieldInfo = (SQLFieldInfo)this.fieldInfoArr.get(i);
            if (fieldInfo.fieldType.equals("0")) {
                if (!this.isShowCodeText) {
                    fields = fields + fieldInfo.fieldStr;
                    continue;
                }
                fields = fields + fieldInfo.fieldCodeStr + " " + fieldInfo.fieldAlias;
                continue;
            }
            fields = fields + fieldInfo.fieldStr;
        }
        return fields;
    }

    private String assembleListGridFields() {
        SQLFieldInfo fieldInfo = null;
        String fields = "";
        for (int i = 0; i < this.fieldInfoArr.size(); ++i) {
            if (i > 0) {
                fields = fields + ", ";
            }
            fieldInfo = (SQLFieldInfo)this.fieldInfoArr.get(i);
            fields = fieldInfo.fieldType.equals("0") ? fields + fieldInfo.tableName + "." + fieldInfo.fieldItem + " AS \"" + fieldInfo.tableName + "." + fieldInfo.fieldItem + "\", " + fieldInfo.joinTableAlias + "." + fieldInfo.joinFieldText + " AS \"" + fieldInfo.tableName + "." + fieldInfo.fieldItem + "TEXT\"" : (fieldInfo.tableName.equals("") ? fields + fieldInfo.fieldStr : fields + fieldInfo.tableName + "." + fieldInfo.fieldItem + " AS \"" + fieldInfo.tableName + "." + fieldInfo.fieldItem + "\"");
        }
        return fields;
    }

    private String assembleSQL(String whereStr, String concernDate) {
        int start;
        String notNormalWhere;
        Pattern pattern;
        Matcher m;
        String sql = "";
        String joinStr = this.assembleTableJoin(concernDate, "");
        if ((joinStr = joinStr + " " + this.assembleCodeTable(concernDate)).indexOf("LEFT JOIN T_BD_PERSON ON null") > -1) {
            joinStr = joinStr.replaceAll("LEFT JOIN T_BD_PERSON ON null", " from t_hr_scmpcaltable inner join T_BD_PERSON on T_BD_PERSON.fid = T_HR_SCMPCALTABLE.fpersonid");
        }
        sql = this.isDistinct ? "SELECT DISTINCT " : "SELECT ";
        sql = !this.isListGridField ? sql + this.assembleFields() : sql + this.assembleListGridFields();
        sql = whereStr.equals("") ? sql + joinStr : ((m = (pattern = Pattern.compile(notNormalWhere = "(((\\s)*ORDER(\\s)+BY(\\s)+)|((\\s)*GROUP(\\s)+BY(\\s)+))", 2)).matcher(whereStr)).find(start = 0) ? (m.start() == 0 ? sql + joinStr + " WHERE 1=1 " + whereStr : sql + joinStr + " WHERE 1=1 AND " + whereStr) : sql + joinStr + " WHERE 1=1 AND " + whereStr);
        return sql;
    }

    public String assembleTableJoin(String concernDate, String relDateField) {
        String[] joinTableArr = new String[this.joinTableList.size()];
        SQLJoinTable joinTable = null;
        String tmpStr = "";
        boolean flag = false;
        String[] otherJoinTableArr = this.otherJoinTables.split(",");
        String[] noTimeTypeTableArr = this.noTimeTypeTables.split(",");
        String[] periodTimeTypeTableArr = this.periodTimeTypeTables.split(",");
        String[] pointTimeTypeTableArr = this.pointTimeTypeTables.split(",");
        String[] ssJoinOnFilter = this.appendJoinTableFilter.split("\\[####\\]");
        String joinTimeType = "2";
        for (int i = 0; i < this.joinTableList.size(); ++i) {
            int j;
            joinTable = (SQLJoinTable)this.joinTableList.get(i);
            if (i == 0) {
                joinTableArr[i] = " FROM " + joinTable.tableName;
                continue;
            }
            flag = false;
            for (j = 0; j < otherJoinTableArr.length; ++j) {
                if (!otherJoinTableArr[j].equals(joinTable.tableName)) continue;
                flag = true;
                break;
            }
            if (flag && this.defaultJoinType.toUpperCase(Locale.ENGLISH).equals("LEFT")) {
                joinTableArr[joinTable.seq] = " INNER JOIN " + joinTable.tableName + " ON " + joinTable.jionStr;
            } else if (!flag && this.defaultJoinType.toUpperCase(Locale.ENGLISH).equals("LEFT")) {
                joinTableArr[joinTable.seq] = " LEFT JOIN " + joinTable.tableName + " ON " + joinTable.jionStr;
            }
            if (flag && this.defaultJoinType.toUpperCase(Locale.ENGLISH).equals("INNER")) {
                joinTableArr[joinTable.seq] = " LEFT JOIN " + joinTable.tableName + " ON " + joinTable.jionStr;
            } else if (!flag && this.defaultJoinType.toUpperCase(Locale.ENGLISH).equals("INNER")) {
                joinTableArr[joinTable.seq] = " INNER JOIN " + joinTable.tableName + " ON " + joinTable.jionStr;
            }
            for (int m = 0; m < ssJoinOnFilter.length; ++m) {
                String[] ss;
                if (ssJoinOnFilter[m].equals("") || (ss = ssJoinOnFilter[m].split("\\[@@@@\\]"))[0].trim().equals("") || ss[1].trim().equals("") || !ss[0].trim().equalsIgnoreCase(joinTable.tableName)) continue;
                joinTableArr[joinTable.seq] = joinTableArr[joinTable.seq] + " AND " + ss[1].trim();
                break;
            }
            flag = false;
            for (j = 0; j < noTimeTypeTableArr.length; ++j) {
                if (!noTimeTypeTableArr[j].equals(joinTable.tableName)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            if (!flag) {
                for (j = 0; j < periodTimeTypeTableArr.length; ++j) {
                    if (!periodTimeTypeTableArr[j].equals(joinTable.tableName)) continue;
                    flag = true;
                    break;
                }
                if (flag && !joinTable.fromTime.equals("") && !joinTable.toTime.equals("")) {
                    joinTableArr[joinTable.seq] = joinTableArr[joinTable.seq] + " AND " + joinTable.tableName + "." + joinTable.fromTime + " <= TO_DATE('" + this.toTime + "','YYYY-MM-DD') AND " + joinTable.tableName + "." + joinTable.toTime + " >= TO_DATE('" + this.fromTime + "','YYYY-MM-DD')";
                    continue;
                }
            }
            flag = false;
            for (j = 0; j < pointTimeTypeTableArr.length; ++j) {
                if (pointTimeTypeTableArr[j].equals(joinTable.tableName)) {
                    flag = true;
                    joinTimeType = "2";
                    break;
                }
                if (pointTimeTypeTableArr[j].equals(joinTable.tableName + ":1")) {
                    flag = true;
                    joinTimeType = "1";
                    break;
                }
                if (!pointTimeTypeTableArr[j].equals(joinTable.tableName + ":2")) continue;
                flag = true;
                joinTimeType = "2";
                break;
            }
            if (flag) {
                if (joinTable.fromTime.equals("") || joinTable.toTime.equals("")) continue;
                joinTableArr[joinTable.seq] = joinTableArr[joinTable.seq] + " AND " + joinTable.tableName + "." + joinTable.fromTime + " <= TO_DATE('" + (joinTimeType.equals("1") ? this.fromTime : this.toTime) + "','YYYY-MM-DD') AND " + joinTable.tableName + "." + joinTable.toTime + " >= TO_DATE('" + (joinTimeType.equals("1") ? this.fromTime : this.toTime) + "','YYYY-MM-DD')";
                continue;
            }
            if (this.defaultTimeType.toLowerCase(Locale.ENGLISH).equals("point")) {
                if (joinTable.fromTime.equals("") || joinTable.toTime.equals("")) continue;
                if (relDateField.equals("")) {
                    joinTableArr[joinTable.seq] = joinTableArr[joinTable.seq] + " AND " + joinTable.tableName + "." + joinTable.fromTime + " <= TO_DATE('" + concernDate + "','YYYY-MM-DD') AND " + joinTable.tableName + "." + joinTable.toTime + " >= TO_DATE('" + concernDate + "','YYYY-MM-DD')";
                    continue;
                }
                joinTableArr[joinTable.seq] = joinTableArr[joinTable.seq] + " AND " + joinTable.tableName + "." + joinTable.fromTime + " <= " + relDateField + " AND " + joinTable.tableName + "." + joinTable.toTime + " >= " + relDateField;
                continue;
            }
            if (this.defaultTimeType.toLowerCase(Locale.ENGLISH).equals("period")) {
                if (joinTable.fromTime.equals("") || joinTable.toTime.equals("")) continue;
                joinTableArr[joinTable.seq] = joinTableArr[joinTable.seq] + " AND " + joinTable.tableName + "." + joinTable.fromTime + " <= TO_DATE('" + this.toTime + "','YYYY-MM-DD') AND " + joinTable.tableName + "." + joinTable.toTime + " >= TO_DATE('" + this.fromTime + "','YYYY-MM-DD')";
                continue;
            }
            if (!this.defaultTimeType.toLowerCase(Locale.ENGLISH).equals("notime")) continue;
        }
        String joinsql = "";
        for (int i = 0; i < joinTableArr.length; ++i) {
            joinsql = joinsql.equals("") ? joinTableArr[i] : joinsql + joinTableArr[i];
        }
        return joinsql;
    }

    public String changeListGridFiedFormat(String fields) {
        String str = "";
        String[] arr = fields.split("@@@@");
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].equals("")) continue;
            str = str.equals("") ? arr[i] : str + "," + arr[i];
        }
        return str;
    }

    public String combineInfosetSql(String mainTable, String tableName, String fieldStr, String whereStr, String constructNum) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select structure.EntityName,structure.parent.*,structure.parent.parent.*, ");
        oql.append("structure.parent.parent.parent.*,structure.parent.parent.parent.parent.*, ");
        oql.append("structure.parent.parent.parent.parent.parent.*,structure.filterColumn.*, ");
        oql.append("structure.parent.parent.parent.parent.parent.parent.*, ");
        oql.append("structure.parent.parent.parent.parent.parent.parent.parent.*, ");
        oql.append(" structure.filterColumn.*");
        oql.append(" where tableName = '");
        oql.append(tableName);
        oql.append("'");
        if (null != constructNum && !"".equals(constructNum)) {
            oql.append(" and structure.clientNumber = '");
            oql.append(constructNum);
            oql.append("'");
        }
        CmpQueryConfigCollection configs = CmpQueryConfigFactory.getLocalInstance(Tools.getInstance().getCtx()).getCmpQueryConfigCollection(oql.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldStr + " from " + mainTable);
        StructureConfigInfo structure = configs != null && configs.size() > 0 && configs.get(0) != null && configs.get(0).getStructure() != null ? configs.get(0).getStructure() : null;
        this.combineRecurseSql(mainTable, structure, sql);
        sql.append(" where " + whereStr);
        return sql.toString();
    }

    public String convertToHisMode(String infoSql, String endDate) {
        StringBuffer originalSqlBuf = new StringBuffer();
        if (infoSql.toUpperCase(Locale.ENGLISH).contains("T_ORG_ADMIN")) {
            originalSqlBuf.setLength(0);
            originalSqlBuf.append("(select his.* from T_ORG_AdminHIS as his ");
            originalSqlBuf.append("inner join (");
            originalSqlBuf.append("select max(FEffdt) as FEffdt,FhistoryRelateID from T_ORG_AdminHIS ");
            originalSqlBuf.append(" where FEffdt <= {ts '");
            originalSqlBuf.append(endDate);
            originalSqlBuf.append("'} ");
            originalSqlBuf.append("group by FhistoryRelateID) as maxHis");
            originalSqlBuf.append(" on his.FhistoryRelateID = maxHis.FhistoryRelateID and his.FEffdt = maxHis.FEffdt ");
            originalSqlBuf.append(") as admin_his");
            infoSql = infoSql.replaceFirst("(?i)LEFT\\s*JOIN\\s*T_ORG_ADMIN", "LEFT JOIN " + originalSqlBuf.toString());
            infoSql = infoSql.replaceFirst("(?i)LEFT\\s*JOIN\\s*T_ORG_ADMIN", "LEFT JOIN " + originalSqlBuf.toString() + "_other");
            String otherStr = "LEFT JOIN " + originalSqlBuf.toString() + "_other";
            if (infoSql.contains(otherStr)) {
                int indexStart = infoSql.indexOf(otherStr);
                if (indexStart > -1) {
                    String subStr = infoSql.substring(indexStart += otherStr.length(), infoSql.length());
                    subStr = subStr.replaceFirst("(?i)T_ORG_ADMIN\\.", "admin_his_other.");
                    infoSql = infoSql.substring(0, indexStart) + subStr;
                }
                infoSql = infoSql.replaceFirst("(?i)T_ORG_ADMIN\\.", "admin_his_other.");
            }
            infoSql = infoSql.replaceAll("(?i)T_ORG_ADMIN\\.", "admin_his.");
            infoSql = infoSql.replaceAll("(?i)admin_his\\.FID", "admin_his.fhistoryrelateid");
            infoSql = infoSql.replaceAll("(?i)admin_his_other\\.FID", "admin_his_other.fhistoryrelateid");
        }
        if (infoSql.toUpperCase(Locale.ENGLISH).contains("T_HR_PERSONPOSITION")) {
            originalSqlBuf.setLength(0);
            originalSqlBuf.append("(select his.* from T_HR_PersonPositionHis as his ");
            originalSqlBuf.append("inner join (");
            originalSqlBuf.append("select max(T_HR_PersonPositionHis.FStartDateTime) as FStartDateTime,T_HR_PersonPositionHis.FPersonId from T_HR_PersonPositionHis ");
            originalSqlBuf.append(" where T_HR_PersonPositionHis.FStartDateTime <= {ts '");
            originalSqlBuf.append(endDate);
            originalSqlBuf.append("'}");
            originalSqlBuf.append("group by FPersonId) as maxHis");
            originalSqlBuf.append(" on his.FPersonId = maxHis.FPersonId and his.FStartDateTime = maxHis.FStartDateTime ");
            originalSqlBuf.append(") as pp_his");
            infoSql = infoSql.replaceAll("(?i)LEFT\\s*JOIN\\s*T_HR_PERSONPOSITION", "LEFT JOIN " + originalSqlBuf.toString());
            infoSql = infoSql.replaceAll("(?i)T_HR_PERSONPOSITION\\.", "pp_his.");
            infoSql = infoSql.replaceAll("(?i)pp_his\\.FID", "pp_his.fhistoryrelateid");
        }
        if (infoSql.toUpperCase(Locale.ENGLISH).contains("T_BD_PERSON")) {
            originalSqlBuf.setLength(0);
            originalSqlBuf.append("(select his.* from T_BD_PersonHis as his ");
            originalSqlBuf.append("inner join (");
            originalSqlBuf.append("select max(T_BD_PersonHis.FEffdt) as FEffdt,T_BD_PersonHis.FhistoryRelateID from T_BD_PersonHis ");
            originalSqlBuf.append(" where T_BD_PersonHis.FEffdt <= {ts '");
            originalSqlBuf.append(endDate);
            originalSqlBuf.append("'} group by FhistoryRelateID) as maxHis");
            originalSqlBuf.append(" on his.FhistoryRelateID = maxHis.FhistoryRelateID and his.FEffdt = maxHis.FEffdt ");
            originalSqlBuf.append(") as person_his");
            infoSql = infoSql.replaceAll("(?i)LEFT\\s*JOIN\\s*T_BD_PERSON", "LEFT JOIN " + originalSqlBuf.toString());
            infoSql = infoSql.replaceAll("(?i)T_BD_PERSON\\.", "person_his.");
            infoSql = infoSql.replaceAll("(?i)person_his\\.FID ", "person_his.fhistoryrelateid ");
        }
        if (infoSql.toUpperCase(Locale.ENGLISH).contains("T_ORG_POSITION")) {
            originalSqlBuf.setLength(0);
            originalSqlBuf.append("(select his.* from T_ORG_PositionHIS as his ");
            originalSqlBuf.append("inner join (");
            originalSqlBuf.append("select max(FEffdt) as FEffdt,FhistoryRelateID from T_ORG_PositionHIS ");
            originalSqlBuf.append(" where FEffdt <= {ts '");
            originalSqlBuf.append(endDate);
            originalSqlBuf.append("'}");
            originalSqlBuf.append("group by FhistoryRelateID) as maxHis");
            originalSqlBuf.append(" on his.FhistoryRelateID = maxHis.FhistoryRelateID and his.FEffdt = maxHis.FEffdt ");
            originalSqlBuf.append(") as position_his");
            infoSql = infoSql.replaceAll("(?i)LEFT\\s*JOIN\\s*T_ORG_POSITION", "LEFT JOIN " + originalSqlBuf.toString());
            infoSql = infoSql.replaceAll("(?i)T_ORG_POSITION\\.", "position_his.");
            infoSql = infoSql.replaceAll("(?i)position_his\\.FID", "position_his.fhistoryrelateid");
        }
        if (infoSql.toUpperCase(Locale.ENGLISH).contains("T_HR_EMPORGRELATION")) {
            originalSqlBuf.setLength(0);
            originalSqlBuf.append("(select his.* from T_HR_EmpOrgRelation as his ");
            originalSqlBuf.append("inner join (");
            originalSqlBuf.append("select max(FEffdt) as FEffdt,fpersonid from T_HR_EmpOrgRelation ");
            originalSqlBuf.append(" where FEffdt <= {ts '");
            originalSqlBuf.append(endDate);
            originalSqlBuf.append("'}");
            originalSqlBuf.append(" and fassignType=1 ");
            originalSqlBuf.append("group by fpersonid) as maxHis");
            originalSqlBuf.append(" on his.Fpersonid = maxHis.Fpersonid and his.feffdt = maxHis.feffdt");
            originalSqlBuf.append(") as empOrgRelation_his");
            infoSql = infoSql.replaceAll("(?i)LEFT\\s*JOIN\\s*T_HR_EMPORGRELATION", "LEFT JOIN " + originalSqlBuf.toString());
            infoSql = infoSql.replaceAll("(?i)T_HR_EMPORGRELATION\\.", "empOrgRelation_his.");
        }
        return infoSql;
    }

    private void combineRecurseSql(String mainTable, StructureConfigInfo config, StringBuffer sql) throws BOSException {
        if (config == null) {
            return;
        }
        if (config.getParent() != null) {
            this.combineRecurseSql(mainTable, config.getParent(), sql);
        }
        String oql = "where parent1.id = '" + config.getId().toString() + "'";
        StructureConfigFilterColumnCollection filters = StructureConfigFilterColumnFactory.getLocalInstance((Context)Tools.getInstance().getCtx()).getStructureConfigFilterColumnCollection(oql);
        String entityName = null;
        String parentEntityName = null;
        String tableName = null;
        String parentTableName = null;
        entityName = config.getEntityName();
        tableName = this.getEntityTableName(entityName);
        if (mainTable.equalsIgnoreCase(tableName)) {
            return;
        }
        if (config.getParent() != null) {
            parentEntityName = config.getParent().getEntityName();
            parentTableName = this.getEntityTableName(parentEntityName);
        }
        if (filters != null && filters.size() > 0) {
            sql.append(" left join " + tableName + " on ");
            for (int i = 0; i < filters.size(); ++i) {
                if (i != 0) {
                    sql.append(" and ");
                }
                sql.append(tableName + "." + this.getEntityFieldName(entityName, filters.get(i).getClientColumn()));
                sql.append(" = ");
                if (StringUtils.isEmpty((String)parentTableName)) {
                    sql.append(mainTable + ".FPersonID");
                    continue;
                }
                if (null != filters.get(i).getFixValue()) {
                    sql.append(filters.get(i).getFixValue());
                    continue;
                }
                sql.append(parentTableName + "." + this.getEntityFieldName(parentEntityName, filters.get(i).getParentColumn()));
            }
        }
    }

    public void dealWithFieldStr(String mainTable, String fieldStr) {
        String commaPlace = SQLGenerate.getFieldListCommaPlace(fieldStr);
        String[] fieldArr = this.getFieldArr(fieldStr, commaPlace);
        String normalField = "(\\s)*(([a-zA-Z0-9_]+)(\\.)([a-zA-Z0-9_]+))(\\s)*";
        String childSql = "\\((\\s)*SELECT(\\s)+";
        Pattern pattern = null;
        Matcher m = null;
        int start = 0;
        String patternStr = "";
        SQLFieldInfo fieldInfo = null;
        String tmpTable = "";
        for (int i = 0; i < fieldArr.length; ++i) {
            patternStr = fieldArr[i].trim();
            if (patternStr.equals("")) continue;
            fieldInfo = new SQLFieldInfo();
            fieldInfo.fieldStr = patternStr;
            patternStr = SQLGenerate.replaceTextContent(patternStr, "'");
            patternStr = SQLGenerate.replaceTextContent(patternStr, "\"");
            pattern = Pattern.compile(childSql, 2);
            m = pattern.matcher(patternStr);
            if (m.find(start = 0)) {
                this.fieldInfoArr.add(fieldInfo);
                continue;
            }
            pattern = Pattern.compile(normalField, 2);
            m = pattern.matcher(patternStr);
            String pstr = "";
            boolean isSingleField = false;
            while (m.find(start)) {
                String[] tmparr;
                pstr = patternStr.substring(m.start(), m.end()).trim();
                if (pstr.indexOf("CT") == 0) {
                    start = m.end();
                    continue;
                }
                if (m.start() == 0 && m.end() == patternStr.length()) {
                    isSingleField = true;
                    tmparr = patternStr.split("\\.");
                    fieldInfo.tableName = tmparr[0];
                    fieldInfo.fieldItem = tmparr[1];
                } else {
                    tmparr = patternStr.split(" ");
                    if (tmparr.length == 2 && m.start() == 0 && m.end() == tmparr[0].length() + 1) {
                        isSingleField = true;
                    } else if (tmparr.length == 3 && m.start() == 0 && m.end() == tmparr[0].length() + 1 && tmparr[1].toUpperCase(Locale.ENGLISH).equals("AS")) {
                        isSingleField = true;
                    }
                    if (isSingleField) {
                        tmparr = tmparr[0].split("\\.");
                        fieldInfo.tableName = tmparr[0].trim();
                        fieldInfo.fieldItem = tmparr[1];
                    }
                }
                tmpTable = pstr.split("\\.")[0];
                if (!tmpTable.equals(mainTable)) {
                    SQLGenerate.setJoinTableList(this.joinTableList, tmpTable);
                }
                start = m.end();
                if (!isSingleField) continue;
            }
            this.fieldInfoArr.add(fieldInfo);
        }
    }

    public void dealWithWhereStr(String mainTable, String whereStr) {
        String whereStrNoComma = SQLGenerate.replaceTextContent(whereStr, "'");
        whereStrNoComma = SQLGenerate.replaceTextContent(whereStrNoComma, "\"");
        whereStrNoComma = SQLGenerate.deleteChildSQL(whereStrNoComma);
        String normalField = "(\\s)*(([a-zA-Z0-9_]+)(\\.)([a-zA-Z0-9_]+))(\\s)*";
        Pattern pattern = null;
        Matcher m = null;
        int start = 0;
        Object fieldInfo = null;
        pattern = Pattern.compile(normalField, 2);
        m = pattern.matcher(whereStrNoComma);
        start = 0;
        int findstart = 0;
        int findend = 0;
        String pstr = "";
        String tmpTable = "";
        while (m.find(start)) {
            findstart = m.start();
            pstr = whereStrNoComma.substring(findstart, findend = m.end());
            if (pstr.indexOf("CT") == 0) {
                start = findend;
                continue;
            }
            tmpTable = pstr.split("\\.")[0].trim();
            if (!tmpTable.equals(mainTable)) {
                SQLGenerate.setJoinTableList(this.joinTableList, tmpTable);
            }
            start = m.end();
        }
        int size = this.joinTableList.size();
        for (int i = 0; i < size; ++i) {
            SQLJoinTable joinTable = (SQLJoinTable)this.joinTableList.get(i);
            String tableNoTime = joinTable.tableName + ".NOTIME";
            if (whereStr.indexOf(tableNoTime) <= -1) continue;
            joinTable.fromTime = "";
            joinTable.toTime = "";
        }
    }

    public String getConcernDate() {
        Calendar cal = Calendar.getInstance();
        String year = String.valueOf(cal.get(1));
        String month = String.valueOf(cal.get(2) + 1);
        String day = String.valueOf(cal.get(5));
        String date = year + "-" + month + "-" + day;
        return date;
    }

    private String getEntityFieldName(String entityName, String fieldName) {
        Context ctx = Tools.getInstance().getCtx();
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        PropertyInfo propertyInfo = null;
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size && !fieldName.equalsIgnoreCase((propertyInfo = collection.get(i)).getName()); ++i) {
        }
        if (propertyInfo == null || propertyInfo.getMappingField() == null || StringUtils.isEmpty((String)propertyInfo.getMappingField().getName())) {
            return null;
        }
        if (propertyInfo.getMappingField().isMultilingual()) {
            String language = ctx.getLocale().getLanguage().toUpperCase(Locale.ENGLISH);
            return propertyInfo.getMappingField().getName() + "_" + language;
        }
        return propertyInfo.getMappingField().getName();
    }

    private String getEntityTableName(String entityName) {
        Context ctx = Tools.getInstance().getCtx();
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        return entityInfo.getTable().getName();
    }

    private String[] getFieldArr(String fieldStr, String commaPlace) {
        if (commaPlace.equals("")) {
            String[] reArr = new String[]{fieldStr};
            return reArr;
        }
        String[] tmparr = commaPlace.split(",");
        String[] reArr = new String[tmparr.length + 1];
        int prePlace = 0;
        int tmpInt = 0;
        for (int i = 0; i < tmparr.length; ++i) {
            tmpInt = Integer.parseInt(tmparr[i]);
            reArr[i] = fieldStr.substring(prePlace, tmpInt - 1);
            prePlace = tmpInt;
        }
        reArr[tmparr.length] = fieldStr.substring(prePlace, fieldStr.length());
        return reArr;
    }

    public String getSQL(String mainTable, String fieldStr, String whereStr, String concernDate) {
        int size;
        this.fieldInfoArr = new ArrayList(2);
        this.joinTableList = new ArrayList(2);
        this.codeTableCount = 0;
        SQLGenerate.setJoinTableList(this.joinTableList, mainTable);
        ((SQLJoinTable)this.joinTableList.get((int)0)).isJoined = true;
        this.dealWithFieldStr(mainTable, fieldStr);
        this.dealWithWhereStr(mainTable, whereStr);
        if (concernDate == null || concernDate.equals("")) {
            concernDate = this.getConcernDate();
        }
        if ((size = this.joinTableList.size()) > 1) {
            for (int i = 0; i < size; ++i) {
                SQLJoinTable joinTable = (SQLJoinTable)this.joinTableList.get(i);
                String tableNoTime = joinTable.tableName + ".NOTIME";
                if (whereStr.indexOf(tableNoTime) <= -1) continue;
                joinTable.fromTime = "";
                joinTable.toTime = "";
            }
        }
        String sql = this.assembleSQL(whereStr, concernDate);
        logger.info((Object)sql);
        return sql;
    }

    public void setFieldInfo(SQLFieldInfo fieldInfo) throws EASBizException {
        DataRow dr;
        DataAccess dataAccess = DAFactory.getDataAccess();
        DataTable dt = dataAccess.getDataTable("SELECT MIS_FIELD.INFOSETID INFOSETID,MIS_FIELD.ITEMID ITEMID,MIS_FIELD.TYPEID TYPEID,MIS_FIELD.REFTABLEID REFTABLEID,MIS_FIELD.CODEVALUEFIELD CODEVALUEFIELD,MIS_FIELD.CODETEXTFIELD CODETEXTFIELD , MIS_TABLE.TOTIMEFIELD TOTIMEFIELD ,MIS_TABLE.FROMTIMEFIELD FROMTIMEFIELD,MAINTABLE.FROMTIMEFIELD MAINTABLEFROMTIME,MAINTABLE.TOTIMEFIELD MAINTABLETOTIME FROM MIS_FIELD LEFT JOIN MIS_TABLE   ON MIS_FIELD.REFTABLEID=MIS_TABLE.INFOSETID LEFT JOIN MIS_TABLE MAINTABLE ON MIS_FIELD.INFOSETID=MAINTABLE.INFOSETID WHERE MIS_FIELD.INFOSETID='" + fieldInfo.tableName + "' AND MIS_FIELD.ITEMID='" + fieldInfo.fieldItem + "'");
        boolean flag = false;
        if (dt.rowCount() == 1 && (dr = dt.getRows(0)).getString("TYPEID").equals("0")) {
            fieldInfo.joinTable = dr.getString("REFTABLEID");
            fieldInfo.joinField = dr.getString("CODEVALUEFIELD");
            fieldInfo.joinFieldText = dr.getString("CODETEXTFIELD");
            fieldInfo.joinFromTime = dr.getString("FROMTIMEFIELD");
            fieldInfo.joinToTime = dr.getString("TOTIMEFIELD");
            fieldInfo.tableName = dr.getString("INFOSETID");
            fieldInfo.fieldType = dr.getString("TYPEID");
            fieldInfo.fieldItem = dr.getString("ITEMID");
            fieldInfo.fromTime = dr.getString("MAINTABLEFROMTIME");
            fieldInfo.toTime = dr.getString("MAINTABLETOTIME");
            SQLFieldInfo tmpfield = null;
            for (int i = 0; i < this.fieldInfoArr.size(); ++i) {
                tmpfield = (SQLFieldInfo)this.fieldInfoArr.get(i);
                if (!tmpfield.tableName.equals(fieldInfo.tableName) || !tmpfield.fieldItem.equals(fieldInfo.fieldItem)) continue;
                fieldInfo.joinTableAlias = tmpfield.joinTableAlias;
                fieldInfo.fieldCodeStr = tmpfield.fieldCodeStr;
                fieldInfo.fieldAlias = tmpfield.fieldAlias;
                flag = true;
                break;
            }
            if (!flag) {
                fieldInfo.joinTableAlias = "alias_" + this.codeTableCount;
                ++this.codeTableCount;
                fieldInfo.fieldCodeStr = fieldInfo.tableName + "." + fieldInfo.fieldItem + "||'@@##'||" + fieldInfo.joinTableAlias + "." + fieldInfo.joinFieldText;
                fieldInfo.fieldAlias = "\"" + fieldInfo.tableName + "." + fieldInfo.fieldItem + "TXT\"";
            }
        }
    }
}

