/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.data;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.formula.common.CommonMethod;
import com.kingdee.shr.compensation.app.formula.common.IdGen;
import com.kingdee.shr.compensation.app.formula.data.DAFactory;
import com.kingdee.shr.compensation.app.formula.data.DataAccess;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.exception.ToolsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public final class Tools {
    private static final Tools instance = new Tools();
    public static final String sFromTimeDefaultValue = "0001-01-01";
    public static final String sToTimeDefaultValue = "9999-12-31";
    private static Logger logger = Logger.getLogger(Tools.class);
    private final String windowTitle = "";
    private static final String[] zeroArray = new String[0];
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private Context ctx;

    public static void delecteServerFile(String path, String[] nameArray) {
        if (path == null || nameArray == null) {
            return;
        }
        File file = null;
        for (int i = 0; i < nameArray.length; ++i) {
            file = new File(path + File.separator + nameArray[i]);
            if (file == null || !file.exists()) continue;
            file.delete();
        }
    }

    public static String fileUpload(HttpServletRequest request, String path) {
        String name = "";
        try {
            DiskFileUpload fu = new DiskFileUpload();
            fu.setSizeMax(0x400000L);
            fu.setSizeThreshold(4096);
            List fileItems = fu.parseRequest(request);
            for (FileItem fi : fileItems) {
                String fileName = fi.getName();
                if (fileName == null) continue;
                name = Tools.getFileName(fileName);
                fi.write(new File(request.getRealPath(path) + Tools.getFileName(fileName)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getCurrentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String currDate = formatter.format(new Date());
        return currDate;
    }

    public static String getCurrentDateTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currDate = formatter.format(new Date());
        return currDate;
    }

    public static String getDateAdd(String date, int field, int amount) throws EASBizException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(Tools.getDateMask());
        Date dt = null;
        try {
            dt = df.parse(date);
        }
        catch (ParseException ex) {
            throw new ToolsException(ToolsException.ERRORDATEFORMAT);
        }
        cal.setTime(dt);
        cal.add(field, amount);
        return df.format(cal.getTime());
    }

    public static String getDateDay(String date) throws EASBizException {
        SimpleDateFormat df = new SimpleDateFormat(Tools.getDateMask());
        Date dt = null;
        try {
            dt = df.parse(date);
        }
        catch (ParseException ex) {
            throw new ToolsException(ToolsException.ERRORDATEFORMAT);
        }
        return String.valueOf(dt.getDay());
    }

    public static final String getDateMask() {
        return "yyyy-MM-dd";
    }

    public static String getDateYear(String date) throws EASBizException {
        SimpleDateFormat df = new SimpleDateFormat(Tools.getDateMask());
        Date dt = null;
        try {
            dt = df.parse(date);
        }
        catch (ParseException ex) {
            throw new ToolsException(ToolsException.ERRORDATEFORMAT);
        }
        return String.valueOf(dt.getYear());
    }

    public static String getDBValue(String sTypeId, String sFieldValue) {
        sFieldValue = Tools.getDBValue(sTypeId, sFieldValue, "");
        return sFieldValue;
    }

    public static String getDBValue(String sTypeId, String sFieldValue, String sDefaultValue) {
        if (sFieldValue.equals("") && sDefaultValue.equals("")) {
            return "NULL";
        }
        if (sFieldValue.equals("") && !sDefaultValue.equals("")) {
            return Tools.getDBValue(sTypeId, sDefaultValue);
        }
        if (sTypeId.equals("4") || sTypeId.equals("5") || sTypeId.equals("9")) {
            return sFieldValue;
        }
        sFieldValue = sTypeId.equals("2") ? "TO_DATE('" + sFieldValue + "', 'yyyy-mm-dd')" : "'" + sFieldValue.replaceAll("'", "''") + "'";
        return sFieldValue;
    }

    public static final String getDebugEnd(String sModuleText) {
        return "\u201c" + sModuleText + "\u201dSuccessful treatment";
    }

    public static final String getDebugSave(String sModuleText) {
        return "\u201c" + sModuleText + "\u201dSuccessful save \uff01";
    }

    public static final String getDebugStart(String sModuleText) {
        return "begin  processing \u201c" + sModuleText + "\u201d";
    }

    public static DataTable getFieldList(String sTable) throws EASBizException {
        DataAccess dl = DAFactory.getDataAccess();
        DataTable dt = null;
        String sql = "SELECT * FROM MIS_FIELD WHERE INFOSETID = '" + sTable + "'";
        try {
            DataTable dataTable = dt = dl.getDataTable(sql);
            return dataTable;
        }
        catch (Exception e) {
            throw new ToolsException(ToolsException.GETCOLUMNERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String path, String name) {
        String filePath = path + File.separator + name;
        StringBuffer buffer = new StringBuffer();
        char[] chrBuffer = new char[50];
        InputStreamReader reader = null;
        try {
            int length;
            File file = new File(filePath);
            reader = new FileReader(file);
            while ((length = reader.read(chrBuffer)) != -1) {
                buffer.append(new String(chrBuffer, 0, length));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            reader = null;
        }
        return buffer.toString();
    }

    private static String getFileName(String filePath) {
        String result = "";
        if (filePath == null) {
            return result;
        }
        int lastFlag = filePath.lastIndexOf("\\");
        return filePath.substring(lastFlag, filePath.length());
    }

    public static String getFOrgid(String userid) throws EASBizException {
        DataAccess da = DAFactory.getDataAccess();
        String sql = "";
        sql = "select person_id from mis_user where userid ='" + userid + "' and datefrom <= sysdate and dateto > sysdate";
        String personid = da.getSingleData(sql);
        if (personid.equals("")) {
            return "unknown";
        }
        sql = "select substr(b.jgbh, 0, 2) || '0000000' from hr_laborrelation a left join hr_org b on a.szjg = b.org_id where a.fromtime <= sysdate and a.totime > sysdate and b.fromtime <= sysdate and b.totime > sysdate and a.person_id='" + personid + "'";
        String orgid = da.getSingleData(sql);
        if (orgid.equals("")) {
            return "unknown";
        }
        if (orgid.equals("000000000")) {
            orgid = "010000000";
        }
        if ((orgid = da.getSingleData(sql = "select org_id from hr_org where jgbh = '" + orgid + "' and fromtime <= sysdate and totime > sysdate")).equals("")) {
            return "unknown";
        }
        return orgid;
    }

    public static String[] getInsertCommonSql_GUID(String userID) {
        String[] sSql = new String[2];
        String oid = CommonMethod.getRandomGUID();
        sSql[0] = "OID, CREATOR, TIMECREATED";
        sSql[1] = "'" + oid + "', " + Tools.getDBValue("1", userID) + ", sysdate";
        return sSql;
    }

    public static final Tools getInstance() {
        return instance;
    }

    public static String getOid(String sOidStr, int sOidLength) throws EASBizException {
        IdGen idgen = IdGen.getInstance(sOidStr);
        String s = String.valueOf(idgen.getNextId());
        String sPrefix = idgen.getPrefix();
        if (!sPrefix.equals("")) {
            sOidLength -= sPrefix.length();
        }
        s = sPrefix + Tools.getPadLeft(s, '0', sOidLength);
        return s;
    }

    public static String getPadLeft(String source, char ch, int length) {
        String s = "0000000000000000";
        s = s.replace('0', ch);
        s = s.substring(0, length);
        s = s + source;
        return s.substring(s.length() - length, s.length());
    }

    public static ArrayList getRelationTable(String sTable, String sField) throws EASBizException {
        sTable = sTable.toUpperCase(Locale.ENGLISH);
        sField = sField.toUpperCase(Locale.ENGLISH);
        String sSql = "select * from mis_tablerelation where (PKTABLE = '" + sTable + "' And PKFIELD = '" + sField + "') or (FKTABLE = '" + sTable + "' And FKFIELD = '" + sField + "')";
        ArrayList<String> al = new ArrayList<String>();
        DataAccess da = DAFactory.getDataAccess();
        DataTable dt = da.getDataTable(sSql);
        for (int i = 0; i < dt.rowCount(); ++i) {
            String sPkTable = dt.getRows(i).getString("PKTABLE");
            String sPkField = dt.getRows(i).getString("PKFIELD");
            String sFkTable = dt.getRows(i).getString("FKTABLE");
            String sFkField = dt.getRows(i).getString("PKFIELD");
            if (sPkTable.equals(sTable) && sPkField.equals(sField)) {
                al.add(sFkTable + " " + sFkField);
                continue;
            }
            if (!sFkTable.equals(sTable) || !sFkField.equals(sField)) continue;
            al.add(sPkTable + " " + sPkField);
        }
        return al;
    }

    public static String getSelectDbValue(String sValue) {
        sValue = sValue.replaceAll("'", "''");
        sValue = sValue.replaceAll("&", "' || '&' || '");
        return sValue;
    }

    public static String getStringDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String currDate = formatter.format(date);
        return currDate;
    }

    public static String GetTableAndTypeToXML(DataTable dtData) throws Exception {
        StringBuffer dtToXml = new StringBuffer("");
        StringBuffer colName = new StringBuffer("");
        try {
            String sValue = "";
            for (int i = 0; i < dtData.rowCount(); ++i) {
                dtToXml.append("<DIV ");
                for (int j = 0; j < dtData.columnCount(); ++j) {
                    if (i == 0) {
                        colName.append(dtData.getColumns(j).getName().toString() + ",");
                    }
                    if ((sValue = dtData.getRows(i).getString(j)).equals(sToTimeDefaultValue)) {
                        sValue = "";
                    }
                    dtToXml.append(dtData.getColumns(j).getName().toString() + " = '" + sValue + "' ");
                    if (i != 0) continue;
                    dtToXml.append(dtData.getColumns(j).getName().toString() + "_type = '" + dtData.getColumns(j).getType() + "' ");
                }
                dtToXml.append(">");
                if (i == 0) {
                    dtToXml.append(colName.toString().substring(0, colName.length() - 1));
                }
                dtToXml.append("</DIV>");
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        if (dtToXml.toString() != "") {
            return dtToXml.toString();
        }
        return "<DIV></DIV>";
    }

    public static String GetTableToXML(DataTable dtData) throws Exception {
        StringBuffer dtToXml = new StringBuffer("");
        StringBuffer colName = new StringBuffer("");
        try {
            String sValue = "";
            for (int i = 0; i < dtData.rowCount(); ++i) {
                dtToXml.append("<DIV ");
                for (int j = 0; j < dtData.columnCount(); ++j) {
                    if (i == 0) {
                        colName.append(dtData.getColumns(j).getName().toString() + ",");
                    }
                    if ((sValue = dtData.getRows(i).getString(j)).equals(sToTimeDefaultValue)) {
                        sValue = "";
                    }
                    dtToXml.append(dtData.getColumns(j).getName().toString() + " = '" + sValue + "' ");
                }
                dtToXml.append(">");
                if (i == 0) {
                    dtToXml.append(colName.toString().substring(0, colName.length() - 1));
                }
                dtToXml.append("</DIV>");
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        if (dtToXml.toString() != "") {
            return dtToXml.toString();
        }
        return "<DIV></DIV>";
    }

    public static boolean isDate(String strDate, String strFormat) {
        String strReg = "";
        if (strFormat.equalsIgnoreCase("yyyy-mm-dd")) {
            strReg = "[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}";
        } else if (strFormat.equalsIgnoreCase("yyyy-mm")) {
            strReg = "[0-9]{4}-[0-9]{1,2}";
        } else if (strFormat.equalsIgnoreCase("yyyy/mm/dd")) {
            strReg = "[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}";
        } else if (strFormat.equalsIgnoreCase("dd/mm/yyyy")) {
            strReg = "[0-9]{1,2}/[0-9]{1,2}/[0-9]{4}";
        } else if (strFormat.equalsIgnoreCase("yyyy/mm/dd")) {
            strReg = "[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}";
        } else if (strFormat.equalsIgnoreCase("yyyy\\mm\\dd")) {
            strReg = "[0-9]{4}\\[0-9]{1,2}\\[0-9]{1,2}";
        } else if (strFormat.equalsIgnoreCase("dd\\mm\\yyyy")) {
            strReg = "[0-9]{1,2}\\[0-9]{1,2}\\[0-9]{4}";
        }
        return strDate.matches(strReg);
    }

    public static boolean isNumber(String strValue) {
        return strValue.matches("-*[0-9]*[.]{0,1}[0-9]*");
    }

    public static void main(String[] args) {
        String str = "2007/01/09";
        if (Tools.isDate(str, "yyyy/mm/dd")) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }

    public static void printSql(ArrayList alSql, String sModule) {
        System.out.println(sModule + "\uff1abegin *****************************************");
        for (int i = 0; i < alSql.size(); ++i) {
            System.out.println(alSql.get(i).toString());
        }
        System.out.println(sModule + "\uff1aend *****************************************");
    }

    public static void viewdt(DataTable dt) {
        try {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("<table border='1' frame='box'>");
            sb.append("<tr>");
            for (i = 0; i < dt.columnCount(); ++i) {
                sb.append("<td>" + dt.getColumns(i).getName() + "</td>");
            }
            sb.append("</tr>");
            for (i = 0; i < dt.rowCount(); ++i) {
                sb.append("<tr>");
                for (int j = 0; j < dt.columnCount(); ++j) {
                    sb.append("<td>" + dt.getRows(i).getString(j) + "</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
            String s = sb.toString();
            System.out.println(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String[] fileNames, String filePath, String zipName, boolean deleteFlag) {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(filePath + zipName));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        if (null == out) {
            return;
        }
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                out.putNextEntry(new ZipEntry(fileNames[i]));
                FileInputStream in = new FileInputStream(new File(filePath + fileNames[i]));
                try {
                    int b;
                    while ((b = in.read()) != -1) {
                        out.write(b);
                    }
                    continue;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    continue;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                    in = null;
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            out = null;
        }
        if (deleteFlag) {
            for (int i = 0; i < fileNames.length; ++i) {
                File file = new File(filePath + fileNames[i]);
                file.delete();
            }
        }
    }

    private Tools() {
    }

    public String[] arrayListToStringArray(ArrayList list) {
        if (list == null || list.size() == 0) {
            return zeroArray;
        }
        int size = list.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = list.get(i).toString();
        }
        return result;
    }

    public String contactString(String value1, String value2, String separator) {
        if (value1.equals("") && value2.equals("")) {
            return "";
        }
        if (value1.equals("")) {
            return value2;
        }
        if (value2.equals("")) {
            return value1;
        }
        return value1 + separator + value2;
    }

    public String[] contactStringArray(String[] array1, String[] array2) {
        if (array2 == null || array2.length == 0) {
            return array1;
        }
        int size1 = array1.length;
        int size2 = array2.length;
        String[] result = new String[size1 + size2];
        System.arraycopy(array1, 0, result, 0, size1);
        System.arraycopy(array2, 0, result, size1, size2);
        return result;
    }

    public String formatDate(Date date) {
        return this.sdf.format(date);
    }

    public String getClassLoader() {
        return this.getClass().getResource("/").getPath();
    }

    public Context getCtx() {
        return this.ctx;
    }

    public final String getDateMonth() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(Tools.getDateMask());
        return df.format(cal.getTime()).toString().substring(0, 7);
    }

    public final String getToday() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(Tools.getDateMask());
        return df.format(cal.getTime());
    }

    public String[] getZeroStringArray() {
        return zeroArray;
    }

    public final void log(String msg) {
        System.out.println(System.currentTimeMillis() + "```" + msg);
    }

    public final void logError(String msg) {
        System.out.println(System.currentTimeMillis() + "```" + msg);
    }

    public final void logException(Exception e) {
        e.printStackTrace();
    }

    public final void logException(Throwable e) {
        e.printStackTrace();
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

