/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.incomeTax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.app.incomeTax.AbstractReductionSummaryFacadeControllerBean;
import com.kingdee.shr.compensation.app.incomeTax.CommInsuranceItemCollection;
import com.kingdee.shr.compensation.app.incomeTax.CommInsuranceItemFactory;
import com.kingdee.shr.compensation.app.incomeTax.CommInsuranceItemInfo;
import com.kingdee.shr.compensation.app.incomeTax.ComprehensiveReductionCatalogEnum;
import com.kingdee.shr.compensation.app.incomeTax.FbSubmitStatusEnum;
import com.kingdee.shr.compensation.app.incomeTax.ReductionFbCatalogEnum;
import com.kingdee.shr.compensation.app.incomeTax.ReductionItemCollection;
import com.kingdee.shr.compensation.app.incomeTax.ReductionItemFactory;
import com.kingdee.shr.compensation.app.incomeTax.ReductionItemInfo;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryCollection;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFactory;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxDelayInsuranceItemCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxDelayInsuranceItemFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxDelayInsuranceItemInfo;
import com.kingdee.shr.compensation.app.tax.TaskIncomeTaxRelationFactory;
import com.kingdee.shr.compensation.app.tax.TaskIncomeTaxRelationInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReductionSummaryFacadeControllerBean
extends AbstractReductionSummaryFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(ReductionSummaryFacadeControllerBean.class);

    @Override
    protected synchronized void _save(Context ctx, String taxUnitId, Date periodDate, String userId) throws BOSException {
        String sql = "select d.t2, d.t13, d.t14, d.t17, d.fPersonId, d.fIncomeItemId, r.fCardType, r.fCardNumber, e.fPayerType from t_hr_sTaxCalInitDetail d left join t_hr_sTaxPersonRecord r on d.fPersonId = r.fPersonId left join t_hr_sTaxPersonRecordEntry e on d.fPersonId = e.fPersonId and d.fTaxUnitId = e.fTaxUnitId where d.fTaxUnitId = '" + taxUnitId + "' and d.fPeriodBegin = " + CmpDateUtil.toKSqlDate(periodDate);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            HashSet<String> taxFreePersons = new HashSet<String>();
            HashSet<String> commInsPersons = new HashSet<String>();
            HashSet<String> taxDelayInsPersons = new HashSet<String>();
            ArrayList<ReductionBase> taxFreeReductionBases = new ArrayList<ReductionBase>();
            ArrayList<ReductionBase> commInsBases = new ArrayList<ReductionBase>();
            ArrayList<ReductionBase> taxDelayInsBases = new ArrayList<ReductionBase>();
            while (rs.next()) {
                BigDecimal taxFreeIncome = rs.getBigDecimal("t2");
                BigDecimal taxReduction = rs.getBigDecimal("t17");
                BigDecimal commIns = rs.getBigDecimal("t13");
                BigDecimal taxDelayIns = rs.getBigDecimal("t14");
                String personId = rs.getString("fPersonId");
                String incomeItemId = rs.getString("fIncomeItemId");
                String fCardType = rs.getString("fCardType");
                CardTypeEnum cardTypeEnum = CardTypeEnum.getEnum(fCardType);
                String cardType = cardTypeEnum == null ? null : cardTypeEnum.getAlias();
                String cardNumber = rs.getString("fCardNumber");
                String payerType = rs.getString("fPayerType");
                if (this.hasValue(taxFreeIncome) || this.hasValue(taxReduction)) {
                    taxFreePersons.add(personId);
                    if (this.hasValue(taxFreeIncome)) {
                        taxFreeReductionBases.add(new ReductionBase(personId, incomeItemId, cardType, cardNumber, payerType, ComprehensiveReductionCatalogEnum.INCOME));
                    }
                    if (this.hasValue(taxReduction)) {
                        taxFreeReductionBases.add(new ReductionBase(personId, incomeItemId, cardType, cardNumber, payerType, ComprehensiveReductionCatalogEnum.TAX));
                    }
                }
                if (this.hasValue(commIns) && !commInsPersons.contains(personId)) {
                    commInsPersons.add(personId);
                    commInsBases.add(new ReductionBase(personId, incomeItemId, cardType, cardNumber, payerType, null));
                }
                if (!this.hasValue(taxDelayIns) || taxDelayInsPersons.contains(personId)) continue;
                taxDelayInsPersons.add(personId);
                taxDelayInsBases.add(new ReductionBase(personId, incomeItemId, cardType, cardNumber, payerType, null));
            }
            LOG.error((Object)("Reduction summary result: taxFreePersons = " + taxFreePersons.size() + ", commInsPersons = " + commInsPersons.size() + ", taxDelayInsPersons = " + taxDelayInsPersons.size()));
            String oql = "select id, taxUnit.id, catalog, uploadedCount where taxUnit.id ='" + taxUnitId + "' and periodDate = " + CmpDateUtil.toKSqlDate(periodDate);
            ReductionSummaryCollection summaryCollection = ReductionSummaryFactory.getLocalInstance(ctx).getReductionSummaryCollection(oql);
            CoreBaseCollection collection = new CoreBaseCollection();
            if (!taxFreePersons.isEmpty()) {
                ReductionSummaryInfo taxFreeSummary = this.initReductionSummary(taxUnitId, periodDate, summaryCollection, ReductionFbCatalogEnum.REDUCTION_JMSX, userId);
                taxFreeSummary.setPersonCount(taxFreePersons.size());
                collection.add((CoreBaseInfo)taxFreeSummary);
                int uploadedCount = this.addDefaultReductionItem(ctx, taxFreeReductionBases, taxUnitId, periodDate, taxFreeSummary.getId());
                taxFreeSummary.setUploadedCount(uploadedCount);
            } else {
                this.clearReductionInfo(ctx, taxUnitId, periodDate);
            }
            if (!commInsPersons.isEmpty()) {
                ReductionSummaryInfo commInsSummary = this.initReductionSummary(taxUnitId, periodDate, summaryCollection, ReductionFbCatalogEnum.REDUCTION_COMMERCIAL, userId);
                commInsSummary.setPersonCount(commInsPersons.size());
                collection.add((CoreBaseInfo)commInsSummary);
                int uploadedCount = this.addDefaultCommInsItem(ctx, commInsBases, taxUnitId, periodDate, commInsSummary.getId());
                commInsSummary.setUploadedCount(uploadedCount);
            } else {
                this.clearCommReductionInfo(ctx, taxUnitId, periodDate);
            }
            if (!taxDelayInsPersons.isEmpty()) {
                ReductionSummaryInfo taxDelayInsSummary = this.initReductionSummary(taxUnitId, periodDate, summaryCollection, ReductionFbCatalogEnum.REDUCTION_TAX, userId);
                taxDelayInsSummary.setPersonCount(taxDelayInsPersons.size());
                collection.add((CoreBaseInfo)taxDelayInsSummary);
                int uploadedCount = this.addDefaultTaxDelayItem(ctx, taxDelayInsBases, taxUnitId, periodDate, taxDelayInsSummary.getId());
                taxDelayInsSummary.setUploadedCount(uploadedCount);
            } else {
                this.clearTaxDelayReductionInfo(ctx, taxUnitId, periodDate);
            }
            if (!collection.isEmpty()) {
                ReductionSummaryFactory.getLocalInstance(ctx).saveBatchData(collection);
            }
            this.updateSummaryStatus(ctx, taxUnitId, periodDate);
        }
        catch (Exception e) {
            LOG.error((Object)"save ReductionSummary error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void clearTaxDelayReductionInfo(Context ctx, String taxUnitId, Date periodDate) throws BOSException {
        String deleteSQL1 = "delete from T_HR_SReductionSummary where fTaxUnitId = '" + taxUnitId + "' and fPeriodDate =" + CmpDateUtil.toKSqlDate(periodDate) + " and fCatalog =" + 3;
        String deleteSQL2 = "delete from T_HR_STaxDelayInsuranceItem where FSummaryId in (select fid from T_HR_SReductionSummary where fTaxUnitId = '" + taxUnitId + "' and fPeriodDate =" + CmpDateUtil.toKSqlDate(periodDate) + " and fCatalog =" + 3 + ")";
        DbUtil.execute((Context)ctx, (String)deleteSQL2);
        DbUtil.execute((Context)ctx, (String)deleteSQL1);
    }

    private void clearCommReductionInfo(Context ctx, String taxUnitId, Date periodDate) throws BOSException {
        String deleteSQL1 = "delete from T_HR_SReductionSummary where fTaxUnitId = '" + taxUnitId + "' and fPeriodDate =" + CmpDateUtil.toKSqlDate(periodDate) + " and fCatalog =" + 2;
        String deleteSQL2 = "delete from T_HR_SCommInsuranceItem where FSummaryId in (select fid from T_HR_SReductionSummary where fTaxUnitId = '" + taxUnitId + "' and fPeriodDate =" + CmpDateUtil.toKSqlDate(periodDate) + " and fCatalog =" + 2 + ")";
        DbUtil.execute((Context)ctx, (String)deleteSQL2);
        DbUtil.execute((Context)ctx, (String)deleteSQL1);
    }

    private void clearReductionInfo(Context ctx, String taxUnitId, Date periodDate) throws BOSException {
        String deleteSQL1 = "delete from T_HR_SReductionSummary where fTaxUnitId = '" + taxUnitId + "' and fPeriodDate =" + CmpDateUtil.toKSqlDate(periodDate) + " and fCatalog =" + 1;
        String deleteSQL2 = "delete from T_HR_SReductionItem where FSummaryId in (select fid from T_HR_SReductionSummary where fTaxUnitId = '" + taxUnitId + "' and fPeriodDate =" + CmpDateUtil.toKSqlDate(periodDate) + " and fCatalog =" + 1 + ")";
        DbUtil.execute((Context)ctx, (String)deleteSQL2);
        DbUtil.execute((Context)ctx, (String)deleteSQL1);
    }

    private int addDefaultTaxDelayItem(Context ctx, List<ReductionBase> commInsBases, String taxUnitId, Date periodDate, BOSUuid summaryId) throws BOSException {
        String oql = "select person.id, amount where taxUnit.id ='" + taxUnitId + "' and periodDate = " + CmpDateUtil.toKSqlDate(periodDate);
        TaxDelayInsuranceItemCollection collection = TaxDelayInsuranceItemFactory.getLocalInstance(ctx).getTaxDelayInsuranceItemCollection(oql);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (ReductionBase reductionBase : commInsBases) {
            if (this.isExisted(collection, reductionBase)) continue;
            Object[] param = new Object[]{CmpDateUtil.toSqlDate(periodDate), reductionBase.getPersonId(), taxUnitId, summaryId.toString(), 0, CmpDateUtil.getDateStr(periodDate, "yyyy-MM"), BOSUuid.create((String)"F1A498C7").toString(), reductionBase.getCardType(), reductionBase.getCardNumber(), this.getTbTypeByPayerType(reductionBase.getPayerType())};
            params.add(param);
        }
        HashSet<String> effectPersons = new HashSet<String>();
        String inCondition = this.filterTaxDelayInvalidIds(collection, commInsBases, effectPersons);
        if (!StringUtils.isEmpty((String)inCondition)) {
            String deleteSQL = "delete from t_hr_sTaxDelayInsuranceItem where fid in " + CmpStrUtil.buildInSql(inCondition);
            DbUtil.execute((Context)ctx, (String)deleteSQL);
        }
        if (!params.isEmpty()) {
            String insertSQL = "insert into t_hr_sTaxDelayInsuranceItem (FPeriodDate,FPersonId,FTaxUnitId,FSummaryId,FStatus,FYearMonth,Fid,fCardType, fCardNumber, fTbType) values(?,?,?,?,?,?,?,?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, params);
        }
        return effectPersons.size();
    }

    private String filterTaxDelayInvalidIds(TaxDelayInsuranceItemCollection collection, List<ReductionBase> commInsBases, Set<String> effectPersons) {
        if (null == collection || collection.isEmpty()) {
            return null;
        }
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            TaxDelayInsuranceItemInfo item = collection.get(i);
            boolean isExited = false;
            for (ReductionBase reductionBase : commInsBases) {
                if (!item.getPerson().getId().toString().equals(reductionBase.getPersonId())) continue;
                isExited = true;
                break;
            }
            if (!isExited) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(item.getId().toString());
                continue;
            }
            if (item.getAmount() == null) continue;
            effectPersons.add(item.getPerson().getId().toString());
        }
        return ids.toString();
    }

    private int addDefaultCommInsItem(Context ctx, List<ReductionBase> commInsBases, String taxUnitId, Date periodDate, BOSUuid summaryId) throws BOSException {
        String oql = "select person.id, amount where taxUnit.id ='" + taxUnitId + "' and periodDate = " + CmpDateUtil.toKSqlDate(periodDate);
        CommInsuranceItemCollection collection = CommInsuranceItemFactory.getLocalInstance(ctx).getCommInsuranceItemCollection(oql);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (ReductionBase reductionBase : commInsBases) {
            if (this.isExisted(collection, reductionBase)) continue;
            Object[] param = new Object[]{CmpDateUtil.toSqlDate(periodDate), reductionBase.getPersonId(), taxUnitId, summaryId.toString(), 0, BOSUuid.create((String)"83B32BD3").toString(), reductionBase.getCardType(), reductionBase.getCardNumber(), this.getTbTypeByPayerType(reductionBase.getPayerType())};
            params.add(param);
        }
        HashSet<String> effectPersons = new HashSet<String>();
        String inCondition = this.filterCommInvalidIds(collection, commInsBases, effectPersons);
        if (!StringUtils.isEmpty((String)inCondition)) {
            String deleteSQL = "delete from t_hr_sCommInsuranceItem where fid in " + CmpStrUtil.buildInSql(inCondition);
            DbUtil.execute((Context)ctx, (String)deleteSQL);
        }
        if (!params.isEmpty()) {
            String insertSQL = "insert into t_hr_sCommInsuranceItem (FPeriodDate,FPersonId,FTaxUnitId,FSummaryId,FStatus,Fid,fCardType, fCardNumber, fTbType) values(?,?,?,?,?,?,?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, params);
        }
        return effectPersons.size();
    }

    private String filterCommInvalidIds(CommInsuranceItemCollection collection, List<ReductionBase> commInsBases, Set<String> effectPersons) {
        if (null == collection || collection.isEmpty()) {
            return null;
        }
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            CommInsuranceItemInfo item = collection.get(i);
            boolean hasInitDetail = false;
            for (ReductionBase reductionBase : commInsBases) {
                if (!item.getPerson().getId().toString().equals(reductionBase.getPersonId())) continue;
                hasInitDetail = true;
                break;
            }
            if (!hasInitDetail) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(item.getId().toString());
                continue;
            }
            if (item.getAmount() == null) continue;
            effectPersons.add(item.getPerson().getId().toString());
        }
        return ids.toString();
    }

    private int addDefaultReductionItem(Context ctx, List<ReductionBase> reductionBaseList, String taxUnitId, Date periodDate, BOSUuid summaryId) throws BOSException {
        String oql = "select id, person.id, incomeItem.id, catalog, amount where taxUnit.id ='" + taxUnitId + "' and periodDate = " + CmpDateUtil.toKSqlDate(periodDate);
        ReductionItemCollection collection = ReductionItemFactory.getLocalInstance(ctx).getReductionItemCollection(oql);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (ReductionBase reductionBase : reductionBaseList) {
            if (this.isExisted(collection, reductionBase)) {
                LOG.error((Object)"addDefaultReductionItem isExisted = true");
                continue;
            }
            if (StringUtils.isEmpty((String)reductionBase.getCardType()) || StringUtils.isEmpty((String)reductionBase.getCardNumber()) || StringUtils.isEmpty((String)reductionBase.getPayerType())) {
                LOG.error((Object)("Personnel tax declaration information is incomplete, and the details of deductions and exemptions cannot be generated:" + reductionBase.getPersonId()));
            }
            Object[] param = new Object[]{reductionBase.getPersonId(), 0, summaryId.toString(), taxUnitId, reductionBase.getIncomeItemId(), CmpDateUtil.toSqlDate(periodDate), reductionBase.getCatalog().getValue(), BOSUuid.create((String)"47217798").toString(), reductionBase.getCardType(), reductionBase.getCardNumber(), this.getTbTypeByPayerType(reductionBase.getPayerType())};
            params.add(param);
        }
        HashSet<String> effectPersons = new HashSet<String>();
        String inCondition = this.filterInvalidIds(collection, reductionBaseList, effectPersons);
        if (!StringUtils.isEmpty((String)inCondition)) {
            String deleteSQL = "delete from t_hr_sReductionItem where fid in " + CmpStrUtil.buildInSql(inCondition);
            DbUtil.execute((Context)ctx, (String)deleteSQL);
        }
        LOG.error((Object)("addDefaultReductionItem params size = " + params.size()));
        if (!params.isEmpty()) {
            String insertSQL = "insert into t_hr_sReductionItem (FPersonId,FStatus,FSummaryId,FTaxUnitId,FIncomeItemId,FPeriodDate,FCatalog,Fid,fCardType, fCardNumber, fTbType) values(?,?,?,?,?,?,?,?,?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, params);
        }
        return effectPersons.size();
    }

    private String filterInvalidIds(ReductionItemCollection collection, List<ReductionBase> reductionBaseList, Set<String> effectPersons) {
        if (null == collection || collection.isEmpty()) {
            return null;
        }
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            ReductionItemInfo item = collection.get(i);
            boolean hasInitDetail = false;
            for (ReductionBase reductionBase : reductionBaseList) {
                if (!item.getPerson().getId().toString().equals(reductionBase.getPersonId()) || !item.getIncomeItem().getId().toString().equals(reductionBase.getIncomeItemId()) || item.getCatalog() != reductionBase.getCatalog()) continue;
                hasInitDetail = true;
                break;
            }
            if (!hasInitDetail) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(item.getId().toString());
                continue;
            }
            if (item.getAmount() == null) continue;
            effectPersons.add(item.getPerson().getId().toString());
        }
        return ids.toString();
    }

    private String getTbTypeByPayerType(String payerType) {
        return "1".equals(payerType) ? "3" : "1";
    }

    private boolean isExisted(ReductionItemCollection collection, ReductionBase reductionBase) {
        if (null == collection || collection.isEmpty()) {
            return false;
        }
        for (int i = 0; i < collection.size(); ++i) {
            ReductionItemInfo item = collection.get(i);
            if (!item.getPerson().getId().toString().equals(reductionBase.getPersonId()) || !item.getIncomeItem().getId().toString().equals(reductionBase.getIncomeItemId()) || item.getCatalog() != reductionBase.getCatalog()) continue;
            return true;
        }
        return false;
    }

    private boolean isExisted(CommInsuranceItemCollection collection, ReductionBase reductionBase) {
        if (null == collection || collection.isEmpty()) {
            return false;
        }
        for (int i = 0; i < collection.size(); ++i) {
            CommInsuranceItemInfo item = collection.get(i);
            if (!item.getPerson().getId().toString().equals(reductionBase.getPersonId())) continue;
            return true;
        }
        return false;
    }

    private boolean isExisted(TaxDelayInsuranceItemCollection collection, ReductionBase reductionBase) {
        if (null == collection || collection.isEmpty()) {
            return false;
        }
        for (int i = 0; i < collection.size(); ++i) {
            TaxDelayInsuranceItemInfo item = collection.get(i);
            if (!item.getPerson().getId().toString().equals(reductionBase.getPersonId())) continue;
            return true;
        }
        return false;
    }

    private ReductionSummaryInfo initReductionSummary(String taxUnitId, Date periodDate, ReductionSummaryCollection summaryCollection, ReductionFbCatalogEnum catalog, String userId) {
        ReductionSummaryInfo taxFreeSummary = this.getExistedReductionSummaryInfo(summaryCollection, catalog);
        if (null == taxFreeSummary) {
            taxFreeSummary = new ReductionSummaryInfo();
            taxFreeSummary.setId(BOSUuid.create((BOSObjectType)taxFreeSummary.getBOSType()));
            TaxUnitInfo taxUnit = new TaxUnitInfo();
            taxUnit.setId(BOSUuid.read((String)taxUnitId));
            taxFreeSummary.setTaxUnit(taxUnit);
            taxFreeSummary.setCatalog(catalog);
            taxFreeSummary.setPeriodDate(periodDate);
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        taxFreeSummary.setLastUpdateUser(userInfo);
        taxFreeSummary.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        taxFreeSummary.setStatus(FbSubmitStatusEnum.NOT_SUBMIT);
        return taxFreeSummary;
    }

    private ReductionSummaryInfo getExistedReductionSummaryInfo(ReductionSummaryCollection summaryCollection, ReductionFbCatalogEnum catalog) {
        if (null == summaryCollection || summaryCollection.isEmpty()) {
            return null;
        }
        for (int i = 0; i < summaryCollection.size(); ++i) {
            ReductionSummaryInfo summaryInfo = summaryCollection.get(i);
            if (catalog != summaryInfo.getCatalog()) continue;
            return summaryInfo;
        }
        return null;
    }

    private boolean hasValue(BigDecimal val) {
        return null != val && val.compareTo(BigDecimal.ZERO) > 0;
    }

    @Override
    protected void _deleteReductionItems(Context ctx, String taskId) throws BOSException {
        TaxCalTaskInfo task = TaxCalTaskFactory.getLocalInstance(ctx).getTaskById(taskId);
        try {
            String periodStr = task.getPeriod();
            if (periodStr.length() < 10) {
                periodStr = periodStr + "-01";
            }
            Date period = CmpDateUtil.parseDate(periodStr);
            this._save(ctx, task.getTaxUnit().getId().toString(), period, task.getCreator().getId().toString());
        }
        catch (Exception e) {
            LOG.error((Object)"_deleteReductionItems error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _update(Context ctx, String summaryId, String userId, ReductionFbCatalogEnum catalog) throws BOSException {
        int i;
        AbstractObjectCollection items;
        HashSet<String> persons = new HashSet<String>();
        String oql = "select person.id where summary.id = '" + summaryId + "' and amount > 0";
        if (catalog == ReductionFbCatalogEnum.REDUCTION_JMSX) {
            items = ReductionItemFactory.getLocalInstance(ctx).getReductionItemCollection(oql);
            if (null != items && items.size() > 0) {
                for (i = 0; i < items.size(); ++i) {
                    persons.add(items.get(i).getPerson().getId().toString());
                }
            }
        } else if (catalog == ReductionFbCatalogEnum.REDUCTION_COMMERCIAL) {
            items = CommInsuranceItemFactory.getLocalInstance(ctx).getCommInsuranceItemCollection(oql);
            if (null != items && items.size() > 0) {
                for (i = 0; i < items.size(); ++i) {
                    persons.add(items.get(i).getPerson().getId().toString());
                }
            }
        } else if (catalog == ReductionFbCatalogEnum.REDUCTION_TAX && null != (items = TaxDelayInsuranceItemFactory.getLocalInstance(ctx).getTaxDelayInsuranceItemCollection(oql)) && items.size() > 0) {
            for (i = 0; i < items.size(); ++i) {
                persons.add(items.get(i).getPerson().getId().toString());
            }
        }
        ReductionSummaryInfo summaryInfo = new ReductionSummaryInfo();
        summaryInfo.setId(BOSUuid.read((String)summaryId));
        summaryInfo.setUploadedCount(persons.size());
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        summaryInfo.setLastUpdateUser(userInfo);
        summaryInfo.setStatus(FbSubmitStatusEnum.NOT_SUBMIT);
        summaryInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        try {
            ReductionSummaryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(summaryId), summaryInfo);
        }
        catch (EASBizException e) {
            LOG.error((Object)"update Reduction Summary error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _updateStatusByTaskId(Context ctx, String taskId) throws BOSException {
        TaxCalTaskInfo task = TaxCalTaskFactory.getLocalInstance(ctx).getTaskById(taskId);
        String dateStr = task.getPeriod();
        if (dateStr.length() < 10) {
            dateStr = dateStr + "-01";
        }
        try {
            Date period = CmpDateUtil.parseDate(dateStr);
            if (null == period) {
                return;
            }
            this.updateSummaryStatus(ctx, task.getTaxUnit().getId().toString(), period);
        }
        catch (Exception e) {
            LOG.error((Object)"_updateStatusByTaskId error: ", (Throwable)e);
        }
    }

    @Override
    protected void _submit(Context ctx, String initDetails, CoreBaseCollection summaryCollection, CoreBaseCollection summaryTaskRelationCollection) throws BOSException {
        try {
            String taskId = TaxCalForJSFacadeFactory.getLocalInstance(ctx).submitInitData(initDetails, null, TaxCalTaskCatalogEnum.FbUpload);
            ReductionSummaryFactory.getLocalInstance(ctx).saveBatchData(summaryCollection);
            this.saveTaskIncomeTaxRelationCollection(ctx, taskId, summaryTaskRelationCollection);
            this.updateItemStatus(ctx, summaryCollection);
        }
        catch (EASBizException e) {
            LOG.error((Object)"_submit error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void updateItemStatus(Context ctx, CoreBaseCollection summaryCollection) throws BOSException {
        ArrayList<Object[]> reductionItems = new ArrayList<Object[]>();
        ArrayList<Object[]> commInsurances = new ArrayList<Object[]>();
        ArrayList<Object[]> taxDelays = new ArrayList<Object[]>();
        for (int i = 0; i < summaryCollection.size(); ++i) {
            ReductionSummaryInfo info = (ReductionSummaryInfo)summaryCollection.get(i);
            Object[] param = new Object[]{info.getId().toString()};
            if (info.getCatalog() == ReductionFbCatalogEnum.REDUCTION_JMSX) {
                reductionItems.add(param);
                continue;
            }
            if (info.getCatalog() == ReductionFbCatalogEnum.REDUCTION_COMMERCIAL) {
                commInsurances.add(param);
                continue;
            }
            if (info.getCatalog() != ReductionFbCatalogEnum.REDUCTION_TAX) continue;
            taxDelays.add(param);
        }
        if (!reductionItems.isEmpty()) {
            String sql = "update t_hr_sReductionItem set fStatus = 1 where FSummaryId = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, reductionItems);
        }
        if (!commInsurances.isEmpty()) {
            String sql = "update t_hr_sCommInsuranceItem set fStatus = 1 where FSummaryId = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, commInsurances);
        }
        if (!taxDelays.isEmpty()) {
            String sql = "update t_hr_sTaxDelayInsuranceItem set fStatus = 1 where FSummaryId = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, taxDelays);
        }
    }

    private void saveTaskIncomeTaxRelationCollection(Context ctx, String taskId, CoreBaseCollection summaryTaskRelationCollection) throws BOSException, EASBizException {
        for (int i = 0; i < summaryTaskRelationCollection.size(); ++i) {
            TaskIncomeTaxRelationInfo relationInfo = (TaskIncomeTaxRelationInfo)summaryTaskRelationCollection.get(i);
            relationInfo.setTaskId(taskId);
        }
        TaskIncomeTaxRelationFactory.getLocalInstance(ctx).saveBatchData(summaryTaskRelationCollection);
    }

    private void updateSummaryStatus(Context ctx, String taxUnitId, Date period) throws BOSException, SQLException {
        String oql = "select id, catalog where taxUnit.id = '" + taxUnitId + "' and periodDate = " + CmpDateUtil.toKSqlDate(period);
        ReductionSummaryCollection summaryCollection = ReductionSummaryFactory.getLocalInstance(ctx).getReductionSummaryCollection(oql);
        if (null != summaryCollection && !summaryCollection.isEmpty()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            String updateSQL = "update T_HR_SReductionSummary set fStatus = ? where fid = ?";
            for (int i = 0; i < summaryCollection.size(); ++i) {
                String summaryId = summaryCollection.get(i).getId().toString();
                ReductionFbCatalogEnum catalog = summaryCollection.get(i).getCatalog();
                String sql = "select fStatus from %s where fSummaryId = '" + summaryId + "'";
                sql = catalog == ReductionFbCatalogEnum.REDUCTION_JMSX ? String.format(sql, "T_HR_SReductionItem") : (catalog == ReductionFbCatalogEnum.REDUCTION_COMMERCIAL ? String.format(sql, "T_HR_SCommInsuranceItem") : String.format(sql, "T_HR_STaxDelayInsuranceItem"));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                int status = this.getSummaryStatus(rs);
                Object[] param = new Object[]{status, summaryId};
                params.add(param);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
        }
    }

    private int getSummaryStatus(IRowSet rs) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(rs.getInt("fStatus"));
        }
        if (list.isEmpty()) {
            return 0;
        }
        if (list.contains(0)) {
            return 0;
        }
        if (list.contains(1)) {
            return 1;
        }
        if (list.contains(-1)) {
            return -1;
        }
        return 2;
    }

    static class ReductionBase {
        private String personId;
        private String incomeItemId;
        private String cardType;
        private String cardNumber;
        private String payerType;
        private ComprehensiveReductionCatalogEnum catalog;

        public ReductionBase(String personId, String incomeItemId, String cardType, String cardNumber, String payerType, ComprehensiveReductionCatalogEnum catalog) {
            this.personId = personId;
            this.incomeItemId = incomeItemId;
            this.catalog = catalog;
            this.payerType = payerType;
            this.cardType = cardType;
            this.cardNumber = cardNumber;
        }

        public String getPersonId() {
            return this.personId;
        }

        public void setPersonId(String personId) {
            this.personId = personId;
        }

        public String getIncomeItemId() {
            return this.incomeItemId;
        }

        public void setIncomeItemId(String incomeItemId) {
            this.incomeItemId = incomeItemId;
        }

        public ComprehensiveReductionCatalogEnum getCatalog() {
            return this.catalog;
        }

        public void setCatalog(ComprehensiveReductionCatalogEnum catalog) {
            this.catalog = catalog;
        }

        public String getCardType() {
            return this.cardType;
        }

        public void setCardType(String cardType) {
            this.cardType = cardType;
        }

        public String getCardNumber() {
            return this.cardNumber;
        }

        public void setCardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
        }

        public String getPayerType() {
            return this.payerType;
        }

        public void setPayerType(String payerType) {
            this.payerType = payerType;
        }
    }
}

