/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.DeduNodeEnum;
import com.kingdee.shr.compensation.app.budget.DeductConfigFacadeFactory;
import com.kingdee.shr.compensation.app.budget.RollBackNodeEnum;
import com.kingdee.shr.compensation.app.budget.UpdateNodeEnum;
import com.kingdee.shr.compensation.app.integrate.AbstractBatchSubmitShemeBillControllerBean;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.BillEntryCalState;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.IBatchSubmitShemeBill;
import com.kingdee.shr.compensation.app.integrate.SchemeBizKeyDefineCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitBillEntryFacadeFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookFacadeFactory;
import com.kingdee.shr.compensation.integrate.verify.CycleVerify;
import com.kingdee.shr.compensation.service.budget.DeductionParamSubmitBill;
import com.kingdee.shr.compensation.service.timepiece.TimepieceBillDataService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.budget.MiaBudgetUpgradeUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryExtHelper;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateUtils;
import com.kingdee.shr.compensation.util.integrate.CycleEntry;
import com.kingdee.shr.compensation.util.integrate.SubmitBizKeyHelper;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchSubmitShemeBillControllerBean
extends AbstractBatchSubmitShemeBillControllerBean {
    private static final Logger logger = Logger.getLogger(BatchSubmitShemeBillControllerBean.class);
    private static final String CYCLE_EXTEND_TYPE = "75DB4741";

    public IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.beforeSave(ctx, info);
        IObjectPK iObjectPK = this.doSaveOrUpdate(ctx, info);
        this.afterSave(ctx, info, iObjectPK.toString());
        return iObjectPK;
    }

    protected void afterSave(Context ctx, BatchSubmitShemeBillInfo info, String billId) throws BOSException, EASBizException {
        String id = info.getSubmitScheme().getId().toString();
        CalSubmitSchemeInfo calSubmitSchemeInfo = CalSubmitSchemeFactory.getLocalInstance(ctx).getCalSubmitSchemeInfo(" where id = '" + id + "'");
        if (null != calSubmitSchemeInfo.getSubmitSchemeType() && 4 == calSubmitSchemeInfo.getSubmitSchemeType().getValue()) {
            String sql = "update T_HR_TimepieceBillEntry set FLeffectDate =FEffectDate ,FApplyDate = FEffectDate ,FYear = YEAR(FEffectDate) ,FPeriodType ='40' , FLastUpdateTime = null  where FBillID = ? ";
            String sqlcalstatus = "update T_HR_TimepieceBillEntry set fentrycalstatus = ?   where FBillID = ?  and fid = ?";
            BatchSubmitShemeBillEntryCollection coll = info.getEntry();
            if (coll.isEmpty()) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(billId);
                TimepieceBillDataService.dealBillSalaryshowByBillId(ctx, ids, "0");
            }
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (int i = 0; i < coll.size(); ++i) {
                BatchSubmitShemeBillEntryInfo entryInfo = coll.get(i);
                BillEntryCalState entrycalstatus = entryInfo.getEntrycalstatus();
                String value = "0";
                if (entrycalstatus != null) {
                    value = entrycalstatus.getValue();
                }
                String entryid = entryInfo.getId().toString();
                Object[] parma = new Object[]{value, billId, entryid};
                list.add(parma);
            }
            DbUtil.executeBatch((Context)ctx, (String)sqlcalstatus, list);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
            TimepieceBillDataService.dealSalaryshowByBillId(ctx, billId);
        }
    }

    protected void beforeSave(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        this.checkBillExists(ctx, info);
        HRBillStateEnum oldBillState = null;
        if (info.getId() != null) {
            BatchSubmitShemeBillCollection billInfoC = this.getBatchSubmitShemeBillCollection(ctx, "select id,billState where id = '" + info.getId().toString() + "'");
            oldBillState = billInfoC.isEmpty() ? null : billInfoC.get(0).getBillState();
        }
        super.checkHRBillWorkFlowIsEdit(ctx, (HRBillBaseInfo)info, oldBillState);
    }

    private void checkBillExists(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        if (BatchSubmitShemeBillFactory.getLocalInstance(ctx).exists("where number = '" + info.getNumber() + "' and billState > 1")) {
            throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label191", (Locale)ctx.getLocale())));
        }
    }

    private IObjectPK doSaveOrUpdate(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        this.reAssebleBillOrEntryInfo(ctx, info);
        IObjectPK idPk = null;
        if (null == info.getId() || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)info.getId().toString())) {
            idPk = this.dealSave(ctx, info);
            info.setId(BOSUuid.read((String)idPk.toString()));
        } else {
            this.dealUpdate(ctx, info);
            idPk = new ObjectUuidPK(info.getId());
        }
        return idPk;
    }

    protected IObjectPK dealSave(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection coll = info.getEntry();
        info.put("entry", null);
        IObjectPK objectPK = super.innerAddnew(ctx, (IObjectValue)info);
        info.put("entry", (Object)coll);
        SubmitBillEntryFacadeFactory.getLocalInstance(ctx).dealSaveEnties(info);
        return objectPK;
    }

    protected void dealUpdate(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection coll = info.getEntry();
        info.put("entry", null);
        if (super.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            super.innerUpdate(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        } else {
            super.innerAddnew(ctx, (IObjectValue)info);
        }
        info.put("entry", (Object)coll);
        this._saveOrUpdateEntries(ctx, (IObjectValue)info);
    }

    @Override
    protected void _saveOrUpdateEntries(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SubmitBillEntryFacadeFactory.getLocalInstance(ctx).saveOrUpdateEntries((BatchSubmitShemeBillInfo)model);
    }

    @Override
    protected void _reAssebleBillOrEntryInfo(Context ctx, BatchSubmitShemeBillInfo billInfo) throws BOSException, EASBizException {
    }

    public IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.beforeSave(ctx, info);
        this.updateStateAndTriggerNodeAssign(ctx, info.getId(), HRBillStateEnum.SUBMITED);
        this.callDeductOfSubmitScheme(ctx, info, DeduNodeEnum.SUBMIT, null, UpdateNodeEnum.SUBMIT);
        return new ObjectUuidPK(info.getId());
    }

    protected void callDeductOfSubmitScheme(Context ctx, BatchSubmitShemeBillInfo info, DeduNodeEnum deductNodeEnum, RollBackNodeEnum rollBackNodeEnum, UpdateNodeEnum updateNodeEnum) throws BOSException, EASBizException {
        String submitSchemeId;
        if (info.getSubmitScheme() == null || info.getSubmitScheme().getId() == null) {
            submitSchemeId = this.getSubmitSchemeIdByBill(ctx, info);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitSchemeId)) {
                return;
            }
            CalSubmitSchemeInfo calSubmitSchemeInfo = new CalSubmitSchemeInfo();
            calSubmitSchemeInfo.setId(BOSUuid.read((String)submitSchemeId));
            info.setSubmitScheme(calSubmitSchemeInfo);
        }
        if ("jJ0AAAAA1thRn/us".equals(info.getSubmitScheme().getId().toString()) && !MiaBudgetUpgradeUtil.isMiaBudgetUpgrade(ctx)) {
            return;
        }
        if (info.getId() != null) {
            submitSchemeId = this.getSubmitSchemeIdByBill(ctx, info);
            Set<String> entryIdSet = this.getBillEntryIdsByBillId(ctx, info.getId().toString(), submitSchemeId);
            DeductionParamSubmitBill deductionParam = new DeductionParamSubmitBill();
            deductionParam.setBillId(info.getId().toString());
            deductionParam.setDeductNodeEnum(deductNodeEnum);
            deductionParam.setCalSchemeId(submitSchemeId);
            deductionParam.setUpdateNodeEnum(updateNodeEnum);
            deductionParam.setRollbackNodeEnum(rollBackNodeEnum);
            deductionParam.setEntries(entryIdSet);
            if (deductNodeEnum != null) {
                DeductConfigFacadeFactory.getLocalInstance(ctx).dealSchemeDeductConfig(deductionParam, BudgetTemplateTypeEnum.SUBMIT_TYPE);
            } else if (rollBackNodeEnum != null) {
                DeductConfigFacadeFactory.getLocalInstance(ctx).dealWithRollback(deductionParam, BudgetTemplateTypeEnum.SUBMIT_TYPE);
            }
        }
    }

    protected String getSubmitSchemeIdByBill(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException {
        String submitSchemeId = null;
        if (info == null || info.getId() == null) {
            return null;
        }
        CalSubmitSchemeInfo submitScheme = info.getSubmitScheme();
        if (submitScheme == null || submitScheme.getId() == null) {
            String sql = "select Fid,FSubmitSchemeID from  T_HR_SBatchSubmitShemeBill where FID = ? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            try {
                while (rowSet.next()) {
                    submitSchemeId = rowSet.getString("FSubmitSchemeID");
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        } else {
            submitSchemeId = submitScheme.getId().toString();
        }
        return submitSchemeId;
    }

    protected Set<String> getBillEntryIdsByBillId(Context ctx, String billId, String submitSchemeId) throws BOSException {
        HashSet<String> entryIdSet = new HashSet<String>();
        String schemeEntryTableName = CmpIntegrateUtils.getSchemeEntryTableName(ctx, submitSchemeId);
        String queryEntryIdSql = "select FID FROM " + schemeEntryTableName + " where FBillId = '" + billId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryEntryIdSql);
        try {
            while (rowSet.next()) {
                entryIdSet.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return entryIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.beforeSave(ctx, info);
        String entranceName = "BatchSubmitShemeBillControllerBean_SubmitEffect";
        String resource = info.getId().toString();
        CmpDistributedLockUtils.tryLockIfSuccess(ctx, entranceName, resource);
        try {
            CmpIntegrateEntryExtHelper.convertExchangeRateAndSaveEntryExtInSpireBill(ctx, info.getId().toString(), Lists.newArrayList((Object[])new HRBillStateEnum[]{HRBillStateEnum.SUBMITED, HRBillStateEnum.AUDITED}));
            this.updateBillAndEntryState(ctx, info.getId(), HRBillStateEnum.AUDITED);
            StandingBookFacadeFactory.getLocalInstance(ctx).statistics(info.getId().toString());
            this.updateLeffectDateAfterApproved(ctx, info);
            this.deductOfSubmitEffect(ctx, info);
            ObjectUuidPK objectUuidPK = new ObjectUuidPK(info.getId());
            return objectUuidPK;
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, entranceName, resource);
        }
    }

    protected void deductOfSubmitEffect(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        String submitSchemeId = this.getSubmitSchemeIdByBill(ctx, info);
        String sql = "select distinct FDeduNode from T_HR_SSchemeDeduConfig where FCalSubmitSchemeID = ? and ( FDeduNode = 100 or FDeduNode = 200 )";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{submitSchemeId});
        try {
            while (rowSet.next()) {
                int deductNode = rowSet.getInt("FDeduNode");
                if (100 == deductNode) {
                    this.callDeductOfSubmitScheme(ctx, info, DeduNodeEnum.SUBMIT, null, UpdateNodeEnum.SUBMIT);
                }
                if (200 != deductNode) continue;
                this.callDeductOfSubmitScheme(ctx, info, DeduNodeEnum.APPROVE, null, UpdateNodeEnum.APPROVED);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = BatchSubmitShemeBillFactory.getLocalInstance(ctx).getBatchSubmitShemeBillInfo("where id = '" + billId.toString() + "'");
        new CycleVerify(null).doVerifyCycle(ctx, info);
        String entranceName = "BatchSubmitShemeBillControllerBean_setPassState";
        String resource = info.getId().toString();
        CmpDistributedLockUtils.tryLockIfSuccess(ctx, entranceName, resource);
        try {
            try {
                this.callDeductOfSubmitScheme(ctx, info, DeduNodeEnum.APPROVE, null, UpdateNodeEnum.APPROVED);
                this.updateLeffectDateAfterApproved(ctx, info);
                this.updateStateAndTriggerNodeAssign(ctx, billId, HRBillStateEnum.AUDITED);
            }
            catch (EASBizException e) {
                this.updateProcessMessage(ctx, billId, e);
                this.updateStateAndTriggerNodeAssign(ctx, billId, HRBillStateEnum.AUDITEND);
                this.callDeductOfSubmitScheme(ctx, info, null, RollBackNodeEnum.ROLLBACK_SUBMIT, UpdateNodeEnum.NOT_APPROVED);
            }
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, entranceName, resource);
        }
    }

    protected void updateProcessMessage(Context ctx, BOSUuid billId, EASBizException e) throws BOSException {
        String message = e.getMessage();
        String sql = "SELECT top 1 FID,FOpinion_l1,FOpinion_l2,FOpinion_l3 FROM T_BAS_MULTIAPPROVE WHERE FBillID = ? order by FCreateTime desc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId.toString()});
        try {
            while (rowSet.next()) {
                String fid = rowSet.getString("FID");
                String opinion1 = rowSet.getString("FOpinion_l1") == null ? "" : rowSet.getString("FOpinion_l1");
                String opinion2 = rowSet.getString("FOpinion_l2") == null ? "" : rowSet.getString("FOpinion_l2");
                String opinion3 = rowSet.getString("FOpinion_l3") == null ? "" : rowSet.getString("FOpinion_l3");
                String updateSql = "UPDATE T_BAS_MULTIAPPROVE SET  FIsPass = ?, FOpinion_l1 = ?, FOpinion_l2 = ?,FOpinion_l3 = ?  WHERE FID = ?";
                String newOpinion1 = this.getNewOpinion(message, opinion1);
                String newOpinion2 = this.getNewOpinion(message, opinion2);
                String newOpinion3 = this.getNewOpinion(message, opinion3);
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{"false", newOpinion1, newOpinion2, newOpinion3, fid});
            }
        }
        catch (SQLException e1) {
            throw new BOSException(e1.getMessage(), (Throwable)e1);
        }
    }

    private String getNewOpinion(String message, String opinion1) {
        String newOpinion1 = StringUtils.isEmpty((String)opinion1) ? message : opinion1 + "/" + message;
        return newOpinion1;
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.updateStateAndTriggerNodeAssign(ctx, billId, HRBillStateEnum.AUDITEND);
        BatchSubmitShemeBillInfo billInfo = new BatchSubmitShemeBillInfo();
        billInfo.setId(billId);
        this.callDeductOfSubmitScheme(ctx, billInfo, null, RollBackNodeEnum.ROLLBACK_SUBMIT, UpdateNodeEnum.NOT_APPROVED);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.updateStateAndTriggerNodeAssign(ctx, billId, HRBillStateEnum.AUDITING);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.updateStateAndTriggerNodeAssign(ctx, billId, HRBillStateEnum.SUBMITED);
    }

    private void updateStateAndTriggerNodeAssign(Context ctx, BOSUuid billId, HRBillStateEnum state) throws EASBizException, BOSException {
        this.updateBillAndEntryState(ctx, billId, state);
        CmpIntegrateEntryExtHelper.convertExchangeRateAndSaveEntryExtInSpireBill(ctx, billId.toString(), state);
        StandingBookFacadeFactory.getLocalInstance(ctx).statistics(billId.toString());
    }

    protected void updateBillAndEntryState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        this.updateOnlyBillState(ctx, billId, state);
        CmpIntegrateUtils.updateEntryBillState(ctx, billId.toString(), state, null);
    }

    private void updateOnlyBillState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException {
        String sql = "UPDATE T_HR_SBATCHSUBMITSHEMEBILL SET FBILLSTATE = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{state.getValue(), billId.toString()});
    }

    private void updateLeffectDateAfterApproved(Context ctx, BatchSubmitShemeBillInfo billInfo) throws EASBizException, BOSException {
        String submitSchemeId = billInfo.getSubmitScheme().getId().toString();
        CalSubmitSchemeInfo calSubmitSchemeInfo = CalSubmitSchemeFactory.getLocalInstance(ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(billInfo.getSubmitScheme().getId().toString()));
        if (!calSubmitSchemeInfo.isIscycle()) {
            return;
        }
        String billEntryTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId(ctx, submitSchemeId);
        this.updateCycleLeffectDateAfterApproved(ctx, calSubmitSchemeInfo, billEntryTable, billInfo);
    }

    protected void updateCycleLeffectDateAfterApproved(Context ctx, CalSubmitSchemeInfo calSubmitSchemeInfo, String billEntryTable, BatchSubmitShemeBillInfo billInfo) throws EASBizException, BOSException {
        String billId = billInfo.getId().toString();
        SchemeBizKeyDefineCollection schemeBizKeyDefineCols = SubmitBizKeyHelper.getSchemeBizKeyDefineCollectionByBillId(ctx, billId);
        String cycleBillSql = "SELECT FId,FPersonID,FAdminOrgUnitID,FCmpEmpORelationID,FSubmitElementID,FEffectDate,FLeffectDate FROM " + billEntryTable + " entry WHERE FBillState = " + 3 + " AND EXISTS(SELECT 1 FROM T_HR_SBatchSubmitShemeBill WHERE entry.FBillId = FID AND FID <> '%s') AND EXISTS (SELECT 1 FROM " + billEntryTable + " innerEntry WHERE %s)";
        HashSet<String> submitElementIdSet = calSubmitSchemeInfo.isIsEnableSubmitElement() ? this.getDistinctSubmitElementIdSet(ctx, billEntryTable, billId) : new HashSet<String>();
        String afterCycleBillSql = this.getAfterCycleSql(ctx, calSubmitSchemeInfo, submitElementIdSet, cycleBillSql, billId);
        Map<String, CycleEntry> afterCycleEntryMap = this.assembleAndGetAfterCycleEntryMap(ctx, schemeBizKeyDefineCols, afterCycleBillSql);
        HashSet existsSubmitEntryIdSet = Sets.newHashSet();
        String beforeCycleBillSql = this.getBeforeCycleSql(ctx, calSubmitSchemeInfo, submitElementIdSet, cycleBillSql, billId);
        Map<String, CycleEntry> beforeCycleEntryMap = this.assembleAndGetBeforeCycleEntryMap(ctx, schemeBizKeyDefineCols, beforeCycleBillSql, existsSubmitEntryIdSet);
        Set<String> existsBeforeCycleEntryMap = this.getExistsCycleEntryMap(ctx, existsSubmitEntryIdSet);
        String currentCycleBillSql = "SELECT FId,FPersonID,FAdminOrgUnitID,FCmpEmpORelationID,FSubmitElementID,FEffectDate,FLeffectDate FROM " + billEntryTable + " entry WHERE FBillId = '" + billId + "'";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("currentCycleBillSql:" + currentCycleBillSql));
        }
        try {
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            ArrayList insertParamList = Lists.newArrayList();
            ArrayList udpateBeforeParamList = Lists.newArrayList();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currentCycleBillSql);
            while (rs.next()) {
                String bizKey = SubmitBizKeyHelper.getSchemeBizKey(schemeBizKeyDefineCols, rs);
                CycleEntry currentCycleEntry = new CycleEntry(rs.getString("FId"), rs.getDate("FEffectDate"), rs.getDate("FLeffectDate"));
                CycleEntry afterCycleEntry = afterCycleEntryMap.get(bizKey);
                Object[] insertCurrentParam = new Object[]{afterCycleEntry != null && CmpDateUtil.compare(afterCycleEntry.getEffectDate(), currentCycleEntry.getLeffectDate()) <= 0 ? CmpDateUtil.toSqlDate(CmpDateUtil.getAddDate(afterCycleEntry.getEffectDate(), -1)) : null, currentCycleEntry.getId(), afterCycleEntry == null ? null : afterCycleEntry.getId(), BOSUuid.create((String)CYCLE_EXTEND_TYPE).toString(), bizKey, userId, new Timestamp(System.currentTimeMillis())};
                insertParamList.add(insertCurrentParam);
                CycleEntry beforeCycleEntry = beforeCycleEntryMap.get(bizKey);
                if (beforeCycleEntry == null || CmpDateUtil.compare(currentCycleEntry.getEffectDate(), beforeCycleEntry.getLeffectDate()) > 0) continue;
                if (!existsBeforeCycleEntryMap.contains(beforeCycleEntry.getId())) {
                    Object[] insertBeforeParam = new Object[]{CmpDateUtil.toSqlDate(CmpDateUtil.getAddDate(currentCycleEntry.getEffectDate(), -1)), beforeCycleEntry.getId(), currentCycleEntry.getId(), BOSUuid.create((String)CYCLE_EXTEND_TYPE).toString(), bizKey, userId, new Timestamp(System.currentTimeMillis())};
                    insertParamList.add(insertBeforeParam);
                    continue;
                }
                Object[] updateBeforeParam = new Object[]{CmpDateUtil.toSqlDate(CmpDateUtil.getAddDate(currentCycleEntry.getEffectDate(), -1)), currentCycleEntry.getId(), beforeCycleEntry.getId()};
                udpateBeforeParamList.add(updateBeforeParam);
            }
            String insertCycleExtendSql = "INSERT INTO T_HR_SubmitEntryCycleExtend(FExpireDate,FEntryId,FTargetEntryId,FID,FCycleDimession,FCreatorID,FCreateTime) VALUES(?,?,?,?,?,?,?)";
            if (!insertParamList.isEmpty()) {
                DbUtil.executeBatch((Context)ctx, (String)insertCycleExtendSql, (List)insertParamList);
            }
            if (!udpateBeforeParamList.isEmpty()) {
                String updateBeforeCycleExtendSql = "UPDATE T_HR_SubmitEntryCycleExtend SET FExpireDate=?,FTargetEntryId=? WHERE FEntryId = ?";
                DbUtil.executeBatch((Context)ctx, (String)updateBeforeCycleExtendSql, (List)udpateBeforeParamList);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getAfterCycleSql(Context ctx, CalSubmitSchemeInfo calSubmitSchemeInfo, Set<String> submitElementIdSet, String cycleBillSql, String billId) throws BOSException {
        ArrayList afterExistsWhereSqlPartList = Lists.newArrayList((Object[])new String[]{"entry.FEffectDate >= innerEntry.FEffectDate", "innerEntry.FBillId = '" + billId + "'"});
        String afterCycleExistsWhereSql = SubmitBizKeyHelper.getExistsWhereSql(ctx, calSubmitSchemeInfo, submitElementIdSet, afterExistsWhereSqlPartList, "entry", "innerEntry");
        String afterCycleBillSql = String.format(cycleBillSql, billId, afterCycleExistsWhereSql);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("afterCycleBillSql:" + afterCycleBillSql));
        }
        return afterCycleBillSql;
    }

    protected String getBeforeCycleSql(Context ctx, CalSubmitSchemeInfo calSubmitSchemeInfo, Set<String> submitElementIdSet, String cycleBillSql, String billId) throws BOSException {
        ArrayList beforeExistsWhereSqlPartList = Lists.newArrayList((Object[])new String[]{"entry.FEffectDate <= innerEntry.FEffectDate", "innerEntry.FBillId = '" + billId + "'"});
        String beforeCycleExistsWhereSql = SubmitBizKeyHelper.getExistsWhereSql(ctx, calSubmitSchemeInfo, submitElementIdSet, beforeExistsWhereSqlPartList, "entry", "innerEntry");
        String beforeCycleBillSql = String.format(cycleBillSql, billId, beforeCycleExistsWhereSql);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("beforeCycleBillSql:" + beforeCycleBillSql));
        }
        return beforeCycleBillSql;
    }

    protected Map<String, CycleEntry> assembleAndGetAfterCycleEntryMap(Context ctx, SchemeBizKeyDefineCollection schemeBizKeyDefineCols, String afterCycleBillSql) throws BOSException {
        HashMap afterCycleEntryMap = Maps.newHashMap();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)afterCycleBillSql);
            while (rs.next()) {
                String bizKey = SubmitBizKeyHelper.getSchemeBizKey(schemeBizKeyDefineCols, rs);
                CycleEntry cycleEntry = new CycleEntry(rs.getString("FId"), rs.getDate("FEffectDate"), rs.getDate("FLeffectDate"));
                CycleEntry originCycleEntry = (CycleEntry)afterCycleEntryMap.get(bizKey);
                if (originCycleEntry != null && originCycleEntry.getEffectDate().compareTo(cycleEntry.getEffectDate()) <= 0) continue;
                afterCycleEntryMap.put(bizKey, cycleEntry);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return afterCycleEntryMap;
    }

    protected Map<String, CycleEntry> assembleAndGetBeforeCycleEntryMap(Context ctx, SchemeBizKeyDefineCollection schemeBizKeyDefineCols, String beforeCycleBillSql, Set<String> beforeSubmitEntryIdSet) throws BOSException {
        HashMap beforeCycleEntryMap = Maps.newHashMap();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)beforeCycleBillSql);
            while (rs.next()) {
                String bizKey = SubmitBizKeyHelper.getSchemeBizKey(schemeBizKeyDefineCols, rs);
                String fid = rs.getString("FId");
                CycleEntry cycleEntry = new CycleEntry(fid, rs.getDate("FEffectDate"), rs.getDate("FLeffectDate"));
                CycleEntry originCycleEntry = (CycleEntry)beforeCycleEntryMap.get(bizKey);
                if (originCycleEntry == null || originCycleEntry.getEffectDate().compareTo(cycleEntry.getEffectDate()) < 0) {
                    beforeCycleEntryMap.put(bizKey, cycleEntry);
                }
                beforeSubmitEntryIdSet.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return beforeCycleEntryMap;
    }

    protected Set<String> getExistsCycleEntryMap(Context ctx, Set<String> beforeSubmitEntryIdSet) throws BOSException {
        HashSet existsBeforeCycleEntryMap = Sets.newHashSet();
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String inSql = cmpInSql.createInSqlBaseOnFId(ctx, beforeSubmitEntryIdSet);
        String existsBeforeCycleExtendSql = "SELECT FEntryId FROM T_HR_SubmitEntryCycleExtend WHERE FEntryId IN " + inSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existsBeforeCycleExtendSql);
        try {
            while (rs.next()) {
                existsBeforeCycleEntryMap.add(rs.getString("FEntryId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        cmpInSql.release(ctx);
        return existsBeforeCycleEntryMap;
    }

    protected Set<String> getDistinctSubmitElementIdSet(Context ctx, String billEntryTable, String billId) throws BOSException {
        String sql = "SELECT DISTINCT FSubmitElementId FROM %s WHERE FBillId = '%s'";
        sql = String.format(sql, billEntryTable, billId);
        HashSet submitElementIdSet = Sets.newHashSet();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String submitElementId = rs.getString("FSubmitElementId");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitElementId)) continue;
                submitElementIdSet.add(submitElementId);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return submitElementIdSet;
    }

    protected void setSavedStateAndHandleWorkFlow(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        String billId = billID.toString();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
            IBatchSubmitShemeBill batchSubmitShemeBill = BatchSubmitShemeBillFactory.getLocalInstance(ctx);
            BatchSubmitShemeBillInfo batchSubmitShemeBillInfo = batchSubmitShemeBill.getBatchSubmitShemeBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == batchSubmitShemeBillInfo) {
                logger.error((Object)MessageFormat.format(" when CmpWorkFlowMainBillControllerBean._setSaved invocked, getCmpWorkFlowMainBillInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = batchSubmitShemeBillInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                batchSubmitShemeBillInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                CmpIntegrateUtils.updateEntryBillState(ctx, billId, HRBillStateEnum.SAVED, null);
                batchSubmitShemeBill.updatePartial(batchSubmitShemeBillInfo, selector);
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, batchSubmitShemeBillInfo);
            } else {
                logger.error((Object)MessageFormat.format("billInfo,id: {0}", String.valueOf(batchSubmitShemeBillInfo.getId())));
            }
        } else {
            logger.error((Object)" when BatchSubmitShemeBillControllerBean._setSaved invocked, param billId is empty! please check param ");
        }
    }

    protected void _setSaved(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.setSavedStateAndHandleWorkFlow(ctx, billID);
        CmpIntegrateEntryExtHelper.convertExchangeRateAndSaveEntryExtInSpireBill(ctx, billID.toString(), HRBillStateEnum.SAVED);
        StandingBookFacadeFactory.getLocalInstance(ctx).statistics(billID.toString());
    }

    protected void abortBizBillAndWorkFlow(Context ctx, BatchSubmitShemeBillInfo billInfo) throws BOSException, EASBizException {
        if (null == billInfo) {
            logger.error((Object)" when BatchSubmitShemeBillControllerBean._abortBizBill invocked, getBatchSubmitShemeBillInfo is null !");
            return;
        }
        HRBillStateEnum billState = billInfo.getBillState();
        if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            billInfo.setBillState(HRBillStateEnum.SAVED);
            selector.add(new SelectorItemInfo("billState"));
            CmpIntegrateUtils.updateEntryBillState(ctx, billInfo.getId().toString(), HRBillStateEnum.SAVED, null);
            BatchSubmitShemeBillFactory.getLocalInstance(ctx).updatePartial(billInfo, selector);
            this.abortWorkFlow(ctx, billInfo.getId().toString());
            this.clearProcInstBizInfo(ctx, billInfo);
        } else {
            logger.error((Object)MessageFormat.format("billInfo,id: {0}", String.valueOf(billInfo.getId())));
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
            throw new BOSException("billId is null");
        }
        BatchSubmitShemeBillInfo billInfo = BatchSubmitShemeBillFactory.getLocalInstance(ctx).getBatchSubmitShemeBillInfo((IObjectPK)new ObjectUuidPK(billId));
        HRBillStateEnum currentState = billInfo.getBillState();
        this.abortBizBillAndWorkFlow(ctx, billInfo);
        CmpIntegrateEntryExtHelper.convertExchangeRateAndSaveEntryExtInSpireBill(ctx, billId, HRBillStateEnum.SAVED);
        StandingBookFacadeFactory.getLocalInstance(ctx).statistics(billId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId) && MiaBudgetUpgradeUtil.isMiaBudgetUpgrade(ctx) && currentState != HRBillStateEnum.AUDITEND) {
            String submitSchemeId = this.getSubmitSchemeId(ctx, billId);
            Set<String> entryIdSet = this.getBillEntryIdsByBillId(ctx, billId, submitSchemeId);
            DeductionParamSubmitBill deductionParam = new DeductionParamSubmitBill();
            deductionParam.setBillId(billId);
            deductionParam.setEntries(entryIdSet);
            deductionParam.setRollbackNodeEnum(RollBackNodeEnum.ROLLBACK_SUBMIT);
            deductionParam.setCalSchemeId(submitSchemeId);
            deductionParam.setUpdateNodeEnum(UpdateNodeEnum.WITHDRAW);
            DeductConfigFacadeFactory.getLocalInstance(ctx).dealWithRollback(deductionParam, BudgetTemplateTypeEnum.SUBMIT_TYPE);
        }
    }

    protected String getSubmitSchemeId(Context ctx, String billId) throws BOSException {
        String schemeSql = "select FSUBMITSCHEMEID from T_HR_SBatchSubmitShemeBill where FID  = ? ";
        IRowSet schemeRowSet = DbUtil.executeQuery((Context)ctx, (String)schemeSql, (Object[])new Object[]{billId});
        String submitSchemeId = null;
        try {
            while (schemeRowSet.next()) {
                submitSchemeId = schemeRowSet.getString("FSUBMITSCHEMEID");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return submitSchemeId;
    }

    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        CalSubmitSchemeInfo submitScheme = ((BatchSubmitShemeBillInfo)model).getSubmitScheme();
        if (submitScheme != null && submitScheme.getSubmitSchemeType() != null && submitScheme.getSubmitSchemeType().getValue() == 2) {
            String orgID = null;
            if (model.getHrOrgUnit() != null) {
                orgID = model.getHrOrgUnit().getId().toString();
            }
            String number = null;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            model.put("codingRuleHelper", (Object)"MultiIncentiveAwardScheme");
            if (orgID != null && iCodingRuleManager.isExist((IObjectValue)model, orgID, "codingRuleHelper")) {
                number = iCodingRuleManager.getNumber((IObjectValue)model, orgID, "codingRuleHelper", "");
            }
            if (number != null) {
                model.setNumber(number);
            }
        } else {
            super.setNumberFromCodingRule(ctx, model);
        }
    }
}

