/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.OperateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.AbstractSubmitPeriodFacadeControllerBean;
import com.kingdee.shr.compensation.app.integrate.ISubmitPeriod;
import com.kingdee.shr.compensation.app.integrate.ISubmitPeriodDetail;
import com.kingdee.shr.compensation.app.integrate.ISubmitPeriodLog;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodChangeSourceEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodLogFactory;
import com.kingdee.shr.compensation.app.integrate.submitPeriod.ISubmitPeriodGenetor;
import com.kingdee.shr.compensation.app.integrate.submitPeriod.SubmitPeriodGenetorFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class SubmitPeriodFacadeControllerBean
extends AbstractSubmitPeriodFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String DEL_IDS = "delIds";
    private static final String ENTRY = "entry";
    private static final String COMMA = ",";
    private static final String ID = "id";
    private static final String STATE = "state";
    private static final String IS_GEN_NEXT_YEAR = "isGenNextYear";

    @Override
    protected IObjectPK _saveOrUpdateWithEntry(Context ctx, Map param, IObjectValue model) throws BOSException, EASBizException {
        SubmitPeriodInfo submitPeriod = (SubmitPeriodInfo)model;
        SubmitPeriodDetailCollection detail = submitPeriod.getEntry();
        submitPeriod.put(ENTRY, null);
        IObjectPK pk = this.saveOrUpdateSubmitPeriodOnly(ctx, submitPeriod);
        submitPeriod.put(ENTRY, (Object)detail);
        this.deleteEntryDelIds(ctx, param);
        this.saveOrUpdateEntry(ctx, submitPeriod);
        return pk;
    }

    protected IObjectPK saveOrUpdateSubmitPeriodOnly(Context ctx, SubmitPeriodInfo submitPeriod) throws BOSException, EASBizException {
        IObjectPK pk;
        ISubmitPeriod submitPeriodInstance = SubmitPeriodFactory.getLocalInstance(ctx);
        if (submitPeriod.getId() == null) {
            pk = submitPeriodInstance.addnew(submitPeriod);
        } else {
            pk = new ObjectUuidPK(submitPeriod.getId());
            submitPeriodInstance.update(pk, submitPeriod);
        }
        return pk;
    }

    protected void deleteEntryDelIds(Context ctx, Map param) throws BOSException, EASBizException {
        String delIds = (String)param.get(DEL_IDS);
        if (StringUtils.hasLength((String)delIds)) {
            ISubmitPeriodDetail detailInstance = SubmitPeriodDetailFactory.getLocalInstance(ctx);
            String[] delIdArray = delIds.split(COMMA);
            IObjectPK[] delPKArray = new IObjectPK[delIdArray.length];
            for (int i = 0; i < delIdArray.length; ++i) {
                delPKArray[i] = new ObjectUuidPK(delIdArray[i]);
            }
            detailInstance.deleteBatchData(delPKArray);
            this.logDeleteDetails(ctx, delIdArray);
        }
    }

    protected void saveOrUpdateEntry(Context ctx, SubmitPeriodInfo submitPeriod) throws BOSException, EASBizException {
        SubmitPeriodDetailCollection details = submitPeriod.getEntry();
        CoreBaseCollection updateDetails = new CoreBaseCollection();
        CoreBaseCollection addnewDetails = new CoreBaseCollection();
        for (int i = 0; i < details.size(); ++i) {
            SubmitPeriodDetailInfo detailInfo = details.get(i);
            detailInfo.setBill(submitPeriod);
            if (detailInfo.getId() == null) {
                addnewDetails.add((CoreBaseInfo)detailInfo);
                continue;
            }
            updateDetails.add((CoreBaseInfo)detailInfo);
        }
        ISubmitPeriodDetail detailInstance = SubmitPeriodDetailFactory.getLocalInstance(ctx);
        if (addnewDetails.size() != 0) {
            detailInstance.addnew(addnewDetails);
            this.logAddDetails(ctx, addnewDetails);
        }
        if (updateDetails.size() != 0) {
            detailInstance.update(updateDetails);
            this.logUpdateDetails(ctx, updateDetails);
        }
    }

    @Override
    protected boolean _autoAenerateNextYear(Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem(STATE, (Object)1);
        filter.appendFilterItem(IS_GEN_NEXT_YEAR, (Object)true);
        SubmitPeriodCollection cols = this.getSubmitPeriodSortedByAscCollection(ctx, filter);
        CoreBaseCollection allCastedCols = new CoreBaseCollection();
        ISubmitPeriodDetail detailInstance = SubmitPeriodDetailFactory.getLocalInstance(ctx);
        for (int i = 0; i < cols.size(); ++i) {
            SubmitPeriodInfo submitPeriod = cols.get(i);
            if (!this.assertGenerateNextYear(submitPeriod)) continue;
            SubmitPeriodDetailCollection nextYearCollection = this.generateAndGetNextYearCollection(submitPeriod);
            CoreBaseCollection castedCols = (CoreBaseCollection)nextYearCollection.cast(CoreBaseCollection.class);
            allCastedCols.addCollection(castedCols);
        }
        detailInstance.addnewBatchData(allCastedCols);
        this.logAutoAddDetails(ctx, allCastedCols);
        return true;
    }

    private SubmitPeriodCollection getSubmitPeriodSortedByAscCollection(Context ctx, FilterInfo filter) throws BOSException {
        ISubmitPeriod instance = SubmitPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("entry.startDate");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sortCol.add(sorterItemInfo);
        view.setSorter(sortCol);
        view.setFilter(filter);
        return instance.getSubmitPeriodCollection(view);
    }

    protected boolean assertGenerateNextYear(SubmitPeriodInfo submitPeriod) {
        SubmitPeriodDetailCollection availablePeriodDetailCol;
        int periodsForward = submitPeriod.getPeriodsForward();
        return periodsForward >= (availablePeriodDetailCol = this.getAvailablePeriodDetailWithCurentPeriod(submitPeriod.getEntry(), new Date())).size();
    }

    protected SubmitPeriodDetailCollection getAvailablePeriodDetailWithCurentPeriod(SubmitPeriodDetailCollection sortedDetails, Date referenceDate) {
        SubmitPeriodDetailCollection availablePeriodDetailCol = new SubmitPeriodDetailCollection();
        if (sortedDetails == null) {
            return availablePeriodDetailCol;
        }
        for (int i = 0; i < sortedDetails.size(); ++i) {
            if (sortedDetails.get(i).getEndDate().compareTo(referenceDate) < 0) continue;
            availablePeriodDetailCol.add(sortedDetails.get(i));
        }
        return availablePeriodDetailCol;
    }

    protected SubmitPeriodDetailCollection generateAndGetNextYearCollection(SubmitPeriodInfo submitPeriod) {
        ISubmitPeriodGenetor genetor = SubmitPeriodGenetorFactory.getInstance(submitPeriod.getType());
        return genetor.generate(submitPeriod, SubmitPeriodChangeSourceEnum.auto);
    }

    private void logDeleteDetails(Context ctx, String[] delIdArray) throws BOSException, EASBizException {
        EntityViewInfo entryView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, this.IdArray2Set(delIdArray), CompareType.INCLUDE));
        entryView.setFilter(filter);
        ISubmitPeriodDetail detailInstance = SubmitPeriodDetailFactory.getLocalInstance(ctx);
        SubmitPeriodDetailCollection delCols = detailInstance.getSubmitPeriodDetailCollection(entryView);
        CoreBaseCollection castedDelCols = (CoreBaseCollection)delCols.cast(CoreBaseCollection.class);
        ISubmitPeriodLog SubmitPeriodLogInstance = SubmitPeriodLogFactory.getLocalInstance(ctx);
        SubmitPeriodLogInstance.log(castedDelCols, OperateTypeEnum.DELETE, SubmitPeriodChangeSourceEnum.manual);
    }

    private void logAddDetails(Context ctx, CoreBaseCollection delCols) throws BOSException, EASBizException {
        ISubmitPeriodLog SubmitPeriodLogInstance = SubmitPeriodLogFactory.getLocalInstance(ctx);
        SubmitPeriodLogInstance.log(delCols, OperateTypeEnum.ADDNEW, SubmitPeriodChangeSourceEnum.manual);
    }

    private void logAutoAddDetails(Context ctx, CoreBaseCollection delCols) throws BOSException, EASBizException {
        ISubmitPeriodLog SubmitPeriodLogInstance = SubmitPeriodLogFactory.getLocalInstance(ctx);
        SubmitPeriodLogInstance.log(delCols, OperateTypeEnum.ADDNEW, SubmitPeriodChangeSourceEnum.auto);
    }

    private void logUpdateDetails(Context ctx, CoreBaseCollection delCols) throws BOSException, EASBizException {
        ISubmitPeriodLog SubmitPeriodLogInstance = SubmitPeriodLogFactory.getLocalInstance(ctx);
        SubmitPeriodLogInstance.log(delCols, OperateTypeEnum.UPDATE, SubmitPeriodChangeSourceEnum.manual);
    }

    private Set<String> IdArray2Set(String[] delIdArray) {
        return new HashSet<String>(Arrays.asList(delIdArray));
    }
}

