/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.multiinspire;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.integrate.multiinspire.AbstractLimitManagementControllerBean;
import com.kingdee.shr.compensation.app.integrate.multiinspire.LimitManagementCollection;
import com.kingdee.shr.compensation.app.integrate.multiinspire.LimitManagementException;
import com.kingdee.shr.compensation.app.integrate.multiinspire.LimitManagementInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LimitManagementControllerBean
extends AbstractLimitManagementControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LimitManagementControllerBean.class);
    private static final String NEAREST_REAL_PARENT = "nearestRealParent";
    private static final String NEAREST_PARENT = "nearestParent";
    private static final String OLD_NODE = "oldNode";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LimitManagementInfo info = (LimitManagementInfo)model;
        this.setDefaultProperties(ctx, info);
        this.verifyLimitData(ctx, info);
        this.addOrUpdateParentVirtualNode(ctx, info);
        this.verifyState(ctx, info);
        this.initStandingBook(ctx, info);
        LimitManagementInfo oldNode = this.getOldNode(ctx, info);
        info.setVirtualNode(false);
        IObjectPK pk = null;
        if (oldNode != null) {
            info.setId(oldNode.getId());
            pk = new ObjectUuidPK(info.getId());
            super._update(ctx, pk, (IObjectValue)info);
        } else {
            pk = super._addnew(ctx, (IObjectValue)info);
        }
        StandingBookInfo standingBookInfo = info.getStandingBook();
        LimitManagementInfo limitInfo = new LimitManagementInfo();
        limitInfo.setId(BOSUuid.read((String)pk.toString()));
        standingBookInfo.setLimitManagement(limitInfo);
        StandingBookFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(standingBookInfo.getId()), standingBookInfo);
        if (StateEnum.DISABLE.equals((Object)info.getState())) {
            this.ableAction(ctx, pk.toString(), StateEnum.DISABLE);
        }
        return pk;
    }

    private void initStandingBook(Context ctx, LimitManagementInfo info) {
        StandingBookInfo standingBookInfo = new StandingBookInfo();
        standingBookInfo.setWithHoldAmount(new BigDecimal(0));
        standingBookInfo.setRealDeductAmount(new BigDecimal(0));
        standingBookInfo.setWithHoleBalance(info.getDepartmentLimit());
        standingBookInfo.setRealDeductBalance(info.getDepartmentLimit());
        UserInfo userInfo = this.getUserInfo(ctx);
        Timestamp createTime = this.getTime();
        standingBookInfo.setCreator(userInfo);
        standingBookInfo.setCreateTime(createTime);
        standingBookInfo.setLastUpdateUser(userInfo);
        standingBookInfo.setLastUpdateTime(createTime);
        standingBookInfo.setCU(this.getCU(ctx, standingBookInfo));
        info.setStandingBook(standingBookInfo);
    }

    private void verifyStandingBookUpdate(Context ctx, IObjectPK pk, LimitManagementInfo limitManagementInfo) throws EASBizException {
        try {
            BigDecimal sum;
            BigDecimal usedAmount;
            StandingBookInfo standingBookInfo;
            LimitManagementCollection limitCollection = super.getLimitManagementCollection(ctx, "select departmentLimit,standingBook.* from where id='" + pk.toString() + "'");
            if (!limitCollection.isEmpty()) {
                LimitManagementInfo limit = limitCollection.get(0);
                standingBookInfo = limit.getStandingBook();
                if (standingBookInfo.getWithHoldAmount() == null) {
                    return;
                }
                usedAmount = standingBookInfo.getUsedAmount() == null ? new BigDecimal(0) : standingBookInfo.getUsedAmount();
                sum = standingBookInfo.getWithHoldAmount().add(standingBookInfo.getRealDeductAmount()).add(usedAmount);
                if (limitManagementInfo.getDepartmentLimit().compareTo(sum) < 0) {
                    throw new LimitManagementException(LimitManagementException.BUDGETLIMIT_LESSTHAN_STANDINGBOOK, new Object[]{sum});
                }
            } else {
                throw new LimitManagementException(LimitManagementException.LIMITMANGEMENT_WAS_DELETED);
            }
            standingBookInfo.setWithHoleBalance(limitManagementInfo.getDepartmentLimit().subtract(sum));
            standingBookInfo.setRealDeductBalance(limitManagementInfo.getDepartmentLimit().subtract(standingBookInfo.getRealDeductAmount()).subtract(usedAmount));
            standingBookInfo.setLastUpdateUser(this.getUserInfo(ctx));
            standingBookInfo.setLastUpdateTime(this.getTime());
            limitManagementInfo.setStandingBook(standingBookInfo);
        }
        catch (BOSException e) {
            throw new LimitManagementException(LimitManagementException.VERIFY_STANDBOOKING_FAILED);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LimitManagementInfo info = (LimitManagementInfo)model;
        this.setDefaultProperties(ctx, info);
        this.verifyLimitData(ctx, info);
        this.verifyStandingBookUpdate(ctx, pk, info);
        this.addOrUpdateParentVirtualNode(ctx, info);
        this.verifyState(ctx, info);
        super._update(ctx, pk, model);
        if (StateEnum.DISABLE.equals((Object)info.getState())) {
            this.ableAction(ctx, pk.toString(), StateEnum.DISABLE);
        }
    }

    private void setDefaultProperties(Context ctx, LimitManagementInfo info) {
        if (info.getState() == null) {
            info.setState(StateEnum.ENABLE);
        }
        if (info.getCurrency() == null) {
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            info.setCurrency(currencyInfo);
        }
    }

    private void verifyLimitData(Context ctx, LimitManagementInfo limitManagementInfo) throws EASBizException {
        if (limitManagementInfo.getMaxLimit() != null && limitManagementInfo.getMaxLimit().compareTo(limitManagementInfo.getBudgetLimit()) < 0) {
            throw new LimitManagementException(LimitManagementException.MAXLIMIT_LESSTHAN_BUDGETLIMIT);
        }
        if (limitManagementInfo.getDepartmentLimit() != null && limitManagementInfo.getDepartmentLimit().compareTo(limitManagementInfo.getBudgetLimit()) > 0) {
            throw new LimitManagementException(LimitManagementException.DEPARTMENTLIMIT_MORETHAN_BUDGETLIMIT);
        }
        try {
            this.verifyChildrenSumLimit(ctx, limitManagementInfo);
            this.verifyParentLimit(ctx, limitManagementInfo);
        }
        catch (BOSException e) {
            throw new LimitManagementException(LimitManagementException.VERIFY_BUDGETLIMIT_FAILED, e);
        }
    }

    private void verifyChildrenSumLimit(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        LimitManagementInfo oldNode = this.getOldNode(ctx, limitManagementInfo);
        if (oldNode != null && oldNode.isVirtualNode()) {
            BigDecimal departmentLimit;
            BigDecimal bigDecimal = departmentLimit = limitManagementInfo.getDepartmentLimit() == null ? BigDecimal.ZERO : limitManagementInfo.getDepartmentLimit();
            if (limitManagementInfo.getBudgetLimit().subtract(departmentLimit).compareTo(oldNode.getBudgetLimit()) < 0) {
                throw new LimitManagementException(LimitManagementException.BUDGETLIMIT_LESSTHAN_CHILDREN, new Object[]{oldNode.getBudgetLimit()});
            }
        } else if (oldNode != null && !oldNode.isVirtualNode()) {
            BigDecimal departmentLimit;
            BigDecimal childrenSum = this.getChildrenSum(ctx, oldNode);
            BigDecimal bigDecimal = departmentLimit = limitManagementInfo.getDepartmentLimit() == null ? BigDecimal.ZERO : limitManagementInfo.getDepartmentLimit();
            if (limitManagementInfo.getBudgetLimit().subtract(departmentLimit).compareTo(childrenSum) < 0) {
                throw new LimitManagementException(LimitManagementException.BUDGETLIMIT_LESSTHAN_CHILDREN, new Object[]{childrenSum});
            }
        }
    }

    private LimitManagementInfo getOldNode(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        if (limitManagementInfo.containsKey(OLD_NODE)) {
            return (LimitManagementInfo)limitManagementInfo.get(OLD_NODE);
        }
        String oqlBuffer = "where adminOrgUnit.id = '" + limitManagementInfo.getAdminOrgUnit().getId() + "' and costType.id = '" + limitManagementInfo.getCostType().getId() + "' and budgetYear = " + limitManagementInfo.getBudgetYear();
        LimitManagementCollection dbLimitCollection = super.getLimitManagementCollection(ctx, oqlBuffer);
        LimitManagementInfo node = null;
        if (dbLimitCollection != null && dbLimitCollection.size() > 0) {
            node = dbLimitCollection.get(0);
        }
        limitManagementInfo.put(OLD_NODE, node);
        return node;
    }

    private void verifyParentLimit(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        LimitManagementInfo nearestRealParent = this.getNearestRealParent(ctx, limitManagementInfo);
        if (nearestRealParent != null) {
            BigDecimal childrenSum = this.getChildrenSum(ctx, nearestRealParent);
            BigDecimal oldBudgetLimit = new BigDecimal(0);
            LimitManagementInfo oldNode = this.getOldNode(ctx, limitManagementInfo);
            if (oldNode != null) {
                oldBudgetLimit = oldNode.getBudgetLimit();
            }
            BigDecimal departmentLimit = nearestRealParent.getDepartmentLimit() == null ? BigDecimal.ZERO : nearestRealParent.getDepartmentLimit();
            BigDecimal result = nearestRealParent.getBudgetLimit().subtract(departmentLimit).subtract(childrenSum.subtract(oldBudgetLimit).add(limitManagementInfo.getBudgetLimit()));
            if (result.compareTo(BigDecimal.ZERO) < 0) {
                throw new LimitManagementException(LimitManagementException.BUDGETLIMIT_MORETHAN_PARENT, new Object[]{nearestRealParent.getAdminOrgUnit().getName(), result.abs()});
            }
        }
    }

    private LimitManagementInfo getNearestRealParent(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        if (limitManagementInfo.containsKey(NEAREST_REAL_PARENT)) {
            return (LimitManagementInfo)limitManagementInfo.get(NEAREST_REAL_PARENT);
        }
        LimitManagementInfo result = this.getNearestParent(ctx, limitManagementInfo, true, false);
        limitManagementInfo.put(NEAREST_REAL_PARENT, result);
        return result;
    }

    private LimitManagementInfo getNearestParent(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        if (limitManagementInfo.containsKey(NEAREST_PARENT)) {
            return (LimitManagementInfo)limitManagementInfo.get(NEAREST_PARENT);
        }
        LimitManagementInfo result = this.getNearestParent(ctx, limitManagementInfo, false, false);
        limitManagementInfo.put(NEAREST_PARENT, result);
        return result;
    }

    private LimitManagementInfo getNearestParent(Context ctx, LimitManagementInfo limitManagementInfo, boolean isAvailable, boolean isVirtual) throws BOSException {
        IAdminOrgUnit iAdminOrgUnit;
        AdminOrgUnitCollection admins;
        if (StringUtils.isEmpty((CharSequence)limitManagementInfo.getAdminOrgUnit().getLongNumber()) && (admins = (iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx)).getAdminOrgUnitCollection("select id,number,name,longNumber from where id = '" + limitManagementInfo.getAdminOrgUnit().getId() + "'")) != null && admins.size() > 0) {
            limitManagementInfo.setAdminOrgUnit(admins.get(0));
        }
        String longNumberStr = limitManagementInfo.getAdminOrgUnit().getLongNumber();
        HashSet<String> parentSet = new HashSet<String>();
        while (longNumberStr.contains("!")) {
            int index = longNumberStr.lastIndexOf("!");
            longNumberStr = longNumberStr.substring(0, index);
            parentSet.add(longNumberStr);
        }
        LimitManagementInfo nearestParent = null;
        if (!parentSet.isEmpty()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectorsCollection = viewInfo.getSelector();
            selectorsCollection.add("*");
            selectorsCollection.add("adminOrgUnit.id");
            selectorsCollection.add("adminOrgUnit.name");
            selectorsCollection.add("adminOrgUnit.longNumber");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("costType.id", (Object)limitManagementInfo.getCostType().getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("budgetYear", (Object)limitManagementInfo.getBudgetYear(), CompareType.EQUALS));
            if (isAvailable) {
                filterInfo.getFilterItems().add(new FilterItemInfo("virtualNode", (Object)isVirtual, CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", parentSet, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            SorterItemCollection sorteItems = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("adminOrgUnit.longNumber");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorteItems.add(sorterItemInfo);
            viewInfo.setSorter(sorteItems);
            LimitManagementCollection parentCollection = super.getLimitManagementCollection(ctx, viewInfo);
            if (parentCollection != null && parentCollection.size() > 0) {
                nearestParent = parentCollection.get(0);
            }
        }
        return nearestParent;
    }

    private BigDecimal getChildrenSum(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException {
        String parentOqlBuffer = "where adminOrgUnit.parent = '" + limitManagementInfo.getAdminOrgUnit().getId() + "' and costType.id = '" + limitManagementInfo.getCostType().getId() + "' and budgetYear = " + limitManagementInfo.getBudgetYear();
        LimitManagementCollection childrenCollection = super.getLimitManagementCollection(ctx, parentOqlBuffer);
        BigDecimal childrenSum = new BigDecimal(0);
        if (childrenCollection != null && childrenCollection.size() > 0) {
            for (int i = 0; i < childrenCollection.size(); ++i) {
                childrenSum = childrenSum.add(childrenCollection.get(i).getBudgetLimit());
            }
        }
        return childrenSum;
    }

    private void addOrUpdateParentVirtualNode(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        if (limitManagementInfo.getId() != null && !"".equals(limitManagementInfo.getId().toString())) {
            this.updateParentVirtualNode(ctx, limitManagementInfo);
        } else {
            this.updateParentVirtualNode(ctx, limitManagementInfo);
            this.addParentVirtualNode(ctx, limitManagementInfo);
        }
    }

    private void updateParentVirtualNode(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        LimitManagementInfo nearestRealParent = this.getNearestRealParent(ctx, limitManagementInfo);
        String longNumberStr = limitManagementInfo.getAdminOrgUnit().getLongNumber();
        HashSet<String> parentSet = new HashSet<String>();
        while (longNumberStr.contains("!")) {
            int index = longNumberStr.lastIndexOf("!");
            longNumberStr = longNumberStr.substring(0, index);
            if (nearestRealParent != null && longNumberStr.equals(nearestRealParent.getAdminOrgUnit().getLongNumber())) break;
            parentSet.add(longNumberStr);
        }
        if (parentSet.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("costType.id", (Object)limitManagementInfo.getCostType().getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("budgetYear", (Object)limitManagementInfo.getBudgetYear(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("virtualNode", (Object)true, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", parentSet, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            LimitManagementCollection parentCollection = super.getLimitManagementCollection(ctx, viewInfo);
            if (parentCollection != null && parentCollection.size() > 0) {
                LimitManagementInfo oldNode = this.getOldNode(ctx, limitManagementInfo);
                BigDecimal oldBudgetLimit = new BigDecimal(0);
                if (oldNode != null) {
                    oldBudgetLimit = oldNode.getBudgetLimit();
                }
                for (int i = 0; i < parentCollection.size(); ++i) {
                    LimitManagementInfo parentInfo = parentCollection.get(i);
                    BigDecimal childrenSum = this.getChildrenSum(ctx, parentInfo);
                    parentInfo.setBudgetLimit(childrenSum.subtract(oldBudgetLimit).add(limitManagementInfo.getBudgetLimit()));
                    parentInfo.setLastUpdateTime(this.getTime());
                    parentInfo.setLastUpdateUser(this.getUserInfo(ctx));
                    super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId().toString()), (IObjectValue)parentInfo);
                }
            }
        }
    }

    private UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        return new Timestamp(d.getTime().getTime());
    }

    private void addParentVirtualNode(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        int index;
        LimitManagementInfo nearestParent = this.getNearestParent(ctx, limitManagementInfo);
        String available = null;
        if (nearestParent != null) {
            available = nearestParent.getAdminOrgUnit().getLongNumber();
        }
        String longNumberStr = limitManagementInfo.getAdminOrgUnit().getLongNumber();
        HashSet<String> parentSet = new HashSet<String>();
        while (longNumberStr.contains("!") && !(longNumberStr = longNumberStr.substring(0, index = longNumberStr.lastIndexOf("!"))).equals(available)) {
            parentSet.add(longNumberStr);
        }
        if (!parentSet.isEmpty()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectorsCollection = viewInfo.getSelector();
            selectorsCollection.add("id");
            selectorsCollection.add("longNumber");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", parentSet, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            AdminOrgUnitCollection admins = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
            if (admins != null && admins.size() > 0) {
                for (int i = 0; i < admins.size(); ++i) {
                    LimitManagementInfo virtualNode = new LimitManagementInfo();
                    virtualNode.setId(null);
                    virtualNode.setVirtualNode(true);
                    virtualNode.setAdminOrgUnit(admins.get(i));
                    virtualNode.setCostType(limitManagementInfo.getCostType());
                    virtualNode.setBudgetYear(limitManagementInfo.getBudgetYear());
                    virtualNode.setBudgetLimit(limitManagementInfo.getBudgetLimit());
                    virtualNode.setDepartmentLimit(new BigDecimal(0));
                    virtualNode.setCurrency(limitManagementInfo.getCurrency());
                    virtualNode.setState(limitManagementInfo.getState());
                    super._addnew(ctx, (IObjectValue)virtualNode);
                }
            }
        }
    }

    private void verifyState(Context ctx, LimitManagementInfo limitManagementInfo) throws BOSException, EASBizException {
        LimitManagementInfo nearestRealParent = this.getNearestRealParent(ctx, limitManagementInfo);
        if (nearestRealParent != null && StateEnum.DISABLE.equals((Object)nearestRealParent.getState())) {
            limitManagementInfo.setState(StateEnum.DISABLE);
        }
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        if (!super._exists(ctx, "where state = 2 and id = '" + id + "'")) {
            throw new LimitManagementException(LimitManagementException.PLZ_CHOOSE_DISABLED);
        }
        LimitManagementCollection collection = super.getLimitManagementCollection(ctx, "where id = '" + id + "'");
        if (collection != null && collection.size() > 0) {
            LimitManagementInfo info = collection.get(0);
            info.setState(StateEnum.ENABLE);
            info.setLastUpdateUser(this.getUserInfo(ctx));
            info.setLastUpdateTime(this.getTime());
            super._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)info);
        }
    }

    @Override
    protected void _enableIncludeSub(Context ctx, String id) throws BOSException, EASBizException {
        if (!super._exists(ctx, "where state = 2 and id = '" + id + "'")) {
            throw new LimitManagementException(LimitManagementException.PLZ_CHOOSE_DISABLED);
        }
        this.ableAction(ctx, id, StateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        if (!super._exists(ctx, "where virtualNode = 0 and state = 1 and id = '" + id + "'")) {
            throw new LimitManagementException(LimitManagementException.PLZ_CHOOSE_ENABLED);
        }
        LimitManagementCollection collection = super.getLimitManagementCollection(ctx, "select id,costType,budgetYear,adminOrgUnit.longNumber where id = '" + id + "'");
        if (!collection.isEmpty()) {
            LimitManagementInfo info = collection.get(0);
            String filterStr = "select id,adminOrgUnit.id,adminOrgUnit.name,costType,budgetYear,standingBook.id,standingBook.withHoldAmount where virtualNode = 0 and  costType = '" + info.getCostType().getId().toString() + "' and budgetYear = " + info.getBudgetYear() + " and (adminOrgUnit.longNumber = '" + info.getAdminOrgUnit().getLongNumber() + "' or adminOrgUnit.longNumber like '" + info.getAdminOrgUnit().getLongNumber() + "!%') order by adminOrgUnit.longNumber";
            LimitManagementCollection subCollection = super.getLimitManagementCollection(ctx, filterStr);
            if (subCollection != null && subCollection.size() > 0) {
                for (int i = 0; i < subCollection.size(); ++i) {
                    LimitManagementInfo subInfo = subCollection.get(i);
                    if (subInfo.getStandingBook() == null || BigDecimal.ZERO.compareTo(subInfo.getStandingBook().getWithHoldAmount()) == 0) continue;
                    throw new LimitManagementException(LimitManagementException.EXISTS_APPROVING, new Object[]{subInfo.getAdminOrgUnit().getName()});
                }
            }
        }
        this.ableAction(ctx, id, StateEnum.DISABLE);
    }

    private void ableAction(Context ctx, String id, StateEnum state) throws BOSException {
        LimitManagementCollection collection = super.getLimitManagementCollection(ctx, "select id,costType,budgetYear,adminOrgUnit.longNumber where id = '" + id + "'");
        if (!collection.isEmpty()) {
            LimitManagementInfo info = collection.get(0);
            StringBuilder disableSql = new StringBuilder(" update t_hr_sLimitManagement set fState = ");
            disableSql.append(state.getValue());
            disableSql.append(" ,FLASTUPDATEUSERID = ?, FLASTUPDATETIME = ? ");
            disableSql.append(" where fid in ( ");
            disableSql.append(" select limitMgmt.fid from t_hr_sLimitManagement limitMgmt left join t_org_admin adminOrg on limitMgmt.fAdminOrgUnitId = adminOrg.fId ");
            disableSql.append(" where limitMgmt.FCostTypeID = ? and limitMgmt.FBudgetYear = ? and (adminOrg.fLongNumber = ? or adminOrg.fLongNumber like ?)) ");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.getUserInfo(ctx).getId().toString());
            params.add(this.getTime());
            params.add(info.getCostType().getId().toString());
            params.add(info.getBudgetYear());
            params.add(info.getAdminOrgUnit().getLongNumber());
            params.add(info.getAdminOrgUnit().getLongNumber() + "!%");
            logger.info((Object)("able sql:" + disableSql.toString() + ",params:" + ((Object)params).toString()));
            DbUtil.execute((Context)ctx, (String)disableSql.toString(), (Object[])params.toArray());
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LimitManagementCollection collection = super.getLimitManagementCollection(ctx, "where id = '" + pk.toString() + "'");
        if (!collection.isEmpty()) {
            LimitManagementInfo info = collection.get(0);
            if (StateEnum.ENABLE.equals((Object)info.getState())) {
                throw new LimitManagementException(LimitManagementException.PLZ_CHOOSE_DISABLED);
            }
            StandingBookInfo standingBookInfo = info.getStandingBook();
            if (BigDecimal.ZERO.compareTo(standingBookInfo.getWithHoldAmount()) != 0 || BigDecimal.ZERO.compareTo(standingBookInfo.getRealDeductAmount()) != 0) {
                throw new LimitManagementException(LimitManagementException.BUDGETLIMIT_WAS_USED);
            }
            StandingBookFactory.getLocalInstance(ctx).delete("where id = '" + info.getStandingBook().getId() + "'");
            BigDecimal childrenSum = this.getChildrenSum(ctx, info);
            LimitManagementInfo virtualNode = new LimitManagementInfo();
            virtualNode.setId(info.getId());
            virtualNode.setVirtualNode(true);
            virtualNode.setAdminOrgUnit(info.getAdminOrgUnit());
            virtualNode.setCostType(info.getCostType());
            virtualNode.setBudgetYear(info.getBudgetYear());
            virtualNode.setBudgetLimit(childrenSum);
            virtualNode.setDepartmentLimit(new BigDecimal(0));
            this._update(ctx, pk, (IObjectValue)virtualNode);
        }
    }
}

