/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.intelligent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.intelligent.AbstractCmpIntelBoardFacadeControllerBean;
import com.kingdee.shr.compensation.intelligent.board.dto.CmpExecuteLogData;
import com.kingdee.shr.compensation.intelligent.constant.CmpIntelConstant;
import com.kingdee.shr.compensation.intelligent.sql.CmpIntelBoardSql;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelBoardUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpIntelBoardFacadeControllerBean
extends AbstractCmpIntelBoardFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.intelligent.CmpIntelBoardFacadeControllerBean");

    @Override
    protected List _getExecuteLog(Context ctx, String sql) throws BOSException, EASBizException {
        ArrayList<CmpExecuteLogData> list = new ArrayList<CmpExecuteLogData>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int num = 0;
        String ruleId = "";
        String ruleNumber = "";
        String ruleName = "";
        String lastTimeStr = "";
        Timestamp lastTime = null;
        CmpExecuteLogData logInfo = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            while (rs.next()) {
                ruleId = rs.getString("ruleId");
                ruleNumber = rs.getString("ruleNumber");
                ruleName = rs.getString("ruleName");
                num = rs.getInt("latestNum");
                lastTime = rs.getTimestamp("lastTime");
                lastTimeStr = lastTime != null ? format.format(lastTime) : "";
                logInfo = new CmpExecuteLogData();
                logInfo.setRuleId(ruleId);
                logInfo.setRuleNumber(ruleNumber);
                logInfo.setRuleName(ruleName);
                logInfo.setTime(lastTimeStr);
                logInfo.setNum(num);
                list.add(logInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    protected List _getToConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> cmpConfirmDataCount = new ArrayList();
        List<Object> socConfirmDataCount = new ArrayList();
        try {
            cmpConfirmDataCount = this.getCmpConfirmDataCount(ctx, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
            socConfirmDataCount = this.getSocConfirmDataCount(ctx, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
            cmpConfirmDataCount.addAll(socConfirmDataCount);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cmpConfirmDataCount;
    }

    private List<Map<String, Object>> getCmpConfirmDataCount(Context ctx, List<String> visibleCards, Map<Integer, String> bizUipkMap, Map<Integer, String> bizPermMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        List<Map<String, Object>> cmpData = this.getToConfirmDataCount(ctx, 1, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        return cmpData;
    }

    private List<Map<String, Object>> getSocConfirmDataCount(Context ctx, List<String> visibleCards, Map<Integer, String> bizUipkMap, Map<Integer, String> bizPermMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        List<Map<String, Object>> socData = this.getToConfirmDataCount(ctx, 3, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        return socData;
    }

    private List<Map<String, Object>> getAdjConfirmDataCount(Context ctx, List<String> visibleCards, Map<Integer, String> bizUipkMap, Map<Integer, String> bizPermMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        List<Map<String, Object>> socData = this.getToConfirmDataCount(ctx, 2, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        return socData;
    }

    private List<Map<String, Object>> getToConfirmDataCount(Context ctx, int bizType, List<String> visibleCards, Map<Integer, String> bizUipkMap, Map<Integer, String> bizPermMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String permItemId = bizPermMap.get(bizType);
        String bizManageType = bizTypeMap.get(bizType);
        String adminFilter = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgFilter = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String sql = CmpIntelBoardSql.getConfirmDataSql(adminFilter, hrOrgFilter, bizType, bizManageType, ctx);
        long t1 = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        long t2 = System.currentTimeMillis();
        logger.error((Object)("t22-t11=" + (t2 - t1)));
        String catalogId = "";
        String catalogName = "";
        String matchDataUipk = "";
        String matchDataPerm = "";
        String subCat = "";
        int num = 0;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        while (rs.next()) {
            catalogId = rs.getString("fid");
            catalogName = rs.getString("name");
            num = rs.getInt("num");
            subCat = rs.getString("FSubCat");
            if (!visibleCards.contains(catalogName) || CmpStrUtil.isEmpty(catalogName)) continue;
            matchDataUipk = bizUipkMap.get(bizType);
            matchDataPerm = bizPermMap.get(bizType);
            if (catalogId.equals("dXnEoek1PUu9j27Ok50pOQB4WXA=")) {
                matchDataUipk = "com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchData.cmPersonAdd.list";
            }
            if (catalogId.equals("ecnRgrVrakexjc9fhpQpwwB4WXA=")) {
                matchDataUipk = "com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchData.socPersonAdd.list";
            }
            if (catalogId.equals("fVa9WCKmTEWBgtswxQH45gB4WXA=")) {
                matchDataUipk = "com.kingdee.shr.compensation.app.intelligent.CmpIntelSynOrgPosition.list";
            }
            if (catalogId.equals("zICC5+gl8kG0Opqki7xwlQB4WXA=")) {
                matchDataUipk = "com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchData.adjPersonAdd.list";
            }
            try {
                catalogId = URLEncoder.encode(catalogId, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            dataMap = new HashMap();
            dataMap.put("label", catalogName);
            dataMap.put("count", num);
            dataMap.put("catalogId", catalogId);
            dataMap.put("uipk", matchDataUipk);
            dataMap.put("permItemId", matchDataPerm);
            dataMap.put("bizType", bizType);
            dataMap.put("subCat", subCat);
            result.add(dataMap);
        }
        Map<String, Object> noMatchMap = this.buildNomatchMap(ctx, bizType, adminFilter, hrOrgFilter, bizTypeMap);
        if (noMatchMap.get("label") != null && !StringUtils.isEmpty((CharSequence)noMatchMap.get("label").toString())) {
            result.add(noMatchMap);
        }
        return result;
    }

    private int getCmpEnrollErrorNum(Context ctx, String adminFilter, String hrOrgFilter) throws BOSException, SQLException {
        String sql = CmpIntelBoardSql.getCmpEnrollErrorNumSql(adminFilter, hrOrgFilter);
        int num = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            num = rs.getInt("num");
        }
        return num;
    }

    private int getAdjEnrollErrorNum(Context ctx, String adminFilter, String hrOrgFilter) throws BOSException, SQLException {
        String sql = CmpIntelBoardSql.getAdjEnrollErrorNumNumSql(adminFilter, hrOrgFilter);
        int num = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            num = rs.getInt("num");
        }
        return num;
    }

    private int getCmpUnAuditEmpOrgRelationNum(Context ctx, String adminFilter, String hrOrgFilter) throws BOSException, SQLException {
        String sql = CmpIntelBoardSql.getCmpUnAuditEmpOrgRelationNumSql(adminFilter, hrOrgFilter);
        int num = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            num = rs.getInt("num");
        }
        return num;
    }

    private int getAdjUnAuditEmpOrgRelationNum(Context ctx, String adminFilter, String hrOrgFilter) throws BOSException, SQLException {
        String sql = CmpIntelBoardSql.getAdjUnAuditEmpOrgRelationNumSql(adminFilter, hrOrgFilter);
        int num = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            num = rs.getInt("num");
        }
        return num;
    }

    private int getSocNoOrgRelNum(Context ctx, String adminFilter, String hrOrgFilter) throws BOSException, SQLException {
        String sql = CmpIntelBoardSql.getSocNoOrgRelNumSql(adminFilter, hrOrgFilter);
        int num = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            num = rs.getInt("num");
        }
        return num;
    }

    private Map<String, Object> buildNomatchMap(Context ctx, int bizType, String adminFilter, String hrFilter, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = 0;
        String uipk = "";
        String label = "";
        String permItemId = "";
        String subCat = "";
        if (bizType == 1) {
            subCat = "CMP_PER";
        } else if (bizType == 3) {
            subCat = "SOC_PER";
        } else if (bizType == 2) {
            subCat = "ADJ_PER";
        }
        Map<Integer, String> catNameMap = this.getBizTypeNoMatchCatNameMap(ctx);
        Map<Integer, String> uipkMap = this.getBizTypeNoMatchUipkMap();
        String bizTypeStr = bizTypeMap.get(bizType);
        Map<Integer, String> permMap = this.getBizTypeMatchPermMap();
        label = catNameMap.get(bizType);
        count = this.getNomatchDataNum(ctx, bizTypeStr, adminFilter, hrFilter);
        uipk = uipkMap.get(bizType);
        permItemId = permMap.get(bizType);
        map.put("label", label);
        map.put("count", count);
        map.put("catalogId", "");
        map.put("uipk", uipk);
        map.put("permItemId", permItemId);
        map.put("bizType", bizType);
        map.put("subCat", subCat);
        return map;
    }

    private int getNomatchDataNum(Context ctx, String bizType, String adminFilter, String hrOrgFilter) throws SQLException, BOSException {
        String sql = CmpIntelBoardSql.getNoMatchDataNumSql(adminFilter, hrOrgFilter);
        int num = 0;
        IRowSet noMatchRs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bizType});
        if (noMatchRs.next()) {
            num = noMatchRs.getInt("num");
        }
        return num;
    }

    private Map<Integer, String> getBizTypeNoMatchCatNameMap(Context ctx) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"CMP_NOMATCH", (Locale)ctx.getLocale()));
        map.put(3, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"SOC_NOMATCH", (Locale)ctx.getLocale()));
        map.put(2, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"ADJ_NOMATCH", (Locale)ctx.getLocale()));
        return map;
    }

    private Map<Integer, String> getBizTypeEnrollErrorMap(Context ctx) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"CMP_ENROLLERROR", (Locale)ctx.getLocale()));
        map.put(2, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"ADJ_ENROLLERROR", (Locale)ctx.getLocale()));
        return map;
    }

    private Map<Integer, String> getBizTypeUnAuditEmpOrgRelationMap(Context ctx) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"CMP_UNAUDITEMPORGRELATION", (Locale)ctx.getLocale()));
        map.put(2, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"ADJ_UNAUDITEMPORGRELATION", (Locale)ctx.getLocale()));
        return map;
    }

    private Map<Integer, String> getBizTypeSocNoOrgRelMap(Context ctx) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(3, EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"SOC_NOORGREL", (Locale)ctx.getLocale()));
        return map;
    }

    private Map<Integer, String> getBizTypeMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "CMP02");
        map.put(2, "CMP01");
        map.put(3, "CMP03");
        return map;
    }

    private Map<Integer, String> getBizTypeMatchUipkMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "com.kingdee.shr.compensation.app.intelligent.cmpMatchResult.list");
        map.put(3, "com.kingdee.shr.compensation.app.intelligent.socMatchResult.list");
        map.put(2, "com.kingdee.shr.compensation.app.intelligent.adjMatchResult.list");
        return map;
    }

    private Map<Integer, String> getBizTypeNoMatchUipkMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "com.kingdee.shr.base.bizmanage.app.PersonBURelaConfirm.cmpNoMatchData.flowIn.list");
        map.put(3, "com.kingdee.shr.base.bizmanage.app.PersonBURelaConfirm.socNoMatchData.flowIn.list");
        map.put(2, "com.kingdee.shr.base.bizmanage.app.PersonBURelaConfirm.adjNoMatchData.flowIn.list");
        return map;
    }

    private Map<Integer, String> getBizTypeEnrollErrorUipkMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "shr.compensation.EnrollError.list");
        map.put(2, "shr.cmpdesign.EnrollError.list");
        return map;
    }

    private Map<Integer, String> getBizTypeUnAuditEmpOrgRelationUipkMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "shr.compensation.UnAuditEmpOrgRelation.list");
        map.put(2, "shr.cmpdesign.UnAuditEmpOrgRelation.list");
        return map;
    }

    private Map<Integer, String> getBizTypeSocNoOrgRelUipkMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(3, "shr.socialSecurity.noOrgRel.list");
        return map;
    }

    private Map<Integer, String> getBizTypeMatchPermMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "fffffff0-ffff-efff-8e9a-00000164d298PERMITEM");
        map.put(3, "fffffff0-ffff-efff-8e9a-00000164d36dPERMITEM");
        map.put(2, "fffffff0-ffff-efff-e22e-0000000320d1PERMITEM");
        map.put(4, "fffffff0-ffff-efff-e22e-00000002ee16PERMITEM");
        return map;
    }

    private Map<Integer, String> getEnrollErrorBizTypePermMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "fffffff0-ffff-efff-8e9a-000001641c10PERMITEM");
        map.put(2, "fffffff0-ffff-efff-8e9a-000001641c10PERMITEM");
        return map;
    }

    private Map<Integer, String> getSocNoOrgRelBizTypePermMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(3, "fffffff0-ffff-efff-8e9a-000001641c10PERMITEM");
        return map;
    }

    private Map<Integer, String> getUnAuditEmpOrgRelationBizTypePermMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "fffffff0-ffff-efff-8e9a-000001641c10PERMITEM");
        map.put(2, "fffffff0-ffff-efff-8e9a-000001641c10PERMITEM");
        return map;
    }

    @Override
    protected List _getForewarnData(Context ctx) throws BOSException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<Object> cmpEnrollErrorCount = new ArrayList();
        List<Object> adjEnrollErrorCount = new ArrayList();
        List<Object> cmpUnAuditEmpOrgRelationCount = new ArrayList();
        List<Object> adjUnAuditEmpOrgRelationCount = new ArrayList();
        List<Object> socNoOrgRelCount = new ArrayList();
        try {
            cmpEnrollErrorCount = this.getErrorCount(ctx, 1, bizUipkMap, bizTypeMap);
            adjEnrollErrorCount = this.getErrorCount(ctx, 2, bizUipkMap, bizTypeMap);
            cmpUnAuditEmpOrgRelationCount = this.getUnAuditEmpOrgRelationCount(ctx, 1, bizUipkMap, bizTypeMap);
            adjUnAuditEmpOrgRelationCount = this.getUnAuditEmpOrgRelationCount(ctx, 2, bizUipkMap, bizTypeMap);
            socNoOrgRelCount = this.getSocNoOrgRelCount(ctx, 3, bizUipkMap, bizTypeMap);
            cmpEnrollErrorCount.addAll(adjEnrollErrorCount);
            cmpEnrollErrorCount.addAll(cmpUnAuditEmpOrgRelationCount);
            cmpEnrollErrorCount.addAll(adjUnAuditEmpOrgRelationCount);
            cmpEnrollErrorCount.addAll(socNoOrgRelCount);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cmpEnrollErrorCount;
    }

    private List<Map<String, Object>> getSocNoOrgRelCount(Context ctx, int bizType, Map<Integer, String> bizUipkMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = 0;
        String uipk = "";
        String label = "";
        Map<Integer, String> permMap = this.getSocNoOrgRelBizTypePermMap();
        String permItemId = permMap.get(bizType);
        String adminFilter = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgFilter = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        Map<Integer, String> catNameMap = this.getBizTypeSocNoOrgRelMap(ctx);
        Map<Integer, String> uipkMap = this.getBizTypeSocNoOrgRelUipkMap();
        label = catNameMap.get(bizType);
        count = this.getSocNoOrgRelNum(ctx, adminFilter, hrOrgFilter);
        uipk = uipkMap.get(bizType);
        permItemId = permMap.get(bizType);
        map.put("label", label);
        map.put("count", count);
        map.put("bizType", bizType);
        map.put("uipk", uipk);
        map.put("permItemId", permItemId);
        result.add(map);
        return result;
    }

    private List<Map<String, Object>> getUnAuditEmpOrgRelationCount(Context ctx, int bizType, Map<Integer, String> bizUipkMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = 0;
        String uipk = "";
        String label = "";
        Map<Integer, String> permMap = this.getUnAuditEmpOrgRelationBizTypePermMap();
        String permItemId = permMap.get(bizType);
        String adminFilter = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgFilter = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        Map<Integer, String> catNameMap = this.getBizTypeUnAuditEmpOrgRelationMap(ctx);
        Map<Integer, String> uipkMap = this.getBizTypeUnAuditEmpOrgRelationUipkMap();
        label = catNameMap.get(bizType);
        if (bizType == 1) {
            count = this.getCmpUnAuditEmpOrgRelationNum(ctx, adminFilter, hrOrgFilter);
        } else if (bizType == 2) {
            count = this.getAdjUnAuditEmpOrgRelationNum(ctx, adminFilter, hrOrgFilter);
        }
        uipk = uipkMap.get(bizType);
        permItemId = permMap.get(bizType);
        map.put("label", label);
        map.put("count", count);
        map.put("bizType", bizType);
        map.put("uipk", uipk);
        map.put("permItemId", permItemId);
        result.add(map);
        return result;
    }

    private List<Map<String, Object>> getErrorCount(Context ctx, int bizType, Map<Integer, String> bizUipkMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = 0;
        String uipk = "";
        String label = "";
        Map<Integer, String> permMap = this.getEnrollErrorBizTypePermMap();
        String permItemId = permMap.get(bizType);
        String hrOrgFilter = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminFilter = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        Map<Integer, String> catNameMap = this.getBizTypeEnrollErrorMap(ctx);
        Map<Integer, String> uipkMap = this.getBizTypeEnrollErrorUipkMap();
        label = catNameMap.get(bizType);
        if (bizType == 1) {
            count = this.getCmpEnrollErrorNum(ctx, adminFilter, hrOrgFilter);
        } else if (bizType == 2) {
            count = this.getAdjEnrollErrorNum(ctx, adminFilter, hrOrgFilter);
        }
        uipk = uipkMap.get(bizType);
        permItemId = permMap.get(bizType);
        map.put("label", label);
        map.put("count", count);
        map.put("catalogId", "");
        map.put("bizType", bizType);
        map.put("uipk", uipk);
        map.put("permItemId", permItemId);
        result.add(map);
        return result;
    }

    @Override
    protected List _getCmpConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getConfirmDataCount(ctx, 1, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }

    @Override
    protected List _getCmpNoConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getNoConfirmDataCount(ctx, 1, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }

    @Override
    protected List _getSocConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getConfirmDataCount(ctx, 3, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }

    @Override
    protected List _getSocNoConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getNoConfirmDataCount(ctx, 3, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }

    private List<Map<String, Object>> getConfirmDataCount(Context ctx, int bizType, List<String> visibleCards, Map<Integer, String> bizUipkMap, Map<Integer, String> bizPermMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        String sql;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String permItemId = bizPermMap.get(bizType);
        String adminFilter = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgFilter = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        if (StringUtils.isEmpty((CharSequence)hrOrgFilter)) {
            hrOrgFilter = "''";
        }
        if (StringUtils.isEmpty((CharSequence)adminFilter)) {
            adminFilter = "''";
        }
        if (bizType == 4) {
            sql = CmpIntelBoardSql.getTaxConfirmDataSql(adminFilter, hrOrgFilter, ctx);
        } else {
            String bizManageType = bizTypeMap.get(bizType);
            sql = CmpIntelBoardSql.getConfirmDataSql(adminFilter, hrOrgFilter, bizType, bizManageType, ctx);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String catalogId = "";
        String catalogName = "";
        String matchDataUipk = "";
        String matchDataPerm = "";
        String subCat = "";
        int num = 0;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        while (rs.next()) {
            catalogId = rs.getString("fid");
            catalogName = rs.getString("name");
            num = rs.getInt("num");
            subCat = rs.getString("FSubCat");
            if (!visibleCards.contains(catalogName) || CmpStrUtil.isEmpty(catalogName)) continue;
            matchDataUipk = bizUipkMap.get(bizType);
            matchDataPerm = bizPermMap.get(bizType);
            if (CmpIntelConstant.catalogIdUipkMap.containsKey(catalogId)) {
                matchDataUipk = CmpIntelConstant.catalogIdUipkMap.get(catalogId);
            }
            if (catalogId.equals("fVa9WCKmTEWBgtswxQH45gB4WXA=")) {
                matchDataUipk = "com.kingdee.shr.compensation.app.intelligent.CmpIntelSynOrgPosition.list";
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)CmpIntelBoardSql.getSynOrgPosiNum(ctx, adminFilter, hrOrgFilter, permItemId));
                while (rs2.next()) {
                    num = rs2.getInt("num");
                }
            }
            try {
                catalogId = URLEncoder.encode(catalogId, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            dataMap = new HashMap();
            dataMap.put("label", catalogName);
            dataMap.put("count", num);
            dataMap.put("catalogId", catalogId);
            dataMap.put("uipk", matchDataUipk);
            dataMap.put("permItemId", matchDataPerm);
            dataMap.put("bizType", bizType);
            dataMap.put("subCat", subCat);
            result.add(dataMap);
        }
        return result;
    }

    private List<Map<String, Object>> getNoConfirmDataCount(Context ctx, int bizType, List<String> visibleCards, Map<Integer, String> bizUipkMap, Map<Integer, String> bizPermMap, Map<Integer, String> bizTypeMap) throws BOSException, SQLException {
        Map<String, Object> noMatchMap;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String permItemId = bizPermMap.get(bizType);
        String adminFilter = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgFilter = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        if (StringUtils.isEmpty((CharSequence)hrOrgFilter)) {
            hrOrgFilter = "''";
        }
        if (StringUtils.isEmpty((CharSequence)adminFilter)) {
            adminFilter = "''";
        }
        if ((noMatchMap = this.buildNomatchMap(ctx, bizType, adminFilter, hrOrgFilter, bizTypeMap)).get("label") != null && !StringUtils.isEmpty((CharSequence)noMatchMap.get("label").toString())) {
            result.add(noMatchMap);
        }
        return result;
    }

    @Override
    protected List _getAdjConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getConfirmDataCount(ctx, 2, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }

    @Override
    protected List _getAdjNoConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getNoConfirmDataCount(ctx, 2, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }

    @Override
    protected List _getTaxConfirmData(Context ctx) throws BOSException, EASBizException {
        Map<Integer, String> bizUipkMap = this.getBizTypeMatchUipkMap();
        Map<Integer, String> bizPermMap = this.getBizTypeMatchPermMap();
        Map<Integer, String> bizTypeMap = this.getBizTypeMap();
        List<String> visibleCards = CmpIntelBoardUtil.getVisibleCards(ctx);
        List<Object> countList = new ArrayList();
        try {
            countList = this.getConfirmDataCount(ctx, 4, visibleCards, bizUipkMap, bizPermMap, bizTypeMap);
            for (Map map : countList) {
                if (!URLEncoder.encode("wus2oLDetUG53juFxau19wB4WXA=", "utf-8").equals(map.get("catalogId").toString())) continue;
                String permItemId = bizPermMap.get(4);
                String calTableFilter = CmpIntelBoardUtil.getCalTableDataRange(ctx, permItemId);
                String sql = "select count(*) num from T_HR_SCmpSynTaxMatchLog where FCmpCalTableID in (" + calTableFilter + ")";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (!rs.next()) continue;
                map.put("count", rs.getInt("num"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return countList;
    }
}

