/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.intelligent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.intelligent.AbstractCmpIntelligentEntryFacadeControllerBean;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryInfo;
import com.kingdee.shr.compensation.intelligent.dto.MatchEntry;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelSyncTaxUnitJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpSyncOrgPositionBean;
import com.kingdee.shr.compensation.intelligent.dto.json.Scheme;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class CmpIntelligentEntryFacadeControllerBean
extends AbstractCmpIntelligentEntryFacadeControllerBean {
    private static final long serialVersionUID = -8582677917554826820L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.intelligent.CmpIntelligentEntryFacadeControllerBean");
    private static final String CMP_TYPE = "cmpType";
    private static final String SOC_CATEGORY = "socCategory";
    private static final String ID = "id";

    @Override
    protected void _permissionVerification(Context ctx, Map param) throws BOSException {
        List<Object[]> paramsList = this.getParamList(ctx, param);
        this.updateRuleEntry(ctx, paramsList);
    }

    @Override
    protected boolean _changeOrgUnitVerify(Context ctx, Map param) throws BOSException {
        List<Object[]> paramsList = this.getParamList(ctx, param);
        return !CollectionUtils.isEmpty(paramsList);
    }

    private List<Object[]> getParamList(Context ctx, Map param) throws BOSException {
        String ruleId = (String)param.get("ruleId");
        String hrOrgId = (String)param.get("hrOrgId");
        Set<String> salarySystemIds = this.getalarySystemIds(ctx, hrOrgId);
        Set<String> socCategoryIds = this.getSocCategoryIds(ctx, hrOrgId);
        String oql = " where cmpIntelRule = '" + ruleId + "'";
        CmpIntelEntryCollection entryColl = CmpIntelEntryFactory.getLocalInstance(ctx).getCmpIntelEntryCollection(oql);
        return this.verifyRuleEntry(ctx, salarySystemIds, socCategoryIds, entryColl);
    }

    protected List<Object[]> verifyRuleEntry(Context ctx, Set<String> salarySystemIds, Set<String> socCategoryIds, CmpIntelEntryCollection entryColl) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < entryColl.size(); ++i) {
            CmpIntelEntryInfo info = entryColl.get(i);
            if (info == null || info.getCmpIntelCatalog() == null || info.getCmpIntelCatalog().getId() == null || info.getData() == null || info.getId() == null) continue;
            String cataLogId = info.getCmpIntelCatalog().getId().toString();
            String fid = info.getId().toString();
            String data = info.getData();
            String newData = "";
            switch (cataLogId) {
                case "ecnRgrVrakexjc9fhpQpwwB4WXA=": {
                    newData = this.verifySocPerson(data, socCategoryIds);
                    break;
                }
                case "4zLXKaEJukGwTPFYcVyZlQB4WXA=": {
                    newData = this.verifySocPerson(data, socCategoryIds);
                    break;
                }
                case "zAOYO3uW+E+4twZ3xNBPrgB4WXA=": {
                    newData = this.verifyScheme(data);
                    break;
                }
                case "UF3MyIHT8EaBGOoGPuo7GwB4WXA=": {
                    newData = this.verifyScheme(data);
                    break;
                }
                case "fVa9WCKmTEWBgtswxQH45gB4WXA=": {
                    newData = this.verifySyncOrgPosition(data);
                    break;
                }
                case "bhO18GJPsUGlp1aMQNubhAB4WXA=": {
                    newData = this.verifyClassificationChange(data, salarySystemIds);
                    break;
                }
                case "wus2oLDetUG53juFxau19wB4WXA=": {
                    newData = this.verifyTaxUnitPersonSync(data);
                    break;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)newData)) continue;
            Object[] param = new Object[]{newData, fid};
            paramsList.add(param);
        }
        return paramsList;
    }

    protected String verifyTaxUnitPersonSync(String data) {
        CmpItelSyncTaxUnitJsonBean bean = CmpIntelligentUtil.getJsonObj(data, new CmpItelSyncTaxUnitJsonBean());
        if (bean == null || CollectionUtils.isEmpty(bean.getScheme())) {
            return "";
        }
        for (Scheme scheme : bean.getScheme()) {
            String idStr = CmpIntelligentUtil.uriDecode(scheme.getId());
            if (StringUtils.isBlank((CharSequence)idStr)) continue;
            bean.setScheme(new ArrayList<Scheme>());
            return CmpIntelligentUtil.changeObjToJson(bean);
        }
        return "";
    }

    protected String verifyClassificationChange(String data, Set<String> salarySystemIds) {
        MatchEntry entry = CmpIntelligentUtil.getJsonObj(data, new MatchEntry());
        if (entry == null || entry.getTarget() == null) {
            return "";
        }
        Map<String, Object> targetMap = entry.getTarget();
        String condition = (String)targetMap.get(CMP_TYPE);
        String cmpSalaryId = "";
        if (CmpStrUtil.isNotEmpty(condition)) {
            cmpSalaryId = condition.substring(0, condition.lastIndexOf("_"));
            if (!salarySystemIds.contains(cmpSalaryId = CmpIntelligentUtil.uriDecode(cmpSalaryId))) {
                targetMap.put(CMP_TYPE, "");
                entry.setTarget(targetMap);
                return CmpIntelligentUtil.changeObjToJson(entry);
            }
        }
        return "";
    }

    protected String verifySyncOrgPosition(String data) {
        CmpSyncOrgPositionBean bean = CmpIntelligentUtil.getJsonObj(data, new CmpSyncOrgPositionBean());
        if (bean == null || CollectionUtils.isEmpty(bean.getScheme())) {
            return "";
        }
        for (Scheme scheme : bean.getScheme()) {
            String idStr = CmpIntelligentUtil.uriDecode(scheme.getId());
            if (StringUtils.isBlank((CharSequence)idStr)) continue;
            bean.setScheme(new ArrayList<Scheme>());
            return CmpIntelligentUtil.changeObjToJson(bean);
        }
        return "";
    }

    protected String verifyScheme(String data) {
        CmpItelJsonBean bean = CmpIntelligentUtil.getJsonObj(data, new CmpItelJsonBean());
        if (bean == null || CollectionUtils.isEmpty(bean.getScheme())) {
            return "";
        }
        for (Scheme scheme : bean.getScheme()) {
            String idStr = CmpIntelligentUtil.uriDecode(scheme.getId());
            if (StringUtils.isBlank((CharSequence)idStr)) continue;
            bean.setScheme(new ArrayList<Scheme>());
            return CmpIntelligentUtil.changeObjToJson(bean);
        }
        return "";
    }

    protected String verifySocPerson(String data, Set<String> socCategoryIds) {
        MatchEntry entry = CmpIntelligentUtil.getJsonObj(data, new MatchEntry());
        if (entry == null || entry.getOrigin() == null || entry.getTarget() == null) {
            return "";
        }
        boolean resetflag = false;
        Map<String, Object> targetMap = entry.getTarget();
        JSONObject entryJson = JSONObject.parseObject((String)data);
        Object obj = CmpIntelligentUtil.getObjectByKey(entryJson, "target.socCategory");
        if (obj == null) {
            return "";
        }
        if (obj instanceof JSONArray) {
            resetflag = this.parseSocData(socCategoryIds, entry, resetflag, targetMap);
        } else if (obj instanceof String) {
            resetflag = this.parseHistorySocData(socCategoryIds, entry, resetflag, targetMap);
        }
        return resetflag ? CmpIntelligentUtil.changeObjToJson(entry) : "";
    }

    private boolean parseSocData(Set<String> socCategoryIds, MatchEntry entry, boolean resetflag, Map<String, Object> targetMap) {
        List targertList = (List)targetMap.get(SOC_CATEGORY);
        String socCategoryId = "";
        for (int i = 0; i < targertList.size(); ++i) {
            Map map = (Map)targertList.get(i);
            if (map == null || !map.containsKey(ID)) continue;
            socCategoryId = (String)map.get(ID);
            if (socCategoryIds.contains(socCategoryId = CmpIntelligentUtil.uriDecode(socCategoryId))) continue;
            targetMap.put(SOC_CATEGORY, new ArrayList());
            entry.setTarget(targetMap);
            resetflag = true;
        }
        return resetflag;
    }

    private boolean parseHistorySocData(Set<String> socCategoryIds, MatchEntry entry, boolean resetflag, Map<String, Object> targetMap) {
        String condition = (String)targetMap.get(SOC_CATEGORY);
        String socCategoryId = "";
        if (CmpStrUtil.isNotEmpty(condition) && condition.indexOf("_") > -1) {
            socCategoryId = condition.substring(0, condition.lastIndexOf("_"));
            if (!socCategoryIds.contains(socCategoryId = CmpIntelligentUtil.uriDecode(socCategoryId))) {
                targetMap.put(SOC_CATEGORY, new ArrayList());
                entry.setTarget(targetMap);
                resetflag = true;
            }
        }
        return resetflag;
    }

    private Set<String> getSocCategoryIds(Context ctx, String hrOrgId) throws BOSException {
        StringBuilder bu = new StringBuilder();
        int disatributeState = 100;
        bu.append(" SELECT tem.Fid Fid FROM T_HR_SSocCategoryRelHR relHr ");
        bu.append(" INNER join T_HR_SSocCategory tem on  relHr.FBaseInfoId = tem.Fid ");
        bu.append(" INNER join T_BS_SHRBasicItem basic on tem.FShrBasicItemId = basic.Fid ");
        bu.append(" where relHr.FHRORGUSEID = '").append(hrOrgId).append("' and relHr.FSTATE = ").append(disatributeState).append(" and tem.FSTATE = 1 and basic.FSTATE = 1 ");
        return this.getFidSet(ctx, bu.toString());
    }

    private Set<String> getalarySystemIds(Context ctx, String hrOrgId) throws BOSException {
        StringBuilder bu = new StringBuilder();
        int disatributeState = 100;
        bu.append(" SELECT tem.Fid Fid FROM T_HR_SCmpSalarySystemRelHR relHr ");
        bu.append(" INNER join T_HR_SCmpSalarySystem tem on  relHr.FBaseInfoId = tem.Fid ");
        bu.append(" INNER join T_BS_SHRBasicItem basic on tem.FShrBasicItemId = basic.Fid ");
        bu.append(" where relHr.FHRORGUSEID = '").append(hrOrgId).append("' and relHr.FSTATE = ").append(disatributeState).append("  and tem.FSTATE = 1 and basic.FSTATE = 1 ");
        return this.getFidSet(ctx, bu.toString());
    }

    protected void updateRuleEntry(Context ctx, List<Object[]> paramsList) throws BOSException {
        if (!CollectionUtils.isEmpty(paramsList)) {
            String updateSql = "update T_HR_ScmpIntelEntry set Fdata=? where fid=?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
        }
    }

    private Set<String> getFidSet(Context ctx, String sql) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String fid = rs.getString("FID");
                set.add(fid);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getFidSet BOSException :", (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)"getFidSet SQLException :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return set;
    }
}

