/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.intelligent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.hraux.NationalityInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.DeductFeesEnum;
import com.kingdee.shr.compensation.EmployedTypeEnum;
import com.kingdee.shr.compensation.IdentityStatusEnume;
import com.kingdee.shr.compensation.IsOverseaEnum;
import com.kingdee.shr.compensation.PayerTypeEnum;
import com.kingdee.shr.compensation.PersonStatusEnum;
import com.kingdee.shr.compensation.SubmitStatusEnum;
import com.kingdee.shr.compensation.TaxReasonEnum;
import com.kingdee.shr.compensation.app.incomeTax.EmploymentSituationEnum;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordInfo;
import com.kingdee.shr.compensation.app.intelligent.AbstractCmpTaxFacadeControllerBean;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.intelligent.dto.PersonTaxRecord;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.TaxReportUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpTaxFacadeControllerBean
extends AbstractCmpTaxFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.intelligent.CmpTaxFacadeControllerBean");
    private static final String existedPersonRecordEntryKey = "personRecordEntryKey";
    private static final String existedPersonRecordKey = "personRecordKey";
    private static final String existedPersonKey = "personKey";

    @Override
    protected BatchMessageTipsHeader _genPersonDeclaration(Context ctx, String param) throws BOSException {
        PersonTaxRecord personTaxRecord = (PersonTaxRecord)JSONUtils.convertJsonToObject((Context)ctx, (String)param, PersonTaxRecord.class);
        Map selectedIdMap = personTaxRecord.getSelectedIds();
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        try {
            HashSet<String> taxUnitSet = new HashSet<String>();
            HashSet<String> personSet = new HashSet<String>();
            for (Map.Entry entry : selectedIdMap.entrySet()) {
                String[] arr = ((String)entry.getValue()).split("_");
                taxUnitSet.add(arr[0]);
                personSet.add(arr[1]);
            }
            String taxUnitIdSql = cmpInSql.createInSqlBaseOnFId(ctx, taxUnitSet);
            String personIdSql = cmpInSql.createInSqlBaseOnFId(ctx, personSet);
            Map<String, Map<String, CoreBaseInfo>> personDeclarationMap = this.initPersonDeclaration(ctx, taxUnitIdSql, personIdSql);
            BatchMessageTipsHeader batchMessageTipsHeader = this.dealWithPersonDeclaration(ctx, selectedIdMap, personDeclarationMap, personTaxRecord);
            return batchMessageTipsHeader;
        }
        catch (Exception e) {
            logger.error((Object)"_genPersonDeclaration error: ", (Throwable)e);
            throw new BOSException("Failed to generate person declaration, caused by: " + e.getMessage());
        }
        finally {
            cmpInSql.release(ctx);
        }
    }

    private Map<String, Map<String, CoreBaseInfo>> initPersonDeclaration(Context ctx, String taxUnitIdSql, String personIdSql) throws BOSException {
        HashMap<String, Map<String, CoreBaseInfo>> personDeclarationMap = new HashMap<String, Map<String, CoreBaseInfo>>();
        this.initPersonRecordEntryData(ctx, taxUnitIdSql, personIdSql, personDeclarationMap);
        this.initPersonRecordData(ctx, personIdSql, personDeclarationMap);
        this.initPersonData(ctx, personIdSql, personDeclarationMap);
        return personDeclarationMap;
    }

    private void initPersonData(Context ctx, String personIdSql, Map<String, Map<String, CoreBaseInfo>> personDeclarationMap) throws BOSException {
        HashMap<String, PersonOtherInfoInfo> coreBaseInfoMap = new HashMap<String, PersonOtherInfoInfo>();
        String personSql = "select person.id, person.gender, person.birthday, person.email, person.address, person.homePlace, person.cell, person.idCardNo, person.passportNo, person.nationality, person.name, person.number, person.highestDegree, credentialsType.name where person.id in " + personIdSql;
        PersonOtherInfoCollection personCollection = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection(personSql);
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonOtherInfoInfo personOtherInfo = personCollection.get(i);
            PersonInfo personInfo = personOtherInfo.getPerson();
            coreBaseInfoMap.put(personInfo.getId().toString(), personOtherInfo);
        }
        personDeclarationMap.put(existedPersonKey, coreBaseInfoMap);
    }

    private void initPersonRecordData(Context ctx, String personIdSql, Map<String, Map<String, CoreBaseInfo>> personDeclarationMap) throws BOSException {
        HashMap<String, TaxPersonRecordInfo> coreBaseInfoMap = new HashMap<String, TaxPersonRecordInfo>();
        String personRecordSql = "select id where person.id in " + personIdSql;
        TaxPersonRecordCollection existedPersonRecordCollection = TaxPersonRecordFactory.getLocalInstance(ctx).getTaxPersonRecordCollection(personRecordSql);
        for (int i = 0; i < existedPersonRecordCollection.size(); ++i) {
            TaxPersonRecordInfo billInfo = existedPersonRecordCollection.get(i);
            coreBaseInfoMap.put(billInfo.getPerson().getId().toString(), billInfo);
        }
        personDeclarationMap.put(existedPersonRecordKey, coreBaseInfoMap);
    }

    private void initPersonRecordEntryData(Context ctx, String taxUnitIdSql, String personIdSql, Map<String, Map<String, CoreBaseInfo>> personDeclarationMap) throws BOSException {
        HashMap<String, TaxPersonRecordEntryInfo> coreBaseInfoMap = new HashMap<String, TaxPersonRecordEntryInfo>();
        String personRecordEntrySql = "select id, submitStatus where taxUnit.id in " + taxUnitIdSql + " and person.id in " + personIdSql;
        TaxPersonRecordEntryCollection existedPersonRecordEntryCollection = TaxPersonRecordEntryFactory.getLocalInstance(ctx).getTaxPersonRecordEntryCollection(personRecordEntrySql);
        for (int i = 0; i < existedPersonRecordEntryCollection.size(); ++i) {
            TaxPersonRecordEntryInfo entryInfo = existedPersonRecordEntryCollection.get(i);
            coreBaseInfoMap.put(entryInfo.getTaxUnit().getId() + "_" + entryInfo.getPerson().getId(), entryInfo);
        }
        personDeclarationMap.put(existedPersonRecordEntryKey, coreBaseInfoMap);
    }

    private BatchMessageTipsHeader dealWithPersonDeclaration(Context ctx, Map<String, String> selectedIdMap, Map<String, Map<String, CoreBaseInfo>> personDeclarationMap, PersonTaxRecord personTaxRecord) throws BOSException {
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        try {
            HashSet<String> taxUnitPersonSet = new HashSet<String>();
            HashSet<String> successSet = new HashSet<String>();
            Map<String, CoreBaseInfo> existedPersonRecordEntryMap = personDeclarationMap.get(existedPersonRecordEntryKey);
            Map<String, CoreBaseInfo> existedPersonRecordMap = personDeclarationMap.get(existedPersonRecordKey);
            Map<String, CoreBaseInfo> existedPersonMap = personDeclarationMap.get(existedPersonKey);
            CoreBaseCollection entryCollection = new CoreBaseCollection();
            CoreBaseCollection billCollection = new CoreBaseCollection();
            StringBuilder billId = new StringBuilder();
            int success = 0;
            int failure = 0;
            for (Map.Entry<String, String> entry : selectedIdMap.entrySet()) {
                TaxPersonRecordInfo billInfo;
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                String id = entry.getKey();
                body.setId(id);
                billId.append(id).append(",");
                String[] arr = entry.getValue().split("_");
                String taxUnitPersonKey = arr[0] + "_" + arr[1];
                String personKey = arr[1];
                PersonOtherInfoInfo personOtherInfo = (PersonOtherInfoInfo)existedPersonMap.get(personKey);
                TaxPersonRecordEntryInfo entryInfo = (TaxPersonRecordEntryInfo)existedPersonRecordEntryMap.get(taxUnitPersonKey);
                if (!"10".equals(arr[2])) {
                    ++failure;
                    body.setMuitTipsState(Boolean.FALSE.booleanValue());
                    body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label101", (Locale)ctx.getLocale()));
                    batchMessageTipsHeader.addResult(body);
                    continue;
                }
                if (entryInfo != null) {
                    if (SubmitStatusEnum.Submiting == entryInfo.getSubmitStatus()) {
                        ++failure;
                        body.setMuitTipsState(Boolean.FALSE.booleanValue());
                        body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label60", (Locale)ctx.getLocale()));
                        batchMessageTipsHeader.addResult(body);
                        continue;
                    }
                    if (taxUnitPersonSet.contains(taxUnitPersonKey)) {
                        ++success;
                        body.setMuitTipsState(Boolean.TRUE.booleanValue());
                        body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label61", (Locale)ctx.getLocale()));
                        batchMessageTipsHeader.addResult(body);
                        successSet.add(id);
                        continue;
                    }
                    billInfo = (TaxPersonRecordInfo)existedPersonRecordMap.get(personKey);
                    taxUnitPersonSet.add(taxUnitPersonKey);
                } else {
                    if (!existedPersonRecordMap.containsKey(personKey)) {
                        String errStr = this.verifyPersonRecord(ctx, personOtherInfo);
                        if (!StringUtils.isEmpty((String)errStr)) {
                            ++failure;
                            body.setMuitTipsState(Boolean.FALSE.booleanValue());
                            body.setMuitTipsMessage(errStr);
                            batchMessageTipsHeader.addResult(body);
                            continue;
                        }
                        billInfo = new TaxPersonRecordInfo();
                    } else {
                        billInfo = (TaxPersonRecordInfo)existedPersonRecordMap.get(personKey);
                    }
                    entryInfo = new TaxPersonRecordEntryInfo();
                }
                this.initPersonRecord(billCollection, billInfo, personOtherInfo, personTaxRecord);
                this.initPersonRecordEntry(entryCollection, entryInfo, billInfo, arr, personTaxRecord);
                ++success;
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label61", (Locale)ctx.getLocale()));
                batchMessageTipsHeader.addResult(body);
                successSet.add(id);
            }
            this.saveCmpTaxData(ctx, billCollection, entryCollection, successSet);
            billId.deleteCharAt(billId.length() - 1);
            batchMessageTipsHeader.setBillId(billId.toString());
            batchMessageTipsHeader.setSuccessCount(success);
            batchMessageTipsHeader.setFailureCount(failure);
            return batchMessageTipsHeader;
        }
        catch (Exception e) {
            logger.error((Object)"dealWithPersonDeclaration error: ", (Throwable)e);
            throw new BOSException("Failed to dealWith person declaration, caused by: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCmpTaxData(Context ctx, CoreBaseCollection billCollection, CoreBaseCollection entryCollection, Set<String> successSet) {
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        try {
            if (billCollection.size() > 0) {
                TaxPersonRecordFactory.getLocalInstance(ctx).saveBatchData(billCollection);
            }
            if (entryCollection.size() > 0) {
                TaxPersonRecordEntryFactory.getLocalInstance(ctx).saveBatchData(entryCollection);
            }
            if (successSet.size() > 0) {
                this.setConfirmed(ctx, successSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)"saveCmpTaxData error: ", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            cmpInSql.release(ctx);
        }
    }

    private void initPersonRecordEntry(CoreBaseCollection entryCollection, TaxPersonRecordEntryInfo entryInfo, TaxPersonRecordInfo billInfo, String[] arr, PersonTaxRecord personTaxRecord) throws ParseException {
        String handleDate;
        if (null == entryInfo.getId()) {
            String taxUnitKey = arr[0];
            String personKey = arr[1];
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personKey));
            entryInfo.setPerson(personInfo);
            TaxUnitInfo taxUnitInfo = new TaxUnitInfo();
            taxUnitInfo.setId(BOSUuid.read((String)taxUnitKey));
            entryInfo.setTaxUnit(taxUnitInfo);
            entryInfo.setBill(billInfo);
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        }
        if (null != personTaxRecord.getDeductFees()) {
            entryInfo.setDeductFees(DeductFeesEnum.getEnum(personTaxRecord.getDeductFees()));
        }
        if (null != personTaxRecord.getEmployedType()) {
            entryInfo.setEmployedType(EmployedTypeEnum.getEnum(personTaxRecord.getEmployedType()));
        }
        if (null != personTaxRecord.getPayerType()) {
            entryInfo.setPayerType(PayerTypeEnum.getEnum(personTaxRecord.getPayerType()));
        }
        if (null != personTaxRecord.getSituation()) {
            entryInfo.setSituation(EmploymentSituationEnum.getEnum(Integer.parseInt(personTaxRecord.getSituation())));
        }
        if (!StringUtils.isEmpty((String)(handleDate = arr[3]))) {
            entryInfo.setEmployedDate(CmpDateUtil.parseDate(handleDate));
        }
        entryInfo.setPersonStatus(PersonStatusEnum.Normal);
        entryInfo.setSubmitStatus(SubmitStatusEnum.NotSubmit);
        entryInfo.setIdentityStatus(IdentityStatusEnume.WaitVerify);
        entryCollection.add((CoreBaseInfo)entryInfo);
    }

    private String verifyPersonRecord(Context ctx, PersonOtherInfoInfo personOtherInfo) {
        ArrayList<String> fields = new ArrayList<String>();
        PersonInfo personInfo = personOtherInfo.getPerson();
        if (StringUtils.isEmpty((String)personInfo.getIdCardNO()) && StringUtils.isEmpty((String)personInfo.getPassportNO())) {
            fields.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label62", (Locale)ctx.getLocale()));
        }
        if (StringUtils.isEmpty((String)personInfo.getCell())) {
            fields.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label63", (Locale)ctx.getLocale()));
        }
        if (null == personInfo.getBirthday()) {
            fields.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label64", (Locale)ctx.getLocale()));
        }
        if (null == personInfo.getNationality()) {
            fields.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label65", (Locale)ctx.getLocale()));
        }
        if (null == personInfo.getGender()) {
            fields.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label66", (Locale)ctx.getLocale()));
        }
        if (fields.size() > 0) {
            return fields + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label67", (Locale)ctx.getLocale());
        }
        return null;
    }

    private void initPersonRecord(CoreBaseCollection billCollection, TaxPersonRecordInfo personRecord, PersonOtherInfoInfo personOtherInfo, PersonTaxRecord personTaxRecord) throws ParseException {
        IsOverseaEnum isOverseaEnum = null;
        if (!CmpStrUtil.isEmpty(personTaxRecord.getIsOversea())) {
            isOverseaEnum = IsOverseaEnum.getEnum(personTaxRecord.getIsOversea());
            personRecord.setIsOversea(isOverseaEnum);
        }
        if (isOverseaEnum != null && IsOverseaEnum.IsOversea.getValue().equals(isOverseaEnum.getValue())) {
            personRecord.setEntryDate(CmpDateUtil.parseDate(personTaxRecord.getEntryDate()));
            personRecord.setLeaveDate(CmpDateUtil.parseDate(personTaxRecord.getLeaveDate()));
            personRecord.setTaxReason(TaxReasonEnum.getEnum(personTaxRecord.getTaxReason()));
            NationalityInfo birthPlace = new NationalityInfo();
            birthPlace.setId(BOSUuid.read((String)personTaxRecord.getBirthPlaceId()));
            personRecord.setBirthPlace(birthPlace);
        }
        if (personRecord.getId() != null) {
            billCollection.add((CoreBaseInfo)personRecord);
            return;
        }
        personRecord.setId(BOSUuid.create((BOSObjectType)personRecord.getBOSType()));
        PersonInfo personInfo = personOtherInfo.getPerson();
        personRecord.setGender(personInfo.getGender());
        personRecord.setPerson(personInfo);
        String cardNo = personInfo.getIdCardNO();
        personRecord.setTaxNumber(cardNo);
        CardTypeEnum cardType = CardTypeEnum.IdCard;
        isOverseaEnum = IsOverseaEnum.NotOversea;
        if (StringUtils.isEmpty((String)cardNo)) {
            cardNo = personInfo.getPassportNO();
            cardType = TaxReportUtil.convertCardType(personOtherInfo.getCredentialsType().getName());
            isOverseaEnum = IsOverseaEnum.IsOversea;
            personRecord.setTaxNumber(null);
        }
        personRecord.setCardNumber(cardNo);
        personRecord.setReportName(personInfo.getName());
        personRecord.setHometownDetailed(personInfo.getHomeplace());
        personRecord.setNumber(personInfo.getNumber());
        personRecord.setCardType(cardType);
        personRecord.setName(personInfo.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        personRecord.setName(personInfo.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        personRecord.setName(personInfo.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        personRecord.setBirthday(personInfo.getBirthday());
        personRecord.setNationality(personInfo.getNationality());
        personRecord.setIsOversea(isOverseaEnum);
        personRecord.setPhoneNumber(personInfo.getCell());
        personRecord.setEmail(personInfo.getEmail());
        personRecord.setIsDisability(false);
        personRecord.setIsHero(false);
        personRecord.setIsOld(false);
        personRecord.setEduLevel(personInfo.getHighestDegree());
        billCollection.add((CoreBaseInfo)personRecord);
    }

    @Override
    protected void _abrogate(Context ctx, String param) throws BOSException {
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        Set<String> selectIdsSet = this.ConvertStringToSet(param);
        String selectedIdSql = cmpInSql.createInSqlBaseOnFId(ctx, selectIdsSet);
        String sql = "update T_hr_SCmpTaxMatchData set FState = '0' where fid in" + selectedIdSql;
        CmpSQLUtil.execute(ctx, sql);
        cmpInSql.release(ctx);
    }

    protected void setConfirmed(Context ctx, Set param) throws BOSException {
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String idsSql = cmpInSql.createInSqlBaseOnFId(ctx, param);
        String sql = "update T_hr_SCmpTaxMatchData set FState = '20', fLastUpdateUserID = '" + userId + "', fLastUpdateTime = " + CmpDateUtil.toKSqlDate(new Date()) + " where fid in " + idsSql;
        CmpSQLUtil.execute(ctx, sql);
    }

    private Set<String> ConvertStringToSet(String param) {
        String[] arr = param.split(",");
        HashSet<String> set = new HashSet<String>(Arrays.asList(arr));
        return set;
    }

    @Override
    protected void _setEffect(Context ctx, CoreBaseCollection coll, Set param) throws BOSException {
        try {
            if (coll != null || coll.size() > 0) {
                TaxPersonRecordEntryFactory.getLocalInstance(ctx).saveBatchData(coll);
            }
            if (param != null || param.size() > 0) {
                this.setConfirmed(ctx, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)"saveCmpTaxData error: ", (Throwable)e);
            e.printStackTrace();
        }
    }
}

