/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.separateSettlement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeFacadeFactory;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.CmpSchemePersonHasFacadeFactory;
import com.kingdee.shr.compensation.app.formula.SalaryCalculator;
import com.kingdee.shr.compensation.app.formula.SalaryCalculatorProxy;
import com.kingdee.shr.compensation.app.formula.SalayCalculatorMgr;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.separateSettlement.AbstractCmpStopCalControllerBean;
import com.kingdee.shr.compensation.app.separateSettlement.CmpStopCalFactory;
import com.kingdee.shr.compensation.app.separateSettlement.CmpStopCalInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.settlement.CmpStopCalIssueManager;
import com.kingdee.shr.compensation.settlement.pojo.StopCalScheme;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpItemUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpStopCalControllerBean
extends AbstractCmpStopCalControllerBean {
    private static final CmpStopCalIssueManager manager = new CmpStopCalIssueManager();
    private final CmpItemUtil cmpItemUtil = new CmpItemUtil();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.separateSettlement.CmpStopCalControllerBean");

    @Override
    protected Map _stopCal(Context ctx, Map paramMap) throws BOSException {
        this.dealWithData(ctx, paramMap);
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("T_HR_SCMPSTOPCAL");
            tableList.add("T_HR_SCmpCalTable");
            this.cmpItemUtil.dealWithItemColumns(ctx, tableList);
            this.transferData(ctx, paramMap);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return new HashMap();
    }

    public void transferData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Set succList = (Set)paramMap.get("succList");
        String selectData = CmpStrUtil.converCollectionToSql(succList);
        manager.restoreCalDataToIssue(ctx, selectData);
    }

    public void dealWithData(Context ctx, Map paramMap) throws BOSException {
        Set succList = (Set)paramMap.get("succList");
        String sqlIds = CmpStrUtil.converCollectionToSql(succList);
        String sqlStr = "delete from T_HR_SCmpStopCal stopCal where exists ( select fid from T_HR_SCmpCalTable calTable where stopCal.fpersonid = calTable.fpersonid and stopCal.FCALSCHEMEID = calTable.FCALSCHEMEID and stopCal.FPERIODYEAR = calTable.FPERIODYEAR and stopCal.FPERIODMONTH = calTable.FPERIODMONTH and stopCal.FCALTIME = calTable.FCALTIME and calTable.Fid in (" + sqlIds + ") and stopCal.FGrantState = 0)";
        CmpSQLUtil.execute(ctx, sqlStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _calculate(Context ctx, Map param) throws BOSException, EASBizException {
        Object filterStr = param.get("stopCalFilter");
        String stopCalFilter = filterStr.toString();
        CmpStopCalIssueManager issueManager = new CmpStopCalIssueManager();
        Map<String, String> issueMapping = issueManager.restoreIssueDataWithMapping(ctx, stopCalFilter);
        String l = LocaleUtils.getShortCode((Context)ctx);
        ArrayList<StopCalScheme> stopCalList = new ArrayList<StopCalScheme>();
        String sql = "select stopcal.Fid,stopcal.FCalSchemeID,stopcal.FPeriodYear,stopcal.FPeriodMonth,stopcal.FCalTime,scheme.fname_" + l + " as name  from t_hr_scmpstopcal stopcal inner join t_hr_scalscheme scheme on stopcal.FCalSchemeID = scheme.fid where stopcal.fid in (" + stopCalFilter + ") and stopcal.FGrantState = 0  order by stopcal.FPeriodYear,stopcal.FPeriodMonth,stopcal.FCalTime,stopcal.FCalSchemeID";
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
        String tag = "";
        StopCalScheme stopScheme2 = null;
        HashSet<String> successRecord = new HashSet<String>();
        try {
            try {
                while (rs.next()) {
                    String fid = rs.getString("Fid");
                    String calSchemeId = rs.getString("FCalSchemeID");
                    String name = rs.getString("name");
                    int year = rs.getInt("FPeriodYear");
                    int month = rs.getInt("FPeriodMonth");
                    int calTime = rs.getInt("FCalTime");
                    StringBuilder tempString = new StringBuilder(calSchemeId).append(year).append(month).append(calTime);
                    if (!tag.equals(tempString.toString())) {
                        stopScheme2 = new StopCalScheme(calSchemeId, name, year, month, calTime);
                        stopCalList.add(stopScheme2);
                        tag = tempString.toString();
                    }
                    if (null == stopScheme2) continue;
                    stopScheme2.putMapping(fid, issueMapping.get(fid));
                }
                for (StopCalScheme stopScheme2 : stopCalList) {
                    String filter = CmpSQLUtil.createInSqlWithOutBrackets(ctx, stopScheme2.getRangeMapping().values(), "T_HR_SCmpCalTable", "FID");
                    this.oldCal(ctx, stopScheme2, filter);
                    String updateState = "update t_hr_scmpcaltable set fcalstate = 20 where fid in (" + filter + ")";
                    CmpSQLUtil.execute(ctx, updateState);
                    successRecord.addAll(stopScheme2.getRangeMapping().keySet());
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                String calSchemeML = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalSchemeListResource", (String)"label0", (Locale)ctx.getLocale());
                String mes = calSchemeML + "[" + stopScheme2.getName() + "] : " + e.getMessage();
                param.put("errorSchemeMes", mes);
                throw new BOSException((Throwable)e);
            }
            finally {
                issueManager.restoreCalItemDataDirectly(ctx, issueMapping);
                issueManager.updataStopCalState(ctx, successRecord);
            }
        }
        finally {
            issueManager.cleanTempCalData(ctx, issueMapping.values());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void oldCal(Context ctx, StopCalScheme stopScheme, String filter) throws Exception {
        SalaryCalculator calculate = new SalaryCalculator();
        calculate.setStopCal(true);
        SalayCalculatorMgr.addTask(calculate);
        String uid = calculate.getUID();
        SalaryCalculatorProxy cal = new SalaryCalculatorProxy(uid, true);
        cal.setMainTableName("T_HR_SCmpCalTable");
        cal.setPrecision(Integer.parseInt("2"));
        String cmpschemeid = stopScheme.getId();
        cal.setSchemeID(cmpschemeid);
        cal.setCtx(ctx);
        Tools.getInstance().setCtx(ctx);
        CalSchemeInfo calSchemeInfo = this.getHisCalSchemeInfo(ctx, cmpschemeid, stopScheme.getPeriodYear(), stopScheme.getPeriodMonth(), stopScheme.getCalTime());
        if (calSchemeInfo == null) {
            String msg = String.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label25", (Locale)ctx.getLocale()), cmpschemeid);
            throw new BOSException(msg);
        }
        cal.setCalFromDate(Tools.getStringDate(calSchemeInfo.getBeginDate()));
        cal.setCalToDate(Tools.getStringDate(calSchemeInfo.getEndDate()));
        calculate.setSchemeInfo(calSchemeInfo);
        String mainTableRowFilter = "t_hr_scmpcaltable.fid in (" + filter + ") ";
        cal.setMainTableRowFilter(mainTableRowFilter);
        cal.setFilterSql(filter);
        try {
            cal.post();
        }
        finally {
            SalayCalculatorMgr.removeTask(uid, "");
        }
    }

    private CalSchemeInfo getHisCalSchemeInfo(Context ctx, String cmpschemeid, int targetPeriodYear, int targetPeriodMonth, int targetCalTime) throws BOSException, EASBizException {
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, cmpschemeid);
        if (calSchemeInfo == null) {
            return null;
        }
        if (calSchemeInfo.getPeriodYear() == targetPeriodYear && calSchemeInfo.getPeriodMonth() == targetPeriodMonth && calSchemeInfo.getCalTime() == targetCalTime) {
            return calSchemeInfo;
        }
        Map<String, Date> preSchemeDateWithPeriod = this.getPreSchemeDateWithPeriod(calSchemeInfo, targetPeriodYear, targetPeriodMonth);
        calSchemeInfo.setPeriodYear(targetPeriodYear);
        calSchemeInfo.setPeriodMonth(targetPeriodMonth);
        calSchemeInfo.setCalTime(targetCalTime);
        calSchemeInfo.setBeginDate(preSchemeDateWithPeriod.get("beginDate"));
        calSchemeInfo.setEndDate(preSchemeDateWithPeriod.get("endDate"));
        return calSchemeInfo;
    }

    public Map<String, Date> getPreSchemeDateWithPeriod(CalSchemeInfo calSchemeInfo, int targetYear, int targetMonth) throws EASBizException, BOSException {
        HashMap<String, Date> res = new HashMap<String, Date>();
        if (calSchemeInfo == null) {
            return res;
        }
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        CmpPeriodTypeEnum periodType = calSchemeInfo.getCmpPeriodType();
        Date schemeBeginDate = calSchemeInfo.getBeginDate();
        if (periodType == CmpPeriodTypeEnum.halfmonth && 2 == calSchemeInfo.getPeriodTime()) {
            Date endDate = calSchemeInfo.getEndDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.add(2, -1);
            calendar.add(5, 1);
            schemeBeginDate = calendar.getTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(schemeBeginDate);
        int betMonth = (targetYear - periodYear) * 12 + targetMonth - periodMonth;
        calendar.add(2, betMonth);
        Date beginDate = calendar.getTime();
        int k = periodType.equals((Object)CmpPeriodTypeEnum.yeay) ? 12 : (periodType.equals((Object)CmpPeriodTypeEnum.half) ? 6 : (periodType.equals((Object)CmpPeriodTypeEnum.quarter) ? 3 : 1));
        calendar.add(2, k);
        calendar.add(5, -1);
        Date endDate = CmpDateUtil.toDate(calendar.getTime());
        res.put("beginDate", beginDate);
        res.put("endDate", endDate);
        return res;
    }

    public void checkNeededCalSchemeInfo(Context ctx, CalSchemeInfo calSchemeInfo) throws BOSException {
        boolean isValidate = CalSchemeBizHelper.checkCalSchemeLegal(calSchemeInfo);
        if (!isValidate) {
            throw new BOSException(CalSchemeBizHelper.getCalValidateMessage(ctx));
        }
        if (null != calSchemeInfo.getExchangeTable()) {
            Date ruleDate = CurrencyUtil.getEffdtByExchangeRule(calSchemeInfo.getExchangeRule(), calSchemeInfo.getBeginDate(), calSchemeInfo.getEndDate());
            ExchangeRateCollection rateColl = CurrencyUtil.getExchangeRate(ctx, calSchemeInfo.getExchangeTable().getId().toString(), calSchemeInfo.getCurrency().getId().toString(), ruleDate);
            if (null == rateColl || rateColl.size() < 1) {
                // empty if block
            }
        }
    }

    @Override
    protected void _updateStopCal(Context ctx, String filterSql) throws BOSException {
        String sqlStr = "update T_HR_SCmpStopCal stopCal set FGrantSchemeID = null, FGrantPeriodYear = null, FGrantPeriodMonth = null, FGrantCalTime = null, FGrantState = 0, FIsRefer = 0, FcalTableId = null where exists ( select fid from T_HR_SCmpCalTable calTable where stopCal.FGrantSchemeID = calTable.FCALSCHEMEID and stopCal.FGrantPeriodYear = calTable.FPERIODYEAR and stopCal.FGrantPeriodMonth = calTable.FPERIODMONTH and stopCal.FGrantCalTime = calTable.FCALTIME and stopCal.FPERSONID = calTable.FPERSONID and calTable.FCalState in (1,2,3,4,5,6,7) and calTable.Fid in (" + filterSql + ") and (calTable.FIsLockOtherSysData is null or calTable.FIsLockOtherSysData = 0) and stopCal.FGrantState = 1)";
        CmpSQLUtil.execute(ctx, sqlStr);
    }

    @Override
    protected Map _addStopCalPersonRecord(Context ctx, Map params, String userId) throws BOSException {
        String calschemeId = (String)params.get("calschemeId");
        String caltableId = (String)params.get("caltableId");
        boolean overide = (Boolean)params.get("overide");
        String permItemId = (String)params.get("permItemId");
        CmpStopCalInfo calInfo = (CmpStopCalInfo)params.get("stopCalInfo");
        HashMap<String, String> result = new HashMap<String, String>();
        CalSchemeInfo calSchemeInfo = null;
        try {
            calSchemeInfo = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo(" where id = '" + calschemeId + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (null == calSchemeInfo || null == calSchemeInfo.getId()) {
            return result;
        }
        try {
            if (overide && !CmpStrUtil.isEmpty(caltableId)) {
                CmpSchemePersonHasFacadeFactory.getLocalInstance(ctx).delete(permItemId, "'" + caltableId + "'", calSchemeInfo.getId().toString(), true, userId);
            }
            manager.updateCmpStopCalStatus(ctx, calSchemeInfo, calInfo, false);
            String fid = manager.addCmpCalTableRecord(ctx, calSchemeInfo, calInfo);
            manager.updateCaltableItemValue(ctx, calSchemeInfo.getId().toString(), fid, calInfo.getId().toString());
            CalSchemeFacadeFactory.getLocalInstance(ctx).setCalState(calSchemeInfo.getId().toString(), null);
            result.put("cmpCalTableId", fid);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _cancelStopCalPersonRecord(Context ctx, Map params) throws BOSException {
        String stopcalId = (String)params.get("stopcalId");
        String caltableId = (String)params.get("caltableId");
        String updateCaltableSql = " update T_HR_SCMPCALTABLE set FisNotNeedCal = 0 where fid = '" + caltableId + "'";
        CmpSQLUtil.execute(ctx, updateCaltableSql);
        String updateStopcalSql = " update T_HR_SCmpStopCal set  FcaltableId = null, FGrantSchemeID = null, FGrantPeriodYear = null,  FGrantPeriodMonth = null, FGrantCalTime = null, FIsRefer = 0,  FGrantState = 0 where fid = '" + stopcalId + "'";
        CmpSQLUtil.execute(ctx, updateStopcalSql);
        return null;
    }

    @Override
    protected void _transferStopCal(Context ctx, String filterSql) throws BOSException {
        String sql = "select FCalTableID from T_HR_SStopCalTrabfer where FCalTableID in (" + filterSql + ")";
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
        HashSet<String> succList = new HashSet<String>();
        try {
            while (rs.next()) {
                succList.add(rs.getString("FCalTableID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (succList.size() > 0) {
            HashMap<String, HashSet<String>> paramMap = new HashMap<String, HashSet<String>>();
            paramMap.put("succList", succList);
            this._stopCal(ctx, paramMap);
            sql = "delete from T_HR_SStopCalTrabfer where FCalTableID in (" + filterSql + ")";
            CmpSQLUtil.execute(ctx, sql);
        }
    }

    @Override
    protected Map _getAndSaveTaxCalTableIds(Context ctx, String filterSql) throws BOSException, EASBizException {
        boolean isCal;
        try {
            isCal = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_cmp_026", null);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> reCalList = new ArrayList<String>();
        ArrayList<String> allIdList = new ArrayList<String>();
        HashSet<String> succList = new HashSet<String>();
        HashSet<String> failedSet = new HashSet<String>();
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        String lang = ctx.getLocale().getLanguage();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT DETAIL.FID DETAILID, DETAIL.FSTATE, DETAIL.FPERIODEND,CAL.FID FCMPCALTABLEID,CAL.FVALIDATESTATE, ");
        str.append(" PERSON.FNAME_").append(lang).append(" NAME, PERSON.FNUMBER PERNUMBER, CONFIG.FID CONFIGID, CONFIG.FISLAST, CONFIG.FSTATE CONFIGSTATE, ");
        str.append(" CAL.FCALSTATE, CAL.FISLOCKOTHERSYSDATA, stop.FGrantState, stop.Fid stopCalId ");
        str.append(" FROM T_HR_SCMPCALTABLE CAL ");
        str.append(" INNER JOIN T_BD_PERSON PERSON ON CAL.FPERSONID = PERSON.FID ");
        str.append(" LEFT JOIN T_HR_STAXCALINITDETAIL DETAIL ON DETAIL.FCMPCALTABLEID = CAL.FID AND DETAIL.FDATASTATE = ").append(10);
        str.append(" LEFT JOIN T_HR_STAXCALCONFIGDETAIL CONFIG ON DETAIL.FCMPCALTABLEID = CONFIG.FCMPCALTABLEID and DETAIL.fIncomeItemId = CONFIG.fIncomeItemId ");
        str.append(" left join T_HR_SCmpStopCal stop on (stop.fpersonid = cal.fpersonid and stop.FCALSCHEMEID = cal.FCALSCHEMEID and stop.FPERIODYEAR = cal.FPERIODYEAR");
        str.append(" and stop.FPERIODMONTH = cal.FPERIODMONTH and stop.FCALTIME = cal.FCALTIME)");
        str.append(" WHERE CAL.FID IN (").append(filterSql).append(") ");
        List<Integer> stateList = Arrays.asList(1, 4);
        try {
            HashMap<String, BatchMessageTipsBody> messageMap = new HashMap<String, BatchMessageTipsBody>();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                boolean isSuccess = true;
                String msg = "";
                String calId = rowSet.getString("FCMPCALTABLEID");
                String initId = rowSet.getString("DETAILID");
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(calId);
                int calState = rowSet.getInt("FCALSTATE");
                int validateState = rowSet.getInt("FVALIDATESTATE");
                if (!stateList.contains(calState) || calState >= 8 || rowSet.getInt("FISLOCKOTHERSYSDATA") == 1) {
                    isSuccess = false;
                    failedSet.add(calId);
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label69", (Locale)ctx.getLocale());
                } else if (!StringUtils.isEmpty((CharSequence)rowSet.getString("stopCalId")) && rowSet.getInt("FGrantState") > 0) {
                    isSuccess = false;
                    failedSet.add(calId);
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label70", (Locale)ctx.getLocale());
                } else if (calState != 1 && validateState < 50) {
                    isSuccess = false;
                    failedSet.add(calId);
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label242", (Locale)ctx.getLocale());
                } else if (!StringUtils.isEmpty((CharSequence)initId) && 20 == rowSet.getInt("CONFIGSTATE")) {
                    isSuccess = false;
                    failedSet.add(calId);
                    msg = isCal ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label18", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label19", (Locale)ctx.getLocale());
                } else if (!StringUtils.isEmpty((CharSequence)initId) && isCal) {
                    if (30 == rowSet.getInt("FSTATE")) {
                        isSuccess = false;
                        failedSet.add(calId);
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label20", (Locale)ctx.getLocale());
                    } else if (20 == rowSet.getInt("FSTATE")) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label21", (Locale)ctx.getLocale());
                        reCalList.add(calId + "_" + initId);
                    } else if (!StringUtils.isEmpty((CharSequence)rowSet.getString("CONFIGID")) && !rowSet.getBoolean("FISLAST")) {
                        failedSet.add(calId);
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label22", (Locale)ctx.getLocale());
                    } else if (!StringUtils.isEmpty((CharSequence)rowSet.getString("CONFIGID")) && rowSet.getBoolean("FISLAST")) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label23", (Locale)ctx.getLocale());
                        reCalList.add(calId + "_" + initId);
                    }
                }
                if (isSuccess) {
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label26", (Locale)ctx.getLocale());
                    succList.add(calId);
                }
                body.setMuitTipsState(isSuccess);
                body.setMuitTipsMessage(msg);
                ArrayList<String> messageListExt = new ArrayList<String>();
                messageListExt.add(rowSet.getString("PERNUMBER"));
                messageListExt.add(rowSet.getString("NAME"));
                body.addMessageListExt(messageListExt);
                this.addMessageBody(ctx, header, body, messageMap, isSuccess, calId);
                if (allIdList.contains(calId)) continue;
                allIdList.add(calId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("isCal", Boolean.valueOf(isCal));
        HashSet<String> initList = new HashSet<String>();
        ArrayList<String> calTableList = new ArrayList<String>();
        for (String calId2InitId : reCalList) {
            String[] arr = calId2InitId.split("_");
            if (failedSet.contains(arr[0])) continue;
            initList.add(arr[1]);
            calTableList.add(arr[0]);
        }
        succList.removeIf(failedSet::contains);
        header.setBillId(CmpStrUtil.convertListToString(allIdList));
        header.setFailureCount(failedSet.size());
        header.setSuccessCount(allIdList.size() - failedSet.size());
        map.put("header", (Serializable)header);
        map.put("succList", succList);
        if (!initList.isEmpty() && isCal) {
            TaxCalForJSFacadeFactory.getLocalInstance(ctx).deleteCalData(CmpStrUtil.convertSetToSqlString(initList), TaxCalDelTypeEnum.DEL_PERSON);
        }
        if (calTableList.size() > 0) {
            this.saveTaxCalTableIds(ctx, calTableList);
        }
        return map;
    }

    private void addMessageBody(Context ctx, BatchMessageTipsHeader header, BatchMessageTipsBody body, Map<String, BatchMessageTipsBody> messageMap, boolean isSuccess, String calId) {
        if (!messageMap.containsKey(calId)) {
            messageMap.put(calId, body);
            header.addResult(body);
            return;
        }
        if (!isSuccess) {
            BatchMessageTipsBody old = messageMap.get(calId);
            messageMap.put(calId, body);
            String message = body.getMuitTipsMessage();
            String suc1 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label23", (Locale)ctx.getLocale());
            String suc2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label21", (Locale)ctx.getLocale());
            if (!suc1.equals(message) && !suc2.equals(message)) {
                header.getResult().remove(old);
                header.addResult(body);
            }
        }
    }

    public void saveTaxCalTableIds(Context ctx, List<String> calTableList) throws BOSException {
        String insertSql = "insert into T_HR_SStopCalTrabfer(FCalTableID, FTrabferType) values(?, 0)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String s : calTableList) {
            Object[] object = new Object[]{s};
            paramsList.add(object);
        }
        CmpSQLUtil.executeBatch(ctx, insertSql, paramsList);
    }

    @Override
    protected Map _getStopCalData(Context ctx, String selectedData) throws BOSException, EASBizException {
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        boolean isSuccess = false;
        ArrayList<String> allIdList = new ArrayList<String>();
        ArrayList<String> succList = new ArrayList<String>();
        ArrayList<String> calTableList = new ArrayList<String>();
        ArrayList<String> calSchemeIdList = new ArrayList<String>();
        int sucsess = 0;
        int fail = 0;
        String l = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, int[]> schemeCalDataStateMap = new HashMap<String, int[]>();
        int sumIndex = 0;
        int unFinishIndx = 1;
        int finishIndex = 2;
        String tempSchemeId = "";
        int[] stateArr = new int[3];
        StringBuilder select = new StringBuilder();
        select.append("select stopCal.fcalSchemeId,calTable.fCalState,count(calTable.fCalState) as stateCount");
        select.append(" from T_HR_SCMPSTOPCAL stopCal");
        select.append(" left join T_hr_scmpcaltable calTable on calTable.fCalSchemeId = stopCal.fCalSchemeId and calTable.fPeriodYear = stopCal.fPeriodYear ");
        select.append(" and calTable.fPeriodMonth = stopCal.fPeriodMonth and calTable.fCalTime = stopCal.fCalTime ");
        select.append(" where stopCal.fid in (" + selectedData + ")");
        select.append(" group by  stopCal.fcalSchemeId,calTable.fCalState ");
        try {
            IRowSet result = CmpSQLUtil.executeQuery(ctx, select.toString());
            while (result.next()) {
                String fcalSchemeId = result.getString("fcalSchemeId");
                int calState = result.getInt("fCalState");
                int stateCount = result.getInt("stateCount");
                if (!tempSchemeId.equals(fcalSchemeId)) {
                    tempSchemeId = fcalSchemeId;
                    schemeCalDataStateMap.put(fcalSchemeId, stateArr);
                    if (calState == 0) continue;
                    if (calState == 20) {
                        stateArr[finishIndex] = stateCount;
                    } else {
                        stateArr[unFinishIndx] = stateArr[unFinishIndx] + stateCount;
                    }
                    stateArr[sumIndex] = stateArr[sumIndex] + stateCount;
                    continue;
                }
                if (calState == 20) {
                    stateArr[finishIndex] = stateCount;
                } else {
                    stateArr[unFinishIndx] = stateArr[unFinishIndx] + stateCount;
                }
                stateArr[sumIndex] = stateArr[sumIndex] + stateCount;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select stopCal.fid as stopCalId, scheme.fid as calschemeId, scheme.fname_" + l + " as calschemeName, stopCal.fPeriodYear as PeriodYear, stopCal.fPeriodMonth as PeriodMonth, stopCal.fCalTime as CalTime, ");
        sqlStr.append(" stopCal.fDataSource as dataSource, calTable.fid as calTableId, calTable.fCalState as calState, scheme.fid as calSchemeId, ");
        sqlStr.append(" per.fNumber as personNumber, per.fName_" + l + " as personName ");
        sqlStr.append(" from T_HR_SCMPSTOPCAL stopCal ");
        sqlStr.append(" left join T_hr_scmpcaltable calTable on (calTable.fCalSchemeId = stopCal.fCalSchemeId and calTable.fPeriodYear = stopCal.fPeriodYear ");
        sqlStr.append(" and calTable.fPeriodMonth = stopCal.fPeriodMonth and calTable.fCalTime = stopCal.fCalTime and calTable.fPersonId = stopCal.fPersonId ) ");
        sqlStr.append(" left join T_HR_SCalScheme scheme on scheme.fid = stopCal.fCalSchemeId ");
        sqlStr.append(" and scheme.fPeriodYear = stopCal.fPeriodYear and scheme.fPeriodMonth = stopCal.fPeriodMonth and scheme.fCalTime = stopCal.fCalTime");
        sqlStr.append(" inner join T_BD_PERSON per ON stopCal.fPersonId = per.fid ");
        sqlStr.append(" where stopCal.fid in (" + selectedData + ")");
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sqlStr.toString());
            while (rs.next()) {
                String message;
                String stopCalId = rs.getString("stopCalId");
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(stopCalId);
                String calSchemeId = rs.getString("calSchemeId");
                stateArr = (int[])schemeCalDataStateMap.get(calSchemeId);
                if (rs.getInt("dataSource") != 0) {
                    isSuccess = false;
                    message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label27", (Locale)ctx.getLocale());
                } else if (rs.getInt("calState") == 20) {
                    isSuccess = false;
                    message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label28", (Locale)ctx.getLocale());
                } else if (stateArr != null && stateArr[sumIndex] != 0 && stateArr[sumIndex] == stateArr[finishIndex]) {
                    isSuccess = false;
                    message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label28", (Locale)ctx.getLocale());
                } else if (stateArr == null && CmpStrUtil.isEmpty(calSchemeId)) {
                    isSuccess = false;
                    message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label29", (Locale)ctx.getLocale());
                } else {
                    if (!CmpStrUtil.isEmpty(rs.getString("calTableId"))) {
                        calTableList.add(rs.getString("calTableId"));
                    }
                    isSuccess = true;
                    message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label30", (Locale)ctx.getLocale());
                }
                if (isSuccess) {
                    ++sucsess;
                } else {
                    ++fail;
                    throw new BOSException(message);
                }
                succList.add(stopCalId);
                calSchemeIdList.add(calSchemeId);
                String personNum = "personNum";
                String personName = "personName";
                String calschemeName = "calschemeName";
                String periodyear = "periodyear";
                String periodmonth = "periodmonth";
                String caltime = "caltime";
                HashMap<String, String> messageMapExt = new HashMap<String, String>();
                messageMapExt.put(personNum, rs.getString("personNumber"));
                messageMapExt.put(personName, rs.getString(personName));
                messageMapExt.put(calschemeName, rs.getString(calschemeName));
                messageMapExt.put(periodyear, rs.getString(periodyear));
                messageMapExt.put(periodmonth, rs.getString(periodmonth));
                messageMapExt.put(caltime, rs.getString(caltime));
                body.setMuitTipsState(isSuccess);
                body.setMuitTipsMessage(message);
                ArrayList<String> messageListExt = new ArrayList<String>();
                messageListExt.add(rs.getString("personNumber"));
                messageListExt.add(rs.getString("personName"));
                body.addMessageListExt(messageListExt);
                body.setMessageMapExt(messageMapExt);
                header.addResult(body);
                allIdList.add(stopCalId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        header.setBillId(CmpStrUtil.convertListToString(allIdList));
        header.setSuccessCount(sucsess);
        header.setFailureCount(fail);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", header);
        map.put("succList", succList);
        map.put("calTableList", calTableList);
        map.put("calSchemeIdList", calSchemeIdList);
        return map;
    }

    @Override
    protected Map _cancelStopCal(Context ctx, String selectedData, String calTableData) throws BOSException, EASBizException {
        if (!CmpStrUtil.isEmpty(calTableData)) {
            CmpCalTableFactory.getLocalInstance(ctx).delete("where id in (" + calTableData + ")");
        }
        Map<String, String> idMapping = manager.restoreIssueDataWithMapping(ctx, selectedData);
        CmpStopCalFactory.getLocalInstance(ctx).delete("where id in (" + selectedData + ")");
        return idMapping;
    }

    @Override
    protected void _removeCalTableRef(Context ctx, String filter) throws BOSException, EASBizException {
        String sqlStr = "update T_HR_SCmpStopCal stopCal set FGrantSchemeID = null, FGrantPeriodYear = null, FGrantPeriodMonth = null, FGrantCalTime = null, FGrantState = 0, FIsRefer = 0, FcalTableId = null where exists ( select fid from T_HR_SCmpCalTable calTable where stopCal.FGrantSchemeID = calTable.FCALSCHEMEID and stopCal.FGrantPeriodYear = calTable.FPERIODYEAR and stopCal.FGrantPeriodMonth = calTable.FPERIODMONTH and stopCal.FGrantCalTime = calTable.FCALTIME and stopCal.FPERSONID = calTable.FPERSONID and calTable.Fid in (" + filter + ") and stopCal.FGrantState = 1 )";
        CmpSQLUtil.execute(ctx, sqlStr);
    }
}

