/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.tax.AbstractIncomeTaxIssueFacadeControllerBean;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueEntryFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueEntryInfo;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueInfo;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueItemEnum;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueResult;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueStatusEnum;
import com.kingdee.shr.compensation.app.tax.TaskIncomeTaxRelationFactory;
import com.kingdee.shr.compensation.app.tax.TaskIncomeTaxRelationInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.tax.YesOrNoEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class IncomeTaxIssueFacadeControllerBean
extends AbstractIncomeTaxIssueFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(IncomeTaxIssueFacadeControllerBean.class);
    private static final int HANDLE_SUCCESS = 0;

    @Override
    protected void _obtainIncomeTaxIssue(Context ctx, String taxUnits) throws BOSException {
        LOG.debug((Object)("starting to obtain income tax issues, taxUnits=" + taxUnits));
        if (StringUtils.isEmpty((String)taxUnits)) {
            return;
        }
        String yearMonth = CmpDateUtil.getDateStr(CmpDateUtil.getLastMonthEndDate(), "yyyyMM");
        String condition = taxUnits.replace(",", "','");
        String taxUnitOql = "select id,name,taxNumber,regNumber,areaCode,declPassword,realPassword  where taxNumber in ('" + condition + "')";
        TaxUnitCollection taxUnitCollection = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitCollection(taxUnitOql);
        for (int i = 0; i < taxUnitCollection.size(); ++i) {
            this.createSingleTask(ctx, yearMonth, taxUnitCollection.get(i));
        }
    }

    private void createSingleTask(Context ctx, String yearMonth, TaxUnitInfo taxUnitInfo) throws BOSException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("djxhid", taxUnitInfo.getRegNumber() == null ? "" : taxUnitInfo.getRegNumber());
        paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
        paramMap.put("areaid", taxUnitInfo.getAreaCode());
        paramMap.put("sdyf", yearMonth);
        String smmm = Base64Utils.decode(taxUnitInfo.getRealPassword());
        paramMap.put("smmm", smmm == null ? "" : smmm);
        String sbmm = Base64Utils.decode(taxUnitInfo.getDeclPassword());
        paramMap.put("sbmm", sbmm == null ? "" : sbmm);
        paramMap.put("ver", "V2.0.000");
        paramMap.put("TAXUNITID", taxUnitInfo.getId().toString());
        TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.IncomeIssueObtain, paramMap);
    }

    @Override
    protected void _afterObtainIncomeTaxIssue(Context ctx, String taskId, String response) throws BOSException {
    }

    @Override
    protected synchronized void _handleIncomeTaxIssue(Context ctx, IncomeTaxIssueCollection issues) throws BOSException {
        Map<String, List<IncomeTaxIssueInfo>> groups = this.groupIssuesByTaxUnit(issues);
        try {
            for (Map.Entry<String, List<IncomeTaxIssueInfo>> entry : groups.entrySet()) {
                List<IncomeTaxIssueInfo> list = entry.getValue();
                this.addIssueHandleTask(ctx, list);
            }
        }
        catch (EASBizException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void addIssueHandleTask(Context ctx, List<IncomeTaxIssueInfo> issues) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        TaxUnitInfo taxUnitInfo = issues.get(0).getTaxUnit();
        paramMap.put("djxhid", taxUnitInfo.getRegNumber() == null ? "" : taxUnitInfo.getRegNumber());
        paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
        paramMap.put("areaid", taxUnitInfo.getAreaCode());
        String yearMonth = CmpDateUtil.getDateStr(CmpDateUtil.getLastMonthEndDate(), "yyyyMM");
        paramMap.put("sdyf", yearMonth);
        String smmm = Base64Utils.decode(taxUnitInfo.getRealPassword());
        paramMap.put("smmm", smmm == null ? "" : smmm);
        paramMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
        paramMap.put("ver", "V2.0.000");
        paramMap.put("TAXUNITID", taxUnitInfo.getId().toString());
        ArrayList<HashMap<String, Object>> sszycllb = new ArrayList<HashMap<String, Object>>();
        Date fkrq = new Date();
        Map<Long, List<IncomeTaxIssueInfo>> groups = this.groupIssuesByMessageId(issues);
        Base64 base64 = new Base64();
        for (Map.Entry<Long, List<IncomeTaxIssueInfo>> entry : groups.entrySet()) {
            List<IncomeTaxIssueInfo> list = entry.getValue();
            IncomeTaxIssueInfo issueInfo = list.get(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fksm", issueInfo.getFeedbackDesc());
            map.put("fkrxm", issueInfo.getFeedbackPerson());
            this.setResult(issueInfo, map);
            map.put("fkrlxdh", issueInfo.getFeedbackPhone());
            map.put("fkrq", CmpDateUtil.getDateStr(fkrq));
            Long messageId = entry.getKey();
            map.put("id", messageId);
            ArrayList attachmentList = new ArrayList();
            String oql = "select attachment.name, attachment.id, attachment.simpleName where boID in (" + this.getIssueIds(list) + ")";
            BoAttchAssoCollection attachments = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(oql);
            if (!attachments.isEmpty()) {
                for (int i = 0; i < attachments.size(); ++i) {
                    HashMap<String, String> attachmentMap = new HashMap<String, String>();
                    BoAttchAssoInfo boAttchAssoInfo = attachments.get(i);
                    String fileName = boAttchAssoInfo.getAttachment().getName() + "." + boAttchAssoInfo.getAttachment().getSimpleName();
                    attachmentMap.put("wjmc", fileName);
                    String file = this.getBase64String(ctx, base64, boAttchAssoInfo);
                    attachmentMap.put("file", file);
                    attachmentList.add(attachmentMap);
                }
            }
            map.put("zmcllb", attachmentList);
            List<Map<String, Object>> ssmxlb = this.setSsmxlb(list);
            map.put("ssmxlb", ssmxlb);
            sszycllb.add(map);
        }
        paramMap.put("sszycllb", sszycllb);
        IObjectPK taskId = TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.IncomeIssueHandle, paramMap);
        CoreBaseCollection relations = new CoreBaseCollection();
        ArrayList<String> issueIds = new ArrayList<String>();
        for (IncomeTaxIssueInfo issueInfo : issues) {
            TaskIncomeTaxRelationInfo relationInfo = new TaskIncomeTaxRelationInfo();
            relationInfo.setBizId(issueInfo.getId().toString());
            relationInfo.setTaskId(taskId.toString());
            relations.add((CoreBaseInfo)relationInfo);
            issueIds.add(issueInfo.getId().toString());
        }
        String sql = "update t_hr_sIncomeTaxIssue set fStatus = ?, fFeedbackDate = ? where fid in (" + CmpStrUtil.convertCollectionToSql(issueIds) + ")";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = new Object[]{1, CmpDateUtil.toSqlDate(fkrq)};
        params.add(param);
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        try {
            TaskIncomeTaxRelationFactory.getLocalInstance(ctx).addnewBatchData(relations);
        }
        catch (EASBizException e) {
            LOG.error((Object)"addNewBatchData error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private String getBase64String(Context ctx, Base64 base64, BoAttchAssoInfo boAttchAssoInfo) throws BOSException, EASBizException {
        String attachmentId = boAttchAssoInfo.getAttachment().getId().toString();
        byte[] bytes = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attachmentId);
        if (null == bytes) {
            throw new BOSException("\u6682\u65f6\u4e0d\u652f\u6301\u9644\u4ef6\u5b58\u50a8\u4e3a\u975eDB\u7684\u65b9\u5f0f\uff0c\u82e5\u9700\u4f7f\u7528\u8be5\u529f\u80fd\uff0c\u8bf7\u7ba1\u7406\u5458\u767b\u5f55-\u3010\u53c2\u6570\u8bbe\u7f6e\u3011-\u3010\u516c\u5171\u53c2\u6570\u3011\u4e2d\uff0c\u8c03\u6574\u9644\u4ef6\u5b58\u50a8\u65b9\u5f0f\u3002");
        }
        return base64.encodeAsString(bytes);
    }

    private List<Map<String, Object>> setSsmxlb(List<IncomeTaxIssueInfo> list) {
        ArrayList<Map<String, Object>> ssmxlb = new ArrayList<Map<String, Object>>();
        for (IncomeTaxIssueInfo issueInfo : list) {
            if (issueInfo.getIssueItem() != IncomeTaxIssueItemEnum.INCOME) continue;
            HashMap<String, String> ssmx = new HashMap<String, String>();
            ssmx.put("ssmxxh", issueInfo.getEntry().getIndex());
            YesOrNoEnum isExisted = issueInfo.getEntry().getIsExisted();
            ssmx.put("czbz", isExisted == YesOrNoEnum.YES ? "Y" : "N");
            ssmxlb.add(ssmx);
        }
        return ssmxlb;
    }

    private String getIssueIds(List<IncomeTaxIssueInfo> list) {
        ArrayList<String> ids = new ArrayList<String>();
        for (IncomeTaxIssueInfo issueInfo : list) {
            ids.add(issueInfo.getId().toString());
        }
        return CmpStrUtil.convertCollectionToSql(ids);
    }

    private Map<Long, List<IncomeTaxIssueInfo>> groupIssuesByMessageId(List<IncomeTaxIssueInfo> issues) {
        HashMap<Long, List<IncomeTaxIssueInfo>> groups = new HashMap<Long, List<IncomeTaxIssueInfo>>();
        for (IncomeTaxIssueInfo issue : issues) {
            long messageId = issue.getMessageId();
            ArrayList<IncomeTaxIssueInfo> list = (ArrayList<IncomeTaxIssueInfo>)groups.get(messageId);
            if (null == list) {
                list = new ArrayList<IncomeTaxIssueInfo>();
                groups.put(messageId, list);
            }
            list.add(issue);
        }
        return groups;
    }

    private void setResult(IncomeTaxIssueInfo issueInfo, Map<String, Object> map) {
        if (issueInfo.getResult() == IncomeTaxIssueResult.NOT_REAL) {
            map.put("zccljg", "Y");
        } else {
            map.put("zccljg", "N");
        }
    }

    private Map<String, List<IncomeTaxIssueInfo>> groupIssuesByTaxUnit(IncomeTaxIssueCollection issues) throws BOSException {
        HashMap<String, List<IncomeTaxIssueInfo>> map = new HashMap<String, List<IncomeTaxIssueInfo>>();
        for (int i = 0; i < issues.size(); ++i) {
            IncomeTaxIssueInfo issue = issues.get(i);
            if (issue.getStatus() == IncomeTaxIssueStatusEnum.FINISHED || issue.getStatus() == IncomeTaxIssueStatusEnum.DEALING) {
                throw new BOSException("\u8bf7\u9009\u62e9\u7533\u8bc9\u72b6\u6001\u4e3a[\u672a\u5904\u7406]\u6216\u8005[\u5904\u7406\u5931\u8d25]\u7684\u6570\u636e\u8fdb\u884c\u7533\u8bc9\u5904\u7406\u7ed3\u679c\u4e0a\u4f20\uff01");
            }
            String taxUnitId = issue.getTaxUnit().getId().toString();
            ArrayList<IncomeTaxIssueInfo> list = (ArrayList<IncomeTaxIssueInfo>)map.get(taxUnitId);
            if (null == list) {
                list = new ArrayList<IncomeTaxIssueInfo>();
                map.put(taxUnitId, list);
            }
            list.add(issue);
        }
        return map;
    }

    @Override
    protected void _afterHandleIncomeTaxIssue(Context ctx, String taskId, String response) throws BOSException {
    }

    @Override
    protected void _inviteConfirmedPerson(Context ctx, String selectIds) throws BOSException {
        String oql = "select id, taxUnit.id, taxUnit.taxNumber, taxUnit.regNumber, taxUnit.areaCode, taxUnit.declPassword, taxUnit.realPassword, person.cardType, person.cardNumber  where id in " + CmpStrUtil.buildInSql(selectIds);
        IncomeTaxIssueCollection collection = IncomeTaxIssueFactory.getLocalInstance(ctx).getIncomeTaxIssueCollection(oql);
        Map<String, List<IncomeTaxIssueInfo>> groups = this.groupIssuesByTaxUnit(collection);
        for (Map.Entry<String, List<IncomeTaxIssueInfo>> entry : groups.entrySet()) {
            this.doInvite(ctx, entry.getValue());
        }
        String updateSQL = "update t_hr_sIncomeTaxIssue set fInviteStatus = ?, fInviteDate = ? where fid in " + CmpStrUtil.buildInSql(selectIds);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = new Object[]{1, CmpDateUtil.toSqlDate(new Date())};
        params.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
    }

    private void doInvite(Context ctx, List<IncomeTaxIssueInfo> issues) throws BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        TaxUnitInfo taxUnitInfo = issues.get(0).getTaxUnit();
        paramMap.put("djxhid", taxUnitInfo.getRegNumber() == null ? "" : taxUnitInfo.getRegNumber());
        paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
        paramMap.put("areaid", taxUnitInfo.getAreaCode());
        String yearMonth = CmpDateUtil.getDateStr(CmpDateUtil.getLastMonthEndDate(), "yyyyMM");
        paramMap.put("sdyf", yearMonth);
        String smmm = Base64Utils.decode(taxUnitInfo.getRealPassword());
        paramMap.put("smmm", smmm == null ? "" : smmm);
        paramMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
        paramMap.put("ver", "V2.0.000");
        paramMap.put("TAXUNITID", taxUnitInfo.getId().toString());
        ArrayList<Object> rylb = new ArrayList<Object>();
        for (IncomeTaxIssueInfo issue : issues) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("zzlx", issue.getPerson().getCardType().getAlias());
            map.put("zzhm", issue.getPerson().getCardNumber());
            rylb.add(map);
        }
        paramMap.put("rylb", rylb);
        IObjectPK taskId = TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.ConfirmedIncomeIssueInvite, paramMap);
        CoreBaseCollection relations = new CoreBaseCollection();
        for (IncomeTaxIssueInfo issue : issues) {
            TaskIncomeTaxRelationInfo relationInfo = new TaskIncomeTaxRelationInfo();
            relationInfo.setBizId(issue.getId().toString());
            relationInfo.setTaskId(taskId.toString());
            relations.add((CoreBaseInfo)relationInfo);
        }
        try {
            TaskIncomeTaxRelationFactory.getLocalInstance(ctx).addnewBatchData(relations);
        }
        catch (EASBizException e) {
            LOG.error((Object)"TaskIncomeTaxRelationFactory.addnewBatchData error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _afterInviteConfirmedPerson(Context ctx, String taskId, String response) throws BOSException {
    }

    @Override
    protected void _save(Context ctx, IncomeTaxIssueInfo issue) throws BOSException {
        try {
            IncomeTaxIssueFactory.getLocalInstance(ctx).save((CoreBaseInfo)issue);
            IncomeTaxIssueEntryInfo entryInfo = issue.getEntry();
            if (null != entryInfo.getId()) {
                IncomeTaxIssueEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)issue.getEntry());
            }
        }
        catch (EASBizException e) {
            LOG.error((Object)"_save error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }
}

