/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.app.tax.AbstractTaxAccumulateFacadeControllerBean;
import com.kingdee.shr.compensation.app.tax.Annu;
import com.kingdee.shr.compensation.app.tax.CalSchemeAnnu;
import com.kingdee.shr.compensation.app.tax.ISumItemMapRecord;
import com.kingdee.shr.compensation.app.tax.SumItemMapRecordCollection;
import com.kingdee.shr.compensation.app.tax.SumItemMapRecordFactory;
import com.kingdee.shr.compensation.app.tax.SumItemMapRecordInfo;
import com.kingdee.shr.compensation.app.tax.TaxYearCollection;
import com.kingdee.shr.compensation.app.tax.TaxYearFactory;
import com.kingdee.shr.compensation.app.tax.TaxYearInfo;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.helper.CalSchemeBizUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxAccumulateFacadeControllerBean
extends AbstractTaxAccumulateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.tax.TaxAccumulateFacadeControllerBean");

    @Override
    protected String _taxAccumulate(Context ctx, String cmpSchemeId, String permItemId) throws BOSException, EASBizException {
        CalSchemeInfo calSchemeInfo = CalSchemeBizUtil.getCalSchemeInfo(ctx, cmpSchemeId);
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        int taxYear = this.getTaxYear(ctx, calSchemeInfo, periodYear, periodMonth);
        if (taxYear < 0 && calSchemeInfo.isIsUseForTaxCal()) {
            throw new EASBizException(new NumericExceptionSubItem("002", new PersonCmpFacadeException(PersonCmpFacadeException.NOTAXYEAR).getMessage()));
        }
        Map<String, String> itemMap = this.getAccumulateItemMap(ctx, cmpSchemeId, periodYear, periodMonth, calTime);
        return null;
    }

    @Override
    protected String _taxDeduct(Context ctx, String cmpSchemeId, String permItemId, int periodYear, int periodMonth, int calTime) throws BOSException, EASBizException {
        ISumItemMapRecord iMapRecord = SumItemMapRecordFactory.getLocalInstance(ctx);
        iMapRecord.delete(" where calSchemeID='" + cmpSchemeId + "' and periodYear=" + periodYear + " and periodMonth=" + periodMonth + " and calTime=" + calTime);
        return null;
    }

    private Map<String, String> getAccumulateItemMap(Context ctx, String cmpSchemeId, int periodYear, int periodMonth, int calTime) throws EASBizException {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        try {
            ISumItemMapRecord iMapRecord = SumItemMapRecordFactory.getLocalInstance(ctx);
            SumItemMapRecordInfo mapRecord = null;
            SumItemMapRecordCollection mapColl = iMapRecord.getSumItemMapRecordCollection("select * where calSchemeID='" + cmpSchemeId + "' and periodYear=" + periodYear + " and periodMonth=" + periodMonth + " and calTime=" + calTime);
            mapRecord = mapColl != null && mapColl.size() > 0 ? mapColl.get(0) : new SumItemMapRecordInfo();
            CalSchemeItemCollection itemColl = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection("select cmpItem.* where calScheme.id='" + cmpSchemeId + "' and cmpItem.AccumulateItem != null and cmpItem.AccumulateItem !='none'");
            if (itemColl != null && itemColl.size() > 0) {
                int size = itemColl.size();
                String fieldSn = null;
                String accuItem = null;
                for (int i = 0; i < size; ++i) {
                    CalSchemeItemInfo schemeItem = itemColl.get(i);
                    fieldSn = "s" + schemeItem.getCmpItem().getFieldSn();
                    accuItem = schemeItem.getCmpItem().getAccumulateItem().getValue();
                    if (!accuItem.startsWith("f") && !accuItem.startsWith("F")) {
                        accuItem = "F" + accuItem;
                    }
                    itemMap.put(fieldSn, accuItem);
                }
            }
            mapRecord.setCalSchemeID(cmpSchemeId);
            mapRecord.setPeriodYear(periodYear);
            mapRecord.setPeriodMonth(periodMonth);
            mapRecord.setCalTime(calTime);
            String jsonStr = JSONUtils.convertObjectToJson((Context)ctx, itemMap);
            mapRecord.setItemMap(jsonStr);
            iMapRecord.save((CoreBaseInfo)mapRecord);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new PersonCmpFacadeException(PersonCmpFacadeException.GETPERSONALTAXFAIL);
        }
        return itemMap;
    }

    private int getTaxYear(Context ctx, CalSchemeInfo calSchemeInfo, int periodYear, int periodMonth) throws EASBizException {
        int taxYear = -1;
        try {
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getBeginMonth() <= 12) {
                taxYear = periodYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && periodMonth > calSchemeInfo.getEndMonth()) {
                    ++taxYear;
                }
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && periodMonth < calSchemeInfo.getBeginMonth()) {
                    --taxYear;
                }
                return taxYear;
            }
            TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
            if (taxYearCol != null && taxYearCol.size() > 0) {
                TaxYearInfo taxYearInf = taxYearCol.get(0);
                taxYear = periodYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && periodMonth > taxYearInf.getEndMonth()) {
                    ++taxYear;
                }
                if (taxYearInf.getAnnu() == Annu.thatyear && periodMonth < taxYearInf.getBeginMonth()) {
                    --taxYear;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label104", (Locale)ctx.getLocale())));
        }
        return taxYear;
    }
}

