/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.StateEnum;
import com.kingdee.shr.compensation.app.tax.AbstractTaxItemPlanControllerBean;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanCollection;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanFactory;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanInfo;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanRelFactory;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanRelInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitRecordCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitRecordInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxItemPlanControllerBean
extends AbstractTaxItemPlanControllerBean {
    private static final Logger logger = Logger.getLogger(TaxItemPlanControllerBean.class);

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.isExists(ctx, model);
        TaxItemPlanInfo taxItemPlanInfo = (TaxItemPlanInfo)model;
        taxItemPlanInfo.setState(StateEnum.Enable);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        taxItemPlanInfo.setEnableTime(now);
        taxItemPlanInfo.setCreateTime(now);
        this.addTaxUnitNames(taxItemPlanInfo);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)taxItemPlanInfo);
        taxItemPlanInfo.setId(BOSUuid.read((String)pk.toString()));
        if (null != taxItemPlanInfo.getHrOrgUnit()) {
            this.addTaxItemPlanRel(ctx, taxItemPlanInfo);
        }
        return pk;
    }

    private void addTaxUnitNames(TaxItemPlanInfo taxItemPlanInfo) {
        TaxUnitRecordCollection taxUnitRecords = taxItemPlanInfo.getTaxUnitRecords();
        if (null == taxUnitRecords) {
            return;
        }
        StringBuilder taxUnitNames = new StringBuilder();
        for (int i = 0; i < taxUnitRecords.size(); ++i) {
            TaxUnitRecordInfo taxUnitRecordInfo = taxUnitRecords.get(i);
            if (i == taxUnitRecords.size() - 1) {
                taxUnitNames.append(taxUnitRecordInfo.getTaxUnit().getName());
                break;
            }
            taxUnitNames.append(taxUnitRecordInfo.getTaxUnit().getName()).append(",");
        }
        taxItemPlanInfo.setTaxUnitNames(taxUnitNames.toString());
    }

    private void addTaxItemPlanRel(Context ctx, TaxItemPlanInfo taxItemPlanInfo) throws EASBizException, BOSException {
        if (taxItemPlanInfo.isIsContainSub()) {
            this.addChildTaxItemPlanRel(ctx, taxItemPlanInfo);
        }
        TaxItemPlanRelInfo taxItemPlanRelInfo = new TaxItemPlanRelInfo();
        taxItemPlanRelInfo.setLevel(0);
        taxItemPlanRelInfo.setTaxItemPlanId(taxItemPlanInfo.getId().toString());
        taxItemPlanRelInfo.setHrOrgUnitId(taxItemPlanInfo.getHrOrgUnit().getId().toString());
        TaxItemPlanRelFactory.getLocalInstance(ctx).save(taxItemPlanRelInfo);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.isExists(ctx, model);
        TaxItemPlanInfo taxItemPlanInfo = (TaxItemPlanInfo)model;
        this.addTaxUnitNames(taxItemPlanInfo);
        TaxItemPlanCollection taxItemPlanCollection = TaxItemPlanFactory.getLocalInstance(ctx).getTaxItemPlanCollection("select id,isContainSub,hrOrgUnit.id,hrOrgUnit.number,hrOrgUnit.longNumber where id = '" + taxItemPlanInfo.getId().toString() + "'");
        TaxItemPlanInfo oldTaxItemPlanInfo = taxItemPlanCollection.get(0);
        if (null == oldTaxItemPlanInfo.getHrOrgUnit()) {
            this.addTaxItemPlanRel(ctx, taxItemPlanInfo);
        } else {
            if (taxItemPlanInfo.getHrOrgUnit().getId().equals((Object)oldTaxItemPlanInfo.getHrOrgUnit().getId()) && taxItemPlanInfo.isIsContainSub() != oldTaxItemPlanInfo.isIsContainSub()) {
                if (taxItemPlanInfo.isIsContainSub()) {
                    this.addChildTaxItemPlanRel(ctx, taxItemPlanInfo);
                } else {
                    this.deleteChildTaxItemPlanRel(ctx, taxItemPlanInfo);
                }
            }
            if (!taxItemPlanInfo.getHrOrgUnit().getId().equals((Object)oldTaxItemPlanInfo.getHrOrgUnit().getId())) {
                TaxItemPlanRelFactory.getLocalInstance(ctx).delete("where taxItemPlanId ='" + oldTaxItemPlanInfo.getId().toString() + "'");
                this.addTaxItemPlanRel(ctx, taxItemPlanInfo);
            }
        }
        super._update(ctx, pk, (IObjectValue)taxItemPlanInfo);
    }

    private void addChildTaxItemPlanRel(Context ctx, TaxItemPlanInfo taxItemPlanInfo) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgUnit = this.getHrOrgUnit(ctx, taxItemPlanInfo.getHrOrgUnit().getId().toString());
        String number = hrOrgUnit.getNumber();
        String longNumber = hrOrgUnit.getLongNumber();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id,longNumber where longNumber like '" + longNumber + "%' and number <> '" + number + "'");
        for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
            HROrgUnitInfo hrOrgUnitInfo = hrOrgUnitCollection.get(i);
            String childLongNumber = hrOrgUnitInfo.getLongNumber();
            String substring = childLongNumber.substring(longNumber.length() + 1);
            String[] split = substring.split("!");
            TaxItemPlanRelInfo taxItemPlanRelInfo = new TaxItemPlanRelInfo();
            taxItemPlanRelInfo.setTaxItemPlanId(taxItemPlanInfo.getId().toString());
            taxItemPlanRelInfo.setHrOrgUnitSrcId(taxItemPlanInfo.getHrOrgUnit().getId().toString());
            taxItemPlanRelInfo.setHrOrgUnitId(hrOrgUnitInfo.getId().toString());
            taxItemPlanRelInfo.setLevel(split.length);
            coreBaseCollection.add((CoreBaseInfo)taxItemPlanRelInfo);
        }
        TaxItemPlanRelFactory.getLocalInstance(ctx).save(coreBaseCollection);
    }

    private HROrgUnitInfo getHrOrgUnit(Context ctx, String id) throws BOSException {
        IHROrgUnit ihrOrgUnit = HROrgUnitFactory.getLocalInstance((Context)ctx);
        HROrgUnitCollection hrOrgUnitCollection = ihrOrgUnit.getHROrgUnitCollection("select id,number,longNumber where id ='" + id + "'");
        if (hrOrgUnitCollection.size() == 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label61", (Locale)ctx.getLocale()));
        }
        return hrOrgUnitCollection.get(0);
    }

    private void deleteChildTaxItemPlanRel(Context ctx, TaxItemPlanInfo taxItemPlanInfo) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgUnit = this.getHrOrgUnit(ctx, taxItemPlanInfo.getHrOrgUnit().getId().toString());
        String number = hrOrgUnit.getNumber();
        String longNumber = hrOrgUnit.getLongNumber();
        HROrgUnitInfo hrOrgUnitInfo = null;
        StringBuilder stringBuffer = new StringBuilder("(");
        HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id where longNumber like '" + longNumber + "%' and number <> '" + number + "'");
        if (hrOrgUnitCollection.size() == 0) {
            return;
        }
        for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
            hrOrgUnitInfo = hrOrgUnitCollection.get(i);
            if (i == hrOrgUnitCollection.size() - 1) {
                stringBuffer.append("'").append(hrOrgUnitInfo.getId().toString()).append("'").append(")");
                break;
            }
            stringBuffer.append("'").append(hrOrgUnitInfo.getId().toString()).append("'").append(",");
        }
        TaxItemPlanRelFactory.getLocalInstance(ctx).delete("where hrOrgUnitId in" + stringBuffer + " and taxItemPlanId ='" + taxItemPlanInfo.getId().toString() + "'");
    }

    private void isExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxItemPlanInfo taxItemPlanInfo = (TaxItemPlanInfo)model;
        String id = "";
        String name = taxItemPlanInfo.getName();
        String number = taxItemPlanInfo.getNumber();
        String oqlName = "select id where name = '" + name + "'";
        String oqlNumber = "select id where number = '" + number + "'";
        if (taxItemPlanInfo.getId() != null && !StringUtils.isEmpty((String)taxItemPlanInfo.getId().toString())) {
            id = taxItemPlanInfo.getId().toString();
            oqlName = oqlName + " and id <> '" + id + "'";
            oqlNumber = oqlNumber + " and id <> '" + id + "'";
        }
        if (this._exists(ctx, oqlNumber)) {
            throw new BOSException(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label62", (Locale)ctx.getLocale()), number));
        }
        if (this._exists(ctx, oqlName)) {
            throw new BOSException(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label63", (Locale)ctx.getLocale()), name));
        }
    }
}

