/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.app.tax.IsAllowedQuoted;
import com.kingdee.shr.compensation.app.tax.TaxSpeAddDedRecordFactory;
import com.kingdee.shr.compensation.app.tax.TaxSpeAddDedRecordInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxSpeAddDedReportFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.util.Base64Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TaxSpeAddDedReportFacadeControllerBean
extends AbstractTaxSpeAddDedReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger(TaxSpeAddDedReportFacadeControllerBean.class);

    @Override
    protected List _report(Context ctx, Map paramMap) throws BOSException {
        if (this.checkParams(paramMap)) {
            throw new BOSException("\u4e13\u9879\u9644\u52a0\u6263\u9664\u7533\u62a5\u670d\u52a1\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String taxUnitID = (String)paramMap.get("TAXUNITID");
        String period = (String)paramMap.get("PERIOD");
        String taxPersonRecordEntryIDS = (String)paramMap.get("TaxPersonRecordEntryIDS");
        TaxUnitCollection taxUnitCollection = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitCollection("select id,name,number,taxNumber,areaCode,regNumber,declPassword,realPassword,isAutoDeduct where id = '" + taxUnitID + "'");
        if (null == taxUnitCollection || taxUnitCollection.size() == 0) {
            throw new BOSException("\u751f\u6210\u9879\u9644\u52a0\u6263\u9664\u7533\u62a5\u670d\u52a1\u65f6\uff0c\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7eb3\u7a0e\u5355\u4f4d\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u662f\u5426\u88ab\u5220\u9664");
        }
        TaxUnitInfo taxUnitInfo = taxUnitCollection.get(0);
        IsAllowedQuoted isAutoDeduct = taxUnitInfo.getIsAutoDeduct();
        if (0 == isAutoDeduct.getValue()) {
            return null;
        }
        period = period.replace("-", "");
        int periodYear = Integer.parseInt(period.substring(0, 4));
        int periodMonth = Integer.parseInt(period.substring(4, 6));
        StringBuilder checkSQL = new StringBuilder();
        checkSQL.append(" SELECT ");
        checkSQL.append(" PERSON.FID PERSONID, ");
        checkSQL.append(" PERSON.FNAME_L2 PERSONNAME, ");
        checkSQL.append(" TAX.FCARDTYPE CARDTYPE, ");
        checkSQL.append(" TAX.FReportName reportName, ");
        checkSQL.append(" TAX.FCARDNUMBER CARDNUMBER, ");
        checkSQL.append(" ENTRY.FID ENTRYID, ");
        checkSQL.append(" ENTRY.FTAXUNITID TAXUNITID, ");
        checkSQL.append(" RECORD.FID RECORDID, ");
        checkSQL.append(" RECORD.FSTATE ");
        checkSQL.append(" FROM T_HR_STAXPERSONRECORD TAX ");
        checkSQL.append(" INNER JOIN T_HR_STAXPERSONRECORDENTRY ENTRY ON TAX.FID = ENTRY.FBILLID  ");
        checkSQL.append(" LEFT JOIN T_HR_STAXSPEADDDEDRECORD RECORD ON ENTRY.FPERSONID = RECORD.FPERSONID AND ENTRY.FTAXUNITID = RECORD.FTAXUNITID ");
        checkSQL.append(" AND RECORD.FPERIODYEAR  =  ").append(periodYear);
        checkSQL.append(" AND RECORD.FPERIODMONTH = ").append(periodMonth);
        checkSQL.append(" AND RECORD.FTAXUNITID = '").append(taxUnitInfo.getId().toString()).append("' ");
        checkSQL.append(" INNER JOIN T_BD_PERSON PERSON ON ENTRY.FPERSONID = PERSON.FID  ");
        checkSQL.append(" WHERE ");
        checkSQL.append(" ENTRY.FID IN (").append(taxPersonRecordEntryIDS).append(") ");
        String updateRecordSQL = " update T_HR_STAXSPEADDDEDRECORD set Fstate = 30, FTaxCalTaskID = ? where FID = ?";
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString());
            ArrayList rylb = new ArrayList();
            CoreBaseCollection recordCollection = new CoreBaseCollection();
            HashSet<String> reportPersonSet = new HashSet<String>();
            while (rowSet.next()) {
                String recordId = rowSet.getString("RECORDID");
                if (!StringUtils.isEmpty((CharSequence)recordId)) {
                    int state = rowSet.getInt("FSTATE");
                    if (40 == state || 30 == state) continue;
                    if (50 == state) {
                        Object[] updateParam = new Object[]{null, recordId};
                        updateParamList.add(updateParam);
                    }
                }
                String personId = rowSet.getString("PERSONID");
                String personName = rowSet.getString("reportName");
                if (StringUtils.isEmpty((CharSequence)personName)) {
                    personName = rowSet.getString("PERSONNAME");
                }
                String cardType = rowSet.getString("CARDTYPE");
                String cardNumber = rowSet.getString("CARDNUMBER");
                String reportPersonSetKey = personId + "_" + taxUnitID + "_" + periodYear + "_" + periodMonth;
                if (reportPersonSet.contains(reportPersonSetKey)) continue;
                reportPersonSet.add(reportPersonSetKey);
                HashMap<String, String> person = new HashMap<String, String>();
                person.put("xm", personName);
                person.put("zzlx", CardTypeEnum.getEnum(cardType).getAlias());
                person.put("zzhm", cardNumber);
                rylb.add(person);
                TaxSpeAddDedRecordInfo taxSpeAddDedRecordInfo = new TaxSpeAddDedRecordInfo();
                taxSpeAddDedRecordInfo.setTaxUnit(taxUnitInfo);
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personId));
                taxSpeAddDedRecordInfo.setPerson(personInfo);
                taxSpeAddDedRecordInfo.setPeriodYear(periodYear);
                taxSpeAddDedRecordInfo.setPeriodMonth(periodMonth);
                taxSpeAddDedRecordInfo.setState(TaxCalInitDetailStateEnum.RUNNING);
                recordCollection.add((CoreBaseInfo)taxSpeAddDedRecordInfo);
            }
            if (rylb.isEmpty()) {
                return null;
            }
            paramMap.put("qymc", taxUnitInfo.getName());
            paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
            paramMap.put("areaid", taxUnitInfo.getAreaCode());
            paramMap.put("sdyf", period);
            paramMap.put("ver", "V2.0.000");
            paramMap.put("djxhid", taxUnitInfo.getRegNumber());
            paramMap.put("smmm", Base64Utils.decode(taxUnitInfo.getRealPassword()));
            paramMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
            paramMap.put("xzzxxx", "\u662f");
            HashMap dataMap = new HashMap();
            dataMap.put("rylb", rylb);
            paramMap.put("data", dataMap);
            IObjectPK pk = TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.TaxSpeAddtionalDedReport, paramMap);
            TaxCalTaskInfo taxCalTaskInfo = new TaxCalTaskInfo();
            taxCalTaskInfo.setId(BOSUuid.read((String)pk.toString()));
            int size = recordCollection.size();
            for (int i = 0; i < size; ++i) {
                TaxSpeAddDedRecordInfo taxSpeAddDedRecordInfo = (TaxSpeAddDedRecordInfo)recordCollection.get(i);
                taxSpeAddDedRecordInfo.setTaxCalTask(taxCalTaskInfo);
            }
            for (Object[] objects : updateParamList) {
                objects[0] = pk.toString();
            }
            TaxSpeAddDedRecordFactory.getLocalInstance(ctx).saveBatchData(recordCollection);
            if (updateParamList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateRecordSQL, updateParamList);
            }
            ArrayList<IObjectPK> arrayList = new ArrayList<IObjectPK>();
            arrayList.add(pk);
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u751f\u6210\u9879\u9644\u52a0\u6263\u9664\u7533\u62a5\u670d\u52a1\u65f6\uff0c\u5224\u65ad\u662f\u5426\u5b58\u5728\u672a\u4e0b\u8f7d\u7684\u4e13\u9879\u9644\u52a0\u6263\u9664\u4fe1\u606f\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    private boolean checkParams(Map<String, Object> paramMap) {
        if (!paramMap.containsKey("accept_id") && !paramMap.containsKey("RELAYTASK")) {
            return true;
        }
        return !paramMap.containsKey("TaxPersonRecordEntryIDS");
    }

    @Override
    protected void _save(Context ctx, String taskID, String result) throws BOSException {
        Map bodyMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)result, Map.class);
        String code = (String)bodyMap.get("code");
        if ("0000".equals(code)) {
            String updateSql = "update T_HR_STAXSPEADDDEDRECORD set FSTATE = 40 where FTaxCalTaskID = '" + taskID + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }
}

