/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.externaldata;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.timepiece.externaldata.AbstractExternalDataCalculateFacadeControllerBean;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataException;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigInfo;
import com.kingdee.shr.compensation.util.timepiece.ExternalConfigUtil;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.formula.ConcurrentCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExternalDataCalculateFacadeControllerBean
extends AbstractExternalDataCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataCalculateFacadeControllerBean");
    private ConfigInfo configInfo;

    @Override
    protected Map _calculate(Context ctx, Map param) throws BOSException, EASBizException {
        String configId = (String)param.get("configId");
        String condition = (String)param.get("condition");
        String mainTable = this.getMainTable(ctx, configId);
        this.initConfigData(ctx, configId);
        BaseFormulaCollection calFormulas = this.initCalFormula(ctx, configId);
        String uid = this.post(ctx, mainTable, configId, calFormulas, condition);
        HashMap result = Maps.newHashMap();
        result.put("uid", uid);
        return result;
    }

    protected String getMainTable(Context ctx, String configId) throws BOSException, EASBizException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select FINDEX from  T_HR_SExtDataConfig where fid = ?", (Object[])new Object[]{configId});
        int index = 0;
        try {
            while (rowSet.next()) {
                index = rowSet.getInt("FINDEX");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (index == 0) {
            throw new ExternalDataException(ExternalDataException.EXCEPTION12);
        }
        return "CT_COM_CmpDyCreate" + String.format("%04d", index);
    }

    protected BaseFormulaCollection initCalFormula(Context ctx, String configId) throws BOSException, EASBizException {
        BaseFormulaCollection formulaCollection;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select id,name,calItem,express,listItem,listFunc,listTable,sortSn,bigExpress ");
        sqlBuffer.append(" where isCal = 1 and businessRelationConfig.businessId = '").append(configId).append("' \r\n");
        sqlBuffer.append(" order by sortSn");
        try {
            formulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(ExternalDataException.EXCEPTION12, (Throwable)e);
        }
        return formulaCollection;
    }

    protected void initConfigData(Context ctx, String configId) throws BOSException {
        try {
            this.configInfo = ExternalConfigUtil.initExtDataConfig(ctx, configId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String post(Context ctx, String mainTable, String configId, BaseFormulaCollection formulaCollection, String condition) throws EASBizException, BOSException {
        try {
            ConcurrentCalculatorProxy2.Parameters param = ConcurrentCalculatorProxy2.createParamInstance();
            param.setCtx(ctx);
            param.setMainTableName(mainTable);
            param.setMainTableAlias("EXTDATA");
            param.setCalCategoryNum("CMP_SUB_TIMEPIECE_EXTERNALDATA");
            param.setSchemeID(configId);
            param.setEndDate(new Date());
            param.setMainTableRowFilter(condition);
            param.setFormulaCollection(formulaCollection);
            param.setOuterData((Object)this.configInfo);
            ConcurrentCalculatorProxy2 calculator = new ConcurrentCalculatorProxy2(param, new SalaryCalculator2(), false);
            calculator.run();
            return calculator.getUID();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

