/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.cal;

import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.base.impl.SaveCalResultImplCommon;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.util.FunUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetAdjustSaveCalResultImplCommon
extends SaveCalResultImplCommon {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.budget.budgetadjust.cal.BudgetAdjustSaveCalResultImplCommon");

    public void saveCalResult(InitCalData initCalData, Sheet result) throws SalaryException {
        String errMsg = result.getErrMsg();
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            throw new RuntimeException(errMsg);
        }
        List changeDataList = result.getChangeDataList();
        if (null == changeDataList || changeDataList.isEmpty()) {
            return;
        }
        ArrayList<String> updateSqlList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        String nowDate = FunUtils.toKSqlDate((Date)calendar.getTime());
        Map allCnSnMap = initCalData.getAllCnSnMap();
        String mainTableName = initCalData.getMainTableName();
        Context ctx = initCalData.getCtx();
        Map strItemLenMap = (Map)allCnSnMap.get("strLengthMap");
        Map dataTypeMap = (Map)allCnSnMap.get("dataTypeMap");
        Map f7TypeMap = allCnSnMap.containsKey("f7TypeMap") ? (Map)allCnSnMap.get("f7TypeMap") : new HashMap();
        int tempLength = 0;
        String fid = "";
        String column = "";
        String value = "";
        for (Row row : changeDataList) {
            StringBuffer setStr = new StringBuffer();
            StringBuffer updateSql = new StringBuffer();
            fid = row.getFID();
            List cells = row.getCells();
            for (Cell cell : cells) {
                column = cell.getColumn();
                value = cell.getValue();
                if (value != null && strItemLenMap.containsKey(column.toLowerCase(Locale.ENGLISH))) {
                    tempLength = (Integer)strItemLenMap.get(column.toLowerCase(Locale.ENGLISH));
                    value = value.length() > tempLength ? value.substring(0, tempLength - 1) : value;
                } else if (value != null && dataTypeMap != null && (Integer)dataTypeMap.get(column.toLowerCase(Locale.ENGLISH)) == 0) {
                    value = CmpStrUtil.subZeroAndDot(value);
                    Pattern pattern = Pattern.compile("^-?[0-9]{1,10}([.][0-9]{0,10})?$");
                    Matcher matcher = pattern.matcher(value);
                    if (!matcher.matches()) continue;
                    BigDecimal bigValue = new BigDecimal(value);
                    value = bigValue.setScale(2, RoundingMode.HALF_UP).toString();
                }
                if (value != null && f7TypeMap.get(column.toLowerCase()) != null) {
                    boolean inTable = false;
                    for (Map.Entry entry : ((Map)f7TypeMap.get(column.toLowerCase())).entrySet()) {
                        if (!value.equals(entry.getValue())) continue;
                        inTable = true;
                        value = String.valueOf(entry.getKey());
                        break;
                    }
                    if (!inTable) {
                        value = null;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)(value = StringEscapeUtils.escapeSql((String)value)))) {
                    setStr.append(", ").append(column).append(" = null ");
                    continue;
                }
                setStr.append(", ").append(column).append(" = '").append(value).append("' ");
            }
            updateSql.append("update ").append(mainTableName).append(" set ");
            updateSql.append(setStr.toString().replaceFirst(",", ""));
            updateSql.append(" ,FLastUpdateTime = ").append(nowDate);
            updateSql.append(" where fid = '").append(fid).append("'");
            updateSqlList.add(updateSql.toString());
        }
        this.executeBatch(ctx, updateSqlList.toArray());
    }
}

