/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.service.budget.SubBudgetAssignService;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubBudgetManageHelper {
    private static Logger logger = Logger.getLogger(SubBudgetManageHelper.class);
    public static final String SPLIT_FLAG = "###";
    private String billId;
    private Context ctx;
    private CmpBudgetSchemeInfo budgetScheme;
    private List<String> budgetPeriodFields = null;
    private List<String> budgetPeriodColNames = null;
    private List<String> budgetItemFieldSn = null;
    private Map<String, Object> subItemIdMap = null;
    private BudgetAdjustService service = new BudgetAdjustService();
    private boolean updateHis = false;

    public SubBudgetManageHelper(Context ctx, String billId, CmpBudgetSchemeInfo budgetScheme, boolean updateHis) throws BOSException, EASBizException {
        this.billId = billId;
        this.ctx = ctx;
        this.budgetScheme = budgetScheme;
        this.updateHis = updateHis;
        BudgetPeriodMapInfo subItemMap = this.service.getSubItemMapByScheme(ctx, budgetScheme);
        this.budgetPeriodFields = subItemMap.getFieldNameList();
        this.budgetPeriodColNames = subItemMap.getColNameList();
        BudgetItemMapInfo itemMap = this.service.getItemMapByScheme(ctx, budgetScheme.getId().toString());
        this.budgetItemFieldSn = itemMap.getFieldSnList();
        this.subItemIdMap = itemMap.getSubItemIdMap();
    }

    public void update(String addFilterSql) throws EASBizException, BOSException, SQLException {
        Map<String, Object> subManageParams = this.assembleSubManageParams(addFilterSql);
        Map<String, BigDecimal> budgetDataMap = this.assembleBudgetDataMap(addFilterSql);
        List subBudgetManageInfoList = (List)subManageParams.get("subBudgetManageInfoList");
        SubBudgetAssignService subBudgetAssignService = new SubBudgetAssignService();
        subBudgetAssignService.assignSubBudgetData(this.ctx, this.budgetScheme.getId().toString(), budgetDataMap, subBudgetManageInfoList, new HashMap());
    }

    public Map<String, BigDecimal> assembleBudgetDataMap(String addFilterSql) throws BOSException, SQLException {
        HashMap<String, BigDecimal> budgetDataMap = new HashMap<String, BigDecimal>();
        if (this.subItemIdMap == null) {
            return budgetDataMap;
        }
        StringBuilder whereSql = new StringBuilder();
        whereSql.append("where entry.fbillId = ? ");
        if (!StringUtils.isEmpty((String)addFilterSql)) {
            whereSql.append(addFilterSql);
        }
        String queryEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustEntrySql(this.ctx, this.budgetItemFieldSn, whereSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)queryEntrySql, (Object[])new Object[]{this.billId});
        while (rs.next()) {
            String budgetManageId = rs.getString("budgetManageId");
            if (StringUtils.isEmpty((String)budgetManageId)) continue;
            for (int i = 0; i < this.budgetItemFieldSn.size(); ++i) {
                String fieldSn = this.budgetItemFieldSn.get(i);
                if (this.subItemIdMap.get(fieldSn) == null) continue;
                String itemId = this.subItemIdMap.get(fieldSn).toString();
                String mapKey = budgetManageId + SPLIT_FLAG + itemId;
                String colName = this.updateHis ? "T" + fieldSn : "M" + fieldSn;
                BigDecimal bigValue = rs.getBigDecimal(colName);
                budgetDataMap.put(mapKey, bigValue);
            }
        }
        return budgetDataMap;
    }

    public Map<String, Object> assembleSubManageParams(String addFilterSql) throws BOSException, SQLException {
        ArrayList<SubBudgetManageInfo> subList = new ArrayList<SubBudgetManageInfo>();
        StringBuilder whereSql = new StringBuilder();
        whereSql.append("where subentry.fbillId = ? ");
        if (!StringUtils.isEmpty((String)addFilterSql)) {
            whereSql.append(addFilterSql);
        }
        String querySubEntrySql = "";
        querySubEntrySql = this.updateHis ? BudgetAdjustSqlUtils.queryBudgetAdjustSubEntryHisSql(this.budgetPeriodFields, this.budgetPeriodColNames, whereSql.toString()) : BudgetAdjustSqlUtils.queryBudgetAdjustSubEntrySql(this.budgetPeriodFields, this.budgetPeriodColNames, whereSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)querySubEntrySql, (Object[])new Object[]{this.billId});
        while (rs.next()) {
            SubBudgetManageInfo info = new SubBudgetManageInfo();
            info.setId(BOSUuid.read((String)rs.getString("subBudgetManageId")));
            CmpBudgetItemInfo itemInfo = new CmpBudgetItemInfo();
            String itemId = rs.getString("budgetItemId");
            itemInfo.setId(BOSUuid.read((String)itemId));
            info.setCmpBudgetItem(itemInfo);
            BudgetManageInfo manageInfo = new BudgetManageInfo();
            String manageId = rs.getString("budgetManageId");
            manageInfo.setId(BOSUuid.read((String)manageId));
            info.setBudgetMange(manageInfo);
            for (String colName : this.budgetPeriodColNames) {
                info.put(colName, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
            }
            subList.add(info);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("subBudgetManageInfoList", subList);
        return result;
    }
}

