/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemInfo;
import com.kingdee.shr.compensation.app.budget.BudgetYesNoEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemDataType;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.util.columnModel.CmpColumnModelWrapper;
import com.kingdee.shr.compensation.util.columnModel.CmpColumnModels;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetAdjustEntryUtils {
    private static Logger logger = Logger.getLogger(BudgetAdjustEntryUtils.class);
    private static String FIELDS_STR = "fields";
    private static String FORMULA_STR = "formula";
    private static String TARGET_STR = "targetField";
    private static String TARGET_NAME_STR = "name";
    private static String TARGET_PRECISION_STR = "decimalPrecision";

    public static CmpColumnModels assembleBudgetSchemeColModel(Context ctx, String budgetSchemeId) throws BOSException {
        CmpColumnModels columnModels = new CmpColumnModels();
        BudgetTemplateItemCollection itemCollection = BudgetTemplateItemFactory.getLocalInstance(ctx).getBudgetTemplateItemCollection("select budgetItem.*, isRequired where template.id in (select FTemplateID from T_HR_SCmpBudgetScheme where fid = '" + budgetSchemeId + "') order by sortSn");
        Set<String> calItemPropNames = null;
        try {
            calItemPropNames = BudgetAdjustEntryUtils.getCalItemPropNames(ctx, budgetSchemeId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Map<String, List<Map<String, Object>>> autoCalFieldOptionMap = BudgetAdjustEntryUtils.initAutoCalFieldOption(ctx, budgetSchemeId);
        for (int i = 0; i < itemCollection.size(); ++i) {
            CmpColumnModelWrapper wrapperHis;
            CmpColumnModelWrapper wrapper;
            boolean isRequired;
            BudgetTemplateItemInfo templateItemInfo = itemCollection.get(i);
            CmpBudgetItemInfo budgetItem = templateItemInfo.getBudgetItem();
            String propNameHis = "T" + budgetItem.getFieldSn();
            String propName = "M" + budgetItem.getFieldSn();
            boolean bl = isRequired = BudgetYesNoEnum.YES == templateItemInfo.getIsRequired();
            if (CmpBudgetItemDataType.NUMBER == budgetItem.getDataType()) {
                wrapper = CmpColumnModelWrapper.createDecimalColModel(propName, budgetItem.getName(), null);
                wrapper.assembleDecimalInputEditOptions(isRequired, budgetItem.getDataDot().getValue(), budgetItem.getDataLength());
                wrapperHis = CmpColumnModelWrapper.createDecimalColModel(propNameHis, budgetItem.getName(), null);
                wrapperHis.assembleDecimalInputEditOptions(false, budgetItem.getDataDot().getValue(), budgetItem.getDataLength());
                if (autoCalFieldOptionMap.containsKey(propNameHis)) {
                    JSONObject editoptions = (JSONObject)wrapper.get().get("editoptions");
                    editoptions.put("autoCal", (Object)true);
                    editoptions.put("cellFomular", autoCalFieldOptionMap.get(propName));
                }
            } else if (CmpBudgetItemDataType.STRING == budgetItem.getDataType()) {
                wrapper = CmpColumnModelWrapper.createTextColModel(propName, budgetItem.getName(), null);
                wrapper.assembleTextInputEditOptions(isRequired, budgetItem.getDataLength());
                wrapperHis = CmpColumnModelWrapper.createTextColModel(propNameHis, budgetItem.getName(), null);
                wrapperHis.assembleTextInputEditOptions(false, budgetItem.getDataLength());
            } else {
                wrapper = CmpColumnModelWrapper.createEmptyColModel();
                wrapperHis = CmpColumnModelWrapper.createEmptyColModel();
            }
            if (calItemPropNames != null && calItemPropNames.contains(propNameHis)) {
                wrapper.disable();
                if (isRequired) {
                    wrapper.requiredAndDisable();
                }
            }
            columnModels.add(BudgetAdjustEntryUtils.getMultiLan("label0", ctx) + budgetItem.getName(), wrapperHis.disable().removeWidth().get());
            columnModels.add(BudgetAdjustEntryUtils.getMultiLan("label1", ctx) + budgetItem.getName(), wrapper.removeWidth().get());
        }
        return columnModels;
    }

    public static Set<String> getCalItemPropNames(Context ctx, String submitSchemeId) throws BOSException, SQLException {
        HashSet<String> calItemIdSet = new HashSet<String>();
        String formulaSql = "SELECT bf.FCalItem calItem FROM T_HR_SBaseFormula bf LEFT JOIN T_HR_SBusinessRelationConfig brc ON bf.FBUSINESSRELATIONCONFIGID = brc.FID WHERE brc.FBUSINESSID = (SELECT FTemplateID FROM T_HR_SCmpBudgetScheme where fid = ?) AND bf.FISCAL = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)formulaSql, (Object[])new Object[]{submitSchemeId});
        while (rs.next()) {
            String calItemPropName = rs.getString("calItem");
            if (StringUtils.isEmpty((CharSequence)calItemPropName)) continue;
            calItemIdSet.add(calItemPropName);
        }
        return calItemIdSet;
    }

    public static Map<String, Object> assembleSubBudgetSchemeColModel(Context ctx, String budgetSchemeId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)budgetSchemeId)) {
            return resultMap;
        }
        BudgetAdjustService service = new BudgetAdjustService();
        CmpBudgetSchemeInfo schemeInfo = service.getSchemeInfo(ctx, budgetSchemeId);
        BudgetPeriodMapInfo subItemMap = service.getSubItemMapByScheme(ctx, schemeInfo);
        resultMap.put("budgetSchemeInfo", schemeInfo);
        List<String> colLiasList = subItemMap.getColLiasList();
        List<String> colNameList = subItemMap.getColNameList();
        resultMap.put("colNameList", colNameList);
        CmpColumnModels columnModels = new CmpColumnModels();
        for (int i = 0; i < colLiasList.size(); ++i) {
            BudgetAdjustEntryUtils.addSubColumnModel(columnModels, colLiasList.get(i), colNameList.get(i));
        }
        resultMap.put("colNames", columnModels.getColNames());
        resultMap.put("colModel", columnModels.getColModel());
        return resultMap;
    }

    public static void addSubColumnModel(CmpColumnModels columnModels, String colName, String colModelName) {
        CmpColumnModelWrapper wrapper = CmpColumnModelWrapper.createDecimalColModel(colModelName, colName, null);
        wrapper.assembleDecimalInputEditOptions(false, 2, 0);
        columnModels.add(colName, wrapper.removeWidth().get());
    }

    public static Map<String, List<Map<String, Object>>> initAutoCalFieldOption(Context ctx, String schemeId) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(" SELECT FORMULA.FCALITEM, FORMULA.FSORTSN, FORMULA.FEXPRESS, FORMULA.FLISTITEM, ");
        sqlBuffer.append(" ITEM.FDATADOT FDATADOT ");
        sqlBuffer.append(" FROM T_HR_SBUSINESSRELATIONCONFIG CONFIG  ");
        sqlBuffer.append(" INNER JOIN T_HR_SBASEFORMULA FORMULA ON FORMULA.FBUSINESSRELATIONCONFIGID = CONFIG.FID ");
        sqlBuffer.append(" LEFT JOIN T_HR_SCmpBudgetItem ITEM ON FORMULA.FCALITEM =  CONCAT('T',CONVERT(VARCHAR,ITEM.FIELDSN))  ");
        sqlBuffer.append(" WHERE ");
        sqlBuffer.append(" CONFIG.FBUSINESSID = (SELECT FTemplateID FROM T_HR_SCmpBudgetScheme where fid = ?) ");
        sqlBuffer.append(" AND FORMULA.FISCAL = 1 ");
        sqlBuffer.append(" AND FORMULA.FEXPRESS IS NOT NULL ");
        sqlBuffer.append(" AND FORMULA.FCALITEM IS NOT NULL ");
        sqlBuffer.append(" AND (FORMULA.FLISTFUNC IS NULL OR FORMULA.FLISTFUNC LIKE '') ");
        sqlBuffer.append(" AND (FORMULA.FLISTVAR IS NULL OR FORMULA.FLISTVAR LIKE '') ");
        sqlBuffer.append(" AND ITEM.FDATATYPE = '").append("0").append("' ");
        sqlBuffer.append(" ORDER BY FORMULA.FSORTSN ");
        String tableName = "T_HR_SBudgetManage";
        HashMap result = new HashMap();
        HashMap<String, List<Map<String, Object>>> realResult = new HashMap<String, List<Map<String, Object>>>();
        try {
            List perFieldFormulas;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{schemeId});
            String calItem = "";
            String express = "";
            String listItems = "";
            int targetDataDot = 2;
            while (rs.next()) {
                HashMap<String, Object> targetFieldMap = new HashMap<String, Object>();
                calItem = rs.getString("FCALITEM");
                targetDataDot = rs.getInt("FDATADOT");
                targetFieldMap.put(TARGET_NAME_STR, calItem);
                targetFieldMap.put(TARGET_PRECISION_STR, targetDataDot);
                express = rs.getString("FEXPRESS");
                listItems = rs.getString("FLISTITEM");
                if (express.contains("if")) continue;
                express = express.replace(tableName, "").replace("_", "");
                express = express.substring(express.indexOf("=") + 1);
                String[] listItemsArr = (listItems = listItems.replace(tableName, "").replace("double", "").replace("~", "")).split(";");
                if (listItemsArr.length == 1 && listItems.equals(calItem)) continue;
                ArrayList<String> realListItems = new ArrayList<String>(listItemsArr.length - 1);
                for (String listItem : listItemsArr) {
                    if (listItem.equals(calItem)) continue;
                    realListItems.add(listItem);
                }
                for (String listItem : realListItems) {
                    perFieldFormulas = result.containsKey(listItem) ? (List)result.get(listItem) : new ArrayList();
                    HashMap<String, Object> perFormula = new HashMap<String, Object>();
                    perFormula.put(FIELDS_STR, realListItems);
                    perFormula.put(FORMULA_STR, express);
                    perFormula.put(TARGET_STR, targetFieldMap);
                    perFieldFormulas.add(perFormula);
                    result.put(listItem, perFieldFormulas);
                }
            }
            Set keySet = result.keySet();
            Iterator iterator = keySet.iterator();
            String listItem = "";
            String tempItem = "";
            String resultStr = JSONUtils.convertObjectToJson((Context)ctx, result);
            realResult.putAll(JSONUtils.convertJsonToObject((Context)ctx, (String)resultStr));
            while (iterator.hasNext()) {
                listItem = (String)iterator.next();
                perFieldFormulas = (ArrayList)result.get(listItem);
                Iterator iterator2 = perFieldFormulas.iterator();
                while (iterator2.hasNext()) {
                    tempItem = (String)((Map)((Map)iterator2.next()).get(TARGET_STR)).get(TARGET_NAME_STR);
                    if (!result.containsKey(tempItem)) continue;
                    realResult.get(listItem).addAll((ArrayList)result.get(tempItem));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return realResult;
    }

    public static String getMultiLan(String label, Context ctx) {
        return EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetAdjustResource", (String)label, (Locale)ctx.getLocale());
    }
}

