/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.calculate;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.budget.dto.BudgetCalculateOuterData;
import com.kingdee.shr.compensation.budget.dto.BudgetDataTreeNodeInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataAccess;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.util.FunUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetCalculateBusinessDataCommon
extends CalculatorBusinessDataCommon {
    private static Logger logger = Logger.getLogger(BudgetCalculateBusinessDataCommon.class);
    public static Pattern numStartPattern = Pattern.compile("\\d+$");

    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        String mainTableName = initCalData.getMainTableName();
        Map assTable = initCalData.getAssTable();
        assTable.put(mainTableName, (String)assTable.get(mainTableName) + "," + mainTableName + ".BUDGETYEAR");
        assTable.put("T_ORG_Admin~adminOrgUnit", (assTable.containsKey("T_ORG_Admin~adminOrgUnit") ? (String)assTable.get("T_ORG_Admin~adminOrgUnit") + "," : "") + "T_ORG_Admin.FID");
        assTable.put("T_HR_CostType~costType", (assTable.containsKey("T_HR_CostType~costType") ? (String)assTable.get("T_HR_CostType~costType") + "," : "") + "T_HR_CostType.FID");
        DataSet dataSet = this.getSuperData(initCalData);
        Object data = initCalData.getOuterData();
        if (null == data || !(data instanceof BudgetCalculateOuterData)) {
            return dataSet;
        }
        HashMap<String, BudgetDataTreeNodeInfo> budgetDataTree = new HashMap<String, BudgetDataTreeNodeInfo>();
        Context ctx = initCalData.getCtx();
        BudgetCalculateOuterData outData = (BudgetCalculateOuterData)data;
        DataTable mainTable = dataSet.getTables(mainTableName);
        ArrayList columns = mainTable.columns;
        HashMap existDatasIndexMap = mainTable.datasIndexMap;
        ArrayList existDatas = mainTable.datas;
        List<String> adminOrgUnitIds = outData.getAdminOrgUnitIds();
        String adminInSql = CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds);
        Map<String, String> orgParentMapper = this.initOrgParentMapper(ctx, adminInSql);
        this.initSubOrgData(initCalData, budgetDataTree, orgParentMapper);
        String queryBaseData4AddNew = "ADMINORGUNIT.id in " + adminInSql;
        String sql = "";
        try {
            sql = this.buildDataSetSql(initCalData, queryBaseData4AddNew, true);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        DataAccess dac = new DataAccess();
        DataTable addNewDt = dac.getDataForDataTable(initCalData.getCtx(), sql);
        List addNewDatas = addNewDt.datas;
        Map addNewDatasIndexMap = addNewDt.datasIndexMap;
        ArrayList addNewColumn = addNewDt.columns;
        HashMap<String, Integer> addNewColumnIndex = new HashMap<String, Integer>();
        int size = addNewColumn.size();
        for (int i = 0; i < size; ++i) {
            String colName = ((ColumnAttributes)addNewColumn.get(i)).getName();
            colName = "FID".equals(colName) ? "ADMINORGUNIT.FID" : colName;
            addNewColumnIndex.put(colName, i);
        }
        if (null == existDatasIndexMap) {
            existDatas = new ArrayList();
            existDatasIndexMap = new HashMap();
        }
        Map<String, Map<String, Object>> outerData = outData.getData();
        Set<Map.Entry<String, Map<String, Object>>> entrySet = outerData.entrySet();
        for (Map.Entry<String, Map<String, Object>> perRow : entrySet) {
            DataRow dataRow;
            String rowId = perRow.getKey();
            Map<String, Object> rowValue = perRow.getValue();
            boolean isExist = existDatasIndexMap.containsKey(rowId);
            if (isExist) {
                dataRow = (DataRow)existDatas.get((Integer)existDatasIndexMap.get(rowId));
            } else {
                dataRow = new DataRow();
                dataRow.columns = columns;
                mainTable.addRow(dataRow, rowId);
            }
            String adminId = (String)rowValue.get("ADMINORGUNIT.FID");
            String parentId = orgParentMapper.get(adminId);
            for (ColumnAttributes attributes : columns) {
                String colname = attributes.getName();
                if (null == colname) continue;
                if ("FID".equalsIgnoreCase(colname)) {
                    dataRow.add((Object)rowId);
                    continue;
                }
                String valueCol = colname.toUpperCase(Locale.ENGLISH).startsWith("MANAGE.T") ? colname.split("\\.")[1] : colname;
                valueCol = valueCol.toUpperCase(Locale.ENGLISH);
                Object value = null;
                if (addNewColumnIndex.containsKey(colname) || "ADMINORGUNIT.ID".equals(colname)) {
                    value = ((DataRow)addNewDatas.get((Integer)addNewDatasIndexMap.get(rowValue.get("ADMINORGUNIT.FID")))).getValue(((Integer)addNewColumnIndex.get(colname)).intValue());
                } else if (rowValue.containsKey(valueCol) || "COSTTYPE.FID".equals(colname)) {
                    value = rowValue.get(valueCol);
                }
                if (isExist) {
                    dataRow.setValue(colname, value);
                } else {
                    dataRow.add(value);
                }
                dataRow.setModify(true);
            }
            BudgetDataTreeNodeInfo treeNodeInfo = budgetDataTree.containsKey(adminId) ? (BudgetDataTreeNodeInfo)budgetDataTree.get(adminId) : new BudgetDataTreeNodeInfo(adminId, parentId);
            Set<Map.Entry<String, Object>> rowValueEntrySet = rowValue.entrySet();
            for (Map.Entry<String, Object> columnentry : rowValueEntrySet) {
                String colname = columnentry.getKey();
                Object value = columnentry.getValue();
                Matcher matcher = numStartPattern.matcher(colname);
                if (!matcher.find()) continue;
                String TN = rowValue.get("COSTTYPE.FID") + "_" + colname;
                treeNodeInfo.setCurData(TN, value);
            }
            budgetDataTree.put(adminId, treeNodeInfo);
            if (StringUtils.isEmpty((CharSequence)parentId)) continue;
            BudgetDataTreeNodeInfo parentTreeNodeInfo = (BudgetDataTreeNodeInfo)budgetDataTree.get(parentId);
            if (null != parentTreeNodeInfo) {
                parentTreeNodeInfo.addChild(treeNodeInfo);
                continue;
            }
            parentTreeNodeInfo = new BudgetDataTreeNodeInfo(parentId, orgParentMapper.get(parentId));
            parentTreeNodeInfo.addChild(treeNodeInfo);
            budgetDataTree.put(parentId, parentTreeNodeInfo);
        }
        String uid = initCalData.getUid();
        String cacheKey = MD5Util.getMD5String((String)(uid + ctx));
        CacheService cacheService = CacheService.getInstance();
        cacheService.hset("shr.validateruleCache", cacheKey, "BUDGET_MANAGE_TREEDATA_CACHE_KEY", budgetDataTree);
        int tableCount = dataSet.tableCount();
        for (int i = 0; i < tableCount; ++i) {
            DataTable table = dataSet.getTables(i);
            table.datas = mainTable.datas;
            table.columns = mainTable.columns;
            table.datasIndexMap = mainTable.datasIndexMap;
            table.emptyrow = mainTable.emptyrow;
        }
        return dataSet;
    }

    protected DataSet getSuperData(InitCalData initCalData) throws EASBizException {
        return super.initCalData(initCalData);
    }

    protected void initSubOrgData(InitCalData initCalData, Map<String, BudgetDataTreeNodeInfo> budgetDataTree, Map<String, String> orgParentMapper) {
        try {
            BudgetCalculateOuterData outData = (BudgetCalculateOuterData)initCalData.getOuterData();
            HashSet adminOrgUnitIds = Sets.newHashSet();
            for (Map.Entry<String, String> entry : orgParentMapper.entrySet()) {
                adminOrgUnitIds.add(entry.getKey());
                String value = entry.getValue();
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                adminOrgUnitIds.add(value);
            }
            Set<String> selectedFields = this.getSelectedFields(initCalData);
            IRowSet rowSet = this.initCurOrgDataRowSet(initCalData, selectedFields, outData, adminOrgUnitIds);
            this.convertRowSetData(budgetDataTree, orgParentMapper, rowSet, selectedFields, true);
            rowSet = this.initProcessOrgDataRowSet(initCalData, selectedFields, outData, adminOrgUnitIds);
            this.convertRowSetData(budgetDataTree, orgParentMapper, rowSet, selectedFields, false);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected Set<String> getSelectedFields(InitCalData initCalData) {
        String schemeID = initCalData.getSchemeID();
        StringBuilder getFieldSQL = new StringBuilder();
        getFieldSQL.append(" SELECT ");
        getFieldSQL.append(" c.FieldSn ");
        getFieldSQL.append(" FROM T_HR_SBudgetTemplateItem ti ");
        getFieldSQL.append(" left join T_HR_SCmpBudgetScheme s on s.FTemplateID = ti.FTemplateID ");
        getFieldSQL.append(" left join T_HR_SCmpBudgetItem c on c.FID=ti.FBudgetItemID ");
        getFieldSQL.append(" where s.FID = ? ");
        getFieldSQL.append(" order by ti.FSortSn asc,c.FIndex asc ");
        Context ctx = initCalData.getCtx();
        HashSet selectFields = Sets.newHashSet();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getFieldSQL.toString(), (Object[])new Object[]{schemeID});
            while (rowSet.next()) {
                selectFields.add("T" + rowSet.getInt("FieldSn"));
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return selectFields;
    }

    protected IRowSet initCurOrgDataRowSet(InitCalData initCalData, Set<String> selectedFields, BudgetCalculateOuterData outData, Set<String> adminOrgUnitIds) throws BOSException {
        StringBuilder getexistDataSql = new StringBuilder();
        String mainTableAlias = initCalData.getMainTableAlias();
        Context ctx = initCalData.getCtx();
        List<String> costTypes = outData.getCostTypes();
        getexistDataSql.append(" select ").append(selectedFields.toString().replace("[", "").replace("]", ","));
        getexistDataSql.append(mainTableAlias).append(".FCostTypeID ,").append(mainTableAlias).append(".FAdminOrgUnitID ");
        getexistDataSql.append("  from ").append(initCalData.getMainTable()).append(" ").append(mainTableAlias).append(" ");
        getexistDataSql.append("  inner join T_ORG_Admin orgAdmin on ").append(mainTableAlias).append(".FAdminOrgUnitID = orgAdmin.fid ");
        getexistDataSql.append("  where ");
        getexistDataSql.append("  (orgAdmin.fparentid in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds));
        getexistDataSql.append("  or orgAdmin.fid in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds));
        getexistDataSql.append("  or orgAdmin.fparentid is null) ");
        getexistDataSql.append("  and " + mainTableAlias + ".FCostTypeID in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, costTypes));
        getexistDataSql.append("  and " + mainTableAlias + ".FBudgetYear = ").append(outData.getBudgetYear());
        getexistDataSql.append("  and " + mainTableAlias + ".FBudgetSchemeID = ? ");
        getexistDataSql.append("  order by orgAdmin.flongnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getexistDataSql.toString(), (Object[])new Object[]{outData.getBudgetSchemeId()});
        return rowSet;
    }

    protected IRowSet initProcessOrgDataRowSet(InitCalData initCalData, Set<String> selectedFields, BudgetCalculateOuterData outData, Set<String> adminOrgUnitIds) throws BOSException {
        StringBuilder getProcessDataSql = new StringBuilder();
        String mainTableAlias = "entry";
        List<String> costTypes = outData.getCostTypes();
        Context ctx = initCalData.getCtx();
        String selectedFieldsStr = selectedFields.toString().replace("T", "M").replace("[", "").replace("]", ",");
        getProcessDataSql.append(" select ").append(selectedFieldsStr);
        getProcessDataSql.append(mainTableAlias).append(".FCostTypeID ,").append(mainTableAlias).append(".FAdminOrgUnitID ");
        getProcessDataSql.append("  from T_HR_SBudgetAdjustEntry ").append(mainTableAlias);
        getProcessDataSql.append("  inner join T_ORG_Admin orgAdmin on ").append(mainTableAlias).append(".FAdminOrgUnitID = orgAdmin.fid ");
        getProcessDataSql.append("  inner join T_HR_SBudgetAdjustBill bill on ").append(mainTableAlias).append(".FBILLID = bill.FID  ");
        getProcessDataSql.append("  where   ");
        getProcessDataSql.append("  (orgAdmin.fparentid in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds));
        getProcessDataSql.append("  or orgAdmin.fid in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds));
        getProcessDataSql.append("  or orgAdmin.fparentid is null) ");
        getProcessDataSql.append("  and " + mainTableAlias + ".FCostTypeID in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, costTypes));
        getProcessDataSql.append("  and bill.FBudgetSchemeID = ? ");
        getProcessDataSql.append("  and bill.FBILLSTATE in ( ").append(1).append(",").append(2).append(") ");
        getProcessDataSql.append("  order by orgAdmin.flongnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getProcessDataSql.toString(), (Object[])new Object[]{outData.getBudgetSchemeId()});
        return rowSet;
    }

    protected void convertRowSetData(Map<String, BudgetDataTreeNodeInfo> budgetDataTree, Map<String, String> orgParentMapper, IRowSet rowSet, Set<String> selectedFields, boolean isCurData) throws SQLException {
        while (rowSet.next()) {
            String costType = rowSet.getString("FCostTypeID");
            String adminId = rowSet.getString("FAdminOrgUnitID");
            String parentId = orgParentMapper.get(adminId);
            BudgetDataTreeNodeInfo treeNodeInfo = budgetDataTree.containsKey(adminId) ? budgetDataTree.get(adminId) : new BudgetDataTreeNodeInfo(adminId, parentId);
            for (String field : selectedFields) {
                Object object;
                if (!isCurData) {
                    field = field.replace("T", "M");
                }
                if (null == (object = rowSet.getObject(field))) continue;
                if (isCurData) {
                    treeNodeInfo.setCurData(costType + "_" + field, object);
                    continue;
                }
                treeNodeInfo.setProcessData(costType + "_" + field, object);
            }
            budgetDataTree.put(adminId, treeNodeInfo);
            if (StringUtils.isEmpty((CharSequence)parentId)) continue;
            BudgetDataTreeNodeInfo parentTreeNodeInfo = budgetDataTree.get(parentId);
            if (null != parentTreeNodeInfo) {
                parentTreeNodeInfo.addChild(treeNodeInfo);
            } else {
                parentTreeNodeInfo = new BudgetDataTreeNodeInfo(parentId, orgParentMapper.get(parentId));
                parentTreeNodeInfo.addChild(treeNodeInfo);
            }
            budgetDataTree.put(parentId, parentTreeNodeInfo);
        }
    }

    protected Map<String, String> initOrgParentMapper(Context ctx, String adminInSql) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String sql = "SELECT fid,FPARENTID FROM T_ORG_ADMIN WHERE fid IN " + adminInSql + " OR fparentid IN " + adminInSql + " or fparentid in (select fparentid from T_ORG_ADMIN where fid in " + adminInSql + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fid");
                String parentid = rowSet.getString("FPARENTID");
                result.put(fid, parentid);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        return this.buildDataSetSql(initCalData, "MANAGE.id in (" + initCalData.getCondition() + ")", false);
    }

    protected String buildDataSetSql(InitCalData initCalData, String filterStr, boolean isAddNew) throws Exception {
        FilterInfo filter = new FilterInfo(filterStr);
        SqlParam sqlParam = new SqlParam();
        Map<String, String> selectMapping = this.buildSelector(initCalData);
        if (isAddNew) {
            this.removeMainTableItem(selectMapping);
        }
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setSortStr("ADMINORGUNIT.longnumber");
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(false);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = FilterUtil.getSql((Context)initCalData.getCtx(), (SqlParam)sqlParam);
        if (isAddNew) {
            return sql;
        }
        String mainTable = initCalData.getMainTable().toUpperCase(Locale.ENGLISH);
        sql = sql.replace("T_HR_SBUDGETMANAGE", mainTable).replace("T_HR_SCMPSTANDINGBOOK", mainTable.replace("BUDGETMANAGE", "CMPSTANDINGBOOK"));
        return sql;
    }

    protected void removeMainTableItem(Map<String, String> selectMapping) {
        Set<Map.Entry<String, String>> entrySet = selectMapping.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> selector = iterator.next();
            String columnName = selector.getKey();
            if (!columnName.startsWith("MANAGE.")) continue;
            iterator.remove();
        }
        selectMapping.remove("costType.id");
        selectMapping.put("ADMINORGUNIT.id", "FID");
    }

    protected Map<String, String> buildSelector(InitCalData initCalData) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String mainTableAlias = initCalData.getMainTableAlias();
        selectMapping.put(mainTableAlias + ".id", "fid");
        Map assTable = initCalData.getAssTable();
        Set entrySet = assTable.entrySet();
        Iterator it = entrySet.iterator();
        String tableName = "";
        String field = "";
        String strucNum = "";
        String entityName = "";
        String tableField = "";
        String columns = "";
        String column = "";
        String[] tableArr = null;
        String[] columnArr = null;
        StructureConfigInfo structureInfo = null;
        Context ctx = initCalData.getCtx();
        Map structMap = FunUtils.getCmpStructureMapByNum((Context)ctx, (String)initCalData.getConfigNum());
        Map properties = null;
        Map.Entry next = null;
        String mainTableName = initCalData.getMainTableName();
        String stdbTableName = mainTableName.replace("BudgetManage", "CmpStandingBook");
        while (it.hasNext()) {
            next = it.next();
            tableArr = ((String)next.getKey()).split("~");
            tableName = tableArr[0];
            if (mainTableName.equals(tableName)) {
                columns = (String)assTable.get(tableName);
                columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    column = mainTableAlias + "." + columnArr[i].split("\\.")[1];
                    selectMapping.put(column, column);
                }
                continue;
            }
            if (stdbTableName.equals(tableName)) {
                columns = (String)assTable.get(tableName);
                columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    column = "cmpStdB." + columnArr[i].split("\\.")[1];
                    selectMapping.put(column, column);
                }
                continue;
            }
            strucNum = tableArr[1];
            structureInfo = (StructureConfigInfo)structMap.get(strucNum);
            if (structureInfo == null) continue;
            entityName = structureInfo.getEntityName();
            properties = FunUtils.getProperties((Context)ctx, (String)entityName);
            field = (String)next.getValue();
            String[] singleField = field.split(",");
            for (int i = 0; i < singleField.length; ++i) {
                field = singleField[i];
                tableField = field.split("\\.")[1];
                field = ((PropertyInfo)properties.get(tableField)).getName();
                if (selectMapping.containsKey(strucNum + "." + field)) continue;
                selectMapping.put(strucNum + "." + field, strucNum + "." + tableField);
            }
        }
        return selectMapping;
    }

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        String language = ctx.getLocale().getLanguage();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT  b.fid ITEMID, 't'|| to_char(b.FieldSn) FIELDSN,b.fname_" + language + " ITEMNAME ");
        builder.append(" ,b.FDATADOT,b.FDATATYPE,b.FIELDSN,b.FDATALENGTH ");
        builder.append(" FROM T_HR_SCmpBudgetScheme scheme ");
        builder.append(" inner join T_HR_SBudgetTemplateItem a  on scheme.FTemplateID = a.FTemplateID ");
        builder.append(" inner join T_HR_SCmpBudgetItem b on a.FBudgetItemID = b.fid ");
        builder.append(" where scheme.fId = '" + schemeID + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                String fieldSn = rs.getString("FIELDSN");
                sn.add(fieldSn);
                cn.add(name);
                dataDotMap.put(fieldSn, dataDot);
                dataTypeMap.put(fieldSn, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldSn, rs.getInt("FDATALENGTH"));
                }
                idItemMap.put(fieldSn.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        sn.add("forwarncontent");
        cn.add(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label24", (Locale)ctx.getLocale()));
        dataTypeMap.put("forwarncontent", 1);
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        return res;
    }
}

