/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cache.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.cache.annoation.CacheLevel;
import com.kingdee.shr.compensation.cache.core.CacheServiceManager;
import com.kingdee.shr.compensation.cache.core.ICmpCacheSevice;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpCacheServiceHelper {
    private static Logger logger = Logger.getLogger(CmpCacheServiceHelper.class);
    private final String CACHE_LINKED = "&";
    private Class<?> cacheImplClassName = null;
    private Map<String, Map<String, Object>> cacheObjectItemMap = null;

    public void put(Context ctx, String key, Object value) {
        String virtualCacheKey = this.getVirtualCacheKey(ctx);
        this.getCacheServiceInstance().put(virtualCacheKey, this.convertObjet2Cache(ctx, virtualCacheKey, key, value));
    }

    public Object get(Context ctx, String key) {
        String virtualCacheKey = this.getVirtualCacheKey(ctx);
        return this.convertCache2Object(ctx, virtualCacheKey, key);
    }

    public void delete(Context ctx, String key) {
        String virtualCacheKey = this.getVirtualCacheKey(ctx);
        Map<String, Map<String, Object>> cacheItemMap = this.getCacheObjectItemMap();
        Map<String, Object> itemMap = cacheItemMap.get(key);
        if (null != itemMap) {
            itemMap.remove(key);
        }
        cacheItemMap.put(virtualCacheKey, itemMap);
        this.getCacheServiceInstance().put(virtualCacheKey, cacheItemMap);
    }

    public String getVirtualCacheKey(Context ctx) {
        String bizTypeKeyName = this.getCacheImplClass().getName();
        String virtualCacheKey = null;
        try {
            virtualCacheKey = this.assembleRealCacheKey(ctx, bizTypeKeyName);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return virtualCacheKey;
    }

    public ICmpCacheSevice getCacheServiceInstance() {
        return CacheServiceManager.getCmpCacheServiceInstance();
    }

    private Object convertObjet2Cache(Context ctx, String virtualCacheKey, String key, Object value) {
        Map<String, Map<String, Object>> cacheItemMap = this.getCacheObjectItemMap();
        Map<String, Object> itemMap = cacheItemMap.get(key);
        if (null == itemMap) {
            itemMap = new LinkedHashMap<String, Object>();
        }
        itemMap.put(key, value);
        cacheItemMap.put(virtualCacheKey, itemMap);
        return cacheItemMap;
    }

    private Object convertCache2Object(Context ctx, String virtualCacheKey, String key) {
        Map itemMap;
        Map cacheObj = (Map)this.getCacheServiceInstance().get(virtualCacheKey);
        Object findedCacheObjet = null;
        if (null != cacheObj && null != (itemMap = (Map)cacheObj.get(key))) {
            findedCacheObjet = itemMap.get(key);
        }
        return findedCacheObjet;
    }

    private String assembleRealCacheKey(Context ctx, String key) throws EASBizException {
        Class<?> clzz = this.getCacheImplClass();
        CacheLevel annotation = clzz.getAnnotation(CacheLevel.class);
        if (!(annotation instanceof CacheLevel)) {
            String msg = MessageFormat.format("cache impl class :{0}, must annotation @{1}", clzz.getName(), CacheLevel.class.getName());
            logger.error((Object)msg);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        CacheLevel cacheLevel = annotation;
        String cacheLevelValue = cacheLevel.value();
        StringBuffer cacheKey = new StringBuffer();
        if ("local".equalsIgnoreCase(cacheLevelValue)) {
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            cacheKey.append(userId).append("&");
            cacheKey.append(key);
        } else if ("global".equalsIgnoreCase(cacheLevelValue)) {
            cacheKey.append(key);
        }
        return cacheKey.toString();
    }

    private Class<?> getCacheImplClass() {
        return this.getCacheImplClassName();
    }

    public void setCacheImplClassName(Class<?> cacheImplClassName) {
        this.cacheImplClassName = cacheImplClassName;
    }

    public Class<?> getCacheImplClassName() {
        return this.cacheImplClassName;
    }

    public Map<String, Map<String, Object>> getCacheObjectItemMap() {
        return this.cacheObjectItemMap;
    }

    public void setCacheObjectItemMap(Map<String, Map<String, Object>> cacheObjectItemMap) {
        this.cacheObjectItemMap = cacheObjectItemMap;
    }
}

