/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.interceptor;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.calculate.SalaryCalProcessEnum;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.calculate.cache.SalaryCalProcess;
import com.kingdee.shr.compensation.calculate.cache.SalaryCalProcessCache;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;

public class CalFormulaInterceptor
implements MethodInterceptor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.interceptor.CalFormulaInterceptor");

    public Object invoke(MethodInvocation invocation) throws Throwable {
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        HashMap<String, Object> tempMap = calFunction.getTempMap();
        boolean isNeedRecord = true;
        if ("test".equals(calFunction.getType())) {
            isNeedRecord = false;
        }
        if (this.isStopFlag(invocation)) {
            return null;
        }
        if (isNeedRecord) {
            Context ctx = calFunction.getCtx();
            Object shrCmpCompensationCalSaveMapOuter = ctx.get((Object)"shr_cmp_compensation_cal_save_map_outer");
            if (null != shrCmpCompensationCalSaveMapOuter && Boolean.valueOf(shrCmpCompensationCalSaveMapOuter.toString()).booleanValue() && !tempMap.containsKey("shr_cmp_compensation_cal_save_map_outer")) {
                String schemeId = calFunction.getSchemeID();
                String uuid = UUID.randomUUID().toString();
                String pre = "VT" + CalculateTool.getCacheKey(schemeId + "_" + uuid, "");
                tempMap.put("shr_cmp_compensation_cal_save_map_outer", pre);
            }
            this.initFormulaInfo(calFunction);
            Map<String, Object> paramMap = calFunction.getParamMap();
            boolean isLastPerson = Boolean.valueOf(paramMap.get("ThisParamUsedForAnalasysTimeIsLastPerson").toString());
            Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
            Map formulaInfoMap = (Map)calRecordMap.get("CAL_RECORD_MAP_FORMULAINFOMAPKEY");
            String formulaName = (String)paramMap.get("CURFORMULA");
            Map perFormula = (Map)formulaInfoMap.get(formulaName);
            String calItem = (String)perFormula.get("CALITEM");
            Object valueBeforeCal = !StringUtils.isEmpty((CharSequence)calItem) ? paramMap.get(calFunction.MAIN_ID.replace("FID", calItem)) : null;
            long startTimeLong = System.currentTimeMillis();
            invocation.proceed();
            long endTimeLong = System.currentTimeMillis();
            Object valueAfterCal = !StringUtils.isEmpty((CharSequence)calItem) ? paramMap.get(calFunction.MAIN_ID.replace("FID", calItem)) : null;
            isNeedRecord = this.isNeedRecord(perFormula, valueBeforeCal, valueAfterCal);
            this.recordProcessData(invocation, !isNeedRecord);
            this.recordMemoryAndTime(invocation, "CAL_RECORD_MAP_TIME", "CAL_RECORD_MAP_TIME_FORMULA", endTimeLong - startTimeLong);
            boolean isLastFormula = Boolean.valueOf(paramMap.get("ISLASTFORMULA").toString());
            if (isLastFormula) {
                Map perProcessData;
                Map processDataMap = (Map)calRecordMap.get("CAL_RECORD_MAP_PROCESS_DATA");
                String mainId = (String)paramMap.get(calFunction.MAIN_ID);
                if (null != processDataMap && processDataMap.containsKey(mainId) && (perProcessData = (Map)processDataMap.get(mainId)).size() == 0) {
                    processDataMap.remove(mainId);
                }
                if (isLastPerson) {
                    this.recordMemoryAndTime(invocation, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_TEMPMAP", RamUsageEstimator.sizeOfObject(tempMap));
                    this.cleanAndFormatData(calRecordMap);
                }
            }
        } else {
            invocation.proceed();
        }
        return null;
    }

    private boolean isNeedRecord(Map<String, Object> perFormula, Object valueBeforeCal, Object valueAfterCal) {
        boolean isNeedRecord = false;
        String calItemType = (String)perFormula.get("CALITEMTYPE");
        String calItem = (String)perFormula.get("CALITEM");
        if (null == valueBeforeCal && null == valueAfterCal) {
            isNeedRecord = false;
        } else if (null == valueBeforeCal && null != valueAfterCal || null != valueBeforeCal && null == valueAfterCal) {
            isNeedRecord = true;
        } else if ("double".equals(calItemType)) {
            BigDecimal valueAfter;
            BigDecimal valueBefore = new BigDecimal(String.valueOf(valueBeforeCal));
            if (valueBefore.compareTo(valueAfter = new BigDecimal(String.valueOf(valueAfterCal))) != 0) {
                isNeedRecord = true;
            }
        } else if (StringUtils.isEmpty((CharSequence)calItem) || !String.valueOf(valueBeforeCal).equals(String.valueOf(valueAfterCal))) {
            isNeedRecord = true;
        }
        return isNeedRecord;
    }

    protected void cleanAndFormatData(Map<String, Object> calRecordMap) {
        calRecordMap.remove("CAL_RECORD_MAP_FORMULAINFOMAPKEY");
        calRecordMap.remove("CAL_RECORD_MAP_FUNCDEFINENAMEMAPPER");
        Map memoryMap = (Map)calRecordMap.get("CAL_RECORD_MAP_MEMORY");
        Set keySet = memoryMap.keySet();
        for (String firstkey : keySet) {
            Object object = memoryMap.get(firstkey);
            if (object instanceof Long) {
                memoryMap.put(firstkey, RamUsageEstimator.humanReadableUnits((long)((Long)object)));
                continue;
            }
            if (!(object instanceof Map)) continue;
            Map keyMap = (Map)object;
            Set keySet2 = keyMap.keySet();
            for (String secondKey : keySet2) {
                Object secondValue = keyMap.get(secondKey);
                if (!(secondValue instanceof Long)) continue;
                keyMap.put(secondKey, RamUsageEstimator.humanReadableUnits((long)((Long)secondValue)));
            }
        }
    }

    protected void initFormulaInfo(SalaryCalFunction calFunction) {
        Context ctx = calFunction.getCtx();
        CalSchemeInfo calScheme = calFunction.getCalScheme();
        Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
        if (calRecordMap.containsKey("CAL_RECORD_MAP_FORMULAINFOMAPKEY")) {
            return;
        }
        HashMap formulaInfoMap = new HashMap();
        String calSchemeId = calScheme.getId().toString();
        String shortCode = LocaleUtils.getShortCode((Context)ctx);
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(" SELECT FNAME_").append(shortCode).append(" NAME,FID, ");
            builder.append(" FCALITEM, FLISTVAR ,FLISTITEM ,FLISTTABLE ");
            builder.append(" FROM T_HR_SCalFormula ");
            builder.append(" where FCALSCHEMEID = ? ");
            builder.append(" and FISCAL = 1 ");
            builder.append(" order by FSORTSN  ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{calSchemeId});
            String formulaName = "";
            String calItem = "";
            String listVar = "";
            String listItem = "";
            while (rowSet.next()) {
                ArrayList<String> itemList;
                String[] itemArr;
                HashMap<String, Object> perFormula = new HashMap<String, Object>();
                String formulaID = rowSet.getString("FID");
                formulaName = rowSet.getString("NAME");
                calItem = rowSet.getString("FCALITEM");
                listVar = rowSet.getString("FLISTVAR");
                listItem = rowSet.getString("FLISTITEM");
                perFormula.put("CALITEM", calItem);
                perFormula.put("FORMULANAME", formulaName);
                perFormula.put("FORMULAID", formulaID);
                if (!StringUtils.isEmpty((CharSequence)listVar)) {
                    itemArr = listVar.split(";");
                    itemList = new ArrayList();
                    for (String var : itemArr) {
                        var = var.split("~")[2];
                        itemList.add(var.replace("@", ""));
                    }
                    perFormula.put("LISTVAR", itemList);
                }
                if (!StringUtils.isEmpty((CharSequence)listItem)) {
                    itemList = new ArrayList<String>();
                    for (String item : itemArr = listItem.split(";")) {
                        String[] perItemArr = item.split("~");
                        if (perItemArr.length == 3) {
                            item = perItemArr[1] + "_" + perItemArr[2];
                            if (null != calItem && perItemArr[2].equals(calItem)) {
                                perFormula.put("CALITEMTYPE", perItemArr[0]);
                            }
                        } else {
                            item = perItemArr[1] + "_" + perItemArr[3] + "_" + perItemArr[2];
                        }
                        itemList.add(item.toUpperCase());
                    }
                    perFormula.put("LISTITEM", itemList);
                }
                formulaInfoMap.put(formulaName, perFormula);
            }
            calRecordMap.put("CAL_RECORD_MAP_FORMULAINFOMAPKEY", formulaInfoMap);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void recordMemoryAndTime(MethodInvocation invocation, String mainKey, String typeKey, long value) {
        if (value <= 0L) {
            return;
        }
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
        Map<String, Object> paramMap = calFunction.getParamMap();
        Map formulaInfoMap = (Map)calRecordMap.get("CAL_RECORD_MAP_FORMULAINFOMAPKEY");
        String formulaName = (String)paramMap.get("CURFORMULA");
        Map perFormula = (Map)formulaInfoMap.get(formulaName);
        String formulaId = (String)perFormula.get("FORMULAID");
        Map valueMap = calRecordMap.containsKey(mainKey) ? (Map)calRecordMap.get(mainKey) : new HashMap();
        if ("CAL_RECORD_MAP_MEMORY_TEMPMAP".equals(typeKey)) {
            valueMap.put(typeKey, value);
        } else {
            Map funcTypeMap = valueMap.containsKey(typeKey) ? (Map)valueMap.get(typeKey) : new HashMap();
            long total = 0L;
            if (funcTypeMap.containsKey(formulaId)) {
                total = (Long)funcTypeMap.get(formulaId);
            }
            funcTypeMap.put(formulaId, total + value);
            valueMap.put(typeKey, funcTypeMap);
        }
        calRecordMap.put(mainKey, valueMap);
    }

    protected void recordProcessData(MethodInvocation invocation, boolean isRemove) {
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
        Map processDataMap = calRecordMap.containsKey("CAL_RECORD_MAP_PROCESS_DATA") ? (Map)calRecordMap.get("CAL_RECORD_MAP_PROCESS_DATA") : new HashMap();
        Map<String, Object> paramMap = calFunction.getParamMap();
        String mainId = (String)paramMap.get(calFunction.MAIN_ID);
        String curFormulaName = (String)paramMap.get("CURFORMULA");
        Map formulaInfoMap = (Map)calRecordMap.get("CAL_RECORD_MAP_FORMULAINFOMAPKEY");
        Map perFormula = (Map)formulaInfoMap.get(curFormulaName);
        List listVars = (List)perFormula.get("LISTVAR");
        List listItems = (List)perFormula.get("LISTITEM");
        String formulaid = (String)perFormula.get("FORMULAID");
        Map perProcessData = processDataMap.containsKey(mainId) ? (Map)processDataMap.get(mainId) : new HashMap();
        Map formulaProData = perProcessData.containsKey(formulaid) ? (Map)perProcessData.get(formulaid) : new HashMap();
        if (isRemove) {
            perProcessData.remove(formulaid);
            return;
        }
        Map proDataCalVarsMap = formulaProData.containsKey("CAL_RECORD_MAP_PROCESS_DATA_CALVARS") ? (Map)formulaProData.get("CAL_RECORD_MAP_PROCESS_DATA_CALVARS") : new HashMap();
        if (null != listVars && listVars.size() > 0) {
            for (String var : listVars) {
                proDataCalVarsMap.put(var, paramMap.get(var));
            }
        }
        Map proDataCalfieldsMap = formulaProData.containsKey("CAL_RECORD_MAP_PROCESS_DATA_SCHEMEFIELDS") ? (Map)formulaProData.get("CAL_RECORD_MAP_PROCESS_DATA_SCHEMEFIELDS") : new HashMap();
        if (null != listItems && listItems.size() > 0) {
            for (String item : listItems) {
                proDataCalfieldsMap.put(item, paramMap.get(item));
            }
        }
        if (paramMap.containsKey("LOGICMAN_INDEX")) {
            formulaProData.put("LOGICMAN_INDEX", paramMap.get("LOGICMAN_INDEX"));
            paramMap.remove("LOGICMAN_INDEX");
        }
        formulaProData.put("CAL_RECORD_MAP_PROCESS_DATA_CALVARS", proDataCalVarsMap);
        formulaProData.put("CAL_RECORD_MAP_PROCESS_DATA_SCHEMEFIELDS", proDataCalfieldsMap);
        perProcessData.put(formulaid, formulaProData);
        processDataMap.put(mainId, perProcessData);
        calRecordMap.put("CAL_RECORD_MAP_PROCESS_DATA", processDataMap);
    }

    public boolean isStopFlag(MethodInvocation invocation) {
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        String calSchemeId = calFunction.getSchemeID();
        Context ctx = calFunction.getCtx();
        String cacheKey = CalculateTool.getCacheKey(HRFilterUtils.getCurrentUserId((Context)ctx), calSchemeId);
        SalaryCalProcess calProcess = SalaryCalProcessCache.getProcess(ctx, calSchemeId);
        return calProcess.getProcessEnum().equals((Object)SalaryCalProcessEnum.STOPPING);
    }
}

