/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.retrospect;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.json.JSONUtils;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.calculate.retrospect.InitVerifyData;
import com.kingdee.shr.compensation.calculate.retrospect.RetrospectHelper;
import com.kingdee.shr.compensation.calculate.retrospect.StatiicsData;
import com.kingdee.shr.compensation.calculate.retrospect.obj.CalBase;
import com.kingdee.shr.compensation.calculate.retrospect.obj.CalFormula;
import com.kingdee.shr.compensation.calculate.retrospect.obj.CalFunction;
import com.kingdee.shr.compensation.calculate.retrospect.obj.CalItem;
import com.kingdee.shr.compensation.calculate.retrospect.obj.CalStructure;
import com.kingdee.shr.compensation.calculate.retrospect.obj.TempVariable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalFormulaRetrospectService {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.retrospect.CalFormulaRetrospectService");
    private static String keyThat;
    private static String keyReFilter;
    private static String keyRest;
    InitVerifyData initData = new InitVerifyData();

    public void init(Context ctx, String schemeId) throws BOSException {
        keyThat = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"that", (Locale)ctx.getLocale());
        keyReFilter = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"Refiltration", (Locale)ctx.getLocale());
        keyRest = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"Rest", (Locale)ctx.getLocale());
        this.initData.setInitItem(RetrospectHelper.getCmpItem(ctx));
        this.initData.setInitCalItem(RetrospectHelper.getCmpCalItem(ctx, schemeId));
        this.initData.setInitStructure(RetrospectHelper.getStructureField(ctx));
        this.initData.setInitQuery(RetrospectHelper.getCmpQueryConfigField(ctx));
        this.initData.setInitFuns(RetrospectHelper.getCalFunctions(ctx));
        this.initData.setInitFormula(RetrospectHelper.getFormulaContent(ctx, schemeId));
        this.initData.setInitVars(RetrospectHelper.getTempVariable(ctx, schemeId));
        this.initData.setInitTempTable(RetrospectHelper.getTempTable(ctx, schemeId));
    }

    public List<CalFormula> getRetrospectData(Context ctx, String schemeId, String calId) throws BOSException {
        this.init(ctx, schemeId);
        StatiicsData calStaticsData = CalFormulaRetrospectService.getCalStaticsData(ctx, calId);
        if (calStaticsData.cur.isEmpty()) {
            return new ArrayList<CalFormula>();
        }
        List<CalFormula> formulaList = this.analysisStaticsData(ctx, calStaticsData);
        for (CalFormula c : formulaList) {
            c.combineDifference(c.getLastFormula());
        }
        return formulaList;
    }

    public static String setExecuteStatement(int index, String content) {
        if (index < 0) {
            return content;
        }
        StringBuilder str = new StringBuilder();
        String[] arr = content.split(keyThat);
        if (index == arr.length) {
            arr = content.split(keyRest);
            if (arr.length <= 1) {
                return content;
            }
            String express = arr[1];
            int being = express.indexOf("<span");
            if (being < 0) {
                express = "<span style= \"background:yellow;\">" + express + "</span>";
            } else {
                String replaceExp = express.substring(being);
                express = express.replace(replaceExp, "<span style= \"background:yellow;\">" + replaceExp + "</span>");
            }
            str.append(arr[0]).append(keyRest).append(express);
        } else {
            String splitStr = index == arr.length - 1 ? keyRest : keyReFilter;
            for (int i = 0; i < arr.length; ++i) {
                if (i == index) {
                    String[] childArr = arr[index].split(splitStr);
                    String express = childArr[0];
                    int being = express.indexOf("<span");
                    int end = express.lastIndexOf("<span");
                    if (childArr.length == 1) {
                        str.append(express);
                        continue;
                    }
                    if (being < 0) {
                        express = "<span style= \"background:yellow;\">" + express + "</span>";
                    } else {
                        String replaceExp = express.substring(being, end);
                        express = express.replace(replaceExp, "<span style= \"background:yellow;\">" + replaceExp + "</span>");
                    }
                    str.append(express).append(splitStr).append(childArr[1]);
                } else {
                    str.append(arr[i]);
                }
                if (i == arr.length - 1) continue;
                str.append(keyThat);
            }
        }
        return str.toString();
    }

    private CalFormula analysisForOneFormula(String formulaId, Map<String, Object> data) {
        CalFormula f = new CalFormula();
        Map<String, String> initCalItem = this.initData.getInitCalItem();
        Map<String, CalFormulaInfo> initFormula = this.initData.getInitFormula();
        Map<String, CalBase> initItem = this.initData.getInitItem();
        CalFormulaInfo calFormulaInfo = initFormula.get(formulaId);
        Map scheme = (Map)data.get("CAL_RECORD_MAP_PROCESS_DATA_SCHEMEFIELDS");
        f.setName(calFormulaInfo.getName());
        Object v = null;
        if (null != scheme) {
            v = scheme.get(initCalItem.get(formulaId));
        }
        f.setDesc(calFormulaInfo.getDescription());
        CalBase itemInfo = initItem.get(initCalItem.get(formulaId));
        f.setCalItemName(itemInfo.getName());
        if (itemInfo.isNumeric()) {
            f.setValue(null == v ? null : new BigDecimal(v.toString()).toPlainString());
        } else {
            f.setValue(null == v ? null : v.toString());
        }
        if (data.containsKey("LOGICMAN_INDEX")) {
            f.setIndex(Integer.valueOf(data.get("LOGICMAN_INDEX").toString()));
        }
        String content = CalFormulaRetrospectService.setExecuteStatement(f.getIndex(), calFormulaInfo.getContent());
        f.setContent(content);
        if (null != scheme) {
            scheme.remove(initCalItem.get(formulaId));
        }
        ArrayList<CalItem> itemList = new ArrayList<CalItem>();
        ArrayList<CalStructure> strcutureList = new ArrayList<CalStructure>();
        this.combineStructureAndItem(data, itemList, strcutureList);
        f.setItems(itemList);
        f.setStructures(strcutureList);
        ArrayList<CalFunction> funList = new ArrayList<CalFunction>();
        this.combineCalFunctions(data, funList);
        f.setFunctions(funList);
        ArrayList<TempVariable> varList = new ArrayList<TempVariable>();
        this.comineVariables(data, varList);
        f.setVariables(varList);
        return f;
    }

    private void comineVariables(Map<String, Object> data, List<TempVariable> varList) {
        Map<String, CalBase> map = this.initData.getInitVars();
        Map vars = (Map)data.get("CAL_RECORD_MAP_PROCESS_DATA_CALVARS");
        if (null == vars || vars.size() < 1) {
            return;
        }
        for (Map.Entry e : vars.entrySet()) {
            TempVariable tempVariable = new TempVariable();
            String define = "@" + (String)e.getKey();
            if (!map.containsKey(define)) continue;
            CalBase calBase = map.get(define);
            tempVariable.setName(calBase.getName());
            tempVariable.setNumber(calBase.getNumber());
            tempVariable.setValue(null == e.getValue() ? "" : e.getValue().toString());
            tempVariable.setIsNumeric(calBase.isNumeric());
            varList.add(tempVariable);
        }
    }

    private void combineCalFunctions(Map<String, Object> data, List<CalFunction> funList) {
        Map funs = (Map)data.get("CAL_RECORD_MAP_PROCESS_DATA_CALFUNCS");
        Map<String, CalBase> initFuns = this.initData.getInitFuns();
        if (null == funs || funs.isEmpty()) {
            return;
        }
        for (Map.Entry e : funs.entrySet()) {
            List l = (List)e.getValue();
            CalBase initFun = initFuns.get(e.getKey());
            for (int i = 0; i < l.size(); ++i) {
                for (Map.Entry e1 : ((Map)l.get(i)).entrySet()) {
                    int index = ((String)e1.getValue()).indexOf("--->");
                    CalFunction fun = new CalFunction();
                    fun.setName((String)e.getKey());
                    fun.setNumber((String)e1.getKey());
                    fun.setParams(null == initFun ? "" : initFun.getName());
                    fun.setParamValues(-1 == index ? "" : ((String)e1.getValue()).substring(0, index));
                    fun.setValue(-1 == index ? (String)e1.getValue() : ((String)e1.getValue()).substring(index + 4));
                    fun.setIsNumeric(null == initFun ? false : initFun.isNumeric());
                    funList.add(fun);
                }
            }
        }
    }

    private void combineStructureAndItem(Map<String, Object> data, List<CalItem> itemList, List<CalStructure> strcutureList) {
        Map<String, CalBase> initItem = this.initData.getInitItem();
        Map<String, String> initQuery = this.initData.getInitQuery();
        Map<String, CalBase> initStructure = this.initData.getInitStructure();
        Map<String, CalBase> initTempTable = this.initData.getInitTempTable();
        Map scheme = (Map)data.get("CAL_RECORD_MAP_PROCESS_DATA_SCHEMEFIELDS");
        if (null == scheme || scheme.isEmpty()) {
            return;
        }
        for (Map.Entry e : scheme.entrySet()) {
            CalStructure structure;
            String number = (String)e.getKey();
            if (number.contains("T_HR_SCMPCALTABLE")) {
                CalItem item = new CalItem();
                CalBase base = initItem.get(number);
                item.setName(base.getName());
                item.setNumber((String)e.getKey());
                if (base.isNumeric()) {
                    item.setIsNumeric(base.isNumeric());
                    item.setValue(null == e.getValue().toString() ? null : new BigDecimal(e.getValue().toString()).toPlainString());
                } else {
                    item.setValue(null == e.getValue().toString() ? null : e.getValue().toString());
                }
                itemList.add(item);
                continue;
            }
            if (initStructure.containsKey(number)) {
                structure = new CalStructure();
                structure.setValue(e.getValue().toString());
                structure.setName(initQuery.get(initStructure.get(number).getName()));
                structure.setNumber((String)e.getKey());
                structure.setIsNumeric(initStructure.get(number).isNumeric());
                strcutureList.add(structure);
                continue;
            }
            if (!initTempTable.containsKey(number)) continue;
            structure = new CalStructure();
            CalBase c = initTempTable.get(number);
            structure.setValue(e.getValue().toString());
            structure.setName(c.getName());
            structure.setNumber(number);
            structure.setIsNumeric(c.isNumeric());
            strcutureList.add(structure);
        }
    }

    private List<CalFormula> analysisStaticsData(Context ctx, StatiicsData calStaticsData) throws BOSException {
        Map<String, Object> cur = calStaticsData.getCur();
        Map<String, Object> last = calStaticsData.getLast();
        ArrayList<CalFormula> formulaList = new ArrayList<CalFormula>();
        for (Map.Entry<String, Object> e : cur.entrySet()) {
            String formulaId = e.getKey();
            if (!this.initData.getInitCalItem().containsKey(formulaId)) continue;
            Map data = (Map)e.getValue();
            CalFormula f = this.analysisForOneFormula(formulaId, data);
            if (last.containsKey(formulaId)) {
                CalFormula lastF = this.analysisForOneFormula(formulaId, (Map)last.get(formulaId));
                f.setLastFormula(lastF);
            }
            formulaList.add(f);
        }
        return formulaList;
    }

    private static StatiicsData getCalStaticsData(Context ctx, String calId) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" select en.fdata,en.FCmpCalStatisID, st.FTaskBaseID,ba.FCreateTime ");
        str.append(" from T_HR_SCMPCALSTATISENTRY en");
        str.append(" inner join T_HR_SCmpCalStatis st on en.FCmpCalStatisID = st.fid ");
        str.append(" inner join T_HR_SCmpCalTaskBase ba on st.FTaskBaseID = ba.fid ");
        str.append(" where FCmpCalTableID = ? ");
        str.append(" order by ba.fcreatetime ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString(), (Object[])new Object[]{calId});
        Map<String, Object> currentMap = new HashMap<String, Object>();
        HashMap<String, Object> lastMap = new HashMap<String, Object>();
        int count = 0;
        try {
            while (rowSet.next()) {
                if (count == 0) {
                    currentMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)rowSet.getString(1), Map.class);
                    ++count;
                    continue;
                }
                Map tempMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)rowSet.getString(1), Map.class);
                for (Map.Entry e : tempMap.entrySet()) {
                    if (currentMap.containsKey(e.getKey())) {
                        lastMap.put((String)e.getKey(), currentMap.get(e.getKey()));
                    }
                    currentMap.put((String)e.getKey(), e.getValue());
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new StatiicsData(currentMap, lastMap);
    }
}

