/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.app.calculate.CmpCalConfigInfo;
import com.kingdee.shr.compensation.app.calculate.CmpCalConfigQueuEnum;
import com.kingdee.shr.compensation.calculate.config.ThreadPoolConfig;
import com.kingdee.shr.compensation.calculate.thread.SalaryCalThreadPoolExecutor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SalaryCalThreadPoolManger {
    private static volatile SalaryCalThreadPoolExecutor pool;

    private SalaryCalThreadPoolManger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SalaryCalThreadPoolExecutor getInstance(Context ctx) throws BOSException {
        if (null != pool) return pool;
        Class<SalaryCalThreadPoolManger> clazz = SalaryCalThreadPoolManger.class;
        synchronized (SalaryCalThreadPoolManger.class) {
            if (null != pool) return pool;
            CmpCalConfigInfo configInfo = ThreadPoolConfig.getThreadPoolConfig(ctx);
            pool = new SalaryCalThreadPoolExecutor(configInfo.getCore(), configInfo.getMaximum(), 0L, TimeUnit.SECONDS, SalaryCalThreadPoolManger.getBlockingQueue(configInfo.getQueueType(), configInfo.getQueueSize()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return pool;
        }
    }

    private static BlockingQueue<Runnable> getBlockingQueue(CmpCalConfigQueuEnum queueEnum, int size) {
        switch (queueEnum.getValue()) {
            case 10: {
                return new ArrayBlockingQueue<Runnable>(size);
            }
            case 20: {
                return new LinkedBlockingQueue<Runnable>(size);
            }
            case 30: {
                return new PriorityBlockingQueue<Runnable>(size);
            }
        }
        return new ArrayBlockingQueue<Runnable>(size);
    }

    public static Future<Runnable> addTask(Context ctx, Runnable runnable) throws BOSException {
        return SalaryCalThreadPoolManger.getInstance(ctx).submit(runnable);
    }
}

