/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.NumericalUnit;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.BudgetTools;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.DashBoardInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.DashBoardManager;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.util.BudgetAmountUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetDashboardForAnnual
extends AbstractJavaDataQueryService {
    private static final Logger logger = Logger.getLogger(BudgetDashboardForAnnual.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        Object adminOrgUnitObj = this.getParamValue(ctx, "adminOrgUnitId", param);
        Object templateObj = this.getParamValue(ctx, "templateId", param);
        if (null == adminOrgUnitObj || null == templateObj) {
            return result;
        }
        boolean finished = BudgetAmountUtil.budgetInit(ctx);
        if (!finished) {
            return result;
        }
        String templateId = templateObj.toString().replaceAll("'", "");
        String adminOrgUnitId = adminOrgUnitObj.toString().replaceAll("'", "");
        Object currentDateObj = this.getParamValue(ctx, "year", param);
        Object numericalUnit = this.getParamValue(ctx, "numericalUnit", param);
        NumericalUnit unit = null == numericalUnit ? NumericalUnit.INDIVIDUAL : NumericalUnit.getEnum(Integer.valueOf(numericalUnit.toString()));
        Date currentDate = Date.valueOf(currentDateObj.toString());
        int year = BudgetTools.getCurrentYear(ctx, templateId, currentDate);
        DashBoardInfo info = DashBoardManager.getAnnualInfo(ctx, param.getPermItemId(), templateId, adminOrgUnitId, year);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        dataList.add(DashBoardManager.combineResult(ctx, info, unit));
        result.setRows(dataList);
        return result;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getAllData(ctx, param);
    }
}

