/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.app.budget.SubBalanceTypeEnum;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.BudgetTools;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.InputParamInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.OrgUnitBudgetInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.AbstractCombineData;
import java.math.BigDecimal;
import java.util.List;

public abstract class DashBoardForPeriod
extends AbstractCombineData {
    protected SubBalanceTypeEnum subBalanceTypeEnum = SubBalanceTypeEnum.YEAR_TOTAL;

    public DashBoardForPeriod(Context ctx, InputParamInfo paramInfo) {
        super(ctx, paramInfo);
    }

    @Override
    public BigDecimal getUsed(Context ctx) throws BOSException {
        BigDecimal used = this.getBookSummary(ctx, this.standingItems, "=", null);
        used = this.externalUsed.compareTo(new BigDecimal(0)) > 0 ? used.add(this.externalUsed) : used;
        return used;
    }

    @Override
    public BigDecimal getResidue(Context ctx) throws BOSException {
        this.subBalanceTypeEnum = BudgetTools.getPeriodEnum(ctx, this.paramInfo.getTemplateId(), this.paramInfo.getYear());
        return this.getBalanceSummary(ctx, this.balanceItems);
    }

    @Override
    public BigDecimal getMax(Context ctx) throws BOSException {
        if (null == this.budgetItems) {
            this.budgetItems = this.getBudgetItems(ctx);
        }
        return this.getBudgetSummary(ctx, this.budgetItems);
    }

    @Override
    public List<OrgUnitBudgetInfo> getOrgUnitBudgetInfo(Context ctx, boolean isAll) throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append(" from T_HR_SSubBudgetQuery man ");
        sb.append(" inner join T_HR_SBudgetManage bud on man.FBudgetManageID = bud.fid ");
        sb.append(" inner join T_HR_SubCmpStandingBook book on man.fid = book.FSubBudgetQueryID ");
        sb.append(" inner join T_HR_SCmpBudgetScheme sch on bud.FBudgetSchemeID = sch.fid ");
        sb.append(" inner join T_ORG_Admin adminOrgUnit on bud.FAdminOrgUnitID = adminOrgUnit.fid ");
        sb.append(" where sch.FTemplateID = ? and bud.FBudgetYear = ? and man.FPeriod = ? ");
        return this.getOrgUnitBudgetInfo(ctx, isAll, sb.toString(), new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear(), this.paramInfo.getPeriod()});
    }

    protected BigDecimal getBookSummary(Context ctx, String items, String compareType, SubBalanceTypeEnum subBalanceTypeEnum) throws BOSException {
        Object[] param = null;
        String sql = " from T_HR_SubCmpStandingBook book  inner join T_HR_SSubBudgetQuery qu on book.FSubBudgetQueryID = qu.fid  inner join T_HR_SBudgetManage man on qu.FBudgetManageID = man.fid  inner join T_ORG_Admin adminOrgUnit on man.FAdminOrgUnitID = adminOrgUnit.fid  inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid  where sch.FTemplateID = ? and man.FBudgetYear = ? ";
        if (null != subBalanceTypeEnum && subBalanceTypeEnum.equals((Object)SubBalanceTypeEnum.YEAR_TOTAL)) {
            param = new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear()};
        } else {
            sql = sql + " and qu.FPeriod " + compareType + " ? ";
            param = new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear(), this.paramInfo.getPeriod()};
        }
        return this.combineSummary(ctx, items, "book", sql, param);
    }

    protected BigDecimal getBalanceSummary(Context ctx, String balangeItems) throws BOSException {
        BigDecimal sum = new BigDecimal(0);
        switch (this.subBalanceTypeEnum.getValue()) {
            case 3: {
                sum = this.getBookSummary(ctx, balangeItems, "", this.subBalanceTypeEnum);
                break;
            }
            case 1: {
                sum = this.getBookSummary(ctx, balangeItems, "<=", this.subBalanceTypeEnum);
                break;
            }
            case 2: {
                sum = this.getBookSummary(ctx, balangeItems, "=", this.subBalanceTypeEnum);
            }
        }
        return sum;
    }

    protected BigDecimal getBudgetSummary(Context ctx, String budgetItems) throws BOSException {
        String sql = " from T_HR_SSubBudgetQuery qu  inner join T_HR_SBudgetManage man on qu.FBudgetManageID = man.fid  inner join T_ORG_Admin adminOrgUnit on man.FAdminOrgUnitID = adminOrgUnit.fid  inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid  where sch.FTemplateID = ? and man.FBudgetYear = ? and qu.FPeriod = ?";
        return this.combineSummary(ctx, budgetItems, "qu", sql, new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear(), this.paramInfo.getPeriod()});
    }
}

