/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice.BaseCmpBudgetAmountDataQueryService;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.AdminOrgUnitYearBudgetAmountDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemBoard;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CmpBudgetChildOrgAmountTableDataQueryService
extends BaseCmpBudgetAmountDataQueryService {
    @Override
    protected List<Map<String, Object>> assembleRowData(Context ctx, Object detailDataObj) throws BOSException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        AdminOrgUnitCollection orgColl = this.getChildOrgColl();
        Map detailData = (Map)detailDataObj;
        String goodState = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label52", (Locale)ctx.getLocale());
        String warringState = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label53", (Locale)ctx.getLocale());
        String overState = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label54", (Locale)ctx.getLocale());
        for (int i = 0; i < orgColl.size(); ++i) {
            AdminOrgUnitInfo adminOrg = orgColl.get(i);
            String longNumber = adminOrg.getLongNumber();
            AdminOrgUnitYearBudgetAmountDTO amountDTO = (AdminOrgUnitYearBudgetAmountDTO)detailData.get(longNumber);
            assert (amountDTO != null);
            BudgetItemBoard budgetItemBoard = amountDTO.mergeAllItemBoard();
            HashMap<String, Object> row = new HashMap<String, Object>();
            BigDecimal allAmount = budgetItemBoard.getAllAmount();
            BigDecimal realUsedAmount = budgetItemBoard.getRealUsedAmount();
            BigDecimal diffAmount = allAmount.subtract(realUsedAmount);
            BigDecimal pValue = BigDecimal.ZERO;
            String state = "";
            if (allAmount.compareTo(BigDecimal.ZERO) > 0) {
                pValue = realUsedAmount.divide(allAmount, 4, 4).multiply(new BigDecimal(100));
                state = pValue.compareTo(new BigDecimal(80)) < 0 ? goodState : (pValue.compareTo(new BigDecimal(100)) <= 0 ? warringState : overState);
            }
            row.put("state", state);
            row.put("adminOrgName", adminOrg.getName(ctx.getLocale()));
            row.put("budgetAmount", allAmount);
            row.put("usedAmount", realUsedAmount);
            row.put("diffAmount", diffAmount);
            row.put("percent", pValue.setScale(2, 4) + "%");
            rows.add(row);
        }
        return rows;
    }
}

