/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.HRCmpItemTopFewFacadeFactory;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SalaryChangeService
extends AbstractJavaDataQueryService {
    private static final Logger logger = Logger.getLogger(SalaryChangeService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult dataResult = new DataResult();
        dataResult.setRows(this.getDatas(ctx));
        return dataResult;
    }

    public List<Map<String, Object>> getDatas(Context ctx) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            Map data = HRCmpItemTopFewFacadeFactory.getLocalInstance(ctx).getCmpItemTopFew("-1");
            Map<String, Object> resultMap = this.getResultMap(ctx, data);
            if (resultMap == null) {
                return null;
            }
            resultList.add(resultMap);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultList;
    }

    private Map<String, Object> getResultMap(Context ctx, Map<String, Object> data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (data.get("periodYear") == null || StringUtils.isEmpty((CharSequence)data.get("periodYear").toString()) || data.get("periodMonth") == null || StringUtils.isEmpty((CharSequence)data.get("periodMonth").toString())) {
            return null;
        }
        Locale locale = ctx.getLocale();
        String language = locale.getLanguage();
        if ("l1".equalsIgnoreCase(language)) {
            resultMap.put("salaryDate", data.get("periodYear") + "." + data.get("periodMonth"));
        } else {
            resultMap.put("salaryDate", data.get("periodYear") + this.getMultiLan(ctx, "label0") + data.get("periodMonth") + this.getMultiLan(ctx, "label1"));
        }
        List cmpItemRateData = (List)data.get("cmpItemRateData");
        if (null == cmpItemRateData || cmpItemRateData.isEmpty()) {
            return null;
        }
        for (int i = 0; i < cmpItemRateData.size(); ++i) {
            Map item = (Map)cmpItemRateData.get(i);
            if (item == null || item.get("name") == null || item.get("rate") == null || item.get("status") == null) continue;
            String itemName = item.get("name").toString();
            String itemValue = item.get("rate").toString();
            int itemStatus = (Integer)item.get("status");
            resultMap.put("itemName" + (i + 1), itemName);
            resultMap.put("itemValue" + (i + 1), itemValue);
            if (itemStatus == 1) {
                resultMap.put("itemStatus" + (i + 1), "upArrow");
                continue;
            }
            resultMap.put("itemStatus" + (i + 1), "downArrow");
        }
        return resultMap;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult dataResult = new DataResult();
        dataResult.setRows(this.getDatas(ctx));
        return dataResult;
    }

    public String getMultiLan(Context ctx, String label) {
        return EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpDataPlatformResource", (String)label, (Locale)ctx.getLocale());
    }
}

