/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;

public class CmpCurrencyHelper {
    private static final String CNY_ID = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";

    private CmpCurrencyHelper() {
    }

    public static CurrencyInfo getCNYCurrencyInfo(Context ctx) throws BOSException {
        return CmpCurrencyHelper.getCurrencyInfo(ctx, CNY_ID);
    }

    public static String getCNYCurrencyId() {
        return CNY_ID;
    }

    public static CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws BOSException {
        String language = ctx.getLocale().getLanguage();
        String sql = "SELECT FID, FNAME_%s currencyName, FNumber FROM T_BD_CURRENCY WHERE FID = '%s'";
        sql = String.format(sql, language, currencyId);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                currencyInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                currencyInfo.setName(rowSet.getString("currencyName"));
                currencyInfo.setNumber(rowSet.getString("FNumber"));
                return currencyInfo;
            }
        }
        catch (UuidException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        throw new BOSException(String.format("cannot get currency info, id: %s", currencyId));
    }
}

