/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.execution;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelBizType;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.CmpTaxMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.DealType;
import com.kingdee.shr.compensation.app.intelligent.HandleTypeEnum;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.intelligent.biz.CmpTaxMatchProcessHelper;
import com.kingdee.shr.compensation.intelligent.dto.ChangeTaxUnit;
import com.kingdee.shr.compensation.intelligent.dto.TaxUnitCondition;
import com.kingdee.shr.compensation.intelligent.execution.TaxUnitIncreasePersonExecution;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class TaxUnitDecreasePersonExecution
extends TaxUnitIncreasePersonExecution {
    @Override
    protected void assmbleMatchData(PersonBURelaConfirmInfo confirmInfo, TaxUnitCondition condition, CoreBaseCollection coreBaseColl) {
        Date changeDate;
        if (condition == null) {
            return;
        }
        List<ChangeTaxUnit> taxUnits = condition.getChangeTaxUnit();
        Date now = new Date();
        CmpTaxMatchDataInfo baseMatchData = new CmpTaxMatchDataInfo();
        baseMatchData.setCmpIntelRule(this.ruleInfo);
        baseMatchData.setCmpIntelCatalog(this.catalogInfo);
        baseMatchData.setPbuConfirm(confirmInfo);
        baseMatchData.setEffdt(now);
        baseMatchData.setChangeDate(confirmInfo.getChangeDate());
        baseMatchData.setBizType(CmpIntelBizType.TAX);
        baseMatchData.setPerson(confirmInfo.getPerson());
        String addMonth = condition.getChangeMonth().getMonth();
        baseMatchData.setParse(addMonth);
        Date handleDate = changeDate = confirmInfo.getChangeDate();
        if (!"0".equals(addMonth)) {
            handleDate = CmpDateUtil.getAddMonth(changeDate, Integer.parseInt(addMonth));
        }
        baseMatchData.setHandleDate(handleDate);
        baseMatchData.setIsHandled(false);
        baseMatchData.setState(CmpIntelState.UNCONFIRMED);
        for (int i = 0; i < taxUnits.size(); ++i) {
            CmpTaxMatchDataInfo recordMatchData = new CmpTaxMatchDataInfo();
            BeanUtils.copyProperties((Object)baseMatchData, (Object)recordMatchData);
            recordMatchData.setHandleType(HandleTypeEnum.AUTO);
            TaxUnitInfo taxUnitInfo = new TaxUnitInfo();
            taxUnitInfo.setId(BOSUuid.read((String)taxUnits.get(i).getId()));
            recordMatchData.setTaxUnit(taxUnitInfo);
            recordMatchData.setMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label86", (Locale)this.ctx.getLocale()) + taxUnits.get(i).getName());
            recordMatchData.setDealType(DealType.CMP_RECORD);
            coreBaseColl.add((CoreBaseInfo)recordMatchData);
            CmpTaxMatchDataInfo taxMatchData = new CmpTaxMatchDataInfo();
            BeanUtils.copyProperties((Object)baseMatchData, (Object)taxMatchData);
            taxMatchData.setTaxUnit(taxUnitInfo);
            taxMatchData.setHandleType(HandleTypeEnum.MASTER);
            taxMatchData.setMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label87", (Locale)this.ctx.getLocale()) + taxUnits.get(i).getName());
            taxMatchData.setDealType(DealType.TAX_RECORD);
            coreBaseColl.add((CoreBaseInfo)taxMatchData);
        }
    }

    @Override
    protected String getAffairActionReasonFilter(boolean containsChangeTypeFilter) {
        return "affairActionReason.longNumber like '02!%'";
    }

    @Override
    protected String getConfirmOrderBySql() {
        return " order by affairActionReason.longNumber desc";
    }

    @Override
    protected void afterExecute() throws EASBizException, BOSException {
        CmpTaxMatchProcessHelper.getInstance().doAutomaticalDeal(this.ctx);
    }

    @Override
    protected String getNewEmpOrgRelationRange() {
        return "(newEmpOrgRelation.id in (select fid from T_HR_EmpOrgRelation where FIsLatestInAday = 1 and fisInner = 1) or newEmpOrgRelation.id is null)";
    }

    @Override
    protected String buildAdminFilter(CmpIntelEntryAdminOrgCollection orgEntry, Map<String, String> orgLongNumberMap) {
        return this.buildAdminFilter(orgEntry, orgLongNumberMap, true);
    }
}

