/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.validator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.util.NoticeHelper;
import com.kingdee.shr.compensation.record.validator.RecordValidator;
import com.kingdee.shr.compensation.record.validator.RecordValidatorUtils;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.sql.record.AdjustRecordSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustRecordValidator
extends RecordValidator {
    private final Logger logger = Logger.getLogger(AdjustRecordValidator.class);
    private final RecordValidatorUtils validatorUtils = new RecordValidatorUtils();

    @Override
    public List<RecordDataInfo> deletePersonReturnList(Context ctx, String personIds) throws BOSException, EASBizException {
        ArrayList<RecordDataInfo> infoList = new ArrayList<RecordDataInfo>();
        try {
            RecordDataInfo info;
            JSONObject personInfo = this.validatorUtils.getFixAdjustSalaryPerson(ctx, personIds, "PERSON");
            if (personInfo != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
            if ((personInfo = this.validatorUtils.getBatchAdjustBillPerson(ctx, personIds, "PERSON")) != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
            if ((personInfo = this.validatorUtils.getAdjustSalaryApplyPerson(ctx, personIds, "PERSON")) != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
            if ((personInfo = this.validatorUtils.getadjustSalaryNoticePerson(ctx, personIds, "PERSON")) != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("deletePersonAdjError:" + e.getMessage()));
        }
        return infoList;
    }

    @Override
    public RocordValidatorInfo deleteEmpRelation(Context ctx, String billId) throws BOSException, EASBizException {
        RocordValidatorInfo validator;
        StringBuilder str = new StringBuilder();
        String isLastOne = "select 1 from T_HR_SADJUSTEMPORELATION where FPersonId=(select FPersonId from T_HR_SADJUSTEMPORELATION where fid='" + billId + "')";
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, isLastOne);
        if (rowSet.size() == 1) {
            str.append(" where FAdjEmpORelationID = '").append(billId).append("' or ( FAdjEmpORelationID is null and FPersonId=(select FPersonId from T_HR_SADJUSTEMPORELATION where fid='" + billId + "'))");
        } else {
            str.append(" where FAdjEmpORelationID = '").append(billId).append("'");
        }
        String sql = "select FPersonId from T_HR_SFixAdjustSalary " + str;
        rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        String label42 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label42", (Locale)ctx.getLocale());
        if (rowSet.size() > 0) {
            validator = new RocordValidatorInfo();
            try {
                if (rowSet.next()) {
                    validator.setCode(rowSet.getString("FPersonId"));
                    validator.setMsg(label42);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            sql = "select FPersonId,A02.fnumber billNumber from T_HR_SBatchAdjustBillEntry A01 inner join T_HR_SBatchAdjustBill A02 on A01.FBillId = A02.fid and A02.FBillState not in (3,4) " + str.toString();
            rowSet = CmpSQLUtil.executeQuery(ctx, sql);
            validator = new RocordValidatorInfo();
            String label43 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label48", (Locale)ctx.getLocale());
            try {
                if (rowSet.next()) {
                    validator.setCode(rowSet.getString("FPersonId"));
                    validator.setMsg(MessageFormat.format(label43, rowSet.getString("billNumber")));
                }
                StringBuilder queryTableSql = new StringBuilder();
                queryTableSql.append("select fbillentrytablename from T_HR_SAdjSalaryTableRelation  R where R.fbillentrytablename is not null");
                rowSet = CmpSQLUtil.executeQuery(ctx, queryTableSql.toString());
                ArrayList<String> entryTableNames = new ArrayList<String>();
                while (rowSet.next()) {
                    entryTableNames.add(rowSet.getString("fbillEntryTableName"));
                }
                StringBuilder queryEntrySql = new StringBuilder();
                int size = entryTableNames.size();
                HashSet<String> billNumberSet = new HashSet<String>();
                String personId = "";
                for (int i = 0; i < size; ++i) {
                    queryEntrySql.append("SELECT ENTRY.FPersonId,asa.fnumber billNumber FROM T_HR_SAdjustEmpORelation adjrela  inner join " + (String)entryTableNames.get(i) + " ENTRY on adjrela.fid = ENTRY.fadjustemporelationid  inner join T_HR_SAdjustSalaryApply asa on asa.fid = ENTRY.fbillid where asa.FBillState in (1,2,3) and (ENTRY.fstate is null or ENTRY.fstate = 0) and ENTRY.fadjustemporelationid ='" + billId + "'");
                    if (i % 5 == 0 || i == size - 1) {
                        rowSet = CmpSQLUtil.executeQuery(ctx, queryEntrySql.toString());
                        while (rowSet.next()) {
                            billNumberSet.add(rowSet.getString("billNumber"));
                            personId = rowSet.getString("FPersonId");
                        }
                        queryEntrySql.setLength(0);
                        continue;
                    }
                    queryEntrySql.append(" UNION ALL ");
                }
                if (billNumberSet.size() > 0) {
                    String label44 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label49", (Locale)ctx.getLocale());
                    String billNumberStr = CmpStrUtil.convertSetToStringNew(billNumberSet);
                    String msg = validator.getMsg();
                    msg = !StringUtils.isEmpty((String)msg) ? msg + MessageFormat.format(label44, billNumberStr) : MessageFormat.format(label44, billNumberStr);
                    validator.setCode(personId);
                    validator.setMsg(msg);
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return validator;
    }

    @Override
    public List<RocordValidatorInfo> deleteEmpRelationReturnList(Context ctx, String billId) throws BOSException, EASBizException {
        RocordValidatorInfo validator = null;
        ArrayList<RocordValidatorInfo> infoList = new ArrayList<RocordValidatorInfo>();
        try {
            JSONObject personInfo = this.validatorUtils.getFixAdjustSalaryPerson(ctx, billId, "RELATION");
            if (personInfo != null) {
                validator = (RocordValidatorInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RocordValidatorInfo.class);
                infoList.add(validator);
            }
            if ((personInfo = this.validatorUtils.getBatchAdjustBillPerson(ctx, billId, "RELATION")) != null) {
                validator = (RocordValidatorInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RocordValidatorInfo.class);
                infoList.add(validator);
            }
            if ((personInfo = this.validatorUtils.getAdjustSalaryApplyPerson(ctx, billId, "RELATION")) != null) {
                validator = (RocordValidatorInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RocordValidatorInfo.class);
                infoList.add(validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("deleteRelationAdjError:" + e.getMessage()));
        }
        return infoList;
    }

    @Override
    public List<RocordValidatorInfo> loseRecord(Context ctx, String recordIds, Date leffdt) throws BOSException {
        String label37;
        String numbers;
        String key;
        String perName;
        RocordValidatorInfo validator;
        String recFid;
        recordIds = this.getInnerIds(recordIds);
        HashMap<String, RocordValidatorInfo> map = new HashMap<String, RocordValidatorInfo>();
        String sqlDate = CmpDateUtil.toKSqlDate(leffdt);
        StringBuffer str = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select t0.fid as recFid, t1.fid as FPersonId, t1.FName_" + l + " as perName ");
        str.append(" from T_HR_SAdjustPersonRecord t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" where t0.fid in (" + recordIds + ")");
        str.append(" and t0.FEffectDate > " + sqlDate);
        IRowSet r0 = CmpSQLUtil.executeQuery(ctx, str.toString());
        String msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label38", (Locale)ctx.getLocale());
        try {
            while (r0.next()) {
                recFid = r0.getString("recFid");
                validator = new RocordValidatorInfo();
                validator.setCode(r0.getString("recFid"));
                validator.setMsg(r0.getString("perName") + msg);
                map.put(r0.getString("recFid"), validator);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        String calSql = AdjustRecordSQL.getMaxAdjustEmpDateByRecord(recordIds, leffdt, ctx);
        IRowSet r = CmpSQLUtil.executeQuery(ctx, calSql);
        String label39 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label39", (Locale)ctx.getLocale());
        try {
            while (r.next()) {
                recFid = r.getString("recFid");
                if (map.containsKey(recFid)) {
                    validator = (RocordValidatorInfo)map.get(recFid);
                    validator.appendMsg(label39);
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                validator.setMsg(r.getString("perName") + label39);
                map.put(r.getString("recFid"), validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        String empSql = AdjustRecordSQL.getMaxFixByRecord(recordIds, leffdt, ctx);
        IRowSet r1 = CmpSQLUtil.executeQuery(ctx, empSql);
        String label40 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label40", (Locale)ctx.getLocale());
        try {
            while (r1.next()) {
                recFid = r1.getString("recFid");
                if (map.containsKey(recFid)) {
                    validator = (RocordValidatorInfo)map.get(recFid);
                    validator.appendMsg(label40);
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                validator.appendMsg(r1.getString("perName") + label40);
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        String billSql = AdjustRecordSQL.getAdjustBillEntry(ctx, recordIds, leffdt);
        HashMap<String, Set<String>> billMap = new HashMap<String, Set<String>>();
        Set<String> billList = null;
        r1 = CmpSQLUtil.executeQuery(ctx, billSql);
        try {
            while (r1.next()) {
                recFid = r1.getString("recFid");
                perName = r1.getString("perName");
                key = recFid + "_" + perName;
                if (billMap.get(key) != null) {
                    billList = (Set)billMap.get(key);
                } else {
                    billList = new HashSet();
                    billMap.put(key, billList);
                }
                billList.add(r1.getString("billNum"));
            }
            for (Map.Entry entry : billMap.entrySet()) {
                numbers = ((Set)entry.getValue()).toString();
                if (StringUtils.isEmpty((String)numbers)) continue;
                numbers = numbers.replace("[", "").replace("]", "");
                recFid = ((String)entry.getKey()).split("_")[0];
                perName = ((String)entry.getKey()).split("_")[1];
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                label37 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpFixAdjustResource", (String)"label37", (Locale)ctx.getLocale());
                validator.appendMsg(MessageFormat.format(label37, perName, numbers));
                map.put(recFid, validator);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            billSql = AdjustRecordSQL.getAdjustSalaryApplyEntry(ctx, recordIds, leffdt);
            if (CmpStrUtil.isNotEmpty(billSql)) {
                billMap = new HashMap();
                r1 = CmpSQLUtil.executeQuery(ctx, billSql);
                while (r1.next()) {
                    recFid = r1.getString("recFid");
                    perName = r1.getString("perName");
                    key = recFid + "_" + perName;
                    if (billMap.get(key) != null) {
                        billList = (Set)billMap.get(key);
                    } else {
                        billList = new HashSet();
                        billMap.put(key, billList);
                    }
                    billList.add(r1.getString("billNum"));
                }
                for (Map.Entry entry : billMap.entrySet()) {
                    numbers = ((Set)entry.getValue()).toString();
                    if (StringUtils.isEmpty((String)numbers)) continue;
                    numbers = numbers.replace("[", "").replace("]", "");
                    recFid = ((String)entry.getKey()).split("_")[0];
                    perName = ((String)entry.getKey()).split("_")[1];
                    validator = new RocordValidatorInfo();
                    validator.setCode(recFid);
                    label37 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpFixAdjustResource", (String)"label37", (Locale)ctx.getLocale());
                    validator.appendMsg(MessageFormat.format(label37, perName, numbers));
                    map.put(recFid, validator);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            int confirmAuth = 0;
            String sql = "SELECT FConfirmAuth FROM T_HR_SNoticeParam ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                confirmAuth = rs.getInt("FConfirmAuth");
            }
            if (confirmAuth == 1 && CmpStrUtil.isNotEmpty(billSql = AdjustRecordSQL.getAdjustNoticeEntry(ctx, recordIds, leffdt))) {
                billMap = new HashMap();
                r1 = CmpSQLUtil.executeQuery(ctx, billSql);
                while (r1.next()) {
                    recFid = r1.getString("recFid");
                    perName = r1.getString("perName");
                    key = recFid + "_" + perName;
                    if (billMap.get(key) != null) {
                        billList = (Set)billMap.get(key);
                    } else {
                        billList = new HashSet();
                        billMap.put(key, billList);
                    }
                    billList.add(r1.getString("billNum"));
                }
                for (Map.Entry entry : billMap.entrySet()) {
                    numbers = ((Set)entry.getValue()).toString();
                    if (StringUtils.isEmpty((String)numbers)) continue;
                    numbers = numbers.replace("[", "").replace("]", "");
                    recFid = ((String)entry.getKey()).split("_")[0];
                    perName = ((String)entry.getKey()).split("_")[1];
                    validator = new RocordValidatorInfo();
                    validator.setCode(recFid);
                    String label0 = NoticeHelper.getMultiLan(ctx, "label0");
                    validator.appendMsg(MessageFormat.format(label0, perName, numbers));
                    map.put(recFid, validator);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<RocordValidatorInfo> list = new ArrayList<RocordValidatorInfo>();
        for (Map.Entry entry : map.entrySet()) {
            list.add((RocordValidatorInfo)entry.getValue());
        }
        return list;
    }
}

