/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CalFunctionCumulativeTaxService
extends SalaryCalFunction {
    public double getCumulativeTaxDeduction(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String dateA, String dateB) {
        Context ctx = Tools.getInstance().getCtx();
        String calSchemeId = calScheme.getId().toString();
        String yearKey = "getCumulativeTaxDeduction_" + calSchemeId;
        if (tempMap.get(yearKey) == null) {
            CmpTaxUtil cmpTaxUtil = new CmpTaxUtil();
            Map<String, Date> taxYearRange = cmpTaxUtil.getTaxYearRange(ctx, calScheme);
            if (taxYearRange == null) {
                System.out.println("getCumulativeTaxDeduction\uff1a\u672a\u7ef4\u62a4\u7eb3\u7a0e\u5e74\u5ea6");
                tempMap.put(yearKey, null);
                return -1.0;
            }
            int taxYear = cmpTaxUtil.getTaxYear(ctx, calScheme);
            tempMap.put(yearKey, CalFunctionCumulativeTaxService.getTaxDefaultDate(taxYearRange.get("beginDate"), taxYear, calScheme));
        }
        if (tempMap.get(yearKey) == null || dateB == null) {
            System.out.println("getCumulativeTaxDeduction\uff1a\u672a\u7ef4\u62a4\u7eb3\u7a0e\u5e74\u5ea6\u53c2\u6570dateB" + dateB);
            return -1.0;
        }
        Date taxDefaultDate = (Date)tempMap.get(yearKey);
        Date dateFirst = null;
        Calendar min = Calendar.getInstance();
        min.setTime(taxDefaultDate);
        min.set(min.get(1), 0, 1);
        Date endDate = null;
        Date beginDate = null;
        if (StringUtils.isEmpty((String)dateA)) {
            endDate = taxDefaultDate;
        } else {
            dateFirst = this.parseStringToDate(dateA);
            if (dateFirst == null) {
                System.out.println("getCumulativeTaxDeduction\uff1a\u53c2\u6570dateA" + dateA);
                return -1.0;
            }
            if (dateFirst.before(min.getTime())) {
                return 0.0;
            }
            endDate = taxDefaultDate.before(dateFirst) ? taxDefaultDate : dateFirst;
        }
        Date dateSecond = this.parseStringToDate(dateB);
        if (dateSecond == null) {
            System.out.println("getCumulativeTaxDeduction\uff1a\u53c2\u6570dateB" + dateB);
            return -1.0;
        }
        if (dateFirst != null && dateFirst.before(dateSecond)) {
            return 0.0;
        }
        beginDate = min.getTime().after(dateSecond) ? min.getTime() : dateSecond;
        double sum = (CalFunctionCumulativeTaxService.getDifMonth(beginDate, endDate) + 1) * 5000;
        if (sum < 0.0) {
            System.out.println("getCumulativeTaxDeduction\uff1a\u53c2\u6570dateB" + dateB + "\u53c2\u6570dateA" + dateA + "\u53c2\u6570taxBeginDate" + taxDefaultDate);
            return -1.0;
        }
        return sum;
    }

    public static Integer getDifMonth(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int result = end.get(2) - start.get(2);
        int month = (end.get(1) - start.get(1)) * 12;
        return Math.abs(month + result);
    }

    public static Date getTaxDefaultDate(Date taxBegin, int taxYear, CalSchemeInfo calScheme) {
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        Calendar max = Calendar.getInstance();
        max.set(periodYear, periodMonth - 1, 2);
        int result = 0;
        Calendar min = Calendar.getInstance();
        min.setTime(taxBegin);
        min.set(min.get(1), min.get(2), 1);
        Calendar curr = min;
        while (curr.before(max)) {
            ++result;
            curr.add(2, 1);
        }
        int monthes = result;
        Calendar calendar = Calendar.getInstance();
        calendar.set(taxYear, monthes - 1, 1, 0, 0, 0);
        System.out.println("getTaxDefaultDate\uff1a\u83b7\u53d6\u7a0e\u6b3e\u6240\u5c5e\u671f\u9ed8\u8ba4\u503c" + calendar.getTime().toString());
        return calendar.getTime();
    }

    public Date parseStringToDate(String str) {
        Date res = null;
        String[] formatArr = new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy/MM/dd", "yyyyMMdd", "yyyy/M/d", "yyyy-MM", "yyyy-M", "yyyy/MM", "yyyy/M", "yyyyMM"};
        for (int i = 0; i < formatArr.length; ++i) {
            SimpleDateFormat sdf = new SimpleDateFormat(formatArr[i]);
            sdf.setLenient(false);
            try {
                res = sdf.parse(str);
                break;
            }
            catch (ParseException e) {
                continue;
            }
        }
        return res;
    }
}

